/*
 * Decompiled with CFR 0.152.
 */
package omero.cmd.graphs;

import java.util.Collection;
import ome.model.internal.Details;
import ome.services.graphs.GraphException;
import ome.services.graphs.GraphTraversal;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseGraphTraversalProcessor
implements GraphTraversal.Processor {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseGraphTraversalProcessor.class);
    protected final Session session;

    public BaseGraphTraversalProcessor(Session session) {
        this.session = session;
    }

    public void nullProperties(String className, String propertyName, Collection<Long> ids) {
        String update = "UPDATE " + className + " SET " + propertyName + " = NULL WHERE id IN (:ids)";
        this.session.createQuery(update).setParameterList("ids", ids).executeUpdate();
    }

    public void deleteInstances(String className, Collection<Long> ids) throws GraphException {
        String update = "DELETE FROM " + className + " WHERE id IN (:ids)";
        int count = this.session.createQuery(update).setParameterList("ids", ids).executeUpdate();
        if (count != ids.size()) {
            LOGGER.warn("not all the objects of type " + className + " could be deleted");
        }
    }

    public void assertMayProcess(String className, long id, Details details) throws GraphException {
    }
}

