/*
 * Decompiled with CFR 0.152.
 */
package omero.cmd.graphs;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Ordering;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ome.model.IObject;
import ome.security.ACLVoter;
import ome.security.basic.LightAdminPrivileges;
import ome.services.graphs.GraphPathBean;
import ome.services.graphs.GraphPolicy;
import ome.services.graphs.GraphTraversal;
import ome.services.util.ReadOnlyStatus;
import ome.system.Roles;
import omero.cmd.ERR;
import omero.cmd.FindParents;
import omero.cmd.FoundParents;
import omero.cmd.GraphException;
import omero.cmd.HandleI;
import omero.cmd.Helper;
import omero.cmd.IRequest;
import omero.cmd.Response;
import omero.cmd.graphs.GraphHelper;
import omero.cmd.graphs.GraphUtil;
import omero.cmd.graphs.NullGraphTraversalProcessor;
import omero.cmd.graphs.SkipTailPolicy;
import omero.cmd.graphs.StopBeforeHelper;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FindParentsI
extends FindParents
implements IRequest,
ReadOnlyStatus.IsAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(FindParentsI.class);
    private static final ImmutableMap<String, String> ALL_GROUPS_CONTEXT = ImmutableMap.of((Object)"omero.group", (Object)"-1");
    private static final Set<GraphPolicy.Ability> REQUIRED_ABILITIES = ImmutableSet.of();
    private final ACLVoter aclVoter;
    private final GraphPathBean graphPathBean;
    private final Set<Class<? extends IObject>> targetClasses;
    private final GraphPolicy graphPolicy;
    private final Set<Class<? extends IObject>> classesToFind = new HashSet<Class<? extends IObject>>();
    private Helper helper;
    private GraphHelper graphHelper;
    private GraphTraversal graphTraversal;
    private int targetObjectCount = 0;
    private int foundObjectCount = 0;

    public FindParentsI(ACLVoter aclVoter, Roles securityRoles, GraphPathBean graphPathBean, LightAdminPrivileges adminPrivileges, Set<Class<? extends IObject>> targetClasses, GraphPolicy graphPolicy) {
        this.aclVoter = aclVoter;
        this.graphPathBean = graphPathBean;
        this.targetClasses = targetClasses;
        this.graphPolicy = graphPolicy;
    }

    @Override
    public Map<String, String> getCallContext() {
        return new HashMap<String, String>((Map<String, String>)ALL_GROUPS_CONTEXT);
    }

    @Override
    public void init(Helper helper) {
        Set<Object> graphPolicyAdjusters;
        Set<String> suggestedStopBefore;
        if (LOGGER.isDebugEnabled()) {
            GraphUtil.ParameterReporter arguments = new GraphUtil.ParameterReporter();
            arguments.addParameter("targetObjects", this.targetObjects);
            arguments.addParameter("typesOfParents", (Object)this.typesOfParents);
            arguments.addParameter("stopBefore", (Object)this.stopBefore);
            LOGGER.debug("request: " + arguments);
        }
        this.helper = helper;
        helper.setSteps(1);
        this.graphHelper = new GraphHelper(helper, this.graphPathBean);
        if (CollectionUtils.isEmpty((Collection)this.typesOfParents)) {
            IllegalArgumentException e = new IllegalArgumentException("no types of parents specified to find");
            throw helper.cancel(new ERR(), (Throwable)e, "bad-options", new String[0]);
        }
        this.classesToFind.addAll(this.graphHelper.getClassesFromNames(this.typesOfParents));
        Set<String> targetClassNames = this.graphHelper.getTopLevelNames(this.graphHelper.getClassesFromNames(this.targetObjects.keySet()));
        Set<String> parentTypeNames = this.graphHelper.getTopLevelNames(this.classesToFind);
        Set<String> currentStopBefore = this.graphHelper.getTopLevelNames(this.graphHelper.getClassesFromNames(this.stopBefore));
        try {
            suggestedStopBefore = StopBeforeHelper.get().getStopBeforeParents(targetClassNames, parentTypeNames);
        }
        catch (IllegalArgumentException e) {
            throw helper.cancel(new ERR(), (Throwable)e, "bad-options", new String[0]);
        }
        Sets.SetView extraStopBefore = Sets.difference(suggestedStopBefore, currentStopBefore);
        this.stopBefore.addAll(extraStopBefore);
        if (!extraStopBefore.isEmpty() && LOGGER.isDebugEnabled()) {
            LOGGER.debug("to stopBefore added: " + Joiner.on((char)',').join((Iterable)Ordering.natural().sortedCopy((Iterable)extraStopBefore)));
        }
        if (CollectionUtils.isEmpty((Collection)this.stopBefore)) {
            graphPolicyAdjusters = Collections.emptySet();
        } else {
            final Set<Class<? extends IObject>> typesToStopBefore = this.graphHelper.getClassesFromNames(this.stopBefore);
            Function<GraphPolicy, GraphPolicy> graphPolicyAdjuster = new Function<GraphPolicy, GraphPolicy>(){

                public GraphPolicy apply(GraphPolicy graphPolicy) {
                    return SkipTailPolicy.getSkipTailPolicy(graphPolicy, GraphUtil.getPredicateFromClasses(typesToStopBefore));
                }
            };
            graphPolicyAdjusters = Collections.singleton(graphPolicyAdjuster);
        }
        this.graphTraversal = this.graphHelper.prepareGraphTraversal(null, REQUIRED_ABILITIES, this.graphPolicy, graphPolicyAdjusters, this.aclVoter, this.graphPathBean, null, new NullGraphTraversalProcessor(REQUIRED_ABILITIES), false);
    }

    @Override
    public Object step(int step) throws HandleI.Cancel {
        this.helper.assertStep(step);
        try {
            switch (step) {
                case 0: {
                    SetMultimap<String, Long> targetMultimap = this.graphHelper.getTargetMultimap(this.targetClasses, this.targetObjects);
                    this.targetObjectCount += targetMultimap.size();
                    Map.Entry plan = this.graphTraversal.planOperation(targetMultimap, true, true);
                    if (!((SetMultimap)plan.getValue()).isEmpty()) {
                        IllegalStateException e = new IllegalStateException("querying the model graph does not delete any objects");
                        this.helper.cancel(new ERR(), (Throwable)e, "graph-fail", new String[0]);
                    }
                    return plan.getKey();
                }
            }
            IllegalArgumentException e = new IllegalArgumentException("model object graph operation has no step " + step);
            throw this.helper.cancel(new ERR(), (Throwable)e, "bad-step", new String[0]);
        }
        catch (HandleI.Cancel c) {
            throw c;
        }
        catch (ome.services.graphs.GraphException ge) {
            GraphException graphERR = new GraphException();
            graphERR.message = ge.message;
            throw this.helper.cancel((ERR)graphERR, (Throwable)ge, "graph-fail", new String[0]);
        }
        catch (Throwable t) {
            throw this.helper.cancel(new ERR(), t, "graph-fail", new String[0]);
        }
    }

    @Override
    public void finish() {
    }

    @Override
    public void buildResponse(int step, Object object) {
        this.helper.assertResponse(step);
        if (step == 0) {
            SetMultimap result = (SetMultimap)object;
            result = Multimaps.filterKeys((SetMultimap)result, (Predicate)new Predicate<String>(){

                public boolean apply(String foundClassName) {
                    Class<IObject> foundClass;
                    try {
                        foundClass = Class.forName(foundClassName).asSubclass(IObject.class);
                    }
                    catch (ClassCastException | ClassNotFoundException e) {
                        throw FindParentsI.this.helper.cancel(new ERR(), (Throwable)e, "graph-fail", new String[0]);
                    }
                    for (Class classToFind : FindParentsI.this.classesToFind) {
                        if (!classToFind.isAssignableFrom(foundClass)) continue;
                        return true;
                    }
                    return false;
                }
            });
            Map<String, List<Long>> foundObjects = GraphUtil.copyMultimapForResponse((SetMultimap<String, Long>)result);
            this.foundObjectCount += result.size();
            FoundParents response = new FoundParents(foundObjects);
            this.helper.setResponseIfNull(response);
            this.helper.info("in finding parents of " + this.targetObjectCount + ", found " + this.foundObjectCount + " in total", new Object[0]);
            if (LOGGER.isDebugEnabled()) {
                GraphUtil.ParameterReporter arguments = new GraphUtil.ParameterReporter();
                arguments.addParameter("parents", response.parents);
                LOGGER.debug("response: " + arguments);
            }
        }
    }

    @Override
    public Response getResponse() {
        return this.helper.getResponse();
    }

    public boolean isReadOnly(ReadOnlyStatus readOnly) {
        return true;
    }
}

