/*
 * Decompiled with CFR 0.152.
 */
package omero.cmd.graphs;

import com.google.common.base.Function;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ome.model.IObject;
import ome.services.graphs.GraphException;
import ome.services.graphs.GraphPathBean;
import ome.services.graphs.GraphPolicy;
import ome.services.util.ReadOnlyStatus;
import omero.cmd.ERR;
import omero.cmd.GraphModify2;
import omero.cmd.HandleI;
import omero.cmd.Helper;
import omero.cmd.IRequest;
import omero.cmd.Response;
import omero.cmd.SkipHead;
import omero.cmd.State;
import omero.cmd.Status;
import omero.cmd.graphs.GraphRequestFactory;
import omero.cmd.graphs.GraphUtil;
import omero.cmd.graphs.SkipHeadPolicy;
import omero.cmd.graphs.WrappableRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkipHeadI
extends SkipHead
implements IRequest,
ReadOnlyStatus.IsAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(SkipHeadI.class);
    private static final ImmutableSet<State> REQUEST_FAILURE_FLAGS = ImmutableSet.of((Object)State.CANCELLED, (Object)State.FAILURE);
    private final GraphPathBean graphPathBean;
    private final GraphRequestFactory graphRequestFactory;
    private final Status graphRequestSkipStatus = new Status();
    private final Status graphRequestPerformStatus = new Status();
    private final List<Object> graphRequestSkipObjects = new ArrayList<Object>();
    private final List<Object> graphRequestPerformObjects = new ArrayList<Object>();
    private GraphModify2 graphRequestSkip;
    private GraphModify2 graphRequestPerform;
    private Helper helper;

    public SkipHeadI(GraphPathBean graphPathBean, GraphRequestFactory graphRequestFactory) {
        this.graphPathBean = graphPathBean;
        this.graphRequestFactory = graphRequestFactory;
    }

    @Override
    public Map<String, String> getCallContext() {
        return ((IRequest)((Object)this.request)).getCallContext();
    }

    @Override
    public void init(Helper helper) {
        if (LOGGER.isDebugEnabled()) {
            GraphUtil.ParameterReporter arguments = new GraphUtil.ParameterReporter();
            arguments.addParameter("startFrom", (Object)this.startFrom);
            if (this.request != null) {
                arguments.addParameter("request", ((Object)((Object)this.request)).getClass().getName());
            }
            arguments.addParameter("targetObjects", this.targetObjects);
            arguments.addParameter("childOptions", (Object)this.childOptions);
            arguments.addParameter("dryRun", this.dryRun);
            LOGGER.debug("request: " + arguments);
        }
        this.helper = helper;
        if (this.request == null) {
            throw new RuntimeException(new GraphException("must pass a request argument"));
        }
        if (!(this.request instanceof WrappableRequest)) {
            throw new RuntimeException(new GraphException("cannot use " + SkipHead.class.getSimpleName() + " on " + ((Object)((Object)this.request)).getClass().getSimpleName()));
        }
        Class<?> requestClass = ((Object)((Object)this.request)).getClass();
        WrappableRequest wrappedRequest = (WrappableRequest)((Object)this.request);
        final GraphPolicy.Action startAction = wrappedRequest.getActionForStarting();
        this.graphRequestSkip = (GraphModify2)((Object)this.graphRequestFactory.getRequest(requestClass));
        this.graphRequestPerform = (GraphModify2)((Object)this.graphRequestFactory.getRequest(requestClass));
        wrappedRequest.copyFieldsTo(this.graphRequestPerform);
        wrappedRequest.copyFieldsTo(this.graphRequestSkip);
        GraphUtil.copyFields(this, this.graphRequestSkip);
        this.graphRequestSkip.dryRun = true;
        if (this.dryRun) {
            this.graphRequestPerform.dryRun = true;
        }
        HashMultimap permissionsOverrides = HashMultimap.create();
        ((WrappableRequest)((Object)this.graphRequestSkip)).adjustGraphPolicy(new Function<GraphPolicy, GraphPolicy>((SetMultimap)permissionsOverrides){
            final /* synthetic */ SetMultimap val$permissionsOverrides;
            {
                this.val$permissionsOverrides = setMultimap;
            }

            public GraphPolicy apply(GraphPolicy graphPolicy) {
                try {
                    return SkipHeadPolicy.getSkipHeadPolicySkip(graphPolicy, SkipHeadI.this.graphPathBean, SkipHeadI.this.startFrom, startAction, (SetMultimap<String, Long>)this.val$permissionsOverrides);
                }
                catch (GraphException e) {
                    throw new RuntimeException("graph traversal policy adjustment failed: " + (Object)((Object)e), e);
                }
            }
        });
        ((WrappableRequest)((Object)this.graphRequestPerform)).adjustGraphPolicy(new Function<GraphPolicy, GraphPolicy>((SetMultimap)permissionsOverrides){
            final /* synthetic */ SetMultimap val$permissionsOverrides;
            {
                this.val$permissionsOverrides = setMultimap;
            }

            public GraphPolicy apply(GraphPolicy graphPolicy) {
                return SkipHeadPolicy.getSkipHeadPolicyPerform(graphPolicy, (SetMultimap<String, Long>)this.val$permissionsOverrides);
            }
        });
        try {
            ((IRequest)((Object)this.graphRequestSkip)).init(helper.subhelper(this.graphRequestSkip, this.graphRequestSkipStatus));
            ((IRequest)((Object)this.graphRequestPerform)).init(helper.subhelper(this.graphRequestPerform, this.graphRequestPerformStatus));
        }
        catch (HandleI.Cancel c) {
            Object t = c.getCause();
            if (t == null) {
                t = c;
            }
            helper.fail(new ERR(), (Throwable)t, "graph-fail", new String[0]);
            helper.getStatus().flags.add(State.CANCELLED);
            throw c;
        }
        catch (Throwable t) {
            throw helper.cancel(new ERR(), t, "graph-fail", new String[0]);
        }
        this.graphRequestSkipStatus.steps = 1 + ((WrappableRequest)((Object)this.graphRequestSkip)).getStepProvidingCompleteResponse();
        helper.setSteps(this.graphRequestSkipStatus.steps + this.graphRequestPerformStatus.steps);
    }

    @Override
    public Object step(int step) throws HandleI.Cancel {
        this.helper.assertStep(step);
        if (step < this.graphRequestSkipStatus.steps) {
            try {
                this.graphRequestSkipStatus.currentStep = step;
                this.graphRequestSkipObjects.add(((IRequest)((Object)this.graphRequestSkip)).step(step));
            }
            catch (HandleI.Cancel e) {
                this.helper.getStatus().flags.addAll((Collection<State>)REQUEST_FAILURE_FLAGS);
                this.helper.setResponseIfNull(((IRequest)((Object)this.graphRequestSkip)).getResponse());
                throw e;
            }
        }
        int substep = step - this.graphRequestSkipStatus.steps;
        if (substep == 0) {
            for (int i = 0; i < this.graphRequestSkipStatus.steps; ++i) {
                ((IRequest)((Object)this.graphRequestSkip)).buildResponse(i, this.graphRequestSkipObjects.get(i));
            }
            Response response = ((IRequest)((Object)this.graphRequestSkip)).getResponse();
            Map<String, List<Long>> allTargetedObjects = ((WrappableRequest)((Object)this.graphRequestSkip)).getStartFrom(response);
            this.graphRequestPerform.targetObjects = new HashMap();
            for (String startFromClassName : this.startFrom) {
                int lastDot = startFromClassName.lastIndexOf(46);
                if (lastDot > 0) {
                    startFromClassName = startFromClassName.substring(lastDot + 1);
                }
                Class startFromClass = this.graphPathBean.getClassForSimpleName(startFromClassName);
                for (Map.Entry<String, List<Long>> targetedObjectsByClass : allTargetedObjects.entrySet()) {
                    Class<IObject> targetedClass;
                    String targetedClassName = targetedObjectsByClass.getKey();
                    try {
                        targetedClass = Class.forName(targetedClassName).asSubclass(IObject.class);
                    }
                    catch (ClassNotFoundException cnfe) {
                        IllegalStateException e = new IllegalStateException("response from " + ((Object)((Object)this.graphRequestSkip)).getClass() + " refers to class " + targetedClassName);
                        throw this.helper.cancel(new ERR(), (Throwable)e, "bad-class", new String[0]);
                    }
                    if (!startFromClass.isAssignableFrom(targetedClass)) continue;
                    List<Long> ids = targetedObjectsByClass.getValue();
                    this.graphRequestPerform.targetObjects.put(targetedClassName, ids);
                }
            }
        }
        if (substep < this.graphRequestPerformStatus.steps) {
            try {
                this.graphRequestPerformStatus.currentStep = substep;
                this.graphRequestPerformObjects.add(((IRequest)((Object)this.graphRequestPerform)).step(substep));
            }
            catch (HandleI.Cancel e) {
                this.helper.getStatus().flags.addAll((Collection<State>)REQUEST_FAILURE_FLAGS);
                this.helper.setResponseIfNull(((IRequest)((Object)this.graphRequestPerform)).getResponse());
                throw e;
            }
        } else {
            IllegalArgumentException e = new IllegalArgumentException("model object graph operation has no step " + step);
            throw this.helper.cancel(new ERR(), (Throwable)e, "bad-step", new String[0]);
        }
        return null;
    }

    @Override
    public void finish() {
    }

    @Override
    public void buildResponse(int step, Object object) {
        this.helper.assertResponse(step);
        if (step == 0) {
            IRequest tailHalf = (IRequest)((Object)this.graphRequestPerform);
            for (int substep = 0; substep < this.graphRequestPerformStatus.steps; ++substep) {
                tailHalf.buildResponse(substep, this.graphRequestPerformObjects.get(substep));
            }
            Response response = tailHalf.getResponse();
            this.helper.setResponseIfNull(response);
        }
    }

    @Override
    public Response getResponse() {
        return this.helper.getResponse();
    }

    public boolean isReadOnly(ReadOnlyStatus readOnly) {
        if (this.request instanceof ReadOnlyStatus.IsAware) {
            return ((ReadOnlyStatus.IsAware)this.request).isReadOnly(readOnly);
        }
        return false;
    }
}

