/*
 * Decompiled with CFR 0.152.
 */
package omero.cmd.graphs;

import com.google.common.base.Joiner;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class StopBeforeHelper<X> {
    private final Hierarchy<X> aboves = new Hierarchy();
    private final Hierarchy<X> belows = new Hierarchy();
    private final Set<X> allKnown = new HashSet<X>();
    private static String[][] HIERARCHY = new String[][]{{"Instrument", "Detector", "Dichroic", "Filter", "FilterSet", "LightSource", "Microscope", "Objective", "OTF"}, {"Filter", "TransmittanceRange"}, {"FilterSet", "Dichroic"}, {"LightSource", "LightSource"}, {"LogicalChannel", "DetectorSettings", "LightSettings"}, {"Image", "ObjectiveSettings"}, {"LightSettings", "LightSource"}, {"DetectorSettings", "Detector"}, {"ObjectiveSettings", "Objective"}, {"Detector", "Instrument"}, {"LightSource", "Instrument"}, {"Objective", "Instrument"}, {"OTF", "FilterSet", "Objective"}, {"FilterSet", "FilterSetEmissionFilterLink", "FilterSetExcitationFilterLink"}, {"LightPath", "LightPathEmissionFilterLink", "LightPathExcitationFilterLink"}, {"Project", "ProjectDatasetLink"}, {"Dataset", "DatasetImageLink"}, {"Folder", "Folder", "FolderImageLink", "FolderRoiLink"}, {"DatasetImageLink", "Image"}, {"ProjectDatasetLink", "Dataset"}, {"FolderImageLink", "Image"}, {"FolderRoiLink", "Roi"}, {"Image", "ImagingEnvironment", "Instrument", "ObjectiveSettings", "Pixels", "StageLabel"}, {"Pixels", "Channel", "PixelsOriginalFileMap", "PlaneInfo", "RenderingDef", "Thumbnail"}, {"LogicalChannel", "Channel", "LightPath"}, {"Channel", "LogicalChannel"}, {"Annotation", "OriginalFile"}, {"FilesetEntry", "OriginalFile"}, {"PixelsOriginalFileMap", "OriginalFile"}, {"Roi", "OriginalFile"}, {"RenderingDef", "QuantumDef", "CodomainMapContext", "ChannelBinding", "ProjectionDef"}, {"Image", "Experiment"}, {"Experiment", "MicrobeamManipulation"}, {"Fileset", "Image", "FilesetEntry", "FilesetJobLink"}, {"FilesetJobLink", "Job"}, {"Job", "JobOriginalFileLink"}, {"JobOriginalFileLink", "OriginalFile"}, {"Image", "Roi"}, {"Roi", "Shape"}, {"Shape", "Image"}, {"Screen", "Reagent"}, {"Well", "WellReagentLink"}, {"WellReagentLink", "Reagent"}, {"Screen", "ScreenPlateLink"}, {"ScreenPlateLink", "Plate"}, {"Plate", "Well", "PlateAcquisition"}, {"PlateAcquisition", "WellSample"}, {"Well", "WellSample"}, {"WellSample", "Image"}, {"Channel", "StatsInfo"}};
    private static final StopBeforeHelper<String> STOP_BEFORE_HELPER = new StopBeforeHelper();

    static StopBeforeHelper<String> get() {
        return STOP_BEFORE_HELPER;
    }

    private void addEdge(X above, X below) {
        ((Hierarchy)this.belows).addEdge(above, below);
        ((Hierarchy)this.aboves).addEdge(below, above);
        this.allKnown.add(above);
        this.allKnown.add(below);
    }

    private void assertNodesKnown(Set<X> nodes) {
        Sets.SetView unknown = Sets.difference(nodes, this.allKnown);
        if (!unknown.isEmpty()) {
            throw new IllegalArgumentException("unknown in hierarchy: " + Joiner.on((char)',').join((Iterable)unknown));
        }
    }

    Set<X> getStopBeforeParents(Set<X> startFrom, Set<X> sought) {
        this.assertNodesKnown(startFrom);
        this.assertNodesKnown(sought);
        Set pathNodes = ((Hierarchy)this.aboves).allBeyond(startFrom);
        pathNodes.retainAll(((Hierarchy)this.belows).allBeyond(sought));
        Set beyonds = ((Hierarchy)this.aboves).directlyBeyond(pathNodes);
        beyonds.removeAll(pathNodes);
        return beyonds;
    }

    Set<X> getStopBeforeChildren(Set<X> startFrom, Set<X> sought) {
        this.assertNodesKnown(startFrom);
        this.assertNodesKnown(sought);
        Set pathNodes = ((Hierarchy)this.belows).allBeyond(startFrom);
        pathNodes.retainAll(((Hierarchy)this.aboves).allBeyond(sought));
        Set beyonds = ((Hierarchy)this.belows).directlyBeyond(pathNodes);
        beyonds.removeAll(pathNodes);
        return beyonds;
    }

    static {
        for (String[] stringArray : HIERARCHY) {
            for (int index = 1; index < stringArray.length; ++index) {
                super.addEdge(stringArray[0], stringArray[index]);
            }
        }
        for (String[] stringArray : new String[]{"Annotation", "Channel", "Dataset", "Detector", "Dichroic", "Fileset", "Filter", "Folder", "Image", "Instrument", "LightPath", "LightSource", "Objective", "OriginalFile", "PlaneInfo", "PlateAcquisition", "Plate", "Project", "Reagent", "Roi", "Screen", "Shape", "Well"}) {
            String link = (String)stringArray + "AnnotationLink";
            super.addEdge((String)stringArray, link);
            super.addEdge(link, "Annotation");
        }
    }

    private static class Hierarchy<X> {
        private final SetMultimap<X, X> directlyBeyond = HashMultimap.create();
        private final SetMultimap<X, X> allBeyond = HashMultimap.create();
        private boolean dirty = false;

        private Hierarchy() {
        }

        private void addEdge(X from, X to) {
            if (this.directlyBeyond.put(from, to)) {
                this.dirty = true;
            }
        }

        private Set<X> getAllBeyond(Set<X> current, Set<X> all) {
            all.addAll(current);
            HashSet next = new HashSet();
            for (X node : current) {
                next.addAll(this.directlyBeyond.get(node));
            }
            next.removeAll(all);
            return next.isEmpty() ? all : this.getAllBeyond(next, all);
        }

        private void computeAllBeyond() {
            for (Object from : this.directlyBeyond.keySet()) {
                for (Object to : this.getAllBeyond(Collections.singleton(from), new HashSet())) {
                    this.allBeyond.put(from, to);
                }
            }
            this.dirty = false;
        }

        private Set<X> beyond(SetMultimap<X, X> beyonds, Collection<X> nodes) {
            if (this.dirty) {
                this.computeAllBeyond();
            }
            HashSet beyond = new HashSet();
            for (X node : nodes) {
                beyond.addAll(beyonds.get(node));
            }
            return beyond;
        }

        private Set<X> directlyBeyond(Collection<X> nodes) {
            return this.beyond(this.directlyBeyond, nodes);
        }

        private Set<X> allBeyond(Collection<X> nodes) {
            return this.beyond(this.allBeyond, nodes);
        }
    }
}

