/*
 * Decompiled with CFR 0.152.
 */
package omero.gateway.facility;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import omero.RType;
import omero.ServerError;
import omero.api.IQueryPrx;
import omero.api.RawFileStorePrx;
import omero.gateway.Gateway;
import omero.gateway.SecurityContext;
import omero.gateway.exception.DSAccessException;
import omero.gateway.exception.DSOutOfServiceException;
import omero.gateway.facility.BrowseFacility;
import omero.gateway.model.ImageData;
import omero.model.Fileset;
import omero.model.FilesetEntry;
import omero.model.IObject;
import omero.model.OriginalFile;
import omero.rtypes;
import omero.sys.ParametersI;
import org.apache.commons.collections.CollectionUtils;

public class TransferFacilityHelper {
    private static final int INC = 262144;
    private BrowseFacility browse;
    private Gateway gateway;

    TransferFacilityHelper(Gateway gateway) throws ExecutionException {
        this.gateway = gateway;
        this.browse = gateway.getFacility(BrowseFacility.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     */
    List<File> downloadImage(SecurityContext context, String targetPath, long imageId) throws DSAccessException, DSOutOfServiceException {
        List<IObject> filesets;
        ArrayList<File> files = new ArrayList<File>();
        ImageData image = this.browse.findObject(context, ImageData.class, imageId, true);
        try {
            String query;
            long id;
            IQueryPrx service = this.gateway.getQueryService(context);
            ParametersI param = new ParametersI();
            if (image.isFSImage()) {
                id = image.getId();
                ArrayList<RType> l2 = new ArrayList<RType>();
                l2.add(rtypes.rlong(id));
                param.add("imageIds", rtypes.rlist(l2));
                query = this.createFileSetQuery();
            } else if (image.isArchived()) {
                StringBuffer buffer = new StringBuffer();
                id = image.getDefaultPixels().getId();
                buffer.append("select ofile from OriginalFile as ofile ");
                buffer.append("join fetch ofile.hasher ");
                buffer.append("left join ofile.pixelsFileMaps as pfm ");
                buffer.append("left join pfm.child as child ");
                buffer.append("where child.id = :id");
                param.map.put("id", rtypes.rlong(id));
                query = buffer.toString();
            } else {
                return null;
            }
            filesets = service.findAllByQuery(query, param);
        }
        catch (Exception e) {
            throw new DSAccessException("Cannot retrieve original file", e);
        }
        if (CollectionUtils.isEmpty(filesets)) {
            return files;
        }
        ArrayList<IObject> values = new ArrayList<IObject>();
        if (image.isFSImage()) {
            for (Fileset set : filesets) {
                List<FilesetEntry> entries = set.copyUsedFiles();
                for (FilesetEntry fs : entries) {
                    values.add(fs.getOriginalFile());
                }
            }
        } else {
            values.addAll(filesets);
        }
        RawFileStorePrx store = null;
        FileOutputStream stream = null;
        long offset = 0L;
        Iterator<IObject> i = values.iterator();
        File f = null;
        while (i.hasNext()) {
            OriginalFile of = (OriginalFile)i.next();
            try {
                store = this.gateway.getRawFileService(context);
                store.setFileId(of.getId().getValue());
                f = new File(targetPath, of.getName().getValue());
                files.add(f);
                stream = new FileOutputStream(f);
                long size = of.getSize().getValue();
                try {
                    try {
                        offset = 0L;
                        while (offset + 262144L < size) {
                            stream.write(store.read(offset, 262144));
                            offset += 262144L;
                        }
                    }
                    finally {
                        stream.write(store.read(offset, (int)(size - offset)));
                        stream.close();
                    }
                }
                catch (Exception e) {
                    if (stream != null) {
                        stream.close();
                    }
                    if (f == null) continue;
                    f.delete();
                    files.remove(f);
                }
            }
            catch (IOException e) {
                if (f != null) {
                    f.delete();
                    files.remove(f);
                }
                throw new DSAccessException("Cannot create file in folderPath", e);
            }
            catch (Throwable t) {
                throw new DSAccessException("ServerError on retrieveArchived", t);
            }
            finally {
                try {
                    store.close();
                }
                catch (ServerError serverError) {}
            }
        }
        return files;
    }

    private String createFileSetQuery() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("select fs from Fileset as fs ");
        buffer.append("join fetch fs.images as image ");
        buffer.append("left outer join fetch fs.usedFiles as usedFile ");
        buffer.append("join fetch usedFile.originalFile as f ");
        buffer.append("join fetch f.hasher ");
        buffer.append("where image.id in (:imageIds)");
        return buffer.toString();
    }
}

