/*
 * Decompiled with CFR 0.152.
 */
package omero.gateway.model;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import omero.RString;
import omero.gateway.model.AnnotationData;
import omero.model.FileAnnotation;
import omero.model.FileAnnotationI;
import omero.model.OriginalFile;
import omero.rtypes;

public class FileAnnotationData
extends AnnotationData {
    public static final String FLIM_NS = "openmicroscopy.org/omero/analysis/flim";
    public static final String EXPERIMENTER_PHOTO_NS = "openmicroscopy.org/omero/experimenter/photo";
    public static final String COMPANION_FILE_NS = "openmicroscopy.org/omero/import/companionFile";
    public static final String LOG_FILE_NS = "openmicroscopy.org/omero/import/logFile";
    public static final String MOVIE_NS = "openmicroscopy.org/omero/movie";
    public static final String MEASUREMENT_NS = "openmicroscopy.org/omero/measurement";
    public static final String BULK_ANNOTATIONS_NS = "openmicroscopy.org/omero/bulk_annotations";
    public static final String ORIGINAL_METADATA_NAME = "original_metadata.txt";
    public static final String PDF = "pdf";
    public static final String TEXT = "txt";
    public static final String CSV = "csv";
    public static final String XML = "xml";
    public static final String HTML = "html";
    public static final String HTM = "htm";
    public static final String MS_WORD = "doc";
    public static final String MS_WORD_X = "docx";
    public static final String MS_EXCEL = "xls";
    public static final String MS_POWER_POINT = "ppt";
    public static final String MS_POWER_POINT_X = "pptx";
    public static final String MS_POWER_POINT_SHOW = "pps";
    public static final String RTF = "rtf";
    public static final String UNKNOWN = "UNKNOWN OR NULL FORMAT";
    private static final String SERVER_PDF = "application/pdf";
    private static final String SERVER_HTML = "text/html";
    private static final String SERVER_XML = "text/xml";
    private static final String SERVER_TEXT = "text/plain";
    private static final String SERVER_CSV = "text/csv";
    private static final String SERVER_RTF = "text/rtf";
    private static final String SERVER_MS_WORD = "application/msword";
    private static final String SERVER_MS_POWERPOINT = "application/vnd.ms-powerpoint";
    private static final String SERVER_MS_EXCEL = "application/vnd.ms-excel";
    private static final String SERVER_OCTET_STREAM = "application/octet-stream";
    private File attachedFile;
    private String format;

    private OriginalFile getFile() {
        OriginalFile f = ((FileAnnotation)this.asAnnotation()).getFile();
        if (f != null && f.isLoaded()) {
            return f;
        }
        return null;
    }

    private void validateFormat(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Path cannot be null.");
        }
        this.format = path.endsWith(PDF) ? PDF : (path.endsWith(TEXT) ? TEXT : (path.endsWith(CSV) ? CSV : (path.endsWith(XML) ? XML : (path.endsWith(HTML) || path.endsWith(HTM) ? HTML : (path.endsWith(MS_WORD) || path.endsWith(MS_WORD_X) ? MS_WORD : (path.endsWith(MS_EXCEL) ? MS_EXCEL : (path.endsWith(MS_POWER_POINT) || path.endsWith(MS_POWER_POINT_SHOW) || path.endsWith(MS_POWER_POINT_X) ? MS_POWER_POINT : (path.endsWith(RTF) ? RTF : ""))))))));
    }

    public FileAnnotationData(File file) {
        super(FileAnnotationI.class);
        if (file == null) {
            throw new IllegalArgumentException("File cannot be null.");
        }
        this.validateFormat(file.getAbsolutePath());
        this.attachedFile = file;
    }

    public FileAnnotationData(FileAnnotation annotation) {
        super(annotation);
        this.format = null;
    }

    public String getOriginalMimetype() {
        OriginalFile f = this.getFile();
        String unknown = UNKNOWN;
        String format = f == null ? unknown : (f.getMimetype() == null ? unknown : f.getMimetype().getValue());
        return format;
    }

    @Override
    public void setDescription(String description) {
        if (description == null || description.trim().length() == 0) {
            return;
        }
        this.setDirty(true);
        this.asAnnotation().setDescription(rtypes.rstring(description));
    }

    @Override
    public String getDescription() {
        RString value = this.asAnnotation().getDescription();
        if (value == null) {
            return "";
        }
        return value.getValue();
    }

    public String getServerFileMimetype() {
        if (this.format == null) {
            return SERVER_TEXT;
        }
        if (this.format.equals(PDF)) {
            return SERVER_PDF;
        }
        if (this.format.equals(XML)) {
            return SERVER_XML;
        }
        if (this.format.equals(HTML) || this.format.equals(HTM)) {
            return SERVER_HTML;
        }
        if (this.format.equals(CSV)) {
            return SERVER_CSV;
        }
        if (this.format.equals(TEXT)) {
            return SERVER_TEXT;
        }
        if (this.format.equals(RTF)) {
            return SERVER_RTF;
        }
        if (this.format.equals(MS_WORD) || this.format.equals(MS_WORD_X)) {
            return SERVER_MS_WORD;
        }
        if (this.format.equals(MS_EXCEL)) {
            return SERVER_MS_EXCEL;
        }
        if (this.format.equals(MS_POWER_POINT) || this.format.equals(MS_POWER_POINT_SHOW) || this.format.equals(MS_POWER_POINT_X)) {
            return SERVER_MS_POWERPOINT;
        }
        try {
            String guessedMimeType = Files.probeContentType(this.attachedFile.toPath());
            if (guessedMimeType != null) {
                return guessedMimeType;
            }
        }
        catch (IOException | SecurityException exception) {
            // empty catch block
        }
        return SERVER_OCTET_STREAM;
    }

    public String getFileFormat() {
        if (this.attachedFile != null) {
            return this.format;
        }
        String format = this.getOriginalMimetype();
        if (SERVER_PDF.equals(format)) {
            return PDF;
        }
        if (SERVER_CSV.equals(format)) {
            return CSV;
        }
        if (SERVER_TEXT.equals(format)) {
            return TEXT;
        }
        if (SERVER_XML.equals(format)) {
            return XML;
        }
        if (SERVER_HTML.equals(format)) {
            return HTML;
        }
        if (SERVER_RTF.equals(format)) {
            return RTF;
        }
        if (SERVER_MS_EXCEL.equals(format)) {
            return MS_EXCEL;
        }
        if (SERVER_MS_WORD.equals(format)) {
            return MS_WORD;
        }
        if (SERVER_MS_POWERPOINT.equals(format)) {
            return MS_POWER_POINT;
        }
        return UNKNOWN;
    }

    public String getFileKind() {
        String format = this.getFileFormat();
        if (PDF.equals(format)) {
            return "PDF Document";
        }
        if (XML.equals(format)) {
            return "XML Document";
        }
        if (MS_WORD.equals(format) || MS_WORD_X.equals(format)) {
            return "Microsoft Word Document";
        }
        if (MS_EXCEL.equals(format)) {
            return "Microsoft Excel Document";
        }
        if (MS_POWER_POINT.equals(format) || MS_POWER_POINT_SHOW.equals(format) || MS_POWER_POINT_X.equals(format)) {
            return "Microsoft Powerpoint Document";
        }
        if (TEXT.equals(format)) {
            return "Plain Text Document";
        }
        if (HTML.equals(format) || HTM.equals(format)) {
            return "HTML Document";
        }
        if (CSV.equals(format)) {
            return "Comma Separated Value Document";
        }
        if (RTF.equals(format)) {
            return "Rich Text Format Document";
        }
        return "";
    }

    public File getAttachedFile() {
        return this.attachedFile;
    }

    public String getFileName() {
        if (this.attachedFile != null) {
            return this.attachedFile.getName();
        }
        OriginalFile f = this.getFile();
        String name = "";
        if (f != null) {
            if (f.getName() != null) {
                name = f.getName().getValue();
            }
            if (name != null && name.trim().length() != 0) {
                return name;
            }
            if (f.getPath() != null) {
                name = f.getPath().getValue();
            }
            if (name != null && name.trim().length() != 0) {
                return name;
            }
        }
        return "" + this.getFileID();
    }

    public String getFilePath() {
        if (this.attachedFile != null) {
            return this.attachedFile.getAbsolutePath();
        }
        OriginalFile f = this.getFile();
        if (f != null && f.getPath() != null) {
            return f.getPath().getValue();
        }
        return "";
    }

    public long getFileSize() {
        if (this.getId() < 0L) {
            return -1L;
        }
        OriginalFile f = this.getFile();
        if (f == null || f.getSize() == null) {
            return -1L;
        }
        return f.getSize().getValue();
    }

    public long getFileID() {
        if (this.getId() < 0L) {
            return -1L;
        }
        OriginalFile f = this.getFile();
        if (f == null || f.getId() == null) {
            return -1L;
        }
        return f.getId().getValue();
    }

    @Override
    public Object getContent() {
        return ((FileAnnotation)this.asAnnotation()).getFile();
    }

    @Override
    public String getContentAsString() {
        return this.getFilePath();
    }

    public boolean isMovieFile() {
        String ns = this.getNameSpace();
        if (MOVIE_NS.equals(ns)) {
            return true;
        }
        String format = this.getOriginalMimetype();
        return format.contains("video");
    }

    @Override
    public void setContent(Object content) {
        if (content == null) {
            throw new IllegalArgumentException("Content must be an Original file");
        }
        if (!(content instanceof OriginalFile)) {
            throw new IllegalArgumentException("Content must be an Original file");
        }
        this.setDirty(true);
        ((FileAnnotation)this.asAnnotation()).setFile((OriginalFile)content);
    }
}

