/*
 * Decompiled with CFR 0.152.
 */
package omero.gateway.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import omero.gateway.model.DataObject;
import omero.model.Fileset;
import omero.model.FilesetEntry;
import omero.model.Image;
import omero.model.OriginalFile;

public class FilesetData
extends DataObject {
    public FilesetData(Fileset set) {
        if (set == null) {
            throw new IllegalArgumentException("No set specified");
        }
        this.setValue(set);
    }

    public List<String> getAbsolutePaths() {
        ArrayList<String> paths = new ArrayList<String>();
        Fileset set = (Fileset)this.asIObject();
        List<FilesetEntry> entries = set.copyUsedFiles();
        if (entries == null) {
            return paths;
        }
        Iterator<FilesetEntry> i = entries.iterator();
        while (i.hasNext()) {
            OriginalFile f = i.next().getOriginalFile();
            StringBuffer buffer = new StringBuffer();
            if (f.getPath() != null) {
                buffer.append(f.getPath().getValue());
            }
            if (f.getName() != null) {
                buffer.append(f.getName().getValue());
            }
            paths.add(buffer.toString());
        }
        return paths;
    }

    public List<String> getUsedFilePaths() {
        ArrayList<String> paths = new ArrayList<String>();
        Fileset set = (Fileset)this.asIObject();
        List<FilesetEntry> entries = set.copyUsedFiles();
        for (FilesetEntry next : entries) {
            paths.add(next.getClientPath().getValue());
        }
        return paths;
    }

    public List<Long> getImageIds() {
        ArrayList<Long> ids = new ArrayList<Long>();
        Fileset fs = (Fileset)this.asIObject();
        List<Image> images = fs.copyImages();
        if (images == null || images.size() == 0) {
            return ids;
        }
        Iterator<Image> i = images.iterator();
        while (i.hasNext()) {
            ids.add(i.next().getId().getValue());
        }
        return ids;
    }
}

