/*
 * Decompiled with CFR 0.152.
 */
package omero.gateway.model;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.gateway.model.ImageData;
import omero.gateway.model.PlateData;
import omero.gateway.model.ProjectData;
import omero.gateway.model.ScreenData;
import omero.gateway.model.SearchScope;
import org.apache.commons.lang.StringUtils;

public class SearchParameters {
    public static final int ALL_GROUPS_ID = -1;
    public static final int DATE_IMPORT = 0;
    public static final int DATE_ACQUISITION = 1;
    public static final Set<SearchScope> ALL_SCOPE = new HashSet<SearchScope>();
    public static final List<Class<? extends DataObject>> ALL_TYPES;
    private Timestamp start;
    private Timestamp end;
    private int dateType = -1;
    private Set<SearchScope> scope;
    private List<Class<? extends DataObject>> types;
    private String query;
    private long groupId = -1L;
    private long userId = -1L;

    public SearchParameters(Set<SearchScope> scope, List<Class<? extends DataObject>> types, String query) {
        this.query = query;
        this.scope = scope;
        this.types = types;
    }

    public void setTimeInterval(Timestamp start, Timestamp end, int type) {
        this.start = start;
        this.end = end;
        this.dateType = type;
    }

    public Timestamp getStart() {
        return this.start;
    }

    public Timestamp getEnd() {
        return this.end;
    }

    public Set<SearchScope> getScope() {
        return this.scope;
    }

    public List<Class<? extends DataObject>> getTypes() {
        return this.types;
    }

    public String getQuery() {
        return this.query;
    }

    public boolean isValid() {
        return !StringUtils.isBlank((String)this.query) || this.start != null || this.end != null;
    }

    public boolean hasTextToSearch() {
        return StringUtils.isNotBlank((String)this.query);
    }

    public long getUserId() {
        return this.userId;
    }

    public void setUserId(long userId) {
        this.userId = userId;
    }

    public int getDateType() {
        return this.dateType;
    }

    public void setDateType(int dateType) {
        this.dateType = dateType;
    }

    public long getGroupId() {
        return this.groupId;
    }

    public void setGroupId(long groupId) {
        this.groupId = groupId;
    }

    static {
        ALL_SCOPE.add(SearchScope.NAME);
        ALL_SCOPE.add(SearchScope.DESCRIPTION);
        ALL_SCOPE.add(SearchScope.ANNOTATION);
        ALL_TYPES = new ArrayList<Class<? extends DataObject>>();
        ALL_TYPES.add(ImageData.class);
        ALL_TYPES.add(DatasetData.class);
        ALL_TYPES.add(ProjectData.class);
        ALL_TYPES.add(PlateData.class);
        ALL_TYPES.add(ScreenData.class);
    }
}

