/*
 * Decompiled with CFR 0.152.
 */
package omero.model;

import Ice.Current;
import Ice.DispatchStatus;
import Ice.FormatType;
import Ice.OperationMode;
import Ice.OperationNotExistException;
import IceInternal.BasicStream;
import IceInternal.Ex;
import IceInternal.Incoming;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import omero.RInt;
import omero.RIntHolder;
import omero.RLong;
import omero.RString;
import omero.RStringHolder;
import omero.model.Annotation;
import omero.model.AnnotationHolder;
import omero.model.Details;
import omero.model.IObject;
import omero.model.ReagentAnnotationLink;
import omero.model.ReagentAnnotationLinkHolder;
import omero.model.ReagentAnnotationLinksSeqHelper;
import omero.model.ReagentHolder;
import omero.model.ReagentLinkedAnnotationSeqHelper;
import omero.model.ReagentLinkedWellSeqHelper;
import omero.model.ReagentWellLinksSeqHelper;
import omero.model.Screen;
import omero.model.ScreenHolder;
import omero.model.Well;
import omero.model.WellHolder;
import omero.model.WellReagentLink;
import omero.model.WellReagentLinkHolder;
import omero.model._ReagentOperations;
import omero.model._ReagentOperationsNC;
import omero.sys.CountMapHelper;

public abstract class Reagent
extends IObject
implements _ReagentOperations,
_ReagentOperationsNC {
    public static final String[] __ids = new String[]{"::Ice::Object", "::omero::model::IObject", "::omero::model::Reagent"};
    private static final String[] __all = new String[]{"addAllReagentAnnotationLinkSet", "addAllWellReagentLinkSet", "addReagentAnnotationLink", "addReagentAnnotationLinkToBoth", "addWellReagentLink", "addWellReagentLinkToBoth", "clearAnnotationLinks", "clearWellLinks", "copyAnnotationLinks", "copyWellLinks", "findReagentAnnotationLink", "findWellReagentLink", "getAnnotationLinksCountPerOwner", "getDescription", "getDetails", "getId", "getName", "getReagentIdentifier", "getScreen", "getVersion", "getWellLinksCountPerOwner", "ice_id", "ice_ids", "ice_isA", "ice_ping", "isAnnotated", "isGlobal", "isLink", "isLoaded", "isMutable", "linkAnnotation", "linkWell", "linkedAnnotationList", "linkedWellList", "proxy", "reloadAnnotationLinks", "reloadWellLinks", "removeAllReagentAnnotationLinkSet", "removeAllWellReagentLinkSet", "removeReagentAnnotationLink", "removeReagentAnnotationLinkFromBoth", "removeWellReagentLink", "removeWellReagentLinkFromBoth", "setDescription", "setId", "setName", "setReagentIdentifier", "setScreen", "setVersion", "shallowCopy", "sizeOfAnnotationLinks", "sizeOfWellLinks", "unlinkAnnotation", "unlinkWell", "unload", "unloadAnnotationLinks", "unloadCollections", "unloadDetails", "unloadWellLinks"};
    protected RInt version;
    protected RString name;
    protected RString reagentIdentifier;
    protected Screen screen;
    protected List<WellReagentLink> wellLinksSeq;
    protected boolean wellLinksLoaded;
    protected Map<Long, Long> wellLinksCountPerOwner;
    protected List<ReagentAnnotationLink> annotationLinksSeq;
    protected boolean annotationLinksLoaded;
    protected Map<Long, Long> annotationLinksCountPerOwner;
    protected RString description;
    public static final long serialVersionUID = -5597289103596011445L;

    public Reagent() {
    }

    public Reagent(RLong id, Details details, boolean loaded, RInt version, RString name, RString reagentIdentifier, Screen screen, List<WellReagentLink> wellLinksSeq, boolean wellLinksLoaded, Map<Long, Long> wellLinksCountPerOwner, List<ReagentAnnotationLink> annotationLinksSeq, boolean annotationLinksLoaded, Map<Long, Long> annotationLinksCountPerOwner, RString description) {
        super(id, details, loaded);
        this.version = version;
        this.name = name;
        this.reagentIdentifier = reagentIdentifier;
        this.screen = screen;
        this.wellLinksSeq = wellLinksSeq;
        this.wellLinksLoaded = wellLinksLoaded;
        this.wellLinksCountPerOwner = wellLinksCountPerOwner;
        this.annotationLinksSeq = annotationLinksSeq;
        this.annotationLinksLoaded = annotationLinksLoaded;
        this.annotationLinksCountPerOwner = annotationLinksCountPerOwner;
        this.description = description;
    }

    @Override
    public boolean ice_isA(String s) {
        return Arrays.binarySearch(__ids, s) >= 0;
    }

    @Override
    public boolean ice_isA(String s, Current __current) {
        return Arrays.binarySearch(__ids, s) >= 0;
    }

    @Override
    public String[] ice_ids() {
        return __ids;
    }

    @Override
    public String[] ice_ids(Current __current) {
        return __ids;
    }

    @Override
    public String ice_id() {
        return __ids[2];
    }

    @Override
    public String ice_id(Current __current) {
        return __ids[2];
    }

    public static String ice_staticId() {
        return __ids[2];
    }

    @Override
    public final void addAllReagentAnnotationLinkSet(List<ReagentAnnotationLink> targets) {
        this.addAllReagentAnnotationLinkSet(targets, null);
    }

    @Override
    public final void addAllWellReagentLinkSet(List<WellReagentLink> targets) {
        this.addAllWellReagentLinkSet(targets, null);
    }

    @Override
    public final void addReagentAnnotationLink(ReagentAnnotationLink target) {
        this.addReagentAnnotationLink(target, null);
    }

    @Override
    public final void addReagentAnnotationLinkToBoth(ReagentAnnotationLink link, boolean bothSides) {
        this.addReagentAnnotationLinkToBoth(link, bothSides, null);
    }

    @Override
    public final void addWellReagentLink(WellReagentLink target) {
        this.addWellReagentLink(target, null);
    }

    @Override
    public final void addWellReagentLinkToBoth(WellReagentLink link, boolean bothSides) {
        this.addWellReagentLinkToBoth(link, bothSides, null);
    }

    @Override
    public final void clearAnnotationLinks() {
        this.clearAnnotationLinks(null);
    }

    @Override
    public final void clearWellLinks() {
        this.clearWellLinks(null);
    }

    @Override
    public final List<ReagentAnnotationLink> copyAnnotationLinks() {
        return this.copyAnnotationLinks(null);
    }

    @Override
    public final List<WellReagentLink> copyWellLinks() {
        return this.copyWellLinks(null);
    }

    @Override
    public final List<ReagentAnnotationLink> findReagentAnnotationLink(Annotation removal) {
        return this.findReagentAnnotationLink(removal, null);
    }

    @Override
    public final List<WellReagentLink> findWellReagentLink(Well removal) {
        return this.findWellReagentLink(removal, null);
    }

    @Override
    public final Map<Long, Long> getAnnotationLinksCountPerOwner() {
        return this.getAnnotationLinksCountPerOwner(null);
    }

    @Override
    public final RString getDescription() {
        return this.getDescription(null);
    }

    @Override
    public final RString getName() {
        return this.getName(null);
    }

    @Override
    public final RString getReagentIdentifier() {
        return this.getReagentIdentifier(null);
    }

    @Override
    public final Screen getScreen() {
        return this.getScreen(null);
    }

    @Override
    public final RInt getVersion() {
        return this.getVersion(null);
    }

    @Override
    public final Map<Long, Long> getWellLinksCountPerOwner() {
        return this.getWellLinksCountPerOwner(null);
    }

    @Override
    public final ReagentAnnotationLink linkAnnotation(Annotation addition) {
        return this.linkAnnotation(addition, null);
    }

    @Override
    public final WellReagentLink linkWell(Well addition) {
        return this.linkWell(addition, null);
    }

    @Override
    public final List<Annotation> linkedAnnotationList() {
        return this.linkedAnnotationList(null);
    }

    @Override
    public final List<Well> linkedWellList() {
        return this.linkedWellList(null);
    }

    @Override
    public final void reloadAnnotationLinks(Reagent toCopy) {
        this.reloadAnnotationLinks(toCopy, null);
    }

    @Override
    public final void reloadWellLinks(Reagent toCopy) {
        this.reloadWellLinks(toCopy, null);
    }

    @Override
    public final void removeAllReagentAnnotationLinkSet(List<ReagentAnnotationLink> targets) {
        this.removeAllReagentAnnotationLinkSet(targets, null);
    }

    @Override
    public final void removeAllWellReagentLinkSet(List<WellReagentLink> targets) {
        this.removeAllWellReagentLinkSet(targets, null);
    }

    @Override
    public final void removeReagentAnnotationLink(ReagentAnnotationLink theTarget) {
        this.removeReagentAnnotationLink(theTarget, null);
    }

    @Override
    public final void removeReagentAnnotationLinkFromBoth(ReagentAnnotationLink link, boolean bothSides) {
        this.removeReagentAnnotationLinkFromBoth(link, bothSides, null);
    }

    @Override
    public final void removeWellReagentLink(WellReagentLink theTarget) {
        this.removeWellReagentLink(theTarget, null);
    }

    @Override
    public final void removeWellReagentLinkFromBoth(WellReagentLink link, boolean bothSides) {
        this.removeWellReagentLinkFromBoth(link, bothSides, null);
    }

    @Override
    public final void setDescription(RString theDescription) {
        this.setDescription(theDescription, null);
    }

    @Override
    public final void setName(RString theName) {
        this.setName(theName, null);
    }

    @Override
    public final void setReagentIdentifier(RString theReagentIdentifier) {
        this.setReagentIdentifier(theReagentIdentifier, null);
    }

    @Override
    public final void setScreen(Screen theScreen) {
        this.setScreen(theScreen, null);
    }

    @Override
    public final void setVersion(RInt theVersion) {
        this.setVersion(theVersion, null);
    }

    @Override
    public final int sizeOfAnnotationLinks() {
        return this.sizeOfAnnotationLinks(null);
    }

    @Override
    public final int sizeOfWellLinks() {
        return this.sizeOfWellLinks(null);
    }

    @Override
    public final void unlinkAnnotation(Annotation removal) {
        this.unlinkAnnotation(removal, null);
    }

    @Override
    public final void unlinkWell(Well removal) {
        this.unlinkWell(removal, null);
    }

    @Override
    public final void unloadAnnotationLinks() {
        this.unloadAnnotationLinks(null);
    }

    @Override
    public final void unloadWellLinks() {
        this.unloadWellLinks(null);
    }

    public static DispatchStatus ___getVersion(Reagent __obj, Incoming __inS, Current __current) {
        Reagent.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        RInt __ret = __obj.getVersion(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        __os.writeObject((Ice.Object)__ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___setVersion(Reagent __obj, Incoming __inS, Current __current) {
        Reagent.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        RIntHolder theVersion = new RIntHolder();
        __is.readObject((IceInternal.Patcher)theVersion);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.setVersion((RInt)theVersion.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___getName(Reagent __obj, Incoming __inS, Current __current) {
        Reagent.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        RString __ret = __obj.getName(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        __os.writeObject((Ice.Object)__ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___setName(Reagent __obj, Incoming __inS, Current __current) {
        Reagent.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        RStringHolder theName = new RStringHolder();
        __is.readObject((IceInternal.Patcher)theName);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.setName((RString)theName.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___getReagentIdentifier(Reagent __obj, Incoming __inS, Current __current) {
        Reagent.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        RString __ret = __obj.getReagentIdentifier(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        __os.writeObject((Ice.Object)__ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___setReagentIdentifier(Reagent __obj, Incoming __inS, Current __current) {
        Reagent.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        RStringHolder theReagentIdentifier = new RStringHolder();
        __is.readObject((IceInternal.Patcher)theReagentIdentifier);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.setReagentIdentifier((RString)theReagentIdentifier.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___getScreen(Reagent __obj, Incoming __inS, Current __current) {
        Reagent.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        Screen __ret = __obj.getScreen(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        __os.writeObject((Ice.Object)__ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___setScreen(Reagent __obj, Incoming __inS, Current __current) {
        Reagent.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        ScreenHolder theScreen = new ScreenHolder();
        __is.readObject((IceInternal.Patcher)theScreen);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.setScreen((Screen)theScreen.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___unloadWellLinks(Reagent __obj, Incoming __inS, Current __current) {
        Reagent.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        __obj.unloadWellLinks(__current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___sizeOfWellLinks(Reagent __obj, Incoming __inS, Current __current) {
        Reagent.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        int __ret = __obj.sizeOfWellLinks(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        __os.writeInt(__ret);
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___copyWellLinks(Reagent __obj, Incoming __inS, Current __current) {
        Reagent.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        List __ret = __obj.copyWellLinks(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        ReagentWellLinksSeqHelper.write(__os, __ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___addWellReagentLink(Reagent __obj, Incoming __inS, Current __current) {
        Reagent.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        WellReagentLinkHolder target = new WellReagentLinkHolder();
        __is.readObject((IceInternal.Patcher)target);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.addWellReagentLink((WellReagentLink)target.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___addAllWellReagentLinkSet(Reagent __obj, Incoming __inS, Current __current) {
        Reagent.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        List<WellReagentLink> targets = ReagentWellLinksSeqHelper.read(__is);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.addAllWellReagentLinkSet(targets, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___removeWellReagentLink(Reagent __obj, Incoming __inS, Current __current) {
        Reagent.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        WellReagentLinkHolder theTarget = new WellReagentLinkHolder();
        __is.readObject((IceInternal.Patcher)theTarget);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.removeWellReagentLink((WellReagentLink)theTarget.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___removeAllWellReagentLinkSet(Reagent __obj, Incoming __inS, Current __current) {
        Reagent.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        List<WellReagentLink> targets = ReagentWellLinksSeqHelper.read(__is);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.removeAllWellReagentLinkSet(targets, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___clearWellLinks(Reagent __obj, Incoming __inS, Current __current) {
        Reagent.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        __obj.clearWellLinks(__current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___reloadWellLinks(Reagent __obj, Incoming __inS, Current __current) {
        Reagent.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        ReagentHolder toCopy = new ReagentHolder();
        __is.readObject((IceInternal.Patcher)toCopy);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.reloadWellLinks((Reagent)toCopy.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___getWellLinksCountPerOwner(Reagent __obj, Incoming __inS, Current __current) {
        Reagent.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        Map __ret = __obj.getWellLinksCountPerOwner(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        CountMapHelper.write(__os, __ret);
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___linkWell(Reagent __obj, Incoming __inS, Current __current) {
        Reagent.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        WellHolder addition = new WellHolder();
        __is.readObject((IceInternal.Patcher)addition);
        __is.readPendingObjects();
        __inS.endReadParams();
        WellReagentLink __ret = __obj.linkWell((Well)addition.value, __current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        __os.writeObject((Ice.Object)__ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___addWellReagentLinkToBoth(Reagent __obj, Incoming __inS, Current __current) {
        Reagent.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        WellReagentLinkHolder link = new WellReagentLinkHolder();
        __is.readObject((IceInternal.Patcher)link);
        boolean bothSides = __is.readBool();
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.addWellReagentLinkToBoth((WellReagentLink)link.value, bothSides, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___findWellReagentLink(Reagent __obj, Incoming __inS, Current __current) {
        Reagent.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        WellHolder removal = new WellHolder();
        __is.readObject((IceInternal.Patcher)removal);
        __is.readPendingObjects();
        __inS.endReadParams();
        List __ret = __obj.findWellReagentLink((Well)removal.value, __current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        ReagentWellLinksSeqHelper.write(__os, __ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___unlinkWell(Reagent __obj, Incoming __inS, Current __current) {
        Reagent.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        WellHolder removal = new WellHolder();
        __is.readObject((IceInternal.Patcher)removal);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.unlinkWell((Well)removal.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___removeWellReagentLinkFromBoth(Reagent __obj, Incoming __inS, Current __current) {
        Reagent.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        WellReagentLinkHolder link = new WellReagentLinkHolder();
        __is.readObject((IceInternal.Patcher)link);
        boolean bothSides = __is.readBool();
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.removeWellReagentLinkFromBoth((WellReagentLink)link.value, bothSides, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___linkedWellList(Reagent __obj, Incoming __inS, Current __current) {
        Reagent.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        List __ret = __obj.linkedWellList(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        ReagentLinkedWellSeqHelper.write(__os, __ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___unloadAnnotationLinks(Reagent __obj, Incoming __inS, Current __current) {
        Reagent.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        __obj.unloadAnnotationLinks(__current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___sizeOfAnnotationLinks(Reagent __obj, Incoming __inS, Current __current) {
        Reagent.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        int __ret = __obj.sizeOfAnnotationLinks(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        __os.writeInt(__ret);
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___copyAnnotationLinks(Reagent __obj, Incoming __inS, Current __current) {
        Reagent.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        List __ret = __obj.copyAnnotationLinks(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        ReagentAnnotationLinksSeqHelper.write(__os, __ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___addReagentAnnotationLink(Reagent __obj, Incoming __inS, Current __current) {
        Reagent.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        ReagentAnnotationLinkHolder target = new ReagentAnnotationLinkHolder();
        __is.readObject((IceInternal.Patcher)target);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.addReagentAnnotationLink((ReagentAnnotationLink)target.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___addAllReagentAnnotationLinkSet(Reagent __obj, Incoming __inS, Current __current) {
        Reagent.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        List<ReagentAnnotationLink> targets = ReagentAnnotationLinksSeqHelper.read(__is);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.addAllReagentAnnotationLinkSet(targets, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___removeReagentAnnotationLink(Reagent __obj, Incoming __inS, Current __current) {
        Reagent.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        ReagentAnnotationLinkHolder theTarget = new ReagentAnnotationLinkHolder();
        __is.readObject((IceInternal.Patcher)theTarget);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.removeReagentAnnotationLink((ReagentAnnotationLink)theTarget.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___removeAllReagentAnnotationLinkSet(Reagent __obj, Incoming __inS, Current __current) {
        Reagent.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        List<ReagentAnnotationLink> targets = ReagentAnnotationLinksSeqHelper.read(__is);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.removeAllReagentAnnotationLinkSet(targets, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___clearAnnotationLinks(Reagent __obj, Incoming __inS, Current __current) {
        Reagent.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        __obj.clearAnnotationLinks(__current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___reloadAnnotationLinks(Reagent __obj, Incoming __inS, Current __current) {
        Reagent.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        ReagentHolder toCopy = new ReagentHolder();
        __is.readObject((IceInternal.Patcher)toCopy);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.reloadAnnotationLinks((Reagent)toCopy.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___getAnnotationLinksCountPerOwner(Reagent __obj, Incoming __inS, Current __current) {
        Reagent.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        Map __ret = __obj.getAnnotationLinksCountPerOwner(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        CountMapHelper.write(__os, __ret);
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___linkAnnotation(Reagent __obj, Incoming __inS, Current __current) {
        Reagent.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        AnnotationHolder addition = new AnnotationHolder();
        __is.readObject((IceInternal.Patcher)addition);
        __is.readPendingObjects();
        __inS.endReadParams();
        ReagentAnnotationLink __ret = __obj.linkAnnotation((Annotation)addition.value, __current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        __os.writeObject((Ice.Object)__ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___addReagentAnnotationLinkToBoth(Reagent __obj, Incoming __inS, Current __current) {
        Reagent.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        ReagentAnnotationLinkHolder link = new ReagentAnnotationLinkHolder();
        __is.readObject((IceInternal.Patcher)link);
        boolean bothSides = __is.readBool();
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.addReagentAnnotationLinkToBoth((ReagentAnnotationLink)link.value, bothSides, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___findReagentAnnotationLink(Reagent __obj, Incoming __inS, Current __current) {
        Reagent.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        AnnotationHolder removal = new AnnotationHolder();
        __is.readObject((IceInternal.Patcher)removal);
        __is.readPendingObjects();
        __inS.endReadParams();
        List __ret = __obj.findReagentAnnotationLink((Annotation)removal.value, __current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        ReagentAnnotationLinksSeqHelper.write(__os, __ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___unlinkAnnotation(Reagent __obj, Incoming __inS, Current __current) {
        Reagent.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        AnnotationHolder removal = new AnnotationHolder();
        __is.readObject((IceInternal.Patcher)removal);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.unlinkAnnotation((Annotation)removal.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___removeReagentAnnotationLinkFromBoth(Reagent __obj, Incoming __inS, Current __current) {
        Reagent.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        ReagentAnnotationLinkHolder link = new ReagentAnnotationLinkHolder();
        __is.readObject((IceInternal.Patcher)link);
        boolean bothSides = __is.readBool();
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.removeReagentAnnotationLinkFromBoth((ReagentAnnotationLink)link.value, bothSides, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___linkedAnnotationList(Reagent __obj, Incoming __inS, Current __current) {
        Reagent.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        List __ret = __obj.linkedAnnotationList(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        ReagentLinkedAnnotationSeqHelper.write(__os, __ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___getDescription(Reagent __obj, Incoming __inS, Current __current) {
        Reagent.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        RString __ret = __obj.getDescription(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        __os.writeObject((Ice.Object)__ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___setDescription(Reagent __obj, Incoming __inS, Current __current) {
        Reagent.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        RStringHolder theDescription = new RStringHolder();
        __is.readObject((IceInternal.Patcher)theDescription);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.setDescription((RString)theDescription.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    @Override
    public DispatchStatus __dispatch(Incoming in, Current __current) {
        int pos = Arrays.binarySearch(__all, __current.operation);
        if (pos < 0) {
            throw new OperationNotExistException(__current.id, __current.facet, __current.operation);
        }
        switch (pos) {
            case 0: {
                return Reagent.___addAllReagentAnnotationLinkSet(this, in, __current);
            }
            case 1: {
                return Reagent.___addAllWellReagentLinkSet(this, in, __current);
            }
            case 2: {
                return Reagent.___addReagentAnnotationLink(this, in, __current);
            }
            case 3: {
                return Reagent.___addReagentAnnotationLinkToBoth(this, in, __current);
            }
            case 4: {
                return Reagent.___addWellReagentLink(this, in, __current);
            }
            case 5: {
                return Reagent.___addWellReagentLinkToBoth(this, in, __current);
            }
            case 6: {
                return Reagent.___clearAnnotationLinks(this, in, __current);
            }
            case 7: {
                return Reagent.___clearWellLinks(this, in, __current);
            }
            case 8: {
                return Reagent.___copyAnnotationLinks(this, in, __current);
            }
            case 9: {
                return Reagent.___copyWellLinks(this, in, __current);
            }
            case 10: {
                return Reagent.___findReagentAnnotationLink(this, in, __current);
            }
            case 11: {
                return Reagent.___findWellReagentLink(this, in, __current);
            }
            case 12: {
                return Reagent.___getAnnotationLinksCountPerOwner(this, in, __current);
            }
            case 13: {
                return Reagent.___getDescription(this, in, __current);
            }
            case 14: {
                return IObject.___getDetails(this, in, __current);
            }
            case 15: {
                return IObject.___getId(this, in, __current);
            }
            case 16: {
                return Reagent.___getName(this, in, __current);
            }
            case 17: {
                return Reagent.___getReagentIdentifier(this, in, __current);
            }
            case 18: {
                return Reagent.___getScreen(this, in, __current);
            }
            case 19: {
                return Reagent.___getVersion(this, in, __current);
            }
            case 20: {
                return Reagent.___getWellLinksCountPerOwner(this, in, __current);
            }
            case 21: {
                return Reagent.___ice_id((Ice.Object)this, (Incoming)in, (Current)__current);
            }
            case 22: {
                return Reagent.___ice_ids((Ice.Object)this, (Incoming)in, (Current)__current);
            }
            case 23: {
                return Reagent.___ice_isA((Ice.Object)this, (Incoming)in, (Current)__current);
            }
            case 24: {
                return Reagent.___ice_ping((Ice.Object)this, (Incoming)in, (Current)__current);
            }
            case 25: {
                return IObject.___isAnnotated(this, in, __current);
            }
            case 26: {
                return IObject.___isGlobal(this, in, __current);
            }
            case 27: {
                return IObject.___isLink(this, in, __current);
            }
            case 28: {
                return IObject.___isLoaded(this, in, __current);
            }
            case 29: {
                return IObject.___isMutable(this, in, __current);
            }
            case 30: {
                return Reagent.___linkAnnotation(this, in, __current);
            }
            case 31: {
                return Reagent.___linkWell(this, in, __current);
            }
            case 32: {
                return Reagent.___linkedAnnotationList(this, in, __current);
            }
            case 33: {
                return Reagent.___linkedWellList(this, in, __current);
            }
            case 34: {
                return IObject.___proxy(this, in, __current);
            }
            case 35: {
                return Reagent.___reloadAnnotationLinks(this, in, __current);
            }
            case 36: {
                return Reagent.___reloadWellLinks(this, in, __current);
            }
            case 37: {
                return Reagent.___removeAllReagentAnnotationLinkSet(this, in, __current);
            }
            case 38: {
                return Reagent.___removeAllWellReagentLinkSet(this, in, __current);
            }
            case 39: {
                return Reagent.___removeReagentAnnotationLink(this, in, __current);
            }
            case 40: {
                return Reagent.___removeReagentAnnotationLinkFromBoth(this, in, __current);
            }
            case 41: {
                return Reagent.___removeWellReagentLink(this, in, __current);
            }
            case 42: {
                return Reagent.___removeWellReagentLinkFromBoth(this, in, __current);
            }
            case 43: {
                return Reagent.___setDescription(this, in, __current);
            }
            case 44: {
                return IObject.___setId(this, in, __current);
            }
            case 45: {
                return Reagent.___setName(this, in, __current);
            }
            case 46: {
                return Reagent.___setReagentIdentifier(this, in, __current);
            }
            case 47: {
                return Reagent.___setScreen(this, in, __current);
            }
            case 48: {
                return Reagent.___setVersion(this, in, __current);
            }
            case 49: {
                return IObject.___shallowCopy(this, in, __current);
            }
            case 50: {
                return Reagent.___sizeOfAnnotationLinks(this, in, __current);
            }
            case 51: {
                return Reagent.___sizeOfWellLinks(this, in, __current);
            }
            case 52: {
                return Reagent.___unlinkAnnotation(this, in, __current);
            }
            case 53: {
                return Reagent.___unlinkWell(this, in, __current);
            }
            case 54: {
                return IObject.___unload(this, in, __current);
            }
            case 55: {
                return Reagent.___unloadAnnotationLinks(this, in, __current);
            }
            case 56: {
                return IObject.___unloadCollections(this, in, __current);
            }
            case 57: {
                return IObject.___unloadDetails(this, in, __current);
            }
            case 58: {
                return Reagent.___unloadWellLinks(this, in, __current);
            }
        }
        assert (false);
        throw new OperationNotExistException(__current.id, __current.facet, __current.operation);
    }

    @Override
    protected void __writeImpl(BasicStream __os) {
        __os.startWriteSlice(Reagent.ice_staticId(), -1, false);
        __os.writeObject((Ice.Object)this.version);
        __os.writeObject((Ice.Object)this.name);
        __os.writeObject((Ice.Object)this.reagentIdentifier);
        __os.writeObject((Ice.Object)this.screen);
        ReagentWellLinksSeqHelper.write(__os, this.wellLinksSeq);
        __os.writeBool(this.wellLinksLoaded);
        CountMapHelper.write(__os, this.wellLinksCountPerOwner);
        ReagentAnnotationLinksSeqHelper.write(__os, this.annotationLinksSeq);
        __os.writeBool(this.annotationLinksLoaded);
        CountMapHelper.write(__os, this.annotationLinksCountPerOwner);
        __os.writeObject((Ice.Object)this.description);
        __os.endWriteSlice();
        super.__writeImpl(__os);
    }

    @Override
    protected void __readImpl(BasicStream __is) {
        __is.startReadSlice();
        __is.readObject((IceInternal.Patcher)new Patcher(0));
        __is.readObject((IceInternal.Patcher)new Patcher(1));
        __is.readObject((IceInternal.Patcher)new Patcher(2));
        __is.readObject((IceInternal.Patcher)new Patcher(3));
        this.wellLinksSeq = ReagentWellLinksSeqHelper.read(__is);
        this.wellLinksLoaded = __is.readBool();
        this.wellLinksCountPerOwner = CountMapHelper.read(__is);
        this.annotationLinksSeq = ReagentAnnotationLinksSeqHelper.read(__is);
        this.annotationLinksLoaded = __is.readBool();
        this.annotationLinksCountPerOwner = CountMapHelper.read(__is);
        __is.readObject((IceInternal.Patcher)new Patcher(4));
        __is.endReadSlice();
        super.__readImpl(__is);
    }

    @Override
    public Reagent clone() {
        return (Reagent)super.clone();
    }

    private class Patcher
    implements IceInternal.Patcher {
        private int __member;
        private String __typeId;

        Patcher(int member) {
            this.__member = member;
        }

        public void patch(Ice.Object v) {
            switch (this.__member) {
                case 0: {
                    this.__typeId = "::omero::RInt";
                    if (v == null || v instanceof RInt) {
                        Reagent.this.version = (RInt)v;
                        break;
                    }
                    Ex.throwUOE((String)this.type(), (Ice.Object)v);
                    break;
                }
                case 1: {
                    this.__typeId = "::omero::RString";
                    if (v == null || v instanceof RString) {
                        Reagent.this.name = (RString)v;
                        break;
                    }
                    Ex.throwUOE((String)this.type(), (Ice.Object)v);
                    break;
                }
                case 2: {
                    this.__typeId = "::omero::RString";
                    if (v == null || v instanceof RString) {
                        Reagent.this.reagentIdentifier = (RString)v;
                        break;
                    }
                    Ex.throwUOE((String)this.type(), (Ice.Object)v);
                    break;
                }
                case 3: {
                    this.__typeId = "::omero::model::Screen";
                    if (v == null || v instanceof Screen) {
                        Reagent.this.screen = (Screen)v;
                        break;
                    }
                    Ex.throwUOE((String)this.type(), (Ice.Object)v);
                    break;
                }
                case 4: {
                    this.__typeId = "::omero::RString";
                    if (v == null || v instanceof RString) {
                        Reagent.this.description = (RString)v;
                        break;
                    }
                    Ex.throwUOE((String)this.type(), (Ice.Object)v);
                }
            }
        }

        public String type() {
            return this.__typeId;
        }
    }
}

