/*
 * Decompiled with CFR 0.152.
 */
package omero.model;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import omero.model.EllipseI;
import omero.model.Point;
import omero.model.SmartPointI;
import omero.model.SmartShape;
import omero.rtypes;

public class SmartEllipseI
extends EllipseI
implements SmartShape {
    @Override
    public void areaPoints(SmartShape.PointCallback cb) {
        Shape s = this.asAwtShape();
        if (s == null) {
            return;
        }
        if (this.transform != null) {
            s = SmartShape.Util.transformAwtShape(s, this.transform);
        }
        Rectangle2D r = s.getBounds2D();
        SmartShape.Util.pointsByBoundingBox(s, r, cb);
    }

    @Override
    public Shape asAwtShape() {
        try {
            double x = this.getX().getValue();
            double y = this.getY().getValue();
            double radiusx = this.getRadiusX().getValue();
            double radiusy = this.getRadiusY().getValue();
            double height = radiusy * 2.0;
            double width = radiusx * 2.0;
            double cornerX = x - radiusx;
            double cornerY = y - radiusy;
            Ellipse2D.Double e = new Ellipse2D.Double(cornerX, cornerY, width, height);
            return e;
        }
        catch (NullPointerException npe) {
            return null;
        }
    }

    @Override
    public List<Point> asPoints() {
        Ellipse2D.Double e2d = (Ellipse2D.Double)this.asAwtShape();
        if (e2d == null) {
            return null;
        }
        PathIterator it = e2d.getPathIterator(new AffineTransform(), 0.1f);
        ArrayList<Point> points = new ArrayList<Point>();
        double[] coords = new double[6];
        while (!it.isDone()) {
            it.currentSegment(coords);
            SmartPointI pt = new SmartPointI();
            pt.setX(rtypes.rdouble(coords[0]));
            pt.setY(rtypes.rdouble(coords[1]));
            points.add(pt);
            it.next();
        }
        assert (SmartShape.Util.checkNonNull(points)) : "Null points in " + this;
        return points;
    }

    @Override
    public void randomize(Random random) {
        if (this.roi != null) {
            throw new UnsupportedOperationException("Roi-based values unsupported");
        }
        this.x = rtypes.rdouble(random.nextInt(100));
        this.y = rtypes.rdouble(random.nextInt(100));
        this.radiusX = rtypes.rdouble(random.nextInt(100));
        this.radiusY = rtypes.rdouble(random.nextInt(100));
    }
}

