/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola;

import ij.IJ;
import ij.ImageJ;
import ij.plugin.BrowserLauncher;
import ij.plugin.PlugIn;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.security.CodeSource;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import omero.log.LogMessage;
import org.openmicroscopy.shoola.env.Container;
import org.openmicroscopy.shoola.env.config.PluginInfo;
import org.openmicroscopy.shoola.env.data.DataServicesFactory;
import org.openmicroscopy.shoola.env.event.SaveEvent;
import org.openmicroscopy.shoola.env.init.StartupException;
import org.openmicroscopy.shoola.util.ui.MacOSMenuHandler;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class MainIJPlugin
implements PlugIn {
    private static final String IJ_VERSION = "1.39u";
    private static final String TITLE = "Open Microscopy Environment";
    private Container container;

    private void showMessage(PluginInfo info) {
        JEditorPane htmlPane = new JEditorPane("text/html", this.formatMessage(info));
        htmlPane.setEditable(false);
        htmlPane.setOpaque(false);
        htmlPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (HyperlinkEvent.EventType.ACTIVATED.equals(e.getEventType())) {
                    try {
                        BrowserLauncher.openURL((String)e.getURL().toString());
                    }
                    catch (IOException exception) {
                        IJ.log((String)exception.toString());
                    }
                }
            }
        });
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)UIUtilities.buildComponentPanelCenter(htmlPane), "Center");
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JButton okay = new JButton("OK");
        panel.add((Component)UIUtilities.buildComponentPanelCenter(okay), "South");
        final JDialog frame = new JDialog((Frame)IJ.getInstance(), "Warning");
        frame.setDefaultCloseOperation(0);
        frame.getContentPane().add((Component)panel, "Center");
        frame.pack();
        frame.setResizable(false);
        okay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.dispose();
            }
        });
        frame.setDefaultCloseOperation(0);
        UIUtilities.centerAndShow(frame);
    }

    private String formatMessage(PluginInfo info) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<html><body>");
        buffer.append("<p>The plugin requires ");
        buffer.append(info.formatDependencies());
        buffer.append("<br>Download the stable release version from<br>");
        String page = info.getInfo();
        buffer.append("<a href=\"" + page + "\">");
        buffer.append(page);
        buffer.append("</a><br>");
        buffer.append("Add ");
        buffer.append(info.getFirstDependency());
        buffer.append(" to the ");
        buffer.append(info.getDirectory());
        buffer.append(" folder and restart ");
        buffer.append(info.getName());
        buffer.append(".</p>");
        buffer.append("</body><html>");
        return buffer.toString();
    }

    private void onImageJClosing() {
        if (this.container == null) {
            return;
        }
        try {
            DataServicesFactory.getInstance(this.container).shutdown(null);
        }
        catch (Exception e) {
            LogMessage msg = new LogMessage();
            msg.println("Exit Plugin:" + UIUtilities.printErrorText(e));
            if (IJ.debugMode) {
                IJ.log((String)msg.toString());
            }
            msg.close();
        }
    }

    private void attachListeners() {
        block4: {
            Menu menu;
            int count;
            ImageJ view = IJ.getInstance();
            view.addWindowListener((WindowListener)new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    MainIJPlugin.this.onImageJClosing();
                }
            });
            if (view.getMenuBar() != null && view.getMenuBar().getMenuCount() > 0 && (count = (menu = view.getMenuBar().getMenu(0)).getItemCount()) > 0) {
                MenuItem item = menu.getItem(count - 1);
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        MainIJPlugin.this.onImageJClosing();
                    }
                });
            }
            if (UIUtilities.isMacOS()) {
                try {
                    MacOSMenuHandler handler = new MacOSMenuHandler((Frame)view);
                    handler.initialize();
                    view.addPropertyChangeListener(new PropertyChangeListener(){

                        @Override
                        public void propertyChange(PropertyChangeEvent evt) {
                            String name = evt.getPropertyName();
                            if ("quitApplication".equals(name)) {
                                MainIJPlugin.this.onImageJClosing();
                            }
                        }
                    });
                }
                catch (Throwable e) {
                    if (!IJ.debugMode) break block4;
                    IJ.log((String)"Cannot listen to the Quit action of the menu.");
                }
            }
        }
    }

    public void run(String args) {
        if (IJ.versionLessThan((String)IJ_VERSION)) {
            IJ.showMessage((String)TITLE, (String)("This plugin requires ImageJ\n1.39uor later. Your version is " + IJ.getVersion() + "; you will need to upgrade."));
            return;
        }
        String home = "";
        String configFile = null;
        int index = 1;
        int save = -1;
        if (args != null) {
            String[] values = args.split(" ");
            ArrayList<String> l = new ArrayList<String>();
            for (int i = 0; i < values.length; ++i) {
                String v = values[i];
                if (v.startsWith("imageJ")) {
                    String[] k = v.split("=");
                    if (k.length != 2) continue;
                    if (k[1].equals("import")) {
                        index = 3;
                        continue;
                    }
                    if (k[1].equals("saveRoi")) {
                        save = SaveEvent.ROIS;
                        continue;
                    }
                    if (!k[1].equals("saveResult")) continue;
                    save = SaveEvent.RESULTS;
                    continue;
                }
                l.add(v);
            }
            if (l.size() > 0) {
                configFile = (String)l.get(0);
            }
            if (l.size() > 1) {
                home = (String)l.get(1);
            }
        }
        CodeSource src = MainIJPlugin.class.getProtectionDomain().getCodeSource();
        if (home.length() == 0) {
            try {
                File jarFile = new File(src.getLocation().toURI().getPath());
                home = jarFile.getParentFile().getPath();
            }
            catch (Exception i) {
                // empty catch block
            }
        }
        try {
            this.container = Container.startupInPluginMode(home, configFile, index);
            if (save >= 0) {
                this.container.getRegistry().getEventBus().post(new SaveEvent(1, save));
            }
            this.attachListeners();
        }
        catch (StartupException e) {
            this.showMessage(e.getPlugin());
        }
    }
}

