/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import omero.gateway.SecurityContext;
import omero.gateway.model.DataObject;
import omero.gateway.model.TagAnnotationData;
import omero.gateway.model.TextualAnnotationData;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserLoader;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowser;
import org.openmicroscopy.shoola.env.data.views.CallHandle;

public class AnnotatedFilter
extends DataBrowserLoader {
    private List<Long> nodeIds;
    private Map<Long, DataObject> nodes;
    private Class nodeType;
    private Class annotationType;
    private boolean annotated;
    private CallHandle handle;

    private void checkType(Class value) {
        if (value == null) {
            throw new IllegalArgumentException("Annotation type cannot be null.");
        }
        if (value.equals(TagAnnotationData.class)) {
            return;
        }
        if (value.equals(TextualAnnotationData.class)) {
            return;
        }
    }

    public AnnotatedFilter(DataBrowser viewer, SecurityContext ctx, Class type, boolean annotated, Collection<DataObject> nodes) {
        super(viewer, ctx);
        if (nodes == null || nodes.size() == 0) {
            throw new IllegalArgumentException("No nodes to filter.");
        }
        this.checkType(type);
        this.annotated = annotated;
        this.annotationType = type;
        this.nodes = new HashMap<Long, DataObject>();
        this.nodeIds = new ArrayList<Long>();
        for (DataObject data : nodes) {
            this.nodeIds.add(data.getId());
            this.nodeType = data.getClass();
            this.nodes.put(data.getId(), data);
        }
    }

    @Override
    public void cancel() {
        this.handle.cancel();
    }

    @Override
    public void load() {
        long userID = -1L;
        this.handle = this.mhView.filterByAnnotated(this.ctx, this.nodeType, this.nodeIds, this.annotationType, this.annotated, userID, this);
    }

    @Override
    public void handleResult(Object result) {
        if (this.viewer.getState() == 5) {
            return;
        }
        Collection l = (Collection)result;
        ArrayList<DataObject> filteredNodes = new ArrayList<DataObject>();
        if (l == null) {
            this.viewer.setFilteredNodes(filteredNodes, null);
            return;
        }
        Iterator i = l.iterator();
        while (i.hasNext()) {
            filteredNodes.add(this.nodes.get((Long)i.next()));
        }
        this.viewer.setFilteredNodes(filteredNodes, null);
    }
}

