/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser;

import com.google.common.collect.Multimap;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import omero.gateway.SecurityContext;
import omero.gateway.model.DataObject;
import omero.gateway.model.ImageData;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserAgent;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserLoader;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowser;
import org.openmicroscopy.shoola.env.data.events.DSCallFeedbackEvent;
import org.openmicroscopy.shoola.env.data.model.ThumbnailData;
import org.openmicroscopy.shoola.env.data.views.CallHandle;

public class ThumbnailFieldsLoader
extends DataBrowserLoader {
    private Multimap<Point, ImageData> images;
    private CallHandle handle;
    private List<Object> result;

    public ThumbnailFieldsLoader(DataBrowser viewer, SecurityContext ctx, Multimap<Point, ImageData> images) {
        super(viewer, ctx);
        if (images == null) {
            throw new IllegalArgumentException("Collection shouldn't be null.");
        }
        this.images = images;
    }

    @Override
    public void load() {
        long userID = DataBrowserAgent.getUserDetails().getId();
        ArrayList<DataObject> imgs = new ArrayList<DataObject>();
        for (ImageData i : this.images.values()) {
            imgs.add((DataObject)i);
        }
        this.handle = this.hiBrwView.loadThumbnails(this.ctx, imgs, 96, 96, userID, 0, this);
    }

    @Override
    public void cancel() {
        this.handle.cancel();
    }

    @Override
    public void update(DSCallFeedbackEvent fe) {
        if (this.viewer.getState() == 5) {
            return;
        }
        ThumbnailData td = (ThumbnailData)fe.getPartialResult();
        if (td != null) {
            if (this.result == null) {
                this.result = new ArrayList<Object>();
            }
            this.result.add(td);
            boolean complete = this.result.size() == this.images.values().size();
            Point well = null;
            block0: for (Point p : this.images.keys()) {
                for (ImageData img : this.images.get((Object)p)) {
                    if (img.getId() != td.getImageID()) continue;
                    well = p;
                    continue block0;
                }
            }
            this.viewer.updateThumbnailsFields(well, td, complete);
        }
    }

    @Override
    public void handleNullResult() {
    }

    @Override
    public void handleException(Throwable exc) {
        String s = "Thumbnail Retrieval Failure: ";
        this.registry.getLogger().error((Object)this, s + exc);
        this.registry.getUserNotifier().notifyError("Thumbnail Retrieval Failure", s, exc);
    }
}

