/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.actions;

import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.Icon;
import omero.gateway.model.ExperimenterData;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserAgent;
import org.openmicroscopy.shoola.agents.dataBrowser.IconManager;
import org.openmicroscopy.shoola.agents.dataBrowser.actions.DataBrowserAction;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.Browser;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowser;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class ActivatedUserAction
extends DataBrowserAction {
    public static final String NAME = "Activated User";
    private static final String DESCRIPTION = "If selected the user is active.";
    public static final Icon ACTIVATED_ICON;
    public static final Icon NOT_ACTIVATED_ICON;

    @Override
    protected void onStateChange() {
        Browser browser = this.model.getBrowser();
        if (browser != null) {
            this.onDisplayChange(browser.getLastSelectedDisplay());
        }
    }

    @Override
    protected void onDisplayChange(ImageDisplay node) {
        if (!DataBrowserAgent.isAdministrator()) {
            this.setEnabled(false);
            return;
        }
        Browser browser = this.model.getBrowser();
        if (browser == null || node == null || this.model.getType() != 8) {
            this.setEnabled(false);
            return;
        }
        Collection<ImageDisplay> nodes = browser.getSelectedDisplays();
        if (nodes.size() > 1) {
            this.setEnabled(false);
        } else if (node.getHierarchyObject() instanceof ExperimenterData) {
            ExperimenterData exp = (ExperimenterData)node.getHierarchyObject();
            ExperimenterData user = DataBrowserAgent.getUserDetails();
            this.setEnabled(exp.getId() != user.getId() && !this.model.isSystemUser(exp.getId()));
            if (exp.isActive()) {
                this.putValue("SmallIcon", ACTIVATED_ICON);
            } else {
                this.putValue("SmallIcon", NOT_ACTIVATED_ICON);
            }
        } else {
            this.setEnabled(false);
        }
    }

    public ActivatedUserAction(DataBrowser model) {
        super(model);
        this.putValue("Name", NAME);
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        IconManager im = IconManager.getInstance();
        this.putValue("SmallIcon", im.getIcon(18));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    static {
        IconManager icons = IconManager.getInstance();
        ACTIVATED_ICON = icons.getIcon(60);
        NOT_ACTIVATED_ICON = icons.getIcon(61);
    }
}

