/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.util;

import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import omero.gateway.model.DatasetData;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.ImageData;
import omero.gateway.model.ProjectData;
import org.openmicroscopy.shoola.agents.dataBrowser.IconManager;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.dataBrowser.view.ImageTableNode;

public class ImageTableRenderer
extends DefaultTreeCellRenderer {
    private static final Icon DATASET_ICON;
    private static final Icon PROJECT_ICON;
    private final Color color;

    public ImageTableRenderer() {
        this.setOpaque(false);
        this.color = this.getForeground();
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (!(value instanceof ImageTableNode)) {
            return this;
        }
        ImageTableNode node = (ImageTableNode)((Object)value);
        Object v = node.getHierarchyObject();
        if (v instanceof ImageData) {
            this.setIcon(null);
            this.setText(((ImageDisplay)node.getUserObject()).toString());
            this.setToolTipText(node.getToolTip());
            Color c = node.getSibingColor();
            if (c == null) {
                c = this.color;
            }
            this.setForeground(c);
        } else if (v instanceof DatasetData) {
            this.setIcon(DATASET_ICON);
            this.setText(node.getUserObject().toString());
        } else if (v instanceof ProjectData) {
            this.setIcon(PROJECT_ICON);
            this.setText(node.getUserObject().toString());
        } else if (v instanceof ExperimenterData) {
            this.setIcon(null);
            ExperimenterData exp = (ExperimenterData)v;
            this.setText(exp.getUserName());
        }
        return this;
    }

    static {
        IconManager icons = IconManager.getInstance();
        DATASET_ICON = icons.getIcon(15);
        PROJECT_ICON = icons.getIcon(16);
    }
}

