/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.prefs.Preferences;
import omero.gateway.SecurityContext;
import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.FileData;
import omero.gateway.model.GroupData;
import omero.gateway.model.ImageData;
import omero.gateway.model.PlateAcquisitionData;
import omero.gateway.model.PlateData;
import omero.gateway.model.ProjectData;
import omero.gateway.model.SearchResultCollection;
import omero.gateway.model.TagAnnotationData;
import omero.gateway.model.WellData;
import org.openmicroscopy.shoola.agents.dataBrowser.view.AdvancedResultSearchModel;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowser;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowserComponent;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DatasetsModel;
import org.openmicroscopy.shoola.agents.dataBrowser.view.FSFolderModel;
import org.openmicroscopy.shoola.agents.dataBrowser.view.GroupModel;
import org.openmicroscopy.shoola.agents.dataBrowser.view.ImagesModel;
import org.openmicroscopy.shoola.agents.dataBrowser.view.SearchModel;
import org.openmicroscopy.shoola.agents.dataBrowser.view.TagsModel;
import org.openmicroscopy.shoola.agents.dataBrowser.view.WellsModel;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageTimeSet;
import org.openmicroscopy.shoola.env.rnd.RndProxyDef;

public class DataBrowserFactory {
    private static final DataBrowserFactory singleton = new DataBrowserFactory();
    private static final String THUMBNAIL_SCALE_FACTOR = "thumbnailScaleFactor";
    private Set<String> discardedBrowsers;
    private Map<Object, DataBrowser> browsers = new HashMap<Object, DataBrowser>();
    private DataBrowser searchBrowser = null;
    private ImageData rndSettingsToCopy = null;
    private RndProxyDef rndDefToCopy;
    private Class dataToCopy = null;

    public static final void discardAll() {
        for (Map.Entry<Object, DataBrowser> entry : DataBrowserFactory.singleton.browsers.entrySet()) {
            DataBrowserComponent comp = (DataBrowserComponent)entry.getValue();
            comp.discard();
            DataBrowserFactory.singleton.discardedBrowsers.add((String)entry.getKey());
        }
        System.gc();
        DataBrowserFactory.singleton.browsers.clear();
    }

    public static final DataBrowser getSearchBrowser(Map<SecurityContext, Collection<DataObject>> result) {
        return singleton.createSearchDataBrowser(result);
    }

    public static final DataBrowser getSearchBrowser(SearchResultCollection results) {
        return singleton.createSearchDataBrowser(results);
    }

    public static final DataBrowser getSearchBrowser() {
        return DataBrowserFactory.singleton.searchBrowser;
    }

    public static final DataBrowser getWellsDataBrowser(SecurityContext ctx, Map<Class, Object> ancestors, Object parent, Collection<WellData> wells, boolean withThumbnails) {
        return singleton.createWellsDataBrowser(ctx, ancestors, parent, wells, withThumbnails);
    }

    public static final DataBrowser getDataBrowser(SecurityContext ctx, Object grandParent, Object parent, Collection<ImageData> images, TreeImageDisplay node) {
        return singleton.createImagesDataBrowser(ctx, grandParent, parent, images, node);
    }

    public static final DataBrowser getTagsBrowser(SecurityContext ctx, TagAnnotationData parent, Collection<DataObject> nodes, boolean withImages) {
        return singleton.createTagsDataBrowser(ctx, (DataObject)parent, nodes, withImages);
    }

    public static final DataBrowser getGroupsBrowser(SecurityContext ctx, GroupData parent, Collection<ExperimenterData> experimenters) {
        return singleton.createGroupsBrowser(ctx, parent, experimenters);
    }

    public static final DataBrowser getFSFolderBrowser(SecurityContext ctx, FileData parent, Collection<DataObject> files) {
        return singleton.createFSFolderBrowser(ctx, parent, files);
    }

    public static final DataBrowser getDataBrowser(SecurityContext ctx, ProjectData parent, Set<DatasetData> nodes) {
        return singleton.createDatasetsDataBrowser(ctx, (DataObject)parent, nodes);
    }

    public static final DataBrowser getDataBrowser(Object parent) {
        if (parent == null) {
            return null;
        }
        return DataBrowserFactory.singleton.browsers.get(DataBrowserFactory.createKey(parent));
    }

    public static final boolean hasBeenDiscarded(Object parent) {
        if (parent == null) {
            return false;
        }
        String key = DataBrowserFactory.createKey(parent);
        for (String value : DataBrowserFactory.singleton.discardedBrowsers) {
            if (!value.equals(key)) continue;
            return true;
        }
        return false;
    }

    public static final void refreshThumbnails(Collection ids) {
        if (ids != null && ids.size() > 0) {
            if (DataBrowserFactory.singleton.searchBrowser != null) {
                DataBrowserFactory.singleton.searchBrowser.reloadThumbnails(ids);
            }
            for (Map.Entry<Object, DataBrowser> entry : DataBrowserFactory.singleton.browsers.entrySet()) {
                DataBrowserComponent comp = (DataBrowserComponent)entry.getValue();
                comp.reloadThumbnails(ids);
            }
            System.gc();
        }
    }

    public static final void setRndSettingsToCopy(ImageData rndSettingsToCopy, RndProxyDef rndDefToCopy) {
        DataBrowserFactory.singleton.rndSettingsToCopy = rndSettingsToCopy;
        DataBrowserFactory.singleton.rndDefToCopy = rndDefToCopy;
        for (Map.Entry<Object, DataBrowser> entry : DataBrowserFactory.singleton.browsers.entrySet()) {
            DataBrowserComponent comp = (DataBrowserComponent)entry.getValue();
            comp.notifyRndSettingsToCopy();
        }
        if (DataBrowserFactory.singleton.searchBrowser != null) {
            ((DataBrowserComponent)DataBrowserFactory.singleton.searchBrowser).notifyRndSettingsToCopy();
        }
    }

    public static final void setDataToCopy(Class dataToCopy) {
        DataBrowserFactory.singleton.dataToCopy = dataToCopy;
        for (Map.Entry<Object, DataBrowser> entry : DataBrowserFactory.singleton.browsers.entrySet()) {
            DataBrowserComponent comp = (DataBrowserComponent)entry.getValue();
            comp.notifyDataToCopy();
        }
        if (DataBrowserFactory.singleton.searchBrowser != null) {
            ((DataBrowserComponent)DataBrowserFactory.singleton.searchBrowser).notifyDataToCopy();
        }
    }

    public static final void onGroupSwitched(boolean success) {
        if (!success) {
            return;
        }
        DataBrowserFactory.singleton.dataToCopy = null;
        for (Map.Entry<Object, DataBrowser> entry : DataBrowserFactory.singleton.browsers.entrySet()) {
            DataBrowserComponent comp = (DataBrowserComponent)entry.getValue();
            comp.discard();
        }
        DataBrowserFactory.singleton.browsers.clear();
        DataBrowserFactory.singleton.discardedBrowsers.clear();
        DataBrowserFactory.singleton.searchBrowser = null;
    }

    public static void onAnnotated(List<DataObject> containers, int count) {
        for (Map.Entry<Object, DataBrowser> entry : DataBrowserFactory.singleton.browsers.entrySet()) {
            DataBrowserComponent comp = (DataBrowserComponent)entry.getValue();
            comp.onAnnotated(containers, count);
        }
    }

    public static void setDisplayMode(int displayMode) {
        for (Map.Entry<Object, DataBrowser> entry : DataBrowserFactory.singleton.browsers.entrySet()) {
            entry.getValue().setDisplayMode(displayMode);
        }
        DataBrowserFactory.onGroupSwitched(true);
    }

    public static double getThumbnailScaleFactor() {
        Preferences p = Preferences.userNodeForPackage(DataBrowserFactory.class);
        String value = p.get(THUMBNAIL_SCALE_FACTOR, "0.5");
        return Double.parseDouble(value);
    }

    public static void setThumbnailScaleFactor(double d) {
        Preferences p = Preferences.userNodeForPackage(DataBrowserFactory.class);
        p.put(THUMBNAIL_SCALE_FACTOR, "" + d);
    }

    static boolean hasRndSettingsToCopy() {
        return DataBrowserFactory.singleton.rndSettingsToCopy != null || DataBrowserFactory.singleton.rndDefToCopy != null;
    }

    static boolean areSettingsCompatible(long groupID) {
        if (!DataBrowserFactory.hasRndSettingsToCopy()) {
            return false;
        }
        RndProxyDef def = DataBrowserFactory.singleton.rndDefToCopy;
        ImageData img = DataBrowserFactory.singleton.rndSettingsToCopy;
        return DataBrowserFactory.singleton.rndDefToCopy != null || DataBrowserFactory.singleton.rndSettingsToCopy.getGroupId() == groupID;
    }

    static Class hasDataToCopy() {
        return DataBrowserFactory.singleton.dataToCopy;
    }

    private static final String createKey(Object parent) {
        String key = parent.toString();
        if (parent instanceof DataObject) {
            key = key + ((DataObject)parent).getId();
        } else if (parent instanceof TreeImageDisplay) {
            key = TreeImageTimeSet.createPath((TreeImageDisplay)parent, key);
        }
        return key;
    }

    private DataBrowserFactory() {
        this.discardedBrowsers = new HashSet<String>();
    }

    private DataBrowser createWellsDataBrowser(SecurityContext ctx, Map<Class, Object> ancestors, Object parent2, Collection<WellData> wells, boolean withThumbnails) {
        PlateData plate;
        Set set;
        Iterator<Map.Entry<Class, Object>> i;
        Object p = parent2;
        Object go = null;
        if (parent2 instanceof PlateAcquisitionData) {
            p = ancestors.get(PlateData.class);
            if (p == null) {
                return null;
            }
            ancestors.remove(PlateData.class);
        }
        if (ancestors.size() > 0 && (i = ancestors.entrySet().iterator()).hasNext()) {
            Map.Entry<Class, Object> entry = i.next();
            go = entry.getValue();
        }
        WellsModel model = new WellsModel(ctx, p, wells, withThumbnails);
        model.setGrandParent(go);
        DataBrowserComponent comp = new DataBrowserComponent(model);
        model.initialize(comp);
        comp.initialize();
        if (parent2 instanceof PlateData && (set = (plate = (PlateData)parent2).getPlateAcquisitions()) != null && set.size() == 1) {
            for (Object parent2 : set) {
            }
        }
        String key = parent2.toString();
        if (parent2 instanceof DataObject) {
            key = key + ((DataObject)parent2).getId();
        }
        this.browsers.put(key, comp);
        return comp;
    }

    private DataBrowser createImagesDataBrowser(SecurityContext ctx, Object grandParent, Object parent, Collection<ImageData> images, TreeImageDisplay node) {
        ImagesModel model = new ImagesModel(ctx, parent, images);
        model.setGrandParent(grandParent);
        DataBrowserComponent comp = new DataBrowserComponent(model);
        model.initialize(comp);
        comp.initialize();
        String key = parent.toString();
        key = parent instanceof DataObject ? key + ((DataObject)parent).getId() : TreeImageTimeSet.createPath(node, key);
        this.browsers.put(key, comp);
        return comp;
    }

    private DataBrowser createDatasetsDataBrowser(SecurityContext ctx, DataObject parent, Set<DatasetData> datasets) {
        DatasetsModel model = new DatasetsModel(ctx, parent, datasets);
        DataBrowserComponent comp = new DataBrowserComponent(model);
        model.initialize(comp);
        comp.initialize();
        StringBuffer buffer = new StringBuffer();
        if (parent == null) {
            buffer.append(DatasetData.class.toString());
            Iterator<DatasetData> i = datasets.iterator();
            ArrayList<Long> ids = new ArrayList<Long>();
            while (i.hasNext()) {
                ids.add(i.next().getId());
            }
            this.sortNodes(ids);
            Iterator j = ids.iterator();
            while (j.hasNext()) {
                buffer.append("" + (Long)j.next());
            }
        } else {
            buffer.append(parent.toString() + parent.getId());
        }
        this.browsers.put(buffer.toString(), comp);
        return comp;
    }

    private DataBrowser createTagsDataBrowser(SecurityContext ctx, DataObject parent, Collection<DataObject> dataObjects, boolean withImages) {
        TagsModel model = new TagsModel(ctx, parent, dataObjects, withImages);
        DataBrowserComponent comp = new DataBrowserComponent(model);
        model.initialize(comp);
        comp.initialize();
        String key = parent.toString() + parent.getId();
        this.browsers.put(key, comp);
        return comp;
    }

    private DataBrowser createGroupsBrowser(SecurityContext ctx, GroupData parent, Collection<ExperimenterData> experimenters) {
        GroupModel model = new GroupModel(ctx, parent, experimenters);
        DataBrowserComponent comp = new DataBrowserComponent(model);
        model.initialize(comp);
        comp.initialize();
        String key = parent.toString() + parent.getId();
        this.browsers.put(key, comp);
        return comp;
    }

    private DataBrowser createFSFolderBrowser(SecurityContext ctx, FileData parent, Collection<DataObject> files) {
        FSFolderModel model = new FSFolderModel(ctx, parent, files);
        DataBrowserComponent comp = new DataBrowserComponent(model);
        model.initialize(comp);
        comp.initialize();
        String key = parent.toString() + parent.getId();
        this.browsers.put(key, comp);
        return comp;
    }

    private DataBrowser createSearchDataBrowser(Map<SecurityContext, Collection<DataObject>> result) {
        SearchModel model = new SearchModel(result);
        DataBrowserComponent comp = new DataBrowserComponent(model);
        model.initialize(comp);
        comp.initialize();
        this.searchBrowser = comp;
        return comp;
    }

    private DataBrowser createSearchDataBrowser(SearchResultCollection result) {
        AdvancedResultSearchModel model = new AdvancedResultSearchModel(result);
        DataBrowserComponent comp = new DataBrowserComponent(model);
        model.initialize(comp);
        comp.initialize();
        this.searchBrowser = comp;
        return comp;
    }

    private void sortNodes(List nodes) {
        if (nodes == null || nodes.size() == 0) {
            return;
        }
        Comparator c = new Comparator(){

            public int compare(Object o1, Object o2) {
                long i1 = (Long)o1;
                long i2 = (Long)o2;
                int v = 0;
                if (i1 < i2) {
                    v = -1;
                } else if (i1 > i2) {
                    v = 1;
                }
                return -v;
            }
        };
        Collections.sort(nodes, c);
    }
}

