/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import omero.gateway.SecurityContext;
import omero.gateway.model.DataObject;
import omero.gateway.model.ExperimenterData;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserLoader;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserTranslator;
import org.openmicroscopy.shoola.agents.dataBrowser.ThumbnailLoader;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.BrowserFactory;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageNode;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowserModel;

class GroupModel
extends DataBrowserModel {
    GroupModel(SecurityContext ctx, Object parent, Collection<ExperimenterData> experimenters) {
        super(ctx);
        if (experimenters == null) {
            throw new IllegalArgumentException("No experimenters.");
        }
        this.parent = parent;
        Set visTrees = DataBrowserTranslator.transformExperimenters(experimenters);
        this.numberOfImages = experimenters.size();
        this.browser = BrowserFactory.createBrowser(visTrees);
    }

    @Override
    protected List<DataBrowserLoader> createDataLoader(boolean refresh, Collection ids) {
        if (refresh) {
            this.imagesLoaded = 0;
        }
        if (this.imagesLoaded != 0 && ids != null) {
            this.imagesLoaded -= ids.size();
        }
        if (this.imagesLoaded == this.numberOfImages) {
            return null;
        }
        List<ImageNode> nodes = this.browser.getVisibleImageNodes();
        if (nodes == null || nodes.size() == 0) {
            return null;
        }
        Iterator<ImageNode> i = nodes.iterator();
        ArrayList<DataObject> imgs = new ArrayList<DataObject>();
        ArrayList<Long> loaded = new ArrayList<Long>();
        if (ids != null) {
            while (i.hasNext()) {
                DataObject data;
                ImageNode node = i.next();
                if (node.getThumbnail().getFullScaleThumb() != null || !ids.contains((data = (DataObject)node.getHierarchyObject()).getId()) || loaded.contains(data.getId())) continue;
                imgs.add(data);
                loaded.add(data.getId());
                ++this.imagesLoaded;
            }
        } else {
            while (i.hasNext()) {
                DataObject data;
                long id;
                ImageNode node = i.next();
                if (node.getThumbnail().getFullScaleThumb() != null || (id = (data = (DataObject)node.getHierarchyObject()).getId()) <= 0L || loaded.contains(id)) continue;
                imgs.add(data);
                loaded.add(id);
                ++this.imagesLoaded;
            }
        }
        if (imgs.size() == 0) {
            return null;
        }
        ArrayList<DataBrowserLoader> loaders = new ArrayList<DataBrowserLoader>();
        loaders.add(new ThumbnailLoader(this.component, this.ctx, this.sorter.sort(imgs), 1, imgs.size()));
        return loaders;
    }

    @Override
    protected int getType() {
        return 8;
    }

    @Override
    protected List<ImageDisplay> getNodes() {
        return null;
    }
}

