/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.util.Collection;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import omero.gateway.model.DataObject;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.RollOverNode;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowserModel;
import org.openmicroscopy.shoola.agents.dataBrowser.view.ImageTable;
import org.openmicroscopy.shoola.agents.util.ViewerSorter;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class ImageTableView
extends JPanel {
    static final String TABLE_NODES_SELECTION_PROPERTY = "tableNodesSelection";
    static final String TABLE_SELECTION_MENU_PROPERTY = "tableSelectionMenu";
    static final String TABLE_SELECTION_VIEW_PROPERTY = "tableSelectionView";
    static final String TABLE_SELECTION_ROLL_OVER_PROPERTY = "tableSelectionRollOver";
    private ImageTable table;
    private DataBrowserModel model;
    private double magnification;

    private void initComponents(ImageDisplay root) {
        this.table = new ImageTable(root, this, this.model);
    }

    private void buildGUI() {
        this.setLayout(new BorderLayout());
        this.setBackground(UIUtilities.BACKGROUND_COLOR);
        JScrollPane pane = new JScrollPane((Component)((Object)this.table));
        pane.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.add((Component)pane, "Center");
    }

    ImageTableView(DataBrowserModel model, ImageDisplay root) {
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        this.model = model;
        this.initComponents(root);
        this.buildGUI();
    }

    void showMenu(Point location) {
        this.firePropertyChange(TABLE_SELECTION_MENU_PROPERTY, null, location);
    }

    ViewerSorter getSorter() {
        return this.model.getSorter();
    }

    void refreshTable() {
        this.table.refreshTable();
    }

    void selectNodes(List<ImageDisplay> nodes) {
        this.table.setHighlightedNodes(nodes);
        this.firePropertyChange(TABLE_NODES_SELECTION_PROPERTY, null, nodes);
    }

    void setSelectedNodes(List<DataObject> objects) {
        this.table.setSelectedNodes(objects);
    }

    void viewSelectedNode() {
        this.firePropertyChange(TABLE_SELECTION_VIEW_PROPERTY, (Object)false, (Object)true);
    }

    void rollOverNode(RollOverNode node) {
        this.firePropertyChange(TABLE_SELECTION_ROLL_OVER_PROPERTY, (Object)false, node);
    }

    void markUnmodifiedNodes(Class type, Collection<Long> ids) {
        this.table.markUnmodifiedNodes(type, ids);
    }

    void setMagnification(double magnification) {
        this.magnification = magnification;
    }

    double getMagnification() {
        return this.magnification;
    }
}

