/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.view;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.commons.collections.CollectionUtils;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.WellImageSet;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.WellSampleNode;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowserControl;
import org.openmicroscopy.shoola.agents.dataBrowser.view.WellsModel;
import org.openmicroscopy.shoola.util.ui.PlateGrid;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class PlateGridUI
extends JPanel {
    private static final String DEFAULT_WELL_TEXT = "Well: ";
    private WellsModel model;
    private PlateGrid grid;
    private JLabel selectedNode;
    private JLabel selectedText;
    private DataBrowserControl controller;

    private void initComponents() {
        this.grid = new PlateGrid(this.model.getRowSequenceIndex(), this.model.getColumnSequenceIndex(), this.model.getValidWells(), this.model.getRows(), this.model.getColumns());
        this.grid.addPropertyChangeListener(this.controller);
        WellSampleNode node = this.model.getSelectedWell();
        this.selectedNode = new JLabel();
        if (node != null && node.isWell()) {
            this.selectedNode.setText(DEFAULT_WELL_TEXT + node.getParentWell().getWellLocation());
            this.grid.selectCell(node.getRow(), node.getColumn());
        }
        this.selectedText = new JLabel();
    }

    private void buildGUI() {
        this.setBackground(UIUtilities.BACKGROUND_COLOR);
        double[][] size = new double[][]{{-2.0, 5.0, -2.0}, {-2.0, -2.0, -1.0}};
        this.setLayout(new TableLayout(size));
        this.add((Component)this.grid, "0, 0, 0, 2");
        this.add((Component)this.selectedText, "2, 2, LEFT, TOP");
    }

    PlateGridUI(WellsModel model, DataBrowserControl controller) {
        this.model = model;
        this.controller = controller;
        this.initComponents();
        this.buildGUI();
    }

    void onSelectedWell() {
        WellSampleNode node2;
        List<WellSampleNode> nodes = this.model.getSelectedWells();
        if (CollectionUtils.isNotEmpty(nodes) && (node2 = nodes.get(0)).isWell()) {
            WellImageSet well = node2.getParentWell();
            if (nodes.size() == 1) {
                this.selectedNode.setText(DEFAULT_WELL_TEXT + well.getWellLocation());
                if (well.getText() != null) {
                    this.selectedText.setText(UIUtilities.formatToolTipText(well.getText()));
                }
            } else {
                this.selectedText.setText("");
                this.selectedNode.setText("");
            }
            ArrayList<Point> cells = new ArrayList<Point>(nodes.size());
            for (WellSampleNode node2 : nodes) {
                cells.add(new Point(node2.getRow(), node2.getColumn()));
            }
            this.grid.selectCells(cells);
        }
    }
}

