/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openmicroscopy.shoola.agents.dataBrowser.Colors;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.WellSampleNode;
import org.openmicroscopy.shoola.agents.dataBrowser.view.WellFieldsCanvas;
import org.openmicroscopy.shoola.agents.dataBrowser.view.WellFieldsView;
import org.openmicroscopy.shoola.agents.dataBrowser.view.WellsModel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class RowFieldCanvas
extends WellFieldsCanvas {
    private List<String> titles;
    private Dimension thumbDim;
    private int nFields;

    public RowFieldCanvas(WellFieldsView parent, final WellsModel model) {
        super(parent, model);
        this.setDoubleBuffered(true);
        this.setBackground(UIUtilities.BACKGROUND);
        this.setLayout(new GridBagLayout());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                WellSampleNode node = RowFieldCanvas.this.getNode(e.getPoint());
                if (e.getClickCount() == 2 && node != null) {
                    RowFieldCanvas.this.firePropertyChange(WellFieldsCanvas.VIEW_PROPERTY, null, node);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                WellSampleNode node = RowFieldCanvas.this.getNode(e.getPoint());
                if (node == null) {
                    return;
                }
                ArrayList<WellSampleNode> oldSelection = new ArrayList<WellSampleNode>();
                ArrayList<WellSampleNode> newSelection = new ArrayList<WellSampleNode>();
                oldSelection.addAll(model.getSelectedWells());
                newSelection.add(node);
                for (WellSampleNode n : model.getSelectedWells()) {
                    if (!n.isWell()) continue;
                    newSelection.add(n);
                }
                if (WellSampleNode.isSame(oldSelection, newSelection)) {
                    return;
                }
                if (e.isShiftDown()) {
                    int minIndex = Integer.MAX_VALUE;
                    int maxIndex = -1;
                    int index = -1;
                    for (WellSampleNode n : model.getSelectedWells()) {
                        if (n.isWell()) continue;
                        index = RowFieldCanvas.this.calcIndex(n);
                        minIndex = Math.min(minIndex, index);
                        maxIndex = Math.max(maxIndex, index);
                    }
                    index = RowFieldCanvas.this.calcIndex(node);
                    minIndex = Math.min(minIndex, index);
                    maxIndex = Math.max(maxIndex, index);
                    for (Component c : RowFieldCanvas.this.getComponents()) {
                        WellSampleNode n;
                        if (!(c instanceof FieldDisplay) || (n = ((FieldDisplay)c).getNode()).isWell() || (index = RowFieldCanvas.this.calcIndex(n)) < minIndex || index > maxIndex || newSelection.contains(n)) continue;
                        newSelection.add(n);
                    }
                } else if (e.isControlDown() || e.isMetaDown()) {
                    for (WellSampleNode n : model.getSelectedWells()) {
                        if (newSelection.contains(n)) continue;
                        newSelection.add(n);
                    }
                }
                RowFieldCanvas.this.firePropertyChange(WellFieldsCanvas.SELECTION_PROPERTY, oldSelection, newSelection);
            }
        });
    }

    private int calcIndex(WellSampleNode n) {
        int row = this.titles.indexOf(n.getTitle());
        return row * this.nFields + n.getIndex();
    }

    @Override
    public void clear(List<String> titles, int nFields, Dimension thumbDim) {
        this.thumbDim = thumbDim;
        this.removeAll();
        this.titles = titles;
        this.nFields = nFields;
        if (!titles.isEmpty() && nFields > 0) {
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(2, 2, 0, 0);
            c.fill = 0;
            c.gridx = 1;
            c.gridy = 0;
            c.weightx = 0.0;
            c.weighty = 0.0;
            for (int i = 0; i < nFields; ++i) {
                JLabel f = new JLabel("" + (i + 1), 0){

                    @Override
                    public Dimension getPreferredSize() {
                        Dimension d = super.getPreferredSize();
                        if (RowFieldCanvas.this.thumbDim != null) {
                            d.width = ((RowFieldCanvas)RowFieldCanvas.this).thumbDim.width;
                        }
                        return d;
                    }

                    @Override
                    public Dimension getMinimumSize() {
                        return this.getPreferredSize();
                    }
                };
                f.setBackground(UIUtilities.BACKGROUND);
                this.add((Component)f, c);
                ++c.gridx;
            }
            c = new GridBagConstraints();
            c.insets = new Insets(2, 2, 0, 0);
            c.fill = 0;
            c.gridx = 0;
            c.gridy = 1;
            c.weightx = 0.0;
            c.weighty = 0.0;
            for (String title : titles) {
                JLabel f = new JLabel(title, 0){

                    @Override
                    public Dimension getPreferredSize() {
                        Dimension d = super.getPreferredSize();
                        if (RowFieldCanvas.this.thumbDim != null) {
                            d.height = ((RowFieldCanvas)RowFieldCanvas.this).thumbDim.height;
                        }
                        return d;
                    }

                    @Override
                    public Dimension getMinimumSize() {
                        return this.getPreferredSize();
                    }
                };
                f.setBackground(UIUtilities.BACKGROUND);
                this.add((Component)f, c);
                ++c.gridy;
            }
            c = new GridBagConstraints();
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.gridx = nFields + 1;
            c.gridy = titles != null ? titles.size() + 1 : 1;
            c.fill = 1;
            this.add((Component)UIUtilities.createComponent(JLabel.class, UIUtilities.BACKGROUND), c);
            this.displayExistingThumbs();
        }
        this.revalidate();
        this.parent.revalidate();
        this.repaint();
    }

    private void displayExistingThumbs() {
        List<WellSampleNode> l = this.parent.getNodes();
        if (l == null) {
            return;
        }
        for (WellSampleNode n : l) {
            if (!n.getThumbnail().isThumbnailLoaded()) continue;
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 0;
            c.gridx = n.getIndex() + 1;
            c.gridy = this.titles != null ? this.titles.indexOf(n.getTitle()) + 1 : 1;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.insets = new Insets(2, 2, 0, 0);
            FieldDisplay fd = new FieldDisplay(n);
            this.add((Component)fd, c);
        }
    }

    @Override
    public void updateFieldThumb(WellSampleNode node) {
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 0;
        c.gridx = node.getIndex() + 1;
        c.gridy = this.titles != null ? this.titles.indexOf(node.getTitle()) + 1 : 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(2, 2, 0, 0);
        FieldDisplay fd = new FieldDisplay(node);
        this.add((Component)fd, c);
        this.revalidate();
    }

    @Override
    public void refreshUI() {
        for (Component c : this.getComponents()) {
            if (!(c instanceof FieldDisplay)) continue;
            FieldDisplay f = (FieldDisplay)c;
            f.refresh();
            this.thumbDim = f.getPreferredSize();
            break;
        }
        for (Component c : this.getComponents()) {
            if (!(c instanceof FieldDisplay)) continue;
            ((FieldDisplay)c).refresh();
        }
        this.revalidate();
        this.parent.revalidate();
        this.repaint();
    }

    @Override
    public WellSampleNode getNode(Point p) {
        Component c = this.findComponentAt(p);
        if (c instanceof FieldDisplay) {
            return ((FieldDisplay)c).getNode();
        }
        return null;
    }

    boolean isSelected(WellSampleNode n) {
        return this.parent.isSelected(n);
    }

    class FieldDisplay
    extends JPanel {
        private final WellSampleNode node;
        private final Colors colors = Colors.getInstance();
        private double mag = 0.0;

        public FieldDisplay(WellSampleNode node) {
            WellSampleNode copy = node.copy();
            copy.setTitle(node.getTitle());
            copy.setWell(false);
            this.node = copy;
            this.mag = RowFieldCanvas.this.parent.getMagnification();
            this.node.getThumbnail().scale(this.mag);
            this.setBackground(UIUtilities.BACKGROUND);
            Color col = RowFieldCanvas.this.isSelected(this.node) ? this.colors.getColor(0) : this.colors.getColor(1);
            this.setBorder(BorderFactory.createLineBorder(col, 2));
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.node.getThumbnail().getDisplayedImage() != null) {
                g.drawImage(this.node.getThumbnail().getDisplayedImage(), this.getInsets().left, this.getInsets().top, null);
            }
        }

        @Override
        public Dimension getPreferredSize() {
            BufferedImage img = this.node.getThumbnail().getDisplayedImage();
            if (img == null) {
                return new Dimension(0, 0);
            }
            Insets in = this.getInsets();
            return new Dimension(img.getWidth() + in.left + in.right, img.getHeight() + in.top + in.bottom);
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public void refresh() {
            Color col = RowFieldCanvas.this.isSelected(this.node) ? this.colors.getColor(0) : this.colors.getColor(1);
            this.setBorder(BorderFactory.createLineBorder(col, 2));
            if (this.mag != RowFieldCanvas.this.parent.getMagnification()) {
                this.mag = RowFieldCanvas.this.parent.getMagnification();
                this.node.getThumbnail().scale(this.mag);
            }
        }

        public WellSampleNode getNode() {
            return this.node;
        }
    }
}

