/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.visitor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import omero.gateway.model.DatasetData;
import omero.gateway.model.ImageData;
import omero.gateway.model.PlateData;
import omero.gateway.model.ProjectData;
import omero.gateway.model.ScreenData;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplayVisitor;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageNode;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageSet;
import org.openmicroscopy.shoola.util.ui.RegExFactory;

public class RegexFinder
implements ImageDisplayVisitor {
    private Pattern pattern;
    private List<ImageDisplay> foundNodes;

    private String getName(Object userObject) {
        if (userObject instanceof ProjectData) {
            return ((ProjectData)userObject).getName();
        }
        if (userObject instanceof DatasetData) {
            return ((DatasetData)userObject).getName();
        }
        if (userObject instanceof ImageData) {
            return ((ImageData)userObject).getName();
        }
        if (userObject instanceof ScreenData) {
            return ((ScreenData)userObject).getName();
        }
        if (userObject instanceof PlateData) {
            return ((PlateData)userObject).getName();
        }
        return null;
    }

    private String getDescription(Object userObject) {
        if (userObject instanceof ProjectData) {
            return ((ProjectData)userObject).getDescription();
        }
        if (userObject instanceof DatasetData) {
            return ((DatasetData)userObject).getDescription();
        }
        if (userObject instanceof ImageData) {
            return ((ImageData)userObject).getDescription();
        }
        if (userObject instanceof ScreenData) {
            return ((ScreenData)userObject).getDescription();
        }
        if (userObject instanceof PlateData) {
            return ((PlateData)userObject).getDescription();
        }
        return null;
    }

    private void foundNode(ImageDisplay node) {
        String description;
        Object userObject = node.getHierarchyObject();
        String name = this.getName(userObject);
        if (name != null && RegExFactory.find(this.pattern, name = name.trim()) && !this.foundNodes.contains(node)) {
            this.foundNodes.add(node);
        }
        if ((description = this.getDescription(userObject)) != null && RegExFactory.find(this.pattern, description = description.trim()) && !this.foundNodes.contains(node)) {
            this.foundNodes.add(node);
        }
    }

    public RegexFinder(Pattern pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("No pattern specified.");
        }
        this.pattern = pattern;
        this.foundNodes = new ArrayList<ImageDisplay>();
    }

    public void analyse(List<ImageDisplay> nodes) {
        if (nodes == null || nodes.size() == 0) {
            return;
        }
        Iterator<ImageDisplay> i = nodes.iterator();
        while (i.hasNext()) {
            this.foundNode(i.next());
        }
    }

    public List<ImageDisplay> getFoundNodes() {
        return this.foundNodes;
    }

    @Override
    public void visit(ImageNode node) {
        this.foundNode(node);
    }

    @Override
    public void visit(ImageSet node) {
        this.foundNode(node);
    }
}

