/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.events.hiviewer;

import java.awt.Rectangle;
import java.util.Set;
import omero.gateway.model.ExperimenterData;
import org.openmicroscopy.shoola.env.data.model.TimeRefObject;
import org.openmicroscopy.shoola.env.event.RequestEvent;

public class Browse
extends RequestEvent {
    public static final int PROJECT = 0;
    public static final int DATASET = 1;
    public static final int IMAGES = 2;
    public static final int DATASETS = 3;
    public static final int PROJECTS = 4;
    public static final int IMAGE_PER_DATE = 5;
    public static final int TAGS = 6;
    private long hierarchyObjectID;
    private Set<Long> objectsIDs;
    private int eventIndex;
    private Rectangle requesterBounds;
    private ExperimenterData experimenter;
    private TimeRefObject timeRefObject;

    private void checkEventIndex(int index) {
        switch (index) {
            case 0: 
            case 1: {
                return;
            }
        }
        throw new IllegalArgumentException("Event index not valid.");
    }

    private void checkMultiNodesIndex(int index) {
        switch (index) {
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                return;
            }
        }
        throw new IllegalArgumentException("Event index not valid.");
    }

    public Browse(TimeRefObject timeRef, ExperimenterData experimenter, Rectangle bounds) {
        if (timeRef == null) {
            throw new IllegalArgumentException("No time reference specified.");
        }
        if (experimenter == null) {
            throw new IllegalArgumentException("No experimenter specified.");
        }
        this.eventIndex = 5;
        this.requesterBounds = bounds;
        this.timeRefObject = timeRef;
        this.experimenter = experimenter;
    }

    public Browse(long hierarchyObjectID, int index, ExperimenterData experimenter, Rectangle bounds) {
        this.checkEventIndex(index);
        if (experimenter == null) {
            throw new IllegalArgumentException("No experimenter specified.");
        }
        this.hierarchyObjectID = hierarchyObjectID;
        this.eventIndex = index;
        this.experimenter = experimenter;
        this.requesterBounds = bounds;
    }

    public Browse(Set<Long> ids, int index, ExperimenterData experimenter, Rectangle bounds) {
        this.checkMultiNodesIndex(index);
        if (experimenter == null) {
            throw new IllegalArgumentException("No experimenter specified.");
        }
        this.eventIndex = index;
        this.experimenter = experimenter;
        this.objectsIDs = ids;
        this.requesterBounds = bounds;
    }

    public int getEventIndex() {
        return this.eventIndex;
    }

    public long getHierarchyObjectID() {
        return this.hierarchyObjectID;
    }

    public ExperimenterData getExperimenter() {
        return this.experimenter;
    }

    public Set<Long> getObjectIDs() {
        return this.objectsIDs;
    }

    public Rectangle getRequesterBounds() {
        return this.requesterBounds;
    }

    public TimeRefObject getTimeRefObject() {
        return this.timeRefObject;
    }
}

