/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.events.iviewer;

import omero.gateway.model.DataObject;
import omero.gateway.model.ImageData;
import omero.gateway.model.WellSampleData;
import org.openmicroscopy.shoola.env.rnd.RndProxyDef;

public class ViewImageObject {
    private DataObject image;
    private RndProxyDef settings;
    private long selectedUserID;
    private DataObject parent;
    private DataObject grandParent;
    private long imageID;
    private long rndDefID;

    public ViewImageObject(long imageID) {
        if (imageID < 0L) {
            throw new IllegalArgumentException("Image ID not valid.");
        }
        this.imageID = imageID;
        this.selectedUserID = -1L;
        this.rndDefID = -1L;
    }

    public ViewImageObject(DataObject image) {
        if (image == null) {
            throw new IllegalArgumentException("Image not null.");
        }
        if (!(image instanceof ImageData) && !(image instanceof WellSampleData)) {
            throw new IllegalArgumentException("Object can either be a WellSample or an Image.");
        }
        this.image = image;
        this.selectedUserID = -1L;
        this.imageID = -1L;
        this.rndDefID = -1L;
    }

    public void setSelectedRndDef(long rndDefID) {
        this.rndDefID = rndDefID;
    }

    public long getSelectedRndDef() {
        return this.rndDefID;
    }

    public void setContext(DataObject parent, DataObject grandParent) {
        this.parent = parent;
        this.grandParent = grandParent;
    }

    public long getImageID() {
        return this.imageID;
    }

    public DataObject getParent() {
        return this.parent;
    }

    public DataObject getGrandParent() {
        return this.grandParent;
    }

    public void setSettings(RndProxyDef settings, long selectedUserID) {
        this.settings = settings;
        this.selectedUserID = selectedUserID;
    }

    public RndProxyDef getSettings() {
        return this.settings;
    }

    public long getSelectedUserID() {
        return this.selectedUserID;
    }

    public DataObject getImage() {
        return this.image;
    }
}

