/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter;

import java.util.List;
import omero.gateway.SecurityContext;
import omero.gateway.model.ROIData;
import org.openmicroscopy.shoola.agents.fsimporter.DataImporterLoader;
import org.openmicroscopy.shoola.agents.fsimporter.util.FileImportComponentI;
import org.openmicroscopy.shoola.agents.fsimporter.view.Importer;
import org.openmicroscopy.shoola.env.data.views.CallHandle;

public class ROISaver
extends DataImporterLoader {
    private static final String SAVING_MESSAGE = "Saving ROIs";
    private static final String SAVED_MESSAGE = "ROIs Saved";
    private static final String ERROR_MESSAGE = "Error occurred while saving ROIs";
    private CallHandle handle;
    private long imageID;
    private long userID;
    private List<ROIData> rois;
    private FileImportComponentI c;

    public ROISaver(Importer viewer, SecurityContext ctx, List<ROIData> rois, long imageID, long userID, FileImportComponentI c) {
        super(viewer, ctx);
        if (imageID < 0L) {
            throw new IllegalArgumentException("No image specified.");
        }
        this.imageID = imageID;
        this.userID = userID;
        this.rois = rois;
        this.c = c;
    }

    @Override
    public void load() {
        this.handle = this.ivView.saveROI(this.ctx, this.imageID, this.userID, this.rois, this);
        if (this.c != null) {
            this.c.onResultsSaving(SAVING_MESSAGE, true);
        }
    }

    @Override
    public void cancel() {
        this.handle.cancel();
    }

    @Override
    public void handleResult(Object result) {
        if (this.c != null) {
            this.c.onResultsSaving(SAVED_MESSAGE, false);
        }
    }

    @Override
    public void handleException(Throwable exc) {
        super.handleException(exc);
        if (this.c != null) {
            this.c.onResultsSaving(ERROR_MESSAGE, false);
        }
    }
}

