/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.chooser;

import com.google.common.collect.ArrayListMultimap;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.GroupData;
import omero.gateway.model.PermissionData;
import omero.gateway.model.ProjectData;
import omero.gateway.model.ScreenData;
import org.apache.commons.collections.CollectionUtils;
import org.jdesktop.swingx.JXBusyLabel;
import org.openmicroscopy.shoola.agents.fsimporter.IconManager;
import org.openmicroscopy.shoola.agents.fsimporter.ImporterAgent;
import org.openmicroscopy.shoola.agents.fsimporter.chooser.ExperimenterDisplay;
import org.openmicroscopy.shoola.agents.fsimporter.chooser.ImportLocationSettings;
import org.openmicroscopy.shoola.agents.fsimporter.chooser.NullImportSettings;
import org.openmicroscopy.shoola.agents.fsimporter.chooser.ProjectImportLocationSettings;
import org.openmicroscopy.shoola.agents.fsimporter.chooser.ScreenImportLocationSettings;
import org.openmicroscopy.shoola.agents.fsimporter.util.ObjectToCreate;
import org.openmicroscopy.shoola.agents.fsimporter.view.ImportLocationDetails;
import org.openmicroscopy.shoola.agents.fsimporter.view.Importer;
import org.openmicroscopy.shoola.agents.util.ComboBoxToolTipRenderer;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.agents.util.ViewerSorter;
import org.openmicroscopy.shoola.agents.util.browser.DataNode;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.util.ui.EditorDialog;
import org.openmicroscopy.shoola.agents.util.ui.JComboBoxImageObject;
import org.openmicroscopy.shoola.agents.util.ui.JComboBoxImageRenderer;
import org.openmicroscopy.shoola.util.ui.Selectable;
import org.openmicroscopy.shoola.util.ui.SelectableComboBoxModel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class LocationDialog
extends JDialog
implements ActionListener,
PropertyChangeListener,
ChangeListener,
ItemListener {
    static final String ADD_TO_QUEUE_PROPERTY = "addToQueue";
    private static final int UI_GAP = 5;
    private static final int MIN_WIDTH = 640;
    private static final Dimension SELECTION_BOX_SIZE = new Dimension(200, 130);
    private static String TEXT_TITLE = "Import Location - Select where to import your data.";
    private static final String TEXT_IMPORT_AS = "Import For";
    private static final String TEXT_PROJECTS = "Projects";
    private static final String TEXT_SCREENS = "Screens";
    private static final String TOOLTIP_SCREENS_TAB = "Import settings for Screens";
    private static final String TOOLTIP_PROJECTS_TAB = "Import settings for Projects";
    private static final String TEXT_PROJECT = "Project";
    private static final String TEXT_DATASET = "Dataset";
    private static final String TEXT_SCREEN = "Screen";
    private static final String TEXT_GROUP = "Group";
    private static final String TOOLTIP_NEW_SCREEN = "Create a new Screen.";
    private static final String TOOLTIP_NEW_DATASET = "Create a new Dataset.";
    private static final String TOOLTIP_NEW_PROJECT = "Create a new Project.";
    private static final String TEXT_REFRESH = "Refresh";
    private static final String TOOLTIP_REFRESH = "Reload the Groups, Projects, Datasets and/or Screens.";
    private static final String TEXT_NEW = "New...";
    private static final String TEXT_CLOSE = "Close";
    private static final String TOOLTIP_CLOSE_DIALOGUE = "Close the dialog and do not add the files to the queue.";
    private static final String TEXT_QUEUE_ITEMS = "Add to the Queue";
    private static final String TOOLTIP_QUEUE_ITEMS = "Add the files to the queue.";
    private static final Icon GROUP_PRIVATE_ICON;
    private static final Icon GROUP_READ_ONLY_ICON;
    private static final Icon GROUP_READ_LINK_ICON;
    private static final Icon GROUP_READ_WRITE_ICON;
    private static final Icon GROUP_PUBLIC_READ_ICON;
    private static final Icon GROUP_PUBLIC_READ_WRITE_ICON;
    private static final int CMD_CREATE_PROJECT = 1;
    private static final int CMD_CREATE_DATASET = 2;
    private static final int CMD_CREATE_SCREEN = 3;
    private static final int CMD_REFRESH_DISPLAY = 4;
    static final int CMD_ADD = 5;
    static final int CMD_CLOSE = 6;
    private int userSelectedActionCommandId;
    private JPanel projectPanel;
    private JPanel screenPanel;
    private JButton addButton;
    private JButton closeButton;
    private JComboBox groupsBox;
    private JComboBox usersBox;
    private JComboBox projectsBox;
    private JComboBox datasetsBox;
    private JComboBox screensBox;
    private JButton newProjectButton;
    private JButton newDatasetButton;
    private JButton newScreenButton;
    private JButton refreshButton;
    private JTabbedPane tabbedPane;
    private static final int NO_DATA_TYPE = -1;
    private ViewerSorter sorter;
    private TreeImageDisplay container;
    private int dataType = -1;
    private Collection<GroupData> groups;
    private Collection<TreeImageDisplay> objects;
    private List<DataNode> projects = new ArrayList<DataNode>();
    private List<DataNode> screens = new ArrayList<DataNode>();
    private Map<DataNode, List<DataNode>> datasets = new Hashtable<DataNode, List<DataNode>>();
    private DataNode currentProject;
    private DataNode currentDataset;
    private DataNode currentScreen;
    private Importer model;
    private boolean activeWindow;
    private JXBusyLabel busyLabel;

    LocationDialog(JFrame parent, TreeImageDisplay selectedContainer, int importDataType, Collection<TreeImageDisplay> objects, Importer model, long currentGroupId, boolean ijoption) {
        super(parent);
        this.container = selectedContainer;
        this.dataType = importDataType;
        this.objects = objects;
        this.groups = model.getAvailableGroups();
        this.model = model;
        this.setModal(true);
        this.setTitle(TEXT_TITLE);
        this.initUIComponents();
        this.layoutUI(ijoption);
        this.populateUIWithDisplayData(this.findWithId(this.groups, currentGroupId), model.getImportFor());
        this.addPropertyChangeListener(this);
        this.addButton.setEnabled(true);
    }

    private void populateUIWithDisplayData(GroupData selectedGroup, long userID) {
        this.convertToDisplayData(this.objects);
        this.populateGroupBox(this.sort(this.groups), selectedGroup, userID);
        this.populateLocationComboBoxes();
        this.displayViewFor(this.dataType);
    }

    private ExperimenterData getExperimenter(ExperimenterData owner) {
        if (owner == null) {
            return null;
        }
        if (owner.isLoaded()) {
            return owner;
        }
        List l = (List)ImporterAgent.getRegistry().lookup("/users/details");
        if (l == null) {
            return null;
        }
        Iterator i = l.iterator();
        long id = owner.getId();
        while (i.hasNext()) {
            ExperimenterData exp = (ExperimenterData)i.next();
            if (exp.getId() != id) continue;
            return exp;
        }
        return null;
    }

    private void displayViewFor(int dataType) {
        switch (dataType) {
            case 0: {
                this.tabbedPane.setSelectedComponent(this.projectPanel);
                break;
            }
            case 1: {
                this.tabbedPane.setSelectedComponent(this.screenPanel);
            }
        }
    }

    private <T extends DataObject> T findWithId(Collection<T> dataObjects, long id) {
        for (DataObject dataObject : dataObjects) {
            if (dataObject.getId() != id) continue;
            return (T)dataObject;
        }
        return null;
    }

    private DataNode findDataNodeById(Collection<DataNode> nodes, long id) {
        if (CollectionUtils.isEmpty(nodes)) {
            return null;
        }
        for (DataNode node : nodes) {
            if (this.getIdOf(node) != id) continue;
            return node;
        }
        return null;
    }

    private void initUIComponents() {
        this.sorter = new ViewerSorter();
        this.groupsBox = new JComboBox();
        this.usersBox = new JComboBox();
        this.usersBox.setVisible(this.model.canImportAs());
        this.refreshButton = new JButton(TEXT_REFRESH);
        this.refreshButton.setBackground(UIUtilities.BACKGROUND);
        this.refreshButton.setToolTipText(TOOLTIP_REFRESH);
        this.refreshButton.setActionCommand("4");
        this.refreshButton.addActionListener(this);
        this.projectsBox = new JComboBox();
        this.projectsBox.addItemListener(this);
        this.datasetsBox = new JComboBox();
        this.datasetsBox.addItemListener(this);
        this.screensBox = new JComboBox();
        this.screensBox.addItemListener(this);
        this.newProjectButton = new JButton(TEXT_NEW);
        this.newProjectButton.setToolTipText(TOOLTIP_NEW_PROJECT);
        this.newProjectButton.setActionCommand("1");
        this.newProjectButton.addActionListener(this);
        this.newDatasetButton = new JButton(TEXT_NEW);
        this.newDatasetButton.setToolTipText(TOOLTIP_NEW_DATASET);
        this.newDatasetButton.setActionCommand("2");
        this.newDatasetButton.addActionListener(this);
        this.newScreenButton = new JButton(TEXT_NEW);
        this.newScreenButton.setToolTipText(TOOLTIP_NEW_SCREEN);
        this.newScreenButton.setActionCommand("3");
        this.newScreenButton.addActionListener(this);
        this.addButton = new JButton(TEXT_QUEUE_ITEMS);
        this.addButton.setToolTipText(TOOLTIP_QUEUE_ITEMS);
        this.addButton.addActionListener(this);
        this.addButton.setActionCommand("5");
        this.addButton.setEnabled(false);
        this.closeButton = new JButton(TEXT_CLOSE);
        this.closeButton.setToolTipText(TOOLTIP_CLOSE_DIALOGUE);
        this.closeButton.addActionListener(this);
        this.closeButton.setActionCommand("6");
        Dimension d = new Dimension(16, 16);
        this.busyLabel = new JXBusyLabel(d);
        this.busyLabel.setVisible(true);
        this.busyLabel.setBusy(true);
        this.getRootPane().setDefaultButton(this.addButton);
    }

    private JPanel buildLowerButtonPanel(boolean ijoption) {
        JPanel buttonPanel = new JPanel();
        BoxLayout lay = new BoxLayout(buttonPanel, 0);
        buttonPanel.setLayout(lay);
        int plugin = ImporterAgent.runAsPlugin();
        if (plugin != 3 && plugin != 1) {
            buttonPanel.add(this.closeButton);
            buttonPanel.add(this.refreshButton);
        } else {
            if (!ijoption) {
                buttonPanel.add(this.closeButton);
            }
            buttonPanel.add(this.refreshButton);
        }
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.addButton);
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        JPanel buttonWrapper = new JPanel(new BorderLayout());
        buttonWrapper.add((Component)buttonPanel, "Center");
        buttonWrapper.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.BLACK));
        return buttonWrapper;
    }

    private JTabbedPane buildDataTypeTabbedPane() {
        IconManager icons = IconManager.getInstance();
        Icon projectIcon = icons.getIcon(13);
        this.projectPanel = this.buildProjectSelectionPanel();
        Icon screenIcon = icons.getIcon(15);
        this.screenPanel = this.buildScreenSelectionPanel();
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addTab(TEXT_PROJECTS, projectIcon, this.projectPanel, TOOLTIP_PROJECTS_TAB);
        this.tabbedPane.addTab(TEXT_SCREENS, screenIcon, this.screenPanel, TOOLTIP_SCREENS_TAB);
        this.tabbedPane.addChangeListener(this);
        this.tabbedPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return this.tabbedPane;
    }

    private JPanel buildGroupSelectionPanel() {
        JPanel groupPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(1, 1, 1, 1);
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 17;
        if (this.groups.size() > 1) {
            groupPanel.add((Component)UIUtilities.setTextFont(TEXT_GROUP), c);
            ++c.gridx;
            groupPanel.add((Component)this.groupsBox, c);
            ++c.gridy;
            c.gridx = 0;
        }
        if (this.usersBox.isVisible()) {
            groupPanel.add((Component)UIUtilities.setTextFont(TEXT_IMPORT_AS), c);
            ++c.gridx;
            groupPanel.add((Component)this.usersBox, c);
            ++c.gridy;
        }
        c.gridy = 0;
        c.gridx = 2;
        c.weightx = 1.0;
        c.fill = 0;
        c.anchor = 13;
        groupPanel.add((Component)this.busyLabel, c);
        ++c.gridy;
        groupPanel.add((Component)new JPanel(), c);
        return groupPanel;
    }

    private JPanel buildProjectSelectionPanel() {
        JPanel projectPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(1, 1, 1, 1);
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 0;
        c.anchor = 17;
        c.weightx = 0.0;
        c.weighty = 0.0;
        projectPanel.add((Component)UIUtilities.setTextFont(TEXT_PROJECT), c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        projectPanel.add((Component)this.projectsBox, c);
        ++c.gridx;
        c.fill = 0;
        c.weightx = 0.0;
        projectPanel.add((Component)this.newProjectButton, c);
        ++c.gridy;
        c.gridx = 0;
        projectPanel.add((Component)UIUtilities.setTextFont(TEXT_DATASET), c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        projectPanel.add((Component)this.datasetsBox, c);
        ++c.gridx;
        c.fill = 0;
        c.weightx = 0.0;
        projectPanel.add((Component)this.newDatasetButton, c);
        projectPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return projectPanel;
    }

    private JPanel buildScreenSelectionPanel() {
        JPanel screenPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(1, 1, 1, 1);
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 0;
        c.anchor = 17;
        c.weightx = 0.0;
        c.weighty = 0.0;
        screenPanel.add((Component)UIUtilities.setTextFont(TEXT_SCREEN), c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        screenPanel.add((Component)this.screensBox, c);
        ++c.gridx;
        c.fill = 0;
        c.weightx = 0.0;
        screenPanel.add((Component)this.newScreenButton, c);
        screenPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return screenPanel;
    }

    private void populateGroupBox(Collection<GroupData> availableGroups, GroupData selectedGroup, long userID) {
        this.groupsBox.removeItemListener(this);
        this.groupsBox.removeAllItems();
        JComboBoxImageObject selectedGroupItem = null;
        ArrayList<String> tooltips = new ArrayList<String>(availableGroups.size());
        for (GroupData group : availableGroups) {
            JComboBoxImageObject item = new JComboBoxImageObject((DataObject)group, this.getGroupIcon(group));
            ArrayList<String> lines = new ArrayList<String>();
            lines.addAll(UIUtilities.wrapStyleWord(group.getName()));
            tooltips.add(UIUtilities.formatToolTipText(lines));
            this.groupsBox.addItem(item);
            if (selectedGroup == null || selectedGroup.getId() != group.getId()) continue;
            selectedGroupItem = item;
        }
        if (selectedGroupItem != null) {
            this.groupsBox.setSelectedItem(selectedGroupItem);
            this.displayUsers(this.usersBox, selectedGroup, this, userID);
        }
        JComboBoxImageRenderer renderer = new JComboBoxImageRenderer();
        renderer.setTooltips(tooltips);
        renderer.setPreferredSize(SELECTION_BOX_SIZE);
        this.groupsBox.setRenderer(renderer);
        this.groupsBox.addItemListener(this);
    }

    private boolean canImportForUserInGroup(ExperimenterData user, GroupData selectedGroup) {
        ExperimenterData loggedInUser = ImporterAgent.getUserDetails();
        if (user.getId() == loggedInUser.getId()) {
            return true;
        }
        if (ImporterAgent.isAdministrator()) {
            return true;
        }
        Set leaders = selectedGroup.getLeaders();
        for (ExperimenterData leader : leaders) {
            if (leader.getId() != loggedInUser.getId()) continue;
            return true;
        }
        return false;
    }

    private Icon getGroupIcon(GroupData group) {
        switch (group.getPermissions().getPermissionsLevel()) {
            case 0: {
                return GROUP_PRIVATE_ICON;
            }
            case 1: {
                return GROUP_READ_ONLY_ICON;
            }
            case 2: {
                return GROUP_READ_LINK_ICON;
            }
            case 3: {
                return GROUP_READ_WRITE_ICON;
            }
            case 4: {
                return GROUP_PUBLIC_READ_ICON;
            }
            case 5: {
                return GROUP_PUBLIC_READ_WRITE_ICON;
            }
        }
        return null;
    }

    private void layoutUI(boolean ijoption) {
        JComponent pane;
        int plugin = ImporterAgent.runAsPlugin();
        if (plugin == 3 || plugin == 1) {
            this.activeWindow = true;
            JPanel buttons = new JPanel();
            buttons.setLayout(new BoxLayout(buttons, 1));
            ButtonGroup group = new ButtonGroup();
            JRadioButton b = new JRadioButton("Add Image from current window");
            b.setSelected(this.activeWindow);
            buttons.add(b);
            group.add(b);
            b.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    LocationDialog.this.activeWindow = e.getStateChange() == 1;
                }
            });
            b = new JRadioButton("Add Images from all image windows");
            buttons.add(b);
            group.add(b);
            pane = new JPanel();
            pane.setLayout(new BorderLayout());
            pane.add((Component)this.buildDataTypeTabbedPane(), "Center");
            if (ijoption) {
                pane.add((Component)UIUtilities.buildComponentPanel(buttons), "South");
            }
        } else {
            pane = this.buildDataTypeTabbedPane();
        }
        BorderLayout layout = new BorderLayout();
        layout.setHgap(5);
        layout.setVgap(5);
        JPanel content = new JPanel();
        content.setLayout(new BorderLayout());
        content.add((Component)this.buildGroupSelectionPanel(), "North");
        content.add((Component)pane, "Center");
        content.add((Component)this.buildLowerButtonPanel(ijoption), "South");
        content.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)content, "Center");
        this.setMinimumSize();
    }

    private void setMinimumSize() {
        this.pack();
        int minHeight = this.getHeight();
        Dimension minSize = new Dimension(640, minHeight);
        this.setMinimumSize(minSize);
        this.setPreferredSize(minSize);
        this.setSize(minSize);
    }

    private <T extends Container> JPanel wrapInPaddedPanel(T container, int top, int left, int bottom, int right) {
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        p.setBorder(BorderFactory.createEmptyBorder(top, left, bottom, right));
        p.add(container, "Center");
        return p;
    }

    private void close() {
        int plugin = ImporterAgent.runAsPlugin();
        if (plugin == 1 || plugin == 3) {
            return;
        }
        this.setVisible(false);
        this.dispose();
    }

    int centerLocation() {
        UIUtilities.centerAndShow(this);
        return this.userSelectedActionCommandId;
    }

    int showLocation(Point location) {
        this.setLocation(location);
        this.setVisible(true);
        return this.userSelectedActionCommandId;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String actionCommand = ae.getActionCommand();
        try {
            int commandId = Integer.parseInt(actionCommand);
            ProjectData newDataObject = null;
            switch (commandId) {
                case 1: {
                    newDataObject = new ProjectData();
                    break;
                }
                case 2: {
                    newDataObject = new DatasetData();
                    break;
                }
                case 3: {
                    newDataObject = new ScreenData();
                    break;
                }
                case 5: 
                case 6: {
                    this.userSelectedActionCommandId = commandId;
                    this.firePropertyChange(ADD_TO_QUEUE_PROPERTY, null, (Object)commandId);
                    this.close();
                    break;
                }
                case 4: {
                    this.storeCurrentSelections();
                    this.firePropertyChange("refreshLocation", null, new ImportLocationDetails(this.dataType));
                }
            }
            if (newDataObject != null) {
                EditorDialog editor = new EditorDialog((JFrame)this.getOwner(), (DataObject)newDataObject, false);
                editor.addPropertyChangeListener(this);
                editor.setModal(true);
                UIUtilities.centerAndShow(editor);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void switchToSelectedGroup() {
        GroupData selectedNewGroup = this.getSelectedGroup();
        this.objects.clear();
        this.convertToDisplayData(this.objects);
        this.populateLocationComboBoxes();
        this.firePropertyChange("groupChanged", null, selectedNewGroup);
    }

    private void switchToSelectedUser() {
        this.populateLocationComboBoxes();
    }

    protected ImportLocationSettings getImportSettings() {
        GroupData group = this.getSelectedGroup();
        ExperimenterData user = this.getSelectedUser();
        switch (this.dataType) {
            case 0: {
                DataNode project = this.getSelectedItem(this.projectsBox);
                DataNode dataset = this.getSelectedItem(this.datasetsBox);
                return new ProjectImportLocationSettings(group, user, project, dataset);
            }
            case 1: {
                DataNode screen = this.getSelectedItem(this.screensBox);
                return new ScreenImportLocationSettings(group, user, screen);
            }
        }
        return new NullImportSettings(group, user);
    }

    private ExperimenterData getSelectedUser() {
        return this.getUser(this.usersBox.getSelectedIndex());
    }

    private ExperimenterData getUser(int index) {
        Selectable selectedItem = (Selectable)this.usersBox.getItemAt(index);
        if (selectedItem != null) {
            return ((ExperimenterDisplay)selectedItem.getObject()).getData();
        }
        return null;
    }

    private void displayItemsWithTooltips(JComboBox comboBox, List<DataNode> listItems) {
        this.displayItems(comboBox, listItems, null, null);
    }

    private void displayItemsWithTooltips(JComboBox comboBox, List<DataNode> listItems, DataNode selected) {
        this.displayItems(comboBox, listItems, selected, null);
    }

    private boolean isAdmin(long userID) {
        for (GroupData g : this.groups) {
            if (!this.model.isSystemGroup(g.getId(), "system")) continue;
            Set experimenters = g.getExperimenters();
            Iterator j = experimenters.iterator();
            while (j.hasNext()) {
                if (((ExperimenterData)j.next()).getId() != userID) continue;
                return true;
            }
        }
        return false;
    }

    private void displayItems(JComboBox comboBox, List<DataNode> listItems, DataNode select, ItemListener itemListener) {
        if (comboBox == null || listItems == null) {
            return;
        }
        if (itemListener != null) {
            comboBox.removeItemListener(itemListener);
        }
        comboBox.removeAllItems();
        ArrayList<String> tooltips = new ArrayList<String>(listItems.size());
        SelectableComboBoxModel model = new SelectableComboBoxModel();
        Selectable<DataNode> selected = null;
        GroupData group = this.getSelectedGroup();
        ExperimenterData user = this.getSelectedUser();
        long userID = -1L;
        if (user != null) {
            userID = user.getId();
        }
        ExperimenterData loggedIn = ImporterAgent.getUserDetails();
        boolean isAdmin = ImporterAgent.isAdministrator();
        long loggedInID = loggedIn.getId();
        boolean userIsAdmin = this.isAdmin(userID);
        for (DataNode node : listItems) {
            ExperimenterData exp = this.getExperimenter(node.getOwner());
            ArrayList<String> lines = new ArrayList<String>();
            if (exp != null) {
                lines.add("<b>Owner: </b>" + EditorUtil.formatExperimenter(exp));
            }
            lines.addAll(UIUtilities.wrapStyleWord(node.getFullName()));
            tooltips.add(UIUtilities.formatToolTipText(lines));
            boolean selectable = true;
            if (!node.isDefaultNode()) {
                selectable = this.canLink(node.getDataObject(), userID, group, loggedInID, isAdmin, userIsAdmin);
            }
            Selectable<DataNode> comboBoxItem = new Selectable<DataNode>(node, selectable);
            if (select != null) {
                if (node.getDataObject().getId() < 0L && select.getDataObject().getId() < 0L) {
                    if (node.toString().trim().equals(select.toString().trim())) {
                        selected = comboBoxItem;
                    }
                } else if (node.getDataObject().getId() == select.getDataObject().getId()) {
                    selected = comboBoxItem;
                }
            }
            model.addElement(comboBoxItem);
        }
        ComboBoxToolTipRenderer renderer = this.createComboboxRenderer();
        renderer.setTooltips(tooltips);
        comboBox.setModel(model);
        comboBox.setRenderer(renderer);
        if (selected != null) {
            comboBox.setSelectedItem(selected);
        }
        if (itemListener != null) {
            comboBox.addItemListener(itemListener);
        }
    }

    private boolean canLink(DataObject node, long userID, GroupData group, long loggedUserID, boolean isAdmin, boolean userIsAdmin) {
        if (node.getOwner().getId() == userID) {
            return true;
        }
        if (!node.canLink()) {
            return false;
        }
        PermissionData permissions = group.getPermissions();
        if (permissions.getPermissionsLevel() == 0) {
            return false;
        }
        if (permissions.isGroupWrite() || userIsAdmin) {
            return true;
        }
        Set leaders = group.getLeaders();
        if (leaders != null) {
            for (ExperimenterData exp : leaders) {
                if (exp.getId() != userID) continue;
                return true;
            }
        }
        if (userID != loggedUserID) {
            return false;
        }
        return isAdmin;
    }

    private ComboBoxToolTipRenderer createComboboxRenderer() {
        ExperimenterData exp = this.getSelectedUser();
        long id = -1L;
        if (exp != null) {
            id = exp.getId();
        }
        return new ComboBoxToolTipRenderer(id);
    }

    private void displayUsers(JComboBox comboBox, GroupData group, ItemListener itemListener, long userID) {
        if (comboBox == null || group == null) {
            return;
        }
        if (itemListener != null) {
            comboBox.removeItemListener(itemListener);
        }
        comboBox.removeAllItems();
        SelectableComboBoxModel model = new SelectableComboBoxModel();
        Selectable<ExperimenterDisplay> selected = null;
        List members = this.sort(group.getExperimenters());
        ArrayList<String> tooltips = new ArrayList<String>(members.size());
        for (ExperimenterData user : members) {
            boolean canImportAs = this.canImportForUserInGroup(user, group);
            Selectable<ExperimenterDisplay> item = new Selectable<ExperimenterDisplay>(new ExperimenterDisplay(user), canImportAs);
            if (user.getId() == userID) {
                selected = item;
            }
            ArrayList<String> lines = new ArrayList<String>();
            lines.addAll(UIUtilities.wrapStyleWord(EditorUtil.formatExperimenter(user)));
            tooltips.add(UIUtilities.formatToolTipText(lines));
            model.addElement(item);
        }
        ComboBoxToolTipRenderer renderer = this.createComboboxRenderer();
        renderer.setTooltips(tooltips);
        comboBox.setModel(model);
        comboBox.setRenderer(renderer);
        if (selected != null) {
            comboBox.setSelectedItem(selected);
        }
        if (itemListener != null) {
            comboBox.addItemListener(itemListener);
        }
    }

    protected void createProject(DataObject newProject) {
        if (newProject == null) {
            return;
        }
        DataNode newProjectNode = new DataNode(newProject);
        DataNode newDefaultDatasetNode = new DataNode((DataObject)DataNode.createDefaultDataset(), newProjectNode);
        newProjectNode.addNode(newDefaultDatasetNode);
        ArrayList<DataNode> newDatasets = new ArrayList<DataNode>();
        newDatasets.add(newDefaultDatasetNode);
        this.projects.add(newProjectNode);
        this.projects = this.sortByUser(this.projects);
        this.datasets.put(newProjectNode, newDatasets);
        this.currentProject = newProjectNode;
        this.displayItems(this.projectsBox, this.projects, newProjectNode, this);
        this.displayItemsWithTooltips(this.datasetsBox, newDatasets);
        this.repaint();
    }

    protected void createDataset(DatasetData dataset) {
        if (dataset == null) {
            return;
        }
        DataNode selectedProject = this.getSelectedItem(this.projectsBox);
        DataNode newDatasetNode = new DataNode((DataObject)dataset, selectedProject);
        List<DataNode> projectDatasets = this.datasets.get(selectedProject);
        if (projectDatasets == null) {
            projectDatasets = new ArrayList<DataNode>();
            DataNode newDefaultDatasetNode = new DataNode((DataObject)DataNode.createDefaultDataset(), selectedProject);
            selectedProject.addNode(newDefaultDatasetNode);
            projectDatasets.add(newDefaultDatasetNode);
        }
        projectDatasets.add(newDatasetNode);
        projectDatasets = this.sortByUser(projectDatasets);
        this.datasets.put(selectedProject, projectDatasets);
        this.currentDataset = newDatasetNode;
        this.displayItemsWithTooltips(this.datasetsBox, projectDatasets, newDatasetNode);
        this.repaint();
    }

    protected void createScreen(DataObject newScreenObject) {
        if (newScreenObject == null) {
            return;
        }
        DataNode newScreenNode = new DataNode(newScreenObject);
        this.screens.add(newScreenNode);
        this.screens = this.sortByUser(this.screens);
        this.currentScreen = newScreenNode;
        this.displayItemsWithTooltips(this.screensBox, this.screens, newScreenNode);
        this.repaint();
    }

    private void populateDatasetsBox() {
        DataNode project = this.getSelectedItem(this.projectsBox);
        this.displayItemsWithTooltips(this.datasetsBox, this.sortByUser(this.datasets.get(project)));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("createNoParent".equals(name)) {
            Object ho = evt.getNewValue();
            DataObject child = null;
            DataObject parent = null;
            if (ho instanceof ProjectData || ho instanceof ScreenData) {
                child = (DataObject)ho;
            } else if (ho instanceof DatasetData) {
                child = (DataObject)ho;
                DataNode n = this.getSelectedItem(this.projectsBox);
                if (!n.isDefaultNode()) {
                    parent = n.getDataObject();
                }
            }
            GroupData selectedGroup = this.getSelectedGroup();
            if (child != null) {
                this.firePropertyChange("createObject", null, new ObjectToCreate(selectedGroup, child, parent, this.getSelectedUser()));
            }
        }
        if ("refreshLocation".equals(name) || "groupChanged".equals(name)) {
            ImportLocationDetails details;
            this.busyLabel.setBusy(true);
            this.busyLabel.setVisible(true);
            this.addButton.setEnabled(false);
            Object value = evt.getNewValue();
            if (value != null && value instanceof ImportLocationDetails && (details = (ImportLocationDetails)evt.getNewValue()) != null) {
                this.dataType = (int)details.getDataType();
            }
        }
    }

    private GroupData getSelectedGroup() {
        JComboBoxImageObject selectedEntry = (JComboBoxImageObject)this.groupsBox.getSelectedItem();
        return (GroupData)selectedEntry.getData();
    }

    private void convertToDisplayData(Collection<TreeImageDisplay> treeNodes) {
        this.projects.clear();
        this.datasets.clear();
        this.screens.clear();
        DataNode defaultProject = new DataNode((DataObject)DataNode.createDefaultProject());
        ArrayList<DataNode> orphanDatasets = new ArrayList<DataNode>();
        ArrayList<DataNode> lp = new ArrayList<DataNode>();
        ArrayList<DataNode> ls = new ArrayList<DataNode>();
        if (treeNodes != null) {
            for (TreeImageDisplay treeNode : treeNodes) {
                Object userObject = treeNode.getUserObject();
                if (userObject instanceof ProjectData) {
                    DataNode project = new DataNode((DataObject)((ProjectData)userObject));
                    lp.add(project);
                    ArrayList<DataNode> projectDatasets = new ArrayList<DataNode>();
                    List children = treeNode.getChildrenDisplay();
                    for (Object child : children) {
                        TreeImageDisplay n = (TreeImageDisplay)child;
                        projectDatasets.add(new DataNode((DataObject)((DatasetData)n.getUserObject())));
                    }
                    ArrayList<DataNode> list = new ArrayList<DataNode>();
                    list.add(new DataNode((DataObject)DataNode.createDefaultDataset()));
                    list.addAll(this.sort(projectDatasets));
                    this.datasets.put(project, list);
                    continue;
                }
                if (userObject instanceof ScreenData) {
                    DataNode screen = new DataNode((DataObject)((ScreenData)userObject));
                    ls.add(screen);
                    continue;
                }
                if (!(userObject instanceof DatasetData)) continue;
                DataNode dataset = new DataNode((DataObject)((DatasetData)userObject));
                orphanDatasets.add(dataset);
            }
        }
        ArrayList<DataNode> l = new ArrayList<DataNode>();
        l.add(new DataNode((DataObject)DataNode.createDefaultDataset()));
        l.add(new DataNode((DataObject)DataNode.createNoDataset()));
        l.addAll(this.sort(orphanDatasets));
        this.datasets.put(defaultProject, l);
        this.projects.add(defaultProject);
        this.projects.addAll(this.sort(lp));
        this.screens.add(new DataNode((DataObject)DataNode.createDefaultScreen()));
        this.screens.addAll(this.sort(ls));
    }

    private <T> List<T> sort(Collection<T> list) {
        return this.sorter.sort(list);
    }

    private void populateLocationComboBoxes() {
        DataNode selectedProject = null;
        DataNode selectedDataset = null;
        DataNode selectedScreen = null;
        if (this.container != null) {
            Object hostObject = this.container.getUserObject();
            if (hostObject instanceof ProjectData) {
                selectedProject = this.findDataNode(this.projects, hostObject, ProjectData.class);
            } else if (hostObject instanceof DatasetData) {
                Object parentNode = this.getParentUserObject(this.container);
                selectedProject = this.findDataNode(this.projects, parentNode, ProjectData.class);
                DatasetData datasetData = (DatasetData)hostObject;
                long datasetId = datasetData.getId();
                selectedDataset = this.findDataNodeById((Collection<DataNode>)this.datasets.get(selectedProject), datasetId);
            } else if (hostObject instanceof ScreenData) {
                selectedScreen = this.findDataNode(this.screens, hostObject, ScreenData.class);
            }
        } else {
            selectedProject = this.findDataNode(this.projects, this.currentProject);
            int index = 0;
            switch (ImporterAgent.runAsPlugin()) {
                case 1: 
                case 3: {
                    index = 1;
                }
            }
            selectedDataset = this.findDataNode(this.datasets.get(selectedProject), this.currentDataset, index);
            selectedScreen = this.findDataNode(this.screens, this.currentScreen);
        }
        this.displayItems(this.projectsBox, this.sortByUser(this.projects), selectedProject, this);
        if (selectedProject != null) {
            this.displayItemsWithTooltips(this.datasetsBox, this.sortByUser(this.datasets.get(selectedProject)), selectedDataset);
        }
        this.displayItemsWithTooltips(this.screensBox, this.sortByUser(this.screens), selectedScreen);
    }

    private List<DataNode> sortByUser(List<DataNode> nodes) {
        DataNode node2;
        if (CollectionUtils.isEmpty(nodes)) {
            return nodes;
        }
        ArrayList<DataNode> sorted = new ArrayList<DataNode>();
        ArrayListMultimap map = ArrayListMultimap.create();
        sorted.add(nodes.get(0));
        if (nodes.size() > 1 && (node2 = nodes.get(1)).isNoDataset()) {
            sorted.add(node2);
        }
        for (DataNode node2 : nodes) {
            if (node2.isDefaultNode()) continue;
            map.put((Object)node2.getDataObject().getOwner().getId(), (Object)node2);
        }
        ExperimenterData exp = this.getSelectedUser();
        List l = null;
        if (exp != null) {
            l = map.get((Object)exp.getId());
        }
        if (CollectionUtils.isNotEmpty(l)) {
            sorted.addAll(this.sort(l));
        }
        for (int j = 0; j < this.usersBox.getItemCount(); ++j) {
            long id;
            ExperimenterData user = this.getUser(j);
            if (user == null || exp == null || (id = user.getId()) == exp.getId() || (l = map.get((Object)id)) == null) continue;
            sorted.addAll(this.sort(l));
        }
        return sorted;
    }

    private DataNode findDataNode(List<DataNode> nodes, DataNode find, int index) {
        if (CollectionUtils.isEmpty(nodes)) {
            return null;
        }
        if (find == null) {
            if (index >= nodes.size()) {
                return nodes.get(0);
            }
            return nodes.get(index);
        }
        for (DataNode node : nodes) {
            if (this.getIdOf(node) != this.getIdOf(find)) continue;
            return node;
        }
        if (index >= nodes.size()) {
            return nodes.get(0);
        }
        return nodes.get(index);
    }

    private DataNode findDataNode(List<DataNode> nodes, DataNode find) {
        return this.findDataNode(nodes, find, 0);
    }

    private Object getParentUserObject(TreeImageDisplay node) {
        if (node.getParentDisplay() == null) {
            return null;
        }
        return node.getParentDisplay().getUserObject();
    }

    private <T extends DataObject> DataNode findDataNode(List<DataNode> list, Object find, Class<T> klass) {
        DataNode selectedItem = null;
        if (find != null && klass.isInstance(find)) {
            DataObject dataObject = (DataObject)klass.cast(find);
            long nodeId = dataObject.getId();
            selectedItem = this.findDataNodeById(list, nodeId);
        }
        if (selectedItem == null) {
            selectedItem = list.get(0);
        }
        return selectedItem;
    }

    void reset(TreeImageDisplay container, int type, Collection<TreeImageDisplay> objects, long currentGroupId, long userID) {
        this.dataType = type;
        this.objects = objects;
        this.container = container;
        this.busyLabel.setBusy(false);
        this.busyLabel.setVisible(false);
        this.addButton.setEnabled(true);
        this.populateUIWithDisplayData(this.findWithId(this.groups, currentGroupId), userID);
        this.setInputsEnabled(true);
    }

    @Override
    public void stateChanged(ChangeEvent evt) {
        Object source = evt.getSource();
        if (source == this.tabbedPane) {
            JTabbedPane tabbedPane = (JTabbedPane)evt.getSource();
            JPanel activePanel = (JPanel)tabbedPane.getSelectedComponent();
            int newDataType = 0;
            if (activePanel == this.screenPanel) {
                newDataType = 1;
            }
            this.storeCurrentSelections();
            this.firePropertyChange("refreshLocation", null, new ImportLocationDetails(newDataType, this.getSelectedUser()));
        }
    }

    private void storeCurrentSelections() {
        this.currentProject = this.getSelectedItem(this.projectsBox);
        this.currentDataset = this.getSelectedItem(this.datasetsBox);
        this.currentScreen = this.getSelectedItem(this.screensBox);
    }

    private DataNode getSelectedItem(JComboBox comboBox) {
        Object compareItem = comboBox.getSelectedItem();
        if (compareItem instanceof Selectable) {
            Selectable selectable = (Selectable)compareItem;
            if (!selectable.isSelectable()) {
                return null;
            }
            Object innerItem = selectable.getObject();
            if (innerItem instanceof DataNode) {
                return (DataNode)innerItem;
            }
        }
        return null;
    }

    private long getIdOf(DataNode node) {
        if (node == null || node.getDataObject() == null) {
            return -1L;
        }
        return node.getDataObject().getId();
    }

    @Override
    public void itemStateChanged(ItemEvent ie) {
        Object source = ie.getSource();
        if (ie.getStateChange() == 1) {
            if (source == this.groupsBox) {
                this.storeCurrentSelections();
                this.switchToSelectedGroup();
            } else if (source == this.usersBox) {
                this.switchToSelectedUser();
            } else if (source == this.projectsBox) {
                DataNode node = this.getSelectedItem(this.projectsBox);
                this.datasetsBox.setEnabled(true);
                this.newDatasetButton.setEnabled(true);
                if (node.isDefaultProject()) {
                    this.newDatasetButton.setEnabled(true);
                }
                this.populateDatasetsBox();
            }
        }
    }

    void setSelectedGroup(GroupData group) {
        this.groupsBox.setSelectedItem(group);
    }

    private void setInputsEnabled(boolean isEnabled) {
        this.projectsBox.setEnabled(isEnabled);
        this.datasetsBox.setEnabled(isEnabled);
        this.screensBox.setEnabled(isEnabled);
        this.newProjectButton.setEnabled(isEnabled);
        this.newDatasetButton.setEnabled(isEnabled);
        this.newScreenButton.setEnabled(isEnabled);
        this.addButton.setEnabled(isEnabled);
        this.groupsBox.setEnabled(isEnabled);
        this.usersBox.setEnabled(isEnabled);
        this.tabbedPane.setEnabled(isEnabled);
        this.refreshButton.setEnabled(isEnabled);
    }

    boolean isActiveWindow() {
        return this.activeWindow;
    }

    static {
        IconManager icons = IconManager.getInstance();
        GROUP_PRIVATE_ICON = icons.getIcon(22);
        GROUP_READ_ONLY_ICON = icons.getIcon(23);
        GROUP_READ_LINK_ICON = icons.getIcon(24);
        GROUP_READ_WRITE_ICON = icons.getIcon(34);
        GROUP_PUBLIC_READ_ICON = icons.getIcon(25);
        GROUP_PUBLIC_READ_WRITE_ICON = icons.getIcon(25);
    }
}

