/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import omero.gateway.SecurityContext;
import omero.gateway.model.DataObject;
import omero.gateway.model.ImageData;
import org.openmicroscopy.shoola.agents.imviewer.DataLoader;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewer;
import org.openmicroscopy.shoola.env.data.events.DSCallFeedbackEvent;
import org.openmicroscopy.shoola.env.data.model.ThumbnailData;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import org.openmicroscopy.shoola.util.image.geom.Factory;

public class BirdEyeLoader
extends DataLoader {
    public static final double MIN_RATIO = 0.1;
    private CallHandle handle;
    private ImageData image;
    private double ratio = -1.0;
    private int imageSize = -1;
    private boolean cancelled;

    public BirdEyeLoader(ImViewer viewer, SecurityContext ctx, ImageData image, double ratio) {
        super(viewer, ctx);
        if (image == null) {
            throw new IllegalArgumentException("No image to load.");
        }
        this.image = image;
        this.ratio = ratio;
    }

    public BirdEyeLoader(ImViewer viewer, SecurityContext ctx, ImageData image, int imageSize) {
        super(viewer, ctx);
        if (image == null) {
            throw new IllegalArgumentException("No image to load.");
        }
        this.image = image;
        this.imageSize = imageSize;
    }

    @Override
    public void load() {
        ArrayList<DataObject> objects = new ArrayList<DataObject>();
        objects.add((DataObject)this.image);
        if (this.ratio > 0.0) {
            this.handle = this.hiBrwView.loadThumbnails(this.ctx, objects, 96, 96, -1L, 0, this);
        } else if (this.imageSize > 0) {
            this.handle = this.hiBrwView.loadThumbnails(this.ctx, objects, this.imageSize, this.imageSize, -1L, 0, this);
        }
    }

    @Override
    public void cancel() {
        this.cancelled = true;
        this.handle.cancel();
    }

    @Override
    public void handleCancellation() {
    }

    @Override
    public void handleException(Throwable exc) {
        String s = "Bird Eye Retrieval Failure: ";
        if (this.viewer.getState() == 7) {
            return;
        }
        this.registry.getLogger().error((Object)this, s + exc);
        if (this.viewer.getState() == 19) {
            if (this.cancelled) {
                this.viewer.discard();
            } else {
                this.registry.getUserNotifier().notifyError(s, s, exc);
            }
        }
    }

    @Override
    public void update(DSCallFeedbackEvent fe) {
        if (this.viewer.getState() == 7) {
            return;
        }
        ThumbnailData data = (ThumbnailData)fe.getPartialResult();
        if (data != null) {
            BufferedImage image = data.getThumbnail();
            boolean scaled = false;
            if (image != null && this.ratio > 0.0 && this.ratio != 1.0) {
                image = Factory.magnifyImage(this.ratio, image);
                scaled = true;
            }
            this.viewer.setBirdEyeView(image, scaled);
        }
    }
}

