/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.actions;

import java.awt.event.ActionEvent;
import javax.swing.event.ChangeEvent;
import org.openmicroscopy.shoola.agents.imviewer.IconManager;
import org.openmicroscopy.shoola.agents.imviewer.actions.ViewerAction;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewer;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class PlayMovieAction
extends ViewerAction {
    public static final int ACROSS_Z = 300;
    public static final int ACROSS_T = 301;
    public static final int ACROSS_LIFETIME = 303;
    private static final String DESCRIPTION_ACROSS_Z = "Play movie across Z.";
    private static final String DESCRIPTION_ACROSS_T = "Play movie across T.";
    private static final String DESCRIPTION_ACROSS_BIN = "Play movie across t.";
    private IconManager icons;
    private int index;

    private void checkIndex(int index) {
        switch (index) {
            case 300: 
            case 301: 
            case 303: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Index not valid.");
            }
        }
    }

    @Override
    protected void onStateChange(ChangeEvent e) {
        block0 : switch (this.model.getState()) {
            case 7: {
                break;
            }
            case 8: {
                this.setEnabled(false);
                break;
            }
            case 6: {
                if (this.model.isBigImage()) {
                    this.setEnabled(false);
                    break;
                }
                if (this.model.isPlayingMovie()) {
                    this.setEnabled(this.model.getMovieIndex() == this.index);
                    break;
                }
                switch (this.index) {
                    case 303: {
                        this.setEnabled(this.model.getMaxLifetimeBin() > 1);
                        break block0;
                    }
                    case 301: {
                        this.setEnabled(this.model.getRealT() > 1);
                        break block0;
                    }
                    case 300: {
                        this.setEnabled(this.model.getMaxZ() != 0);
                    }
                }
            }
        }
    }

    public PlayMovieAction(ImViewer model, int index) {
        super(model);
        this.checkIndex(index);
        this.index = index;
        this.icons = IconManager.getInstance();
        switch (index) {
            case 301: {
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_ACROSS_T));
                break;
            }
            case 300: {
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_ACROSS_Z));
                break;
            }
            case 303: {
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_ACROSS_BIN));
            }
        }
        this.putValue("SmallIcon", this.icons.getIcon(15));
    }

    public void setActionIcon(boolean b) {
        if (b) {
            this.putValue("SmallIcon", this.icons.getIcon(15));
        } else {
            this.putValue("SmallIcon", this.icons.getIcon(17));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean b = true;
        if (this.model.isPlayingMovie()) {
            b = false;
        }
        this.setActionIcon(!b);
        this.model.playMovie(b, false, this.index);
    }
}

