/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.util.proj;

import java.util.ArrayList;
import java.util.List;
import omero.gateway.model.DatasetData;
import omero.gateway.model.ProjectData;

public class ProjectionRef {
    private int startT;
    private int endT;
    private int startZ;
    private int endZ;
    private int stepping;
    private int type;
    private String pixelsType;
    private List<DatasetData> datasets;
    private String name;
    private String description;
    private List<Integer> channels;
    private boolean applySettings;
    private ProjectData refProject;

    ProjectionRef() {
        this.setStepping(1);
        this.channels = new ArrayList<Integer>();
    }

    ProjectionRef(int startZ, int endZ, int type) {
        this(startZ, endZ, 1, type);
    }

    ProjectionRef(int startZ, int endZ, int frequence, int type) {
        this.setZInterval(startZ, endZ);
        this.setStepping(frequence);
        this.setType(type);
        this.channels = new ArrayList<Integer>();
    }

    void setStepping(int stepping) {
        if (stepping < 1) {
            stepping = 1;
        }
        this.stepping = stepping;
    }

    void setZInterval(int startZ, int endZ) {
        if (startZ > endZ) {
            throw new IllegalArgumentException("Interval not valid.");
        }
        this.startZ = startZ;
        this.endZ = endZ;
    }

    void setTInterval(int startT, int endT) {
        if (startT > endT) {
            throw new IllegalArgumentException("Interval not valid.");
        }
        this.startT = startT;
        this.endT = endT;
    }

    void setPixelsType(String pixelsType) {
        this.pixelsType = pixelsType;
    }

    void setType(int type) {
        this.type = type;
    }

    void setImageName(String name) {
        this.name = name;
    }

    void setImageDescription(String description) {
        this.description = description;
    }

    void setApplySettings(boolean applySettings) {
        this.applySettings = applySettings;
    }

    void setDatasets(List<DatasetData> datasets) {
        this.datasets = datasets;
    }

    void setChannels(List<Integer> channels) {
        this.channels = channels;
    }

    public String getImageName() {
        return this.name;
    }

    public String getImageDescription() {
        return this.description;
    }

    public List<DatasetData> getDatasets() {
        return this.datasets;
    }

    public List<Integer> getChannels() {
        return this.channels;
    }

    public int getStartZ() {
        return this.startZ;
    }

    public int getEndZ() {
        return this.endZ;
    }

    public int getStartT() {
        return this.startT;
    }

    public int getEndT() {
        return this.endT;
    }

    public int getStepping() {
        return this.stepping;
    }

    public int getType() {
        return this.type;
    }

    public String getPixelsType() {
        return this.pixelsType;
    }

    public boolean isApplySettings() {
        return this.applySettings;
    }

    public void setProject(ProjectData project) {
        this.refProject = project;
    }

    public ProjectData getProject() {
        return this.refProject;
    }
}

