/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.util.saver;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.openmicroscopy.shoola.agents.imviewer.IconManager;
import org.openmicroscopy.shoola.agents.imviewer.util.saver.ImgSaver;
import org.openmicroscopy.shoola.agents.imviewer.util.saver.ImgSaverFileChooser;
import org.openmicroscopy.shoola.util.ui.TitlePanel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.filechooser.CreateFolderDialog;

class ImgSaverUI
implements ActionListener,
PropertyChangeListener {
    static final String SAVE_AS = "Save the current image in the specified format.";
    static final int IMAGE = 0;
    static final int GRID_IMAGE = 1;
    static final int PROJECTED_IMAGE = 2;
    static final int IMAGE_AND_COMPONENTS = 3;
    static final int IMAGE_AND_COMPONENTS_GREY = 4;
    static final int LENS_IMAGE = 5;
    static final int LENS_IMAGE_AND_COMPONENTS = 6;
    static final int LENS_IMAGE_AND_COMPONENTS_GREY = 7;
    private static final int MAX = 7;
    private static final int MAX_PARTIAL = 4;
    private static final String NOTE = "Save the (zoomed) image as TIFF, JPEG, PNG, etc.";
    private static final String PREVIEW_TEXT = "Preview the image to save.";
    private static final Dimension H_SPACER_SIZE = new Dimension(3, 10);
    private static final int CANCEL = 0;
    private static final int SAVE = 1;
    private static final int NEWFOLDER = 2;
    private static final int PREVIEW = 3;
    private static final String[] selections = new String[8];
    private static final String[] partialSelections;
    private static final String[] basicSelections;
    private ImgSaver model;
    private JComboBox savingTypes;
    private ImgSaverFileChooser chooser;
    private JCheckBox settings;
    private JButton cancelButton;
    private JButton newFolderButton;
    private JButton saveButton;
    private JButton previewButton;
    private JCheckBox separateFiles;
    private JCheckBox withROI;

    private void initComponents(int defaultType, boolean includeROI) {
        int index = 0;
        switch (defaultType) {
            case 1: 
            case 2: {
                index = defaultType;
            }
        }
        switch (this.model.getSavingType()) {
            case 2: {
                index = 0;
                this.savingTypes = new JComboBox<String>(basicSelections);
                break;
            }
            case 1: {
                this.savingTypes = new JComboBox<String>(partialSelections);
                break;
            }
            default: {
                this.savingTypes = new JComboBox<String>(selections);
            }
        }
        this.savingTypes.setSelectedIndex(index);
        this.savingTypes.addActionListener(this);
        this.separateFiles = new JCheckBox("Save each channel in a separate file.");
        this.separateFiles.setSelected(true);
        this.separateFiles.setVisible(false);
        this.chooser = new ImgSaverFileChooser(this.model, this);
        this.settings = new JCheckBox();
        this.settings.setText("Set the current directory as default.");
        this.settings.setSelected(true);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this);
        this.cancelButton.setActionCommand("0");
        this.saveButton = new JButton("Save as");
        this.saveButton.setToolTipText(UIUtilities.formatToolTipText(SAVE_AS));
        this.saveButton.addActionListener(this);
        this.saveButton.setActionCommand("1");
        this.previewButton = new JButton("Preview...");
        this.previewButton.addActionListener(this);
        this.previewButton.setActionCommand("3");
        this.previewButton.setToolTipText(UIUtilities.formatToolTipText(PREVIEW_TEXT));
        this.newFolderButton = new JButton("New Folder...");
        this.newFolderButton.addActionListener(this);
        this.newFolderButton.setActionCommand("2");
        this.newFolderButton.setToolTipText(UIUtilities.formatToolTipText("Create a new folder"));
        this.model.getRootPane().setDefaultButton(this.saveButton);
        this.withROI = new JCheckBox("Include ROI");
        this.withROI.setVisible(false);
        if (includeROI) {
            this.withROI.setVisible(true);
            this.withROI.setSelected(true);
        }
    }

    private JPanel buildToolbar() {
        JPanel bar = new JPanel();
        bar.setBorder(null);
        bar.add(this.cancelButton);
        bar.add(Box.createRigidArea(H_SPACER_SIZE));
        bar.add(this.saveButton);
        JPanel controls = new JPanel();
        controls.setLayout(new BoxLayout(controls, 0));
        controls.add(Box.createRigidArea(new Dimension(20, 5)));
        controls.add(this.newFolderButton);
        JPanel p = UIUtilities.buildComponentPanelRight(bar);
        p.setOpaque(true);
        controls.add(p);
        return controls;
    }

    private JPanel buildImagePanel() {
        JPanel result = new JPanel();
        result.setLayout(new BoxLayout(result, 0));
        JLabel l = new JLabel("Saving Types: ");
        result.add(l);
        result.add(UIUtilities.buildComponentPanel(this.savingTypes));
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.add(UIUtilities.buildComponentPanelCenter(result));
        if (this.withROI.isVisible()) {
            p.add(UIUtilities.buildComponentPanel(this.withROI));
        }
        p.add(UIUtilities.buildComponentPanel(this.separateFiles));
        return UIUtilities.buildComponentPanelCenter(p);
    }

    private void buildGUI() {
        boolean supportsWindowDecorations;
        JPanel controls = new JPanel();
        controls.setLayout(new BorderLayout(0, 0));
        controls.add((Component)this.buildImagePanel(), "North");
        controls.add((Component)this.buildToolbar(), "Center");
        controls.add((Component)UIUtilities.buildComponentPanel(this.settings), "South");
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout(0, 0));
        p.add((Component)this.chooser, "Center");
        p.add((Component)controls, "South");
        IconManager im = IconManager.getInstance();
        Container c = this.model.getContentPane();
        c.setLayout(new BorderLayout(0, 0));
        TitlePanel tp = new TitlePanel("Save Image", NOTE, im.getIcon(19));
        c.add((Component)((Object)tp), "North");
        c.add((Component)p, "Center");
        if (JDialog.isDefaultLookAndFeelDecorated() && (supportsWindowDecorations = UIManager.getLookAndFeel().getSupportsWindowDecorations())) {
            this.model.getRootPane().setWindowDecorationStyle(6);
        }
    }

    private void handleSavingTypesSelection() {
        this.withROI.setEnabled(false);
        switch (this.savingTypes.getSelectedIndex()) {
            case 3: 
            case 4: {
                this.withROI.setEnabled(true);
                this.separateFiles.setVisible(true);
                break;
            }
            case 6: 
            case 7: {
                this.separateFiles.setVisible(true);
                break;
            }
            case 0: {
                this.withROI.setEnabled(true);
                this.separateFiles.setVisible(false);
                break;
            }
            case 1: 
            case 2: {
                this.separateFiles.setVisible(false);
            }
        }
    }

    ImgSaverUI(ImgSaver model, int defaultType, boolean withROI) {
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        this.model = model;
        this.initComponents(defaultType, withROI);
        this.buildGUI();
    }

    int getSavingType() {
        return this.savingTypes.getSelectedIndex();
    }

    String getCurrentDirectory() {
        return this.chooser.getCurrentDirectory().toString();
    }

    boolean isSetDefaultFolder() {
        return this.settings.isSelected();
    }

    boolean includeROI() {
        return this.withROI.isSelected() && this.withROI.isEnabled();
    }

    void setControlsEnabled(boolean b) {
        this.saveButton.setEnabled(b);
        this.previewButton.setEnabled(b);
    }

    boolean isSaveImagesInSeparatedFiles() {
        return this.separateFiles.isSelected() && this.separateFiles.isVisible();
    }

    File getSelectedFile() {
        return this.chooser.getSelectedFile();
    }

    String getSelectedFilePath() {
        File f = this.getSelectedFile();
        if (f == null) {
            return "";
        }
        return f.getAbsolutePath();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JComboBox) {
            this.handleSavingTypesSelection();
            return;
        }
        int index = Integer.parseInt(e.getActionCommand());
        switch (index) {
            case 0: {
                this.chooser.cancelSelection();
                break;
            }
            case 1: {
                this.chooser.approveSelection();
                break;
            }
            case 3: {
                this.chooser.previewSelection();
                break;
            }
            case 2: {
                CreateFolderDialog d = new CreateFolderDialog(this.model);
                d.addPropertyChangeListener("createFolder", this);
                d.pack();
                UIUtilities.centerAndShow(this.model, d);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = (String)evt.getNewValue();
        this.chooser.createFolder(name);
    }

    static {
        ImgSaverUI.selections[0] = "Image";
        ImgSaverUI.selections[1] = "Split View";
        ImgSaverUI.selections[2] = "Projection View";
        ImgSaverUI.selections[3] = "Image Channels Panorama";
        ImgSaverUI.selections[4] = "Image Channels (grey scale)  Panorama";
        ImgSaverUI.selections[5] = "Lens View";
        ImgSaverUI.selections[6] = "Lens View And Channels Panorama";
        ImgSaverUI.selections[7] = "Lens View And Channels (grey scale) Panorama";
        partialSelections = new String[5];
        ImgSaverUI.partialSelections[0] = "Image";
        ImgSaverUI.partialSelections[1] = "Split View";
        ImgSaverUI.partialSelections[2] = "Projection View";
        ImgSaverUI.partialSelections[3] = "Image Channels Panorama";
        ImgSaverUI.partialSelections[4] = "Image Channels (grey scale)  Panorama";
        basicSelections = new String[1];
        ImgSaverUI.basicSelections[0] = "Image";
    }
}

