/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement;

import java.util.Collection;
import java.util.Map;
import omero.gateway.SecurityContext;
import omero.gateway.model.FolderData;
import omero.gateway.model.ROIData;
import omero.log.LogMessage;
import org.openmicroscopy.shoola.agents.measurement.MeasurementViewerLoader;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewer;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import org.openmicroscopy.shoola.env.data.views.calls.ROIFolderSaver;

public class ROIFolderSaver
extends MeasurementViewerLoader {
    private long imageID;
    private long userID;
    private Collection<ROIData> roiList;
    private Collection<ROIData> allROIs;
    private Collection<FolderData> folders;
    private ROIFolderSaver.ROIFolderAction action;
    private CallHandle handle;

    public ROIFolderSaver(MeasurementViewer viewer, SecurityContext ctx, long imageID, long userID, Collection<ROIData> roiList, Collection<FolderData> folders, ROIFolderSaver.ROIFolderAction action) {
        this(viewer, ctx, imageID, userID, null, roiList, folders, action);
    }

    public ROIFolderSaver(MeasurementViewer viewer, SecurityContext ctx, long imageID, long userID, Collection<ROIData> allROIs, Collection<ROIData> roiList, Collection<FolderData> folders, ROIFolderSaver.ROIFolderAction action) {
        super(viewer, ctx);
        if (imageID < 0L) {
            throw new IllegalArgumentException("No image specified.");
        }
        this.imageID = imageID;
        this.userID = userID;
        this.allROIs = allROIs;
        this.roiList = roiList;
        this.folders = folders;
        this.action = action;
    }

    @Override
    public void load() {
        this.handle = this.idView.saveROIFolders(this.ctx, this.imageID, this.userID, this.allROIs, this.roiList, this.folders, this.action, this);
    }

    @Override
    public void cancel() {
        this.handle.cancel();
    }

    @Override
    public void handleException(Throwable exc) {
        int state = this.viewer.getState();
        exc.printStackTrace();
        String s = "An error occurred while saving the ROI ";
        LogMessage msg = new LogMessage();
        msg.print("State: " + state);
        msg.print(s);
        msg.print(exc);
        this.registry.getLogger().error((Object)this, msg);
        this.registry.getUserNotifier().notifyInfo("Saving ROI", s);
        this.viewer.discard();
    }

    @Override
    public void handleResult(Object result) {
        if (this.viewer.getState() == 6) {
            return;
        }
        this.viewer.setUpdateROIComponent((Map)result, this.action);
    }
}

