/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.util.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import omero.gateway.model.FolderData;
import omero.gateway.model.TagAnnotationData;
import org.apache.commons.collections.CollectionUtils;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.LineDecoration;
import org.openmicroscopy.shoola.agents.measurement.MeasurementAgent;
import org.openmicroscopy.shoola.agents.measurement.util.model.AttributeField;
import org.openmicroscopy.shoola.env.data.util.StructuredDataResults;
import org.openmicroscopy.shoola.util.roi.figures.Cap;
import org.openmicroscopy.shoola.util.roi.figures.ROIFigure;
import org.openmicroscopy.shoola.util.roi.model.annotation.AnnotationKey;
import org.openmicroscopy.shoola.util.roi.model.annotation.AnnotationKeys;
import org.openmicroscopy.shoola.util.roi.model.annotation.MeasurementAttributes;

public class FigureTableModel
extends AbstractTableModel {
    private static final String NA = "N/A";
    private ROIFigure figure;
    private List<String> columnNames;
    private List<AttributeKey> keys;
    private List values;
    private List<AttributeField> fieldList;

    public FigureTableModel(List<AttributeField> fieldList, List<String> columnNames) {
        if (fieldList == null) {
            throw new IllegalArgumentException("No fields specified.");
        }
        if (columnNames == null) {
            throw new IllegalArgumentException("No column's names specified.");
        }
        this.fieldList = fieldList;
        this.columnNames = columnNames;
        this.keys = new ArrayList<AttributeKey>();
        this.values = new ArrayList();
    }

    public void clearData() {
        this.keys.clear();
        this.values.clear();
        this.fireTableDataChanged();
    }

    public void setData(ROIFigure figure) {
        if (figure == null) {
            throw new IllegalArgumentException("No figure.");
        }
        this.figure = figure;
        this.keys.clear();
        this.values.clear();
        for (AttributeField fieldName : this.fieldList) {
            AttributeKey key2;
            boolean found = false;
            for (AttributeKey key2 : figure.getAttributes().keySet()) {
                Cap c;
                if (!key2.equals(fieldName.getKey())) continue;
                Object value = figure.getAttribute(key2);
                if (MeasurementAttributes.TEXT.equals(key2) || MeasurementAttributes.WIDTH.equals(key2) || MeasurementAttributes.HEIGHT.equals(key2)) {
                    if (figure.isReadOnly()) {
                        fieldName.setEditable(false);
                    } else {
                        fieldName.setEditable(figure.canEdit());
                    }
                } else if (AnnotationKeys.TAG.equals(key2)) {
                    Collection<TagAnnotationData> tags;
                    StructuredDataResults sd = (StructuredDataResults)figure.getAttribute(key2);
                    if (sd != null && CollectionUtils.isNotEmpty(tags = sd.getTags())) {
                        StringBuffer buffer = new StringBuffer();
                        Iterator<TagAnnotationData> k = tags.iterator();
                        int index = 0;
                        int size = tags.size() - 1;
                        while (k.hasNext()) {
                            TagAnnotationData tag = k.next();
                            buffer.append(tag.getTagValue());
                            if (index < size) {
                                buffer.append(", ");
                            }
                            ++index;
                        }
                        value = buffer.toString();
                    }
                } else if (AnnotationKeys.FOLDERS.equals(key2)) {
                    List folders = (List)figure.getAttribute(key2);
                    value = "";
                    if (CollectionUtils.isNotEmpty((Collection)folders)) {
                        Iterator it = folders.iterator();
                        while (it.hasNext()) {
                            value = value + ((FolderData)it.next()).getFolderPathString();
                            if (!it.hasNext()) continue;
                            value = value + "; ";
                        }
                    }
                } else if (MeasurementAttributes.START_DECORATION.equals(key2)) {
                    if (value instanceof LineDecoration && (c = Cap.findByPrototype((LineDecoration)value)) != null) {
                        value = c.getValue();
                    }
                } else if (MeasurementAttributes.END_DECORATION.equals(key2) && value instanceof LineDecoration && (c = Cap.findByPrototype((LineDecoration)value)) != null) {
                    value = c.getValue();
                }
                this.keys.add(key2);
                this.values.add(value);
                found = true;
                break;
            }
            if (found) continue;
            key2 = fieldName.getKey();
            this.keys.add(key2);
            if (key2 instanceof AnnotationKey) {
                this.values.add(figure.getROI().getAnnotation((AnnotationKey)key2));
                continue;
            }
            this.values.add(NA);
        }
        this.fireTableDataChanged();
    }

    public ROIFigure getFigure() {
        return this.figure;
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames.get(col);
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.size();
    }

    @Override
    public int getRowCount() {
        return this.keys.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex < 0) {
            return null;
        }
        if (columnIndex == 0) {
            int n = this.fieldList.size();
            if (rowIndex < n) {
                return this.fieldList.get(rowIndex).getName();
            }
            return null;
        }
        int n = this.values.size();
        if (rowIndex < n) {
            return this.values.get(rowIndex);
        }
        return null;
    }

    public AttributeField getFieldAt(int rowIndex) {
        return this.fieldList.get(rowIndex);
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (col == 0 || this.keys.size() <= row) {
            return;
        }
        AttributeKey key = this.keys.get(row);
        if (this.figure.getAttribute(key) instanceof Double) {
            if (value instanceof Double) {
                this.figure.setAttribute(key, (Double)value);
            }
            if (value instanceof String) {
                try {
                    this.figure.setAttribute(this.keys.get(row), new Double((String)value));
                }
                catch (Exception e) {
                    MeasurementAgent.getRegistry().getUserNotifier().notifyInfo("Value for field invalid", "The value of " + value + " is invalid for " + key.toString());
                    return;
                }
            }
        } else if (MeasurementAttributes.START_DECORATION.equals(key)) {
            Object dec = null;
            if (value != null) {
                Cap c = Cap.findByValue(value.toString());
                if (c != null) {
                    dec = c.newLineDecorationInstance();
                }
                this.figure.setAttribute(key, dec);
            }
        } else if (MeasurementAttributes.END_DECORATION.equals(key)) {
            Object dec = null;
            if (value != null) {
                Cap c = Cap.findByValue(value.toString());
                if (c != null) {
                    dec = c.newLineDecorationInstance();
                }
                this.figure.setAttribute(key, dec);
            }
        } else {
            this.figure.setAttribute(key, value);
        }
        this.values.set(row, value);
        this.fireTableCellUpdated(row, col);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (col == 0) {
            return false;
        }
        if (this.values.get(row) instanceof String && NA.equals(this.values.get(row))) {
            return false;
        }
        return this.fieldList.get(row).isEditable();
    }
}

