/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.util.roimenu;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import omero.gateway.model.FolderData;
import org.openmicroscopy.shoola.agents.measurement.util.actions.ROIAction;
import org.openmicroscopy.shoola.agents.measurement.util.roitable.ROIActionController;
import org.openmicroscopy.shoola.agents.measurement.view.ROITable;
import org.openmicroscopy.shoola.util.roi.figures.ROIFigure;
import org.openmicroscopy.shoola.util.roi.model.ROI;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;

public class ROIPopupMenu {
    static final String POPUP_MENU_DESCRIPTION = "Manager Options";
    static final String ROI_CREATION_OPTIONS = "ROI Management Options";
    static final String ROI_STATS_OPTIONS = "ROI Stats Options";
    private JPopupMenu popupMenu;
    private List<ROIAction> actions;
    private ROITable table;

    public ROIPopupMenu(ROITable table) {
        this.table = table;
        this.actions = new ArrayList<ROIAction>();
        this.createPopupMenu();
    }

    private JMenu createROICreationOptions() {
        JMenu roiOptionsParent = new JMenu(ROI_CREATION_OPTIONS);
        ROIActionController.CreationActionType[] values = ROIActionController.CreationActionType.values();
        for (int indexCnt = 0; indexCnt < values.length; ++indexCnt) {
            ROIAction action = new ROIAction(this.table, values[indexCnt]);
            this.actions.add(action);
            this.popupMenu.add(new JMenuItem(action));
        }
        return roiOptionsParent;
    }

    private void createPopupMenu() {
        this.popupMenu = new JPopupMenu();
        this.createROICreationOptions();
    }

    public void setActionsEnabled(Collection<Object> selection) {
        for (ROIAction action : this.actions) {
            action.setEnabled(this.checkPermission(action.getCreationActionType(), selection));
        }
    }

    public boolean isActionEnabled(ROIActionController.CreationActionType action) {
        for (ROIAction a : this.actions) {
            if (a.getCreationActionType() != ROIActionController.CreationActionType.REMOVE_FROM_FOLDER) continue;
            return a.isEnabled();
        }
        return false;
    }

    public void enableAction(ROIActionController.CreationActionType action, boolean enabled) {
        for (ROIAction a : this.actions) {
            if (a.getCreationActionType() != ROIActionController.CreationActionType.REMOVE_FROM_FOLDER) continue;
            a.setEnabled(enabled);
        }
    }

    private boolean checkPermission(ROIActionController.CreationActionType action, Collection<Object> selection) {
        if (action == ROIActionController.CreationActionType.CREATE_FOLDER) {
            if (selection.size() == 0) {
                return this.table.canCreateFolder();
            }
            if (selection.size() == 1) {
                Object obj = selection.iterator().next();
                if (obj instanceof FolderData) {
                    FolderData f = (FolderData)obj;
                    return this.table.canCreateFolder() && f.canEdit();
                }
                if (obj instanceof ROI) {
                    return this.table.canCreateFolder() && ((ROI)obj).canEdit();
                }
                if (obj instanceof ROIShape) {
                    return this.table.canCreateFolder() && ((ROIShape)obj).getROI().canEdit();
                }
            } else {
                for (Object obj : selection) {
                    if (!(obj instanceof ROI) && !(obj instanceof ROIShape)) {
                        return false;
                    }
                    if (obj instanceof ROI && !((ROI)obj).canEdit()) {
                        return false;
                    }
                    if (!(obj instanceof ROIShape) || ((ROIShape)obj).getROI().canEdit()) continue;
                    return false;
                }
                return this.table.canCreateFolder();
            }
        }
        boolean isFolderSelection = true;
        boolean isROISelection = true;
        for (Object obj : selection) {
            if (isROISelection && !(obj instanceof ROI) && !(obj instanceof ROIShape) && !(obj instanceof ROIFigure)) {
                isROISelection = false;
            }
            if (!isFolderSelection || obj instanceof FolderData) continue;
            isFolderSelection = false;
        }
        if (!(isFolderSelection ^ isROISelection)) {
            return false;
        }
        boolean isInFolder = false;
        int delete = 0;
        int edit = 0;
        int link = 0;
        if (isFolderSelection) {
            for (FolderData folderData : selection) {
                if (folderData.canEdit()) {
                    ++edit;
                }
                if (folderData.canDelete()) {
                    ++delete;
                }
                if (!folderData.canLink()) continue;
                ++link;
            }
        } else {
            for (Object object : selection) {
                ROIFigure roi;
                if (object instanceof ROI) {
                    boolean shapeEdit = true;
                    boolean shapeDel = true;
                    if (!isInFolder) {
                        isInFolder = !this.table.findFolders((ROI)object).isEmpty();
                    }
                    for (ROIShape s : ((ROI)object).getShapes().values()) {
                        roi = s.getFigure();
                        if (shapeEdit && !roi.canEdit()) {
                            shapeEdit = false;
                        }
                        if (!shapeDel || roi.canDelete()) continue;
                        shapeDel = false;
                    }
                    if (shapeEdit) {
                        ++edit;
                        ++link;
                    }
                    if (shapeDel) {
                        ++delete;
                    }
                }
                if (object instanceof ROIShape) {
                    ROIShape shape;
                    if (!isInFolder) {
                        boolean bl = isInFolder = !this.table.findFolders(((ROIShape)object).getROI()).isEmpty();
                    }
                    if (!(roi = (shape = (ROIShape)object).getFigure()).isReadOnly()) {
                        if (roi.canEdit()) {
                            ++edit;
                            ++link;
                        }
                        if (roi.canDelete()) {
                            ++delete;
                        }
                    }
                }
                if (!(object instanceof ROIFigure)) continue;
                if (!isInFolder) {
                    boolean bl = isInFolder = !this.table.findFolders(((ROIFigure)object).getROI()).isEmpty();
                }
                if ((roi = (ROIFigure)object).isReadOnly()) continue;
                if (roi.canEdit()) {
                    ++edit;
                    ++link;
                }
                if (!roi.canDelete()) continue;
                ++delete;
            }
        }
        switch (action) {
            case ADD_TO_FOLDER: {
                return isROISelection && link == selection.size();
            }
            case DELETE: {
                return isROISelection && delete == selection.size();
            }
            case DUPLICATE: {
                return isROISelection && edit == selection.size();
            }
            case MERGE: {
                return isROISelection && edit == selection.size();
            }
            case PROPAGATE: {
                return isROISelection && edit == selection.size();
            }
            case REMOVE_FROM_FOLDER: {
                return isROISelection && link == selection.size() && isInFolder;
            }
            case SPLIT: {
                return isROISelection && edit == selection.size();
            }
            case TAG: {
                return isROISelection && edit == selection.size();
            }
            case CREATE_FOLDER: {
                return isFolderSelection && link == 1 && selection.size() == 1;
            }
            case DELETE_FOLDER: {
                return isFolderSelection && delete == selection.size();
            }
            case EDIT_FOLDER: {
                return isFolderSelection && edit == 1 && selection.size() == 1;
            }
            case MOVE_FOLDER: {
                return isFolderSelection && link == selection.size();
            }
        }
        return false;
    }

    public JPopupMenu getPopupMenu() {
        return this.popupMenu;
    }
}

