/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.view;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import ome.model.units.BigResult;
import omero.gateway.Gateway;
import omero.gateway.SecurityContext;
import omero.gateway.facility.DataManagerFacility;
import omero.gateway.model.AnnotationData;
import omero.gateway.model.ChannelData;
import omero.gateway.model.DataObject;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.FileAnnotationData;
import omero.gateway.model.FolderData;
import omero.gateway.model.GroupData;
import omero.gateway.model.ImageData;
import omero.gateway.model.PixelsData;
import omero.gateway.model.ROIData;
import omero.gateway.model.ROIResult;
import omero.gateway.util.PojoMapper;
import omero.gateway.util.Pojos;
import omero.log.Logger;
import omero.model.IObject;
import omero.model.Length;
import omero.model.LengthI;
import omero.model.enums.UnitsLength;
import org.apache.commons.collections.CollectionUtils;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.Figure;
import org.openmicroscopy.shoola.agents.events.SaveData;
import org.openmicroscopy.shoola.agents.events.iviewer.SaveRelatedData;
import org.openmicroscopy.shoola.agents.measurement.Analyser;
import org.openmicroscopy.shoola.agents.measurement.IconManager;
import org.openmicroscopy.shoola.agents.measurement.MeasurementAgent;
import org.openmicroscopy.shoola.agents.measurement.MeasurementViewerLoader;
import org.openmicroscopy.shoola.agents.measurement.ROIAnnotationLoader;
import org.openmicroscopy.shoola.agents.measurement.ROIAnnotationSaver;
import org.openmicroscopy.shoola.agents.measurement.ROIFolderSaver;
import org.openmicroscopy.shoola.agents.measurement.ROILoader;
import org.openmicroscopy.shoola.agents.measurement.ROISaver;
import org.openmicroscopy.shoola.agents.measurement.ServerSideROILoader;
import org.openmicroscopy.shoola.agents.measurement.TagsLoader;
import org.openmicroscopy.shoola.agents.measurement.util.FileMap;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewer;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerUI;
import org.openmicroscopy.shoola.agents.metadata.MetadataViewerAgent;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.agents.util.ViewerSorter;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.OmeroDataService;
import org.openmicroscopy.shoola.env.data.OmeroImageService;
import org.openmicroscopy.shoola.env.data.model.DeletableObject;
import org.openmicroscopy.shoola.env.data.model.DeleteActivityParam;
import org.openmicroscopy.shoola.env.data.views.calls.ROIFolderSaver;
import org.openmicroscopy.shoola.env.event.EventBus;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.file.IOUtil;
import org.openmicroscopy.shoola.util.roi.ROIComponent;
import org.openmicroscopy.shoola.util.roi.exception.NoSuchROIException;
import org.openmicroscopy.shoola.util.roi.exception.ParsingException;
import org.openmicroscopy.shoola.util.roi.exception.ROICreationException;
import org.openmicroscopy.shoola.util.roi.figures.ROIFigure;
import org.openmicroscopy.shoola.util.roi.model.ROI;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;
import org.openmicroscopy.shoola.util.roi.model.ShapeList;
import org.openmicroscopy.shoola.util.roi.model.annotation.AnnotationKeys;
import org.openmicroscopy.shoola.util.roi.model.annotation.MeasurementAttributes;
import org.openmicroscopy.shoola.util.roi.model.util.Coord3D;
import org.openmicroscopy.shoola.util.roi.model.util.MeasurementUnits;
import org.openmicroscopy.shoola.util.ui.drawingtools.DrawingComponent;
import org.openmicroscopy.shoola.util.ui.drawingtools.canvas.DrawingCanvasView;

class MeasurementViewerModel {
    private long imageID;
    private String name;
    private Rectangle requesterBounds;
    private int state;
    private DrawingComponent drawingComponent;
    private ROIComponent roiComponent;
    private Coord3D currentPlane;
    private PixelsData pixels;
    private double magnification;
    private Map activeChannels;
    private Map analysisResults;
    private List<ChannelData> metadata;
    private MeasurementViewerLoader currentLoader;
    private MeasurementViewerLoader currentSaver;
    private MeasurementViewer component;
    private SaveRelatedData event;
    private Object rndImage;
    private String fileSaved;
    private List<FileAnnotationData> measurements;
    private Collection measurementResults;
    private boolean HCSData;
    private List<ROI> roiToDelete;
    private boolean dataToDelete;
    private boolean bigImage;
    private SecurityContext ctx;
    private ViewerSorter sorter;
    private Collection existingTags;
    private Collection<FolderData> folders;
    private Collection<ROIData> rois;

    private void mapFigureAttributeToROIAnnotation(AttributeKey attribute, ROIFigure figure) {
        if (MeasurementAttributes.TEXT.getKey().equals(attribute.getKey())) {
            ROIShape shape = figure.getROIShape();
            AnnotationKeys.TEXT.set(shape, (String)MeasurementAttributes.TEXT.get(figure));
        }
    }

    private void checkIfHasROIToDelete() {
        if (this.dataToDelete) {
            return;
        }
        Collection<ROI> rois = this.roiComponent.getROIMap().values();
        Iterator<ROI> i = rois.iterator();
        ArrayList<ROI> ownedRois = new ArrayList<ROI>();
        ArrayList<ROIFigure> figures = new ArrayList<ROIFigure>();
        while (i.hasNext()) {
            ROI roi = i.next();
            if (!roi.canDelete()) continue;
            figures.addAll(roi.getAllFigures());
            ownedRois.add(roi);
        }
        this.dataToDelete = ownedRois.size() > 0;
    }

    MeasurementViewerModel(SecurityContext ctx, long imageID, PixelsData pixels, String name, Rectangle bounds, List<ChannelData> channelsData) {
        this.metadata = channelsData;
        this.ctx = ctx;
        this.imageID = imageID;
        this.pixels = pixels;
        this.name = name;
        this.requesterBounds = bounds;
        this.state = 1;
        this.sorter = new ViewerSorter();
        this.drawingComponent = new DrawingComponent();
        this.roiComponent = new ROIComponent();
        this.fileSaved = null;
        this.roiComponent.setPixelSizes(this.getPixelSizeX(), this.getPixelSizeY(), this.getPixelSizeZ());
        this.setPlane(0, 0);
    }

    void initialize(MeasurementViewer component) {
        this.component = component;
    }

    ROIComponent getROIComponent() {
        return this.roiComponent;
    }

    Collection<ROIFigure> getAllFigures() {
        TreeMap<Long, ROI> rois = this.roiComponent.getROIMap();
        ArrayList<ROIFigure> all = new ArrayList<ROIFigure>();
        if (rois == null) {
            return all;
        }
        for (Map.Entry<Long, ROI> entry : rois.entrySet()) {
            ROI roi = entry.getValue();
            List<ROIFigure> l = roi.getAllFigures();
            if (l == null || l.size() <= 0) continue;
            all.addAll(l);
        }
        return all;
    }

    String getUserName() {
        return MeasurementAgent.getRegistry().getAdminService().getLoggingName();
    }

    ExperimenterData getCurrentUser() {
        return MeasurementAgent.getUserDetails();
    }

    String getServerName() {
        return MeasurementAgent.getRegistry().getAdminService().getServerName();
    }

    void setPlane(int z, int t) {
        if (z != -1 && t != -1) {
            this.currentPlane = new Coord3D(z, t);
        } else if (z == -1 && t != -1) {
            this.currentPlane = new Coord3D(this.currentPlane.getZSection(), t);
        } else if (z != -1 && t == -1) {
            this.currentPlane = new Coord3D(z, this.currentPlane.getTimePoint());
        }
    }

    boolean isSameDisplay(MeasurementViewerModel other) {
        if (other == null) {
            return false;
        }
        return other.pixels.getId() == this.getPixelsID() && other.imageID == this.imageID;
    }

    long getImageID() {
        return this.imageID;
    }

    long getPixelsID() {
        return this.pixels.getId();
    }

    String getImageName() {
        return this.name;
    }

    String getImageTitle() {
        return "[ID: " + this.getImageID() + "] " + EditorUtil.getPartialName(this.getImageName());
    }

    Rectangle getRequesterBounds() {
        return this.requesterBounds;
    }

    int getState() {
        return this.state;
    }

    DrawingEditor getDrawingEditor() {
        return this.drawingComponent.getEditor();
    }

    Drawing getDrawing() {
        return this.drawingComponent.getDrawing();
    }

    void discard() {
        this.cancel();
        this.state = 6;
    }

    void cancel() {
        if (this.currentLoader != null) {
            this.currentLoader.cancel();
        }
        this.state = 5;
    }

    int getDefaultZ() {
        return this.currentPlane.getZSection();
    }

    int getDefaultT() {
        return this.currentPlane.getTimePoint();
    }

    double getMagnification() {
        return this.magnification;
    }

    void setMagnification(double magnification) {
        int sizeX = this.getSizeX();
        int sizeY = this.getSizeY();
        this.magnification = magnification;
        this.getDrawingView().setScaleFactor(magnification, new Dimension(sizeX, sizeY));
    }

    void setAttributes(AttributeKey key, Object value) {
        List<Figure> figures = this.getDrawing().getFigures();
        for (Figure f : figures) {
            f.setAttribute(key, value);
        }
        this.getDrawingView().repaint();
    }

    void setState(int state) {
        this.state = state;
    }

    boolean setROI(InputStream input) throws ROICreationException, NoSuchROIException, ParsingException {
        this.state = 5;
        if (input == null) {
            return false;
        }
        List<ROI> roiList = this.roiComponent.loadROI(input);
        if (roiList == null) {
            return false;
        }
        Iterator<ROI> i = roiList.iterator();
        int sizeZ = this.pixels.getSizeZ();
        int sizeT = this.pixels.getSizeT();
        boolean b = true;
        block0: while (i.hasNext()) {
            ROI roi = i.next();
            TreeMap<Coord3D, ROIShape> shapeList = roi.getShapes();
            for (ROIShape shape : shapeList.values()) {
                Coord3D c = shape.getCoord3D();
                if (c.getTimePoint() > sizeT) {
                    b = false;
                    continue block0;
                }
                if (c.getZSection() <= sizeZ) continue;
                b = false;
                continue block0;
            }
        }
        if (!b) {
            for (ROI roi : roiList) {
                this.roiComponent.deleteROI(roi.getID());
            }
            return false;
        }
        this.notifyDataChanged(true);
        return true;
    }

    FileAnnotationData getMeasurement(long fileID) {
        if (this.measurements == null) {
            return null;
        }
        for (FileAnnotationData fa : this.measurements) {
            if (fa.getId() != fileID) continue;
            return fa;
        }
        return null;
    }

    List<FileAnnotationData> getMeasurements() {
        return this.measurements;
    }

    Collection getMeasurementResults() {
        return this.measurementResults;
    }

    void setFolders(Collection<FolderData> folders) {
        this.folders = folders;
    }

    Collection<FolderData> getFolders() {
        return this.folders == null ? Collections.EMPTY_LIST : this.folders;
    }

    Collection<FolderData> getUsedFolders() {
        if (this.folders == null) {
            return Collections.EMPTY_LIST;
        }
        HashMap<Long, FolderData> result = new HashMap<Long, FolderData>();
        for (ROIData roi : this.rois) {
            for (FolderData f : roi.getFolders()) {
                this.addFolderAndParentFolders(f, result);
            }
        }
        return result.values();
    }

    private void addFolderAndParentFolders(FolderData f, Map<Long, FolderData> coll) {
        coll.put(f.getId(), f);
        if (f.getParentFolder() != null) {
            this.addFolderAndParentFolders(f.getParentFolder(), coll);
        }
    }

    List<DataObject> setServerROI(Collection rois) throws ROICreationException, NoSuchROIException {
        ArrayList<DataObject> nodes = new ArrayList<DataObject>();
        this.measurementResults = rois;
        this.rois = new ArrayList<ROIData>();
        this.state = 5;
        ArrayList<ROI> roiList = new ArrayList<ROI>();
        Iterator r = rois.iterator();
        long userID = MeasurementAgent.getUserDetails().getId();
        while (r.hasNext()) {
            ROIResult result = (ROIResult)r.next();
            roiList.addAll(this.roiComponent.loadROI(result.getFileID(), result.getROIs(), userID));
            this.rois.addAll(result.getROIs());
        }
        if (roiList.isEmpty()) {
            return nodes;
        }
        Iterator i = roiList.iterator();
        int sizeZ = this.pixels.getSizeZ();
        int sizeT = this.pixels.getSizeT();
        while (i.hasNext()) {
            ROI roi = (ROI)i.next();
            TreeMap<Coord3D, ROIShape> shapeList = roi.getShapes();
            for (Map.Entry<Coord3D, ROIShape> entry : shapeList.entrySet()) {
                ROIShape shape = entry.getValue();
                Coord3D coord = shape.getCoord3D();
                if (coord.getTimePoint() >= sizeT || coord.getZSection() >= sizeZ) continue;
                int c = coord.getChannel();
                ROIFigure f = shape.getFigure();
                if (shape.getData() != null) {
                    nodes.add((DataObject)shape.getData());
                }
                if (c < 0 || !f.isVisible()) continue;
                f.setVisible(this.isChannelActive(c));
            }
        }
        this.checkIfHasROIToDelete();
        return nodes;
    }

    TreeMap getROI() {
        return this.roiComponent.getROIMap();
    }

    Coord3D getCurrentView() {
        return this.currentPlane;
    }

    boolean sizeInMicrons() {
        return !this.getPixelSizeX().getUnit().equals((Object)UnitsLength.PIXEL);
    }

    Length getPixelSizeX() {
        Length l = null;
        try {
            l = this.pixels.getPixelSizeX(UnitsLength.MICROMETER);
        }
        catch (BigResult e) {
            MeasurementAgent.getRegistry().getLogger().warn((Object)this, "Could not get pixel size X in micrometer");
        }
        return l != null ? l : new LengthI(1.0, UnitsLength.PIXEL);
    }

    Length getPixelSizeY() {
        Length l = null;
        try {
            l = this.pixels.getPixelSizeY(UnitsLength.MICROMETER);
        }
        catch (BigResult e) {
            MeasurementAgent.getRegistry().getLogger().warn((Object)this, "Could not get pixel size Y in micrometer");
        }
        return l != null ? l : new LengthI(1.0, UnitsLength.PIXEL);
    }

    Length getPixelSizeZ() {
        try {
            return this.pixels.getPixelSizeZ(UnitsLength.MICROMETER);
        }
        catch (BigResult e) {
            MeasurementAgent.getRegistry().getLogger().warn((Object)this, "Could not get pixel size Z in micrometer");
            return null;
        }
    }

    int getNumZSections() {
        return this.pixels.getSizeZ();
    }

    int getNumTimePoints() {
        return this.pixels.getSizeT();
    }

    int getSizeX() {
        return this.pixels.getSizeX();
    }

    int getSizeY() {
        return this.pixels.getSizeY();
    }

    DrawingCanvasView getDrawingView() {
        return this.drawingComponent.getDrawingView();
    }

    Collection<ROI> getSelectedROI() {
        Set<Figure> selectedFigs = this.getDrawingView().getSelectedFigures();
        ArrayList<ROI> roiList = new ArrayList<ROI>();
        for (ROIFigure rOIFigure : selectedFigs) {
            roiList.add(rOIFigure.getROI());
        }
        return roiList;
    }

    Collection<ROIShape> getSelectedShapes() {
        Set<Figure> selectedFigs = this.getDrawingView().getSelectedFigures();
        ArrayList<ROIShape> l = new ArrayList<ROIShape>();
        for (ROIFigure rOIFigure : selectedFigs) {
            l.add(rOIFigure.getROIShape());
        }
        return l;
    }

    void removeROIShape(long id) throws NoSuchROIException {
        ROIShape shape = this.roiComponent.getShape(id, this.getCurrentView());
        if (shape != null) {
            if (this.drawingComponent.contains(shape.getFigure())) {
                this.drawingComponent.removeFigure(shape.getFigure());
            } else {
                this.roiComponent.deleteShape(id, this.getCurrentView());
            }
        }
    }

    void removeROIShape(long id, Coord3D coord) throws NoSuchROIException {
        ROIShape shape = this.roiComponent.getShape(id, coord);
        if (shape != null) {
            if (this.drawingComponent.contains(shape.getFigure())) {
                this.drawingComponent.removeFigure(shape.getFigure());
            } else {
                this.roiComponent.deleteShape(id, coord);
            }
        }
    }

    void removeROI(long id) throws NoSuchROIException {
        ROIShape shape = this.roiComponent.getShape(id, this.getCurrentView());
        if (shape != null && this.drawingComponent.contains(shape.getFigure())) {
            this.drawingComponent.removeFigure(shape.getFigure());
        }
        if (this.roiComponent.containsROI(id)) {
            this.roiComponent.deleteROI(id);
        }
    }

    void removeAllROI() throws NoSuchROIException {
        this.state = 5;
        this.drawingComponent.removeAllFigures();
        int size = this.roiComponent.getROIMap().values().size();
        ROI[] valueList = new ROI[size];
        this.roiComponent.getROIMap().values().toArray(valueList);
        if (valueList != null) {
            for (ROI roi : valueList) {
                this.roiComponent.deleteROI(roi.getID());
            }
        }
    }

    List<ROIFigure> removeAllROI(long ownerID, int level) throws NoSuchROIException {
        ROI roi2;
        Collection<ROI> rois = this.roiComponent.getROIMap().values();
        Iterator<ROI> i = rois.iterator();
        ArrayList<ROI> ownedRois = new ArrayList<ROI>();
        ArrayList<ROIFigure> figures = new ArrayList<ROIFigure>();
        switch (level) {
            case 0: {
                while (i.hasNext()) {
                    roi2 = i.next();
                    figures.addAll(roi2.getAllFigures());
                    ownedRois.add(roi2);
                }
                break;
            }
            case 1: {
                while (i.hasNext()) {
                    roi2 = i.next();
                    if (roi2.getOwnerID() != ownerID && roi2.getOwnerID() != -1L) continue;
                    figures.addAll(roi2.getAllFigures());
                    ownedRois.add(roi2);
                }
                break;
            }
            case 2: {
                while (i.hasNext()) {
                    roi2 = i.next();
                    if (roi2.getOwnerID() == ownerID) continue;
                    figures.addAll(roi2.getAllFigures());
                    ownedRois.add(roi2);
                }
                break;
            }
        }
        for (ROI roi2 : ownedRois) {
            this.roiComponent.deleteROI(roi2.getID());
        }
        Iterator j = figures.iterator();
        while (j.hasNext()) {
            this.drawingComponent.removeFigure((Figure)j.next());
        }
        this.event = null;
        this.notifyDataChanged(false);
        this.dataToDelete = false;
        return figures;
    }

    ROI getROI(long id) throws NoSuchROIException {
        return this.roiComponent.getROI(id);
    }

    ROI createROI(ROIFigure figure, boolean addAttribs) throws ROICreationException, NoSuchROIException {
        return this.roiComponent.addROI(figure, this.getCurrentView(), addAttribs);
    }

    ShapeList getShapeList() throws NoSuchROIException {
        return this.roiComponent.getShapeList(this.currentPlane);
    }

    void figureAttributeChanged(AttributeKey attribute, ROIFigure figure) {
        this.mapFigureAttributeToROIAnnotation(attribute, figure);
    }

    void fireLoadROIFromServer(List<FileAnnotationData> measurements) {
        this.measurements = measurements;
        ArrayList<Long> files = null;
        if (measurements != null) {
            files = new ArrayList<Long>();
            Iterator<FileAnnotationData> i = measurements.iterator();
            while (i.hasNext()) {
                files.add(i.next().getId());
            }
        }
        this.state = 3;
        ExperimenterData exp = MeasurementAgent.getUserDetails();
        this.currentLoader = new ROILoader(this.component, this.getSecurityContext(), this.getImageID(), files, exp.getId());
        this.currentLoader.load();
    }

    void fireLoadROIServerOrClient(boolean dataChanged) {
        this.state = 3;
        ExperimenterData exp = MeasurementAgent.getUserDetails();
        this.currentLoader = new ServerSideROILoader(this.component, this.getSecurityContext(), this.getImageID(), exp.getId());
        this.currentLoader.load();
        this.notifyDataChanged(dataChanged);
    }

    void fireROILoading(String fileName) {
        Logger log;
        InputStream stream = null;
        this.state = 3;
        try {
            if (fileName == null) {
                fileName = FileMap.getSavedFile(this.getServerName(), this.getUserName(), this.getPixelsID());
            }
            this.fileSaved = fileName;
            if (this.fileSaved != null) {
                stream = IOUtil.readFileAsInputStream(fileName);
            }
        }
        catch (Exception e) {
            log = MeasurementAgent.getRegistry().getLogger();
            log.warn((Object)this, "Cannot load the ROI " + e.getMessage());
        }
        this.component.setROI(stream);
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (Exception e) {
            log = MeasurementAgent.getRegistry().getLogger();
            log.warn((Object)this, "Cannot close the stream " + e.getMessage());
        }
    }

    String getFileSaved() {
        return this.fileSaved;
    }

    void saveROI(String fileName, boolean post) throws ParsingException {
        Logger log;
        OutputStream stream = null;
        try {
            stream = IOUtil.writeFile(fileName);
        }
        catch (Exception e) {
            log = MeasurementAgent.getRegistry().getLogger();
            log.warn((Object)this, "Cannot save the ROI " + e.getMessage());
        }
        this.roiComponent.saveROI(stream);
        try {
            if (stream != null) {
                stream.close();
            }
            FileMap.setSavedFile(this.getServerName(), this.getUserName(), this.getPixelsID(), fileName);
            if (!post) {
                this.event = null;
            }
            this.notifyDataChanged(false);
        }
        catch (Exception e) {
            log = MeasurementAgent.getRegistry().getLogger();
            log.warn((Object)this, "Cannot close the stream " + e.getMessage());
        }
    }

    void saveROIToServer(boolean async, boolean close) {
        try {
            List<ROIData> roiList = this.getROIData();
            ExperimenterData exp = MeasurementAgent.getUserDetails();
            if (roiList.size() == 0) {
                return;
            }
            this.roiComponent.reset();
            if (async) {
                this.currentSaver = new ROISaver(this.component, this.getSecurityContext(), this.getImageID(), exp.getId(), roiList, close);
                this.state = 8;
                this.currentSaver.load();
                this.notifyDataChanged(false);
            } else {
                OmeroImageService svc = MeasurementAgent.getRegistry().getImageService();
                svc.saveROI(this.getSecurityContext(), this.getImageID(), exp.getId(), roiList);
                this.state = 5;
                this.event = null;
            }
            this.checkIfHasROIToDelete();
        }
        catch (Exception e) {
            Logger log = MeasurementAgent.getRegistry().getLogger();
            log.warn((Object)this, "Cannot save to server " + e.getMessage());
            UserNotifier un = MeasurementAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Save ROI", "Unable to save the ROIs");
        }
    }

    void addROIsToFolder(Collection<ROIData> allROIs, Collection<ROIData> selectedObjects, Collection<FolderData> folders) {
        if (this.getState() != 5) {
            return;
        }
        ExperimenterData exp = MeasurementAgent.getUserDetails();
        this.currentSaver = new ROIFolderSaver(this.component, this.getSecurityContext(), this.getImageID(), exp.getId(), allROIs, selectedObjects, folders, ROIFolderSaver.ROIFolderAction.ADD_TO_FOLDER);
        this.setSaveState();
        this.currentSaver.load();
    }

    void moveROIsToFolder(Collection<ROIData> allROIs, Collection<ROIData> selectedObjects, Collection<FolderData> folders) {
        if (this.getState() != 5) {
            return;
        }
        ExperimenterData exp = MeasurementAgent.getUserDetails();
        this.currentSaver = new ROIFolderSaver(this.component, this.getSecurityContext(), this.getImageID(), exp.getId(), allROIs, selectedObjects, folders, ROIFolderSaver.ROIFolderAction.MOVE_TO_FOLDER);
        this.setSaveState();
        this.currentSaver.load();
    }

    void deleteFolders(Collection<FolderData> folders) {
        if (this.getState() != 5) {
            return;
        }
        ExperimenterData exp = MeasurementAgent.getUserDetails();
        this.currentSaver = new ROIFolderSaver(this.component, this.getSecurityContext(), this.getImageID(), exp.getId(), null, folders, ROIFolderSaver.ROIFolderAction.DELETE_FOLDER);
        this.setSaveState();
        this.currentSaver.load();
    }

    Collection<FolderData> saveROIFolders(Collection<FolderData> folders, boolean async) {
        if (this.getState() != 5) {
            return null;
        }
        if (async) {
            ExperimenterData exp = MeasurementAgent.getUserDetails();
            this.currentSaver = new ROIFolderSaver(this.component, this.getSecurityContext(), this.getImageID(), exp.getId(), null, folders, ROIFolderSaver.ROIFolderAction.CREATE_FOLDER);
            this.setSaveState();
            this.currentSaver.load();
        } else {
            try {
                Registry reg = MetadataViewerAgent.getRegistry();
                OmeroDataService ods = reg.getDataService();
                Gateway gw = ods.getGateway();
                DataManagerFacility dm = (DataManagerFacility)gw.getFacility(DataManagerFacility.class);
                List<Object> objs = new ArrayList<IObject>(folders.size());
                for (FolderData f : folders) {
                    objs.add(f.asIObject());
                }
                objs = dm.saveAndReturnObject(this.getSecurityContext(), objs, null, null);
                Collection result = PojoMapper.asCastedDataObjects(objs);
                Collection ids = Pojos.extractIds(this.folders);
                for (FolderData f : result) {
                    if (ids.contains(f.getId())) continue;
                    this.folders.add(f);
                }
                return result;
            }
            catch (Exception e) {
                MeasurementAgent.getRegistry().getLogger().error((Object)this, "Could not create folders");
            }
        }
        return null;
    }

    void removeROIsFromFolder(Collection<ROIData> selectedObjects, Collection<FolderData> folders) {
        if (this.getState() != 5) {
            return;
        }
        ExperimenterData exp = MeasurementAgent.getUserDetails();
        this.currentSaver = new ROIFolderSaver(this.component, this.getSecurityContext(), this.getImageID(), exp.getId(), selectedObjects, folders, ROIFolderSaver.ROIFolderAction.REMOVE_FROM_FOLDER);
        this.setSaveState();
        this.currentSaver.load();
    }

    private void setSaveState() {
        this.state = 8;
        ((MeasurementViewerUI)this.component.getUI()).setStatus("Saving...");
    }

    List<ROIData> getROIData() {
        try {
            long userID = this.getCurrentUser().getId();
            return this.roiComponent.saveROI(this.getImage(), 5, userID);
        }
        catch (Exception e) {
            Logger log = MeasurementAgent.getRegistry().getLogger();
            log.warn((Object)this, "Cannot transform the ROI: " + e.getMessage());
            return new ArrayList<ROIData>();
        }
    }

    List<ROIData> getROIData(int level) {
        try {
            long userID = this.getCurrentUser().getId();
            switch (level) {
                case 0: {
                    return this.roiComponent.saveROI(this.getImage(), 1, userID);
                }
                case 1: {
                    return this.roiComponent.saveROI(this.getImage(), 2, userID);
                }
                case 2: {
                    return this.roiComponent.saveROI(this.getImage(), 3, userID);
                }
            }
        }
        catch (Exception e) {
            Logger log = MeasurementAgent.getRegistry().getLogger();
            log.warn((Object)this, "Cannot transform the ROI: " + e.getMessage());
        }
        return new ArrayList<ROIData>();
    }

    ImageData getImage() {
        return this.pixels.getImage();
    }

    List<ROIShape> propagateShape(ROIShape shape, int timePoint, int zSection) throws ROICreationException, NoSuchROIException {
        this.notifyDataChanged(true);
        Coord3D coord = new Coord3D(zSection, timePoint);
        return this.roiComponent.propagateShape(shape.getID(), shape.getCoord3D(), shape.getCoord3D(), coord);
    }

    void deleteShape(ROIShape shape, int timePoint, int zSection) throws NoSuchROIException {
        if (this.drawingComponent.contains(shape.getFigure())) {
            this.drawingComponent.getDrawing().remove(shape.getFigure());
        } else {
            this.notifyDataChanged(true);
            this.roiComponent.deleteShape(shape.getID(), shape.getCoord3D(), new Coord3D(zSection, timePoint));
        }
    }

    void showMeasurementsInMicrons(boolean inMicrons) {
        if (inMicrons) {
            this.roiComponent.setPixelSizes(this.getPixelSizeX(), this.getPixelSizeY(), this.getPixelSizeZ());
        } else {
            this.roiComponent.setPixelSizes((Length)new LengthI(1.0, UnitsLength.PIXEL), (Length)new LengthI(1.0, UnitsLength.PIXEL), (Length)new LengthI(1.0, UnitsLength.PIXEL));
        }
    }

    MeasurementUnits getMeasurementUnits() {
        return this.roiComponent.getMeasurementUnits();
    }

    void setActiveChannels(Map activeChannels) {
        this.activeChannels = activeChannels;
    }

    void fireAnalyzeShape(List<ROIShape> shapeList) {
        if (CollectionUtils.isEmpty(shapeList)) {
            return;
        }
        this.state = 4;
        if (this.currentLoader != null) {
            this.currentLoader.cancel();
        }
        ArrayList<ROIShape> l = new ArrayList<ROIShape>(shapeList.size());
        for (ROIShape shape : shapeList) {
            int z = shape.getZ();
            int t = shape.getT();
            if (z >= 0 && t >= 0) {
                l.add(shape);
                continue;
            }
            if (z == -1 && t >= 0) {
                l.add(shape.copy(new Coord3D(this.currentPlane.getZSection(), t)));
                continue;
            }
            if (z >= 0 && t == -1) {
                l.add(shape.copy(new Coord3D(z, this.currentPlane.getTimePoint())));
                continue;
            }
            if (z != -1 || t != -1) continue;
            l.add(shape.copy(new Coord3D(this.currentPlane.getZSection(), this.currentPlane.getTimePoint())));
        }
        this.currentLoader = new Analyser(this.component, this.getSecurityContext(), this.pixels, this.activeChannels.keySet(), l, this.currentPlane);
        this.currentLoader.load();
    }

    List<ChannelData> getMetadata() {
        return this.metadata;
    }

    ChannelData getMetadata(int index) {
        if (index < 0 || index >= this.metadata.size()) {
            return null;
        }
        for (ChannelData d : this.metadata) {
            if (d.getIndex() != index) continue;
            return d;
        }
        return null;
    }

    void setAnalysisResults(Map analysisResults) {
        if (this.analysisResults != null) {
            this.analysisResults.clear();
        } else {
            this.analysisResults = new LinkedHashMap();
        }
        if (analysisResults != null) {
            List newList = this.sorter.sort(analysisResults.keySet());
            for (ROIShape shape : newList) {
                this.analysisResults.put(shape, analysisResults.get(shape));
            }
            analysisResults.clear();
        }
        this.state = 5;
    }

    Map getAnalysisResults() {
        return this.analysisResults;
    }

    Map getActiveChannels() {
        return this.activeChannels;
    }

    Color getActiveChannelColor(int index) {
        return (Color)this.activeChannels.get(index);
    }

    Collection<Figure> getSelectedFigures() {
        return this.getDrawingView().getSelectedFigures();
    }

    boolean isChannelActive(int index) {
        return this.activeChannels.get(index) != null;
    }

    void notifyDataChanged(boolean toSave) {
        if (this.isHCSData()) {
            return;
        }
        if (this.event != null && toSave) {
            return;
        }
        EventBus bus = MeasurementAgent.getRegistry().getEventBus();
        this.event = new SaveRelatedData(this.getPixelsID(), new SaveData(this.getPixelsID(), 0), "The ROI", toSave);
        this.checkIfHasROIToDelete();
        bus.post(this.event);
        if (!toSave) {
            this.event = null;
        }
    }

    void calculateStats(List<ROIShape> shapeList) {
        this.component.analyseShapeList(shapeList);
    }

    List<ROI> getROIList(long fileID) {
        return this.roiComponent.getROIList(fileID);
    }

    ROI cloneROI(long id) throws ROICreationException, NoSuchROIException {
        return this.roiComponent.cloneROI(id);
    }

    void deleteShape(long id, Coord3D coord) throws NoSuchROIException {
        this.roiComponent.deleteShape(id, coord);
    }

    void addShape(long id, Coord3D coord, ROIShape shape) throws ROICreationException, NoSuchROIException {
        this.roiComponent.addShape(id, coord, shape);
    }

    void setRenderedImage(Object rndImage) {
        this.rndImage = rndImage;
    }

    BufferedImage getRenderedImage() {
        if (this.rndImage instanceof BufferedImage) {
            return (BufferedImage)this.rndImage;
        }
        return null;
    }

    Object getRefObject() {
        return this.pixels;
    }

    boolean hasROIToSave() {
        if (this.isHCSData()) {
            return false;
        }
        return this.event != null;
    }

    boolean hasROIToDelete() {
        if (this.hasROIToSave()) {
            return true;
        }
        return this.dataToDelete;
    }

    boolean isHCSData() {
        return this.HCSData;
    }

    void setHCSData(boolean value) {
        this.HCSData = value;
    }

    void markROIForDelete(long id, ROI roi, boolean force) {
        if (roi == null) {
            return;
        }
        if (this.roiToDelete == null) {
            this.roiToDelete = new ArrayList<ROI>();
        }
        if (id < 0L) {
            return;
        }
        if (force) {
            if (!roi.isClientSide()) {
                this.roiToDelete.add(roi);
            }
        } else if (!this.roiComponent.containsROI(id) && !roi.isClientSide()) {
            this.roiToDelete.add(roi);
        }
    }

    List<ROI> getROIToDelete() {
        return this.roiToDelete;
    }

    void onROIDeleted(long imageID) {
        if (this.imageID != imageID) {
            return;
        }
        this.state = 5;
        if (this.roiToDelete != null) {
            this.roiToDelete.clear();
        }
        if (this.getROIData().size() == 0) {
            this.notifyDataChanged(false);
        }
    }

    void deleteAllROIs(List<DeletableObject> list) {
        if (list.size() == 0) {
            return;
        }
        IconManager icons = IconManager.getInstance();
        DeleteActivityParam p = new DeleteActivityParam(icons.getIcon(45), list);
        p.setImageID(this.imageID);
        p.setFailureIcon(icons.getIcon(44));
        UserNotifier un = MeasurementAgent.getRegistry().getUserNotifier();
        un.notifyActivity(this.getSecurityContext(), p);
    }

    void setBigImage(boolean value) {
        this.bigImage = value;
    }

    boolean isBigImage() {
        return this.bigImage;
    }

    SecurityContext getSecurityContext() {
        return this.ctx;
    }

    boolean isMember() {
        if (MeasurementAgent.isAdministrator()) {
            return false;
        }
        Collection groups = MeasurementAgent.getAvailableUserGroups();
        Iterator i = groups.iterator();
        GroupData gRef = null;
        long gId = this.getImage().getGroupId();
        while (i.hasNext()) {
            GroupData g = (GroupData)i.next();
            if (g.getId() != gId) continue;
            gRef = g;
            break;
        }
        if (gRef != null) {
            return EditorUtil.isUserGroupOwner(gRef, MeasurementAgent.getUserDetails().getId());
        }
        return false;
    }

    void setChannelData(List<ChannelData> channels) {
        this.metadata = channels;
    }

    void fireLoadROIAnnotations(List<DataObject> shapes) {
        ROIAnnotationLoader loader = new ROIAnnotationLoader(this.component, this.getSecurityContext(), shapes);
        loader.load();
    }

    void fireAnnotationSaving(Collection<DataObject> toAnnotate, List<AnnotationData> toAdd, List<Object> toRemove) {
        ROIAnnotationSaver saver = new ROIAnnotationSaver(this.component, this.getSecurityContext(), toAnnotate, toAdd, toRemove);
        saver.load();
    }

    void setExistingTags(Collection tags) {
        if (tags != null) {
            this.existingTags = this.sorter.sort(tags);
        }
    }

    Collection getExistingTags() {
        return this.existingTags;
    }

    void fireExistingTagsLoading() {
        TagsLoader loader = new TagsLoader(this.component, this.getSecurityContext(), this.canRetrieveAll());
        loader.load();
    }

    private boolean canRetrieveAll() {
        if (!this.pixels.canAnnotate()) {
            return false;
        }
        GroupData group = this.getGroup(this.pixels.getGroupId());
        if (group == null) {
            return false;
        }
        switch (group.getPermissions().getPermissionsLevel()) {
            case 1: {
                if (MeasurementAgent.isAdministrator()) {
                    return true;
                }
                Set leaders = group.getLeaders();
                Iterator i = leaders.iterator();
                long userID = this.getCurrentUser().getId();
                while (i.hasNext()) {
                    ExperimenterData exp = (ExperimenterData)i.next();
                    if (exp.getId() != userID) continue;
                    return true;
                }
                return false;
            }
            case 0: {
                return false;
            }
        }
        return true;
    }

    private GroupData getGroup(long groupId) {
        Collection groups = MeasurementAgent.getAvailableUserGroups();
        if (groups == null) {
            return null;
        }
        for (GroupData group : groups) {
            if (group.getId() != groupId) continue;
            return group;
        }
        return null;
    }
}

