/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableCellEditor;
import org.apache.commons.lang.StringUtils;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.TextHolderFigure;
import org.openmicroscopy.shoola.agents.measurement.IconManager;
import org.openmicroscopy.shoola.agents.measurement.MeasurementAgent;
import org.openmicroscopy.shoola.agents.measurement.util.model.AnnotationDescription;
import org.openmicroscopy.shoola.agents.measurement.util.model.AttributeField;
import org.openmicroscopy.shoola.agents.measurement.util.model.FigureTableModel;
import org.openmicroscopy.shoola.agents.measurement.util.model.ValueType;
import org.openmicroscopy.shoola.agents.measurement.util.ui.FigureTable;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerControl;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerModel;
import org.openmicroscopy.shoola.util.roi.figures.Cap;
import org.openmicroscopy.shoola.util.roi.figures.MeasureBezierFigure;
import org.openmicroscopy.shoola.util.roi.figures.MeasureEllipseFigure;
import org.openmicroscopy.shoola.util.roi.figures.MeasureLineConnectionFigure;
import org.openmicroscopy.shoola.util.roi.figures.MeasureLineFigure;
import org.openmicroscopy.shoola.util.roi.figures.MeasureRectangleFigure;
import org.openmicroscopy.shoola.util.roi.figures.MeasureTextFigure;
import org.openmicroscopy.shoola.util.roi.figures.ROIFigure;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;
import org.openmicroscopy.shoola.util.roi.model.annotation.AnnotationKeys;
import org.openmicroscopy.shoola.util.roi.model.annotation.MeasurementAttributes;

class ObjectInspector
extends JPanel {
    public static final int INDEX = 0;
    private static final List<String> COLUMN_NAMES = new ArrayList<String>(2);
    private static final String NAME = "Inspector";
    private static final String MAGNIFICATION = "The scaling Factor";
    private FigureTable fieldTable;
    private MeasurementViewerControl controller;
    private MeasurementViewerModel model;
    private JLabel infoLabel;
    private static final List<String> LINE_DECORATION_VALUES;
    private static final List<AttributeField> attributeFields;

    private void initComponents() {
        this.infoLabel = new JLabel("The scaling Factor is " + this.model.getDrawingView().getScaleFactor());
        this.fieldTable = new FigureTable(new FigureTableModel(attributeFields, COLUMN_NAMES));
        this.fieldTable.getTableHeader().setReorderingAllowed(false);
        this.fieldTable.setRowHeight(26);
        this.fieldTable.setSelectionMode(0);
        this.fieldTable.setCellSelectionEnabled(true);
        this.fieldTable.setColumnSelectionAllowed(true);
        this.fieldTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int col = ObjectInspector.this.fieldTable.getSelectedColumn();
                int row = ObjectInspector.this.fieldTable.getSelectedRow();
                Object value = ObjectInspector.this.fieldTable.getValueAt(row, col);
                if (e.getClickCount() == 1) {
                    if (value instanceof Boolean) {
                        ObjectInspector.this.toggleValue();
                    }
                } else if (e.getClickCount() > 1) {
                    e.consume();
                    if (value instanceof Color) {
                        FigureTableModel ftm = (FigureTableModel)ObjectInspector.this.fieldTable.getModel();
                        ROIFigure figure = ftm.getFigure();
                        if (figure != null && !figure.isReadOnly() && figure.canEdit()) {
                            ObjectInspector.this.controller.showColorPicker((Color)value);
                        }
                    } else if (value instanceof Boolean) {
                        ObjectInspector.this.toggleValue();
                    }
                }
            }
        });
        this.fieldTable.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String name = evt.getPropertyName();
                if ("valueChanged".equals(name)) {
                    ObjectInspector.this.handleValueChanged((String)evt.getNewValue());
                }
            }
        });
    }

    private void handleValueChanged(String text) {
        int row = this.fieldTable.getEditingRow();
        if (row < 0 || row >= attributeFields.size()) {
            return;
        }
        AttributeKey attr = this.getAttributeKey(row);
        FigureTableModel ftm = (FigureTableModel)this.fieldTable.getModel();
        ROIFigure figure = ftm.getFigure();
        if (attr.equals(MeasurementAttributes.TEXT)) {
            if (TextHolderFigure.class.isAssignableFrom(figure.getClass())) {
                ((TextHolderFigure)((Object)figure)).setText(text);
            }
        } else if (attr.equals(MeasurementAttributes.FONT_SIZE)) {
            double d = this.parseDouble(text);
            figure.setAttribute(MeasurementAttributes.FONT_SIZE, d);
            figure.changed();
        } else if (attr.equals(MeasurementAttributes.STROKE_WIDTH)) {
            double d = this.parseDouble(text);
            figure.setAttribute(MeasurementAttributes.STROKE_WIDTH, d);
        } else if (attr.equals(MeasurementAttributes.WIDTH)) {
            try {
                double d = this.parseDouble(text);
                this.setFigureDimension(figure, MeasurementAttributes.WIDTH, d);
                if (this.isScaleProportionally()) {
                    this.setFigureDimension(figure, MeasurementAttributes.HEIGHT, d);
                }
            }
            catch (Exception d) {}
        } else if (attr.equals(MeasurementAttributes.HEIGHT)) {
            try {
                double d = this.parseDouble(text);
                this.setFigureDimension(figure, MeasurementAttributes.HEIGHT, d);
                if (this.isScaleProportionally()) {
                    this.setFigureDimension(figure, MeasurementAttributes.WIDTH, d);
                }
            }
            catch (Exception exception) {}
        } else if (attr.equals(MeasurementAttributes.START_DECORATION)) {
            figure.setAttribute(MeasurementAttributes.START_DECORATION, text);
        } else if (attr.equals(MeasurementAttributes.END_DECORATION)) {
            figure.setAttribute(MeasurementAttributes.END_DECORATION, text);
        }
        this.model.getDrawingView().repaint();
    }

    private double parseDouble(String text) {
        double result = 1.0;
        NumberFormat nf = NumberFormat.getInstance();
        if (StringUtils.isNotBlank((String)text)) {
            try {
                result = nf.parse(text).doubleValue();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            if (result < 1.0) {
                result = 1.0;
            }
        }
        return result;
    }

    private void setFigureDimension(ROIFigure figure, AttributeKey key, double dimension) {
        if (figure instanceof MeasureEllipseFigure || figure instanceof MeasureRectangleFigure || figure instanceof MeasureBezierFigure || figure instanceof MeasureTextFigure || figure instanceof MeasureLineConnectionFigure || figure instanceof MeasureLineFigure) {
            figure.setAttribute(key, dimension);
        }
    }

    private void toggleValue() {
        int col = this.fieldTable.getSelectedColumn();
        int row = this.fieldTable.getSelectedRow();
        Boolean v = (Boolean)this.fieldTable.getModel().getValueAt(row, col);
        Boolean value = false;
        if (v != null) {
            value = v;
        }
        boolean newValue = value == false;
        this.fieldTable.getModel().setValueAt(newValue, row, col);
        this.model.getDrawingView().repaint();
    }

    private void buildGUI() {
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(this.fieldTable), "Center");
    }

    ObjectInspector(MeasurementViewerControl controller, MeasurementViewerModel model) {
        if (controller == null) {
            throw new IllegalArgumentException("No control.");
        }
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        this.controller = controller;
        this.model = model;
        this.initComponents();
        this.buildGUI();
    }

    String getComponentName() {
        return NAME;
    }

    Icon getComponentIcon() {
        IconManager icons = IconManager.getInstance();
        return icons.getIcon(1);
    }

    int setCellColor(Color c) {
        int col = this.fieldTable.getSelectedColumn();
        int row = this.fieldTable.getSelectedRow();
        this.fieldTable.getModel().setValueAt(c, row, col);
        return row;
    }

    boolean isShowText() {
        if (this.fieldTable == null) {
            return false;
        }
        int n = this.fieldTable.getRowCount();
        if (n > 4) {
            Object v = this.fieldTable.getModel().getValueAt(this.getRowIndex(MeasurementAttributes.SHOWTEXT), 1);
            if (v == null) {
                return false;
            }
            return (Boolean)v;
        }
        return false;
    }

    void showText(boolean show, ROIFigure figure) {
        FigureTableModel ftm;
        ROIFigure f;
        if (this.fieldTable == null) {
            return;
        }
        int n = this.fieldTable.getRowCount();
        if (n > 4 && (f = (ftm = (FigureTableModel)this.fieldTable.getModel()).getFigure()) != null && f == figure) {
            this.fieldTable.getModel().setValueAt(show, this.getRowIndex(MeasurementAttributes.SHOWTEXT), 1);
        }
    }

    boolean isShowMeasurement() {
        if (this.fieldTable == null) {
            return false;
        }
        int n = this.fieldTable.getRowCount();
        if (n > 5) {
            Object v = this.fieldTable.getModel().getValueAt(this.getRowIndex(MeasurementAttributes.SHOWMEASUREMENT), 1);
            if (v == null) {
                return false;
            }
            return (Boolean)v;
        }
        return false;
    }

    boolean isScaleProportionally() {
        if (this.fieldTable == null) {
            return false;
        }
        int n = this.fieldTable.getRowCount();
        if (n > 1) {
            Object v = this.fieldTable.getModel().getValueAt(this.getRowIndex(MeasurementAttributes.SCALE_PROPORTIONALLY), 1);
            if (v == null) {
                return false;
            }
            return (Boolean)v;
        }
        return false;
    }

    void setModelData(ROIFigure figure) {
        FigureTableModel tableModel = (FigureTableModel)this.fieldTable.getModel();
        tableModel.setData(figure);
        this.fieldTable.repaint();
    }

    void onMagnificationChanged() {
        this.infoLabel.setText("The scaling Factor is " + this.model.getDrawingView().getScaleFactor());
    }

    void removeROIFigure(ROIFigure figure) {
        if (figure == null) {
            return;
        }
        FigureTableModel tm = (FigureTableModel)this.fieldTable.getModel();
        ROIFigure value = tm.getFigure();
        if (value == null) {
            return;
        }
        if (value.getROI().getID() == figure.getROI().getID()) {
            tm.clearData();
        }
    }

    void removeROIFigures(List<ROIFigure> figures) {
        if (figures == null || figures.size() == 0) {
            return;
        }
        FigureTableModel tm = (FigureTableModel)this.fieldTable.getModel();
        ROIFigure value = tm.getFigure();
        if (value == null) {
            return;
        }
        for (ROIFigure figure : figures) {
            if (value.getROI().getID() != figure.getROI().getID()) continue;
            tm.clearData();
        }
        this.fieldTable.repaint();
    }

    void setSelectedFigures(List<ROIShape> l) {
        FigureTableModel tableModel = (FigureTableModel)this.fieldTable.getModel();
        Iterator<ROIShape> i = l.iterator();
        try {
            TableCellEditor editor = this.fieldTable.getCellEditor();
            if (editor != null) {
                editor.stopCellEditing();
            }
            while (i.hasNext()) {
                ROIShape shape = i.next();
                tableModel.setData(shape.getFigure());
                this.fieldTable.repaint();
            }
        }
        catch (Exception e) {
            MeasurementAgent.getRegistry().getLogger().info((Object)this, "Figures selection" + e);
        }
    }

    void clearData() {
        FigureTableModel tm = (FigureTableModel)this.fieldTable.getModel();
        tm.clearData();
    }

    AttributeKey getAttributeKey(int row) {
        return attributeFields.get(row).getKey();
    }

    int getRowIndex(AttributeKey attKey) {
        for (int i = 0; i < attributeFields.size(); ++i) {
            if (!attributeFields.get(i).getKey().equals(attKey)) continue;
            return i;
        }
        return -1;
    }

    static {
        COLUMN_NAMES.add("Field");
        COLUMN_NAMES.add("Value");
        LINE_DECORATION_VALUES = new ArrayList<String>();
        for (Cap c : Cap.values()) {
            LINE_DECORATION_VALUES.add(c.getValue());
        }
        attributeFields = new ArrayList<AttributeField>();
        attributeFields.add(new AttributeField(AnnotationKeys.FOLDERS, AnnotationDescription.annotationDescription.get(AnnotationKeys.FOLDERS), false));
        attributeFields.add(new AttributeField(AnnotationKeys.TAG, AnnotationDescription.annotationDescription.get(AnnotationKeys.TAG), false));
        attributeFields.add(new AttributeField(MeasurementAttributes.TEXT, AnnotationDescription.annotationDescription.get(AnnotationKeys.TEXT), true));
        attributeFields.add(new AttributeField(MeasurementAttributes.FONT_SIZE, AnnotationDescription.annotationDescription.get(MeasurementAttributes.FONT_SIZE), true));
        attributeFields.add(new AttributeField(MeasurementAttributes.SCALE_PROPORTIONALLY, AnnotationDescription.annotationDescription.get(MeasurementAttributes.SCALE_PROPORTIONALLY), false));
        attributeFields.add(new AttributeField(MeasurementAttributes.WIDTH, AnnotationDescription.annotationDescription.get(AnnotationKeys.WIDTH), true));
        attributeFields.add(new AttributeField(MeasurementAttributes.HEIGHT, AnnotationDescription.annotationDescription.get(AnnotationKeys.HEIGHT), true));
        attributeFields.add(new AttributeField(MeasurementAttributes.START_DECORATION, AnnotationDescription.annotationDescription.get(MeasurementAttributes.START_DECORATION), true, LINE_DECORATION_VALUES, ValueType.ENUM));
        attributeFields.add(new AttributeField(MeasurementAttributes.END_DECORATION, AnnotationDescription.annotationDescription.get(MeasurementAttributes.END_DECORATION), true, LINE_DECORATION_VALUES, ValueType.ENUM));
        attributeFields.add(new AttributeField(MeasurementAttributes.SHOWTEXT, "Show Comment", false));
        attributeFields.add(new AttributeField(MeasurementAttributes.SHOWMEASUREMENT, AnnotationDescription.annotationDescription.get(MeasurementAttributes.SHOWMEASUREMENT), false));
        attributeFields.add(new AttributeField(MeasurementAttributes.FILL_COLOR, AnnotationDescription.annotationDescription.get(MeasurementAttributes.FILL_COLOR), false));
        attributeFields.add(new AttributeField(MeasurementAttributes.STROKE_COLOR, AnnotationDescription.annotationDescription.get(MeasurementAttributes.STROKE_COLOR), false));
        attributeFields.add(new AttributeField(MeasurementAttributes.STROKE_WIDTH, AnnotationDescription.annotationDescription.get(MeasurementAttributes.STROKE_WIDTH), true));
    }
}

