/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.view;

import java.awt.Component;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DragSourceMotionListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.DropMode;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import omero.gateway.model.DataObject;
import omero.gateway.model.FolderData;
import omero.gateway.util.Pojos;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;
import org.jdesktop.swingx.treetable.TreeTableModel;
import org.jhotdraw.draw.Figure;
import org.openmicroscopy.shoola.agents.measurement.IconManager;
import org.openmicroscopy.shoola.agents.measurement.MeasurementAgent;
import org.openmicroscopy.shoola.agents.measurement.util.roimenu.ROIPopupMenu;
import org.openmicroscopy.shoola.agents.measurement.util.roitable.ROIActionController;
import org.openmicroscopy.shoola.agents.measurement.util.roitable.ROINode;
import org.openmicroscopy.shoola.agents.measurement.util.roitable.ROINodeMap;
import org.openmicroscopy.shoola.agents.measurement.util.roitable.ROITableCellRenderer;
import org.openmicroscopy.shoola.agents.measurement.util.roitable.ROITableModel;
import org.openmicroscopy.shoola.agents.measurement.util.roitable.ROIUtil;
import org.openmicroscopy.shoola.agents.measurement.util.roitable.TableRowTransferHandler;
import org.openmicroscopy.shoola.agents.measurement.util.ui.ShapeRenderer;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerControl;
import org.openmicroscopy.shoola.agents.measurement.view.ObjectManager;
import org.openmicroscopy.shoola.agents.util.SelectionWizard;
import org.openmicroscopy.shoola.agents.util.SelectionWizardDataSource;
import org.openmicroscopy.shoola.agents.util.ui.EditorDialog;
import org.openmicroscopy.shoola.agents.util.ui.SelectionDialog;
import org.openmicroscopy.shoola.util.roi.figures.ROIFigure;
import org.openmicroscopy.shoola.util.roi.model.ROI;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;
import org.openmicroscopy.shoola.util.roi.model.annotation.AnnotationKeys;
import org.openmicroscopy.shoola.util.roi.model.annotation.MeasurementAttributes;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.graphutils.ShapeType;
import org.openmicroscopy.shoola.util.ui.treetable.OMETreeTable;
import org.openmicroscopy.shoola.util.ui.treetable.model.OMETreeNode;
import org.openmicroscopy.shoola.util.ui.treetable.renderers.BooleanCellRenderer;

public class ROITable
extends OMETreeTable
implements ROIActionController,
PropertyChangeListener {
    private ROINode root;
    private Vector<String> columnNames;
    private ROINodeMap nodesMap;
    private ROITableModel model;
    private ROIPopupMenu popupMenu;
    private ObjectManager manager;
    private boolean reset;
    private ROIActionController.CreationActionType action;
    private int[] previousSelectionIndices;
    private String folderNameFilter = "";
    private Collection<Long> onlyShowFolderIds = new HashSet<Long>();
    private Collection<FolderData> recentlyModifiedFolders = new ArrayList<FolderData>();
    private final String DS_ALL_NAME = "All Folders";
    private final String DS_DISPLAYED_NAMED = "Displayed Folders";
    private String defaultDS = "Displayed Folders";
    private CheckboxRenderer checkboxRenderer = new CheckboxRenderer();
    private static final int AUTOSCROLL_INSET = 10;
    private Timer timer;
    private Point lastPosition;
    private Rectangle outer;
    private Rectangle inner;

    private void autoscroll(Point position) {
        int dx;
        Rectangle r;
        int dy;
        ROITable s = this;
        if (position.y < this.inner.y) {
            dy = s.getScrollableUnitIncrement(this.outer, 1, -1);
            r = new Rectangle(this.inner.x, this.outer.y - dy, this.inner.width, dy);
            this.scrollRectToVisible(r);
        } else if (position.y > this.inner.y + this.inner.height) {
            dy = s.getScrollableUnitIncrement(this.outer, 1, 1);
            r = new Rectangle(this.inner.x, this.outer.y + this.outer.height, this.inner.width, dy);
            this.scrollRectToVisible(r);
        }
        if (position.x < this.inner.x) {
            dx = s.getScrollableUnitIncrement(this.outer, 0, -1);
            r = new Rectangle(this.outer.x - dx, this.inner.y, dx, this.inner.height);
            this.scrollRectToVisible(r);
        } else if (position.x > this.inner.x + this.inner.width) {
            dx = s.getScrollableUnitIncrement(this.outer, 0, 1);
            r = new Rectangle(this.outer.x + this.outer.width, this.inner.y, dx, this.inner.height);
            this.scrollRectToVisible(r);
        }
    }

    private void updateRegion() {
        Rectangle visible = this.getVisibleRect();
        this.outer.setBounds(visible.x, visible.y, visible.width, visible.height);
        Insets i = new Insets(0, 0, 0, 0);
        if (this instanceof Scrollable) {
            int minSize = 20;
            if (visible.width >= minSize) {
                i.right = 10;
                i.left = 10;
            }
            if (visible.height >= minSize) {
                i.bottom = 10;
                i.top = 10;
            }
        }
        this.inner.setBounds(visible.x + i.left, visible.y + i.top, visible.width - (i.left + i.right), visible.height - (i.top + i.bottom));
    }

    ROITable(ROITableModel model, Vector columnNames, ObjectManager manager) {
        super((TreeTableModel)model);
        this.model = model;
        this.manager = manager;
        this.root = (ROINode)model.getRoot();
        this.columnNames = columnNames;
        ToolTipManager.sharedInstance().registerComponent((JComponent)((Object)this));
        this.setAutoResizeMode(4);
        this.setRowHeight(25);
        this.nodesMap = new ROINodeMap();
        for (int i = 0; i < model.getColumnCount(); ++i) {
            this.getColumn(i).setResizable(true);
        }
        this.setDefaultRenderer(ShapeType.class, new ShapeRenderer());
        this.setTreeCellRenderer(new ROITableCellRenderer());
        this.popupMenu = new ROIPopupMenu(this);
        this.reset = false;
        this.setColumnSelectionAllowed(false);
        this.setRowSelectionAllowed(true);
        this.setUI(new CustomTableUI());
        this.setDragEnabled(true);
        this.setDropMode(DropMode.ON);
        this.setTransferHandler(new TableRowTransferHandler((JTable)((Object)this)));
        this.selectionModel.addListSelectionListener(new ListSelectionListener(){
            boolean active = true;

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!this.active) {
                    return;
                }
                if (ROIUtil.getSelectionType(ROITable.this.getSelectedObjects()) == ROIUtil.SelectionType.MIXED && ROITable.this.previousSelectionIndices != null) {
                    this.active = false;
                    ROITable.this.selectionModel.clearSelection();
                    for (int i : ROITable.this.previousSelectionIndices) {
                        ROITable.this.selectionModel.addSelectionInterval(i, i);
                    }
                    this.active = true;
                } else {
                    ROITable.access$002(ROITable.this, ROITable.this.getSelectedRows());
                }
            }
        });
        DragSource.getDefaultDragSource().addDragSourceMotionListener(new DragSourceMotionListener(){

            @Override
            public void dragMouseMoved(DragSourceDragEvent e) {
                ROITable.this.lastPosition = MouseInfo.getPointerInfo().getLocation();
                if (!ROITable.this.timer.isRunning()) {
                    ROITable.this.timer.start();
                }
            }
        });
        DragSource.getDefaultDragSource().addDragSourceListener(new DragSourceListener(){

            @Override
            public void dropActionChanged(DragSourceDragEvent dsde) {
            }

            @Override
            public void dragOver(DragSourceDragEvent dsde) {
            }

            @Override
            public void dragExit(DragSourceEvent dse) {
            }

            @Override
            public void dragEnter(DragSourceDragEvent dsde) {
            }

            @Override
            public void dragDropEnd(DragSourceDropEvent dsde) {
                if (ROITable.this.timer.isRunning()) {
                    ROITable.this.timer.stop();
                }
            }
        });
        this.outer = new Rectangle();
        this.inner = new Rectangle();
        Toolkit t = Toolkit.getDefaultToolkit();
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ROITable.this.updateRegion();
                Point componentPosition = new Point(ROITable.this.lastPosition);
                SwingUtilities.convertPointFromScreen(componentPosition, (Component)((Object)ROITable.this));
                if (ROITable.this.outer.contains(componentPosition) && !ROITable.this.inner.contains(componentPosition)) {
                    ROITable.this.autoscroll(componentPosition);
                }
            }
        };
        Integer prop = (Integer)t.getDesktopProperty("DnD.Autoscroll.interval");
        this.timer = new Timer(prop == null ? 100 : prop, al);
        prop = (Integer)t.getDesktopProperty("DnD.Autoscroll.initialDelay");
        this.timer.setInitialDelay(prop == null ? 100 : prop);
    }

    void onSelection(Collection<Object> selection) {
        this.popupMenu.setActionsEnabled(selection);
        if (this.popupMenu.isActionEnabled(ROIActionController.CreationActionType.REMOVE_FROM_FOLDER)) {
            List<ROIShape> selectedObjects = this.getSelectedROIShapes();
            HashMap<Long, FolderData> inFolders = new HashMap<Long, FolderData>();
            for (ROIShape shape : selectedObjects) {
                for (FolderData f : shape.getROI().getFolders()) {
                    if (inFolders.containsKey(f.getId())) continue;
                    inFolders.put(f.getId(), f);
                }
            }
            this.popupMenu.enableAction(ROIActionController.CreationActionType.REMOVE_FROM_FOLDER, !inFolders.isEmpty());
        }
    }

    void selectROIShape(ROIShape shape) {
        Collection<ROINode> nodes = this.nodesMap.get(shape.getROI());
        for (ROINode node : nodes) {
            this.expandROIRow(node);
            ROINode child = node.findChild(shape);
            int row = this.getRowForPath(child.getPath());
            this.selectionModel.addSelectionInterval(row, row);
        }
    }

    void scrollToROIShape(ROIShape shape) {
        Collection<ROINode> nodes = this.nodesMap.get(shape.getROI());
        OMETreeNode child = null;
        for (ROINode node : nodes) {
            this.expandROIRow(node);
            child = node.findChild(shape);
        }
        if (child != null) {
            this.scrollPathToVisible(child.getPath());
        }
    }

    void showROIManagementMenu(Component c, int x, int y) {
        this.popupMenu.setActionsEnabled(this.getSelectedObjects());
        JPopupMenu menu = this.popupMenu.getPopupMenu();
        if (menu.isVisible()) {
            return;
        }
        menu.show(c, x, y);
    }

    void refresh() {
        this.setTreeTableModel((TreeTableModel)new ROITableModel(this.root, this.columnNames));
    }

    Set<Long> getExpandedFolders() {
        HashSet<Long> result = new HashSet<Long>();
        for (ROINode node : this.nodesMap.values()) {
            if (!node.isExpanded() || !node.isFolderNode()) continue;
            result.add(((FolderData)node.getUserObject()).getId());
        }
        return result;
    }

    void expandFolders(Collection<Long> ids) {
        for (ROINode node : this.nodesMap.values()) {
            if (!node.isFolderNode() || !ids.contains(((FolderData)node.getUserObject()).getId())) continue;
            this.expandPath(node.getPath());
        }
    }

    void clear() {
        int childCount = this.root.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            this.root.remove(0);
        }
        this.setTreeTableModel((TreeTableModel)new ROITableModel(this.root, this.columnNames));
        this.nodesMap.clear();
        this.recentlyModifiedFolders.clear();
        this.invalidate();
        this.repaint();
    }

    public void setNameFilter(String filter) {
        this.folderNameFilter = filter.toLowerCase();
    }

    public Collection<Long> getIDFilter() {
        return this.onlyShowFolderIds;
    }

    public void setValueAt(Object obj, int row, int column) {
        ROINode node = (ROINode)this.getNodeAtRow(row);
        if (node == null) {
            return;
        }
        super.setValueAt(obj, row, column);
        if (node.isROINode()) {
            ROI roi = (ROI)node.getUserObject();
            ROINode expandNode = node;
            if (roi.isVisible() && !expandNode.isExpanded()) {
                this.expandROIRow(expandNode);
            }
        } else if (node.isShapeNode()) {
            ROINode expandNode = (ROINode)node.getParent();
            ROIShape roiShape = (ROIShape)node.getUserObject();
            if (roiShape.getROI().isVisible() && !expandNode.isExpanded()) {
                this.expandROIRow(expandNode);
            }
        }
        this.repaint();
    }

    void addROIShape(ROIShape shape) {
        ArrayList<ROIShape> shapeList = new ArrayList<ROIShape>();
        shapeList.add(shape);
        this.addROIShapeList(shapeList);
    }

    void addROIShapeList(List<ROIShape> shapeList) {
        HashSet<String> expandedNodeIds = new HashSet<String>();
        ArrayList<ROINode> tmp = new ArrayList<ROINode>();
        ROIUtil.getAllDecendants(this.root, tmp);
        for (ROINode n : tmp) {
            if (!n.isExpanded()) continue;
            expandedNodeIds.add(ROIUtil.getUUID(n.getUserObject()));
        }
        ROINode parent2 = null;
        for (ROIShape shape : shapeList) {
            int index;
            ROINode newNode;
            ROINode roiShapeNode;
            Collection<ROINode> nodes;
            if (shape.getROI().getFolders().isEmpty()) {
                nodes = this.nodesMap.get(shape.getROI());
                if (nodes.isEmpty()) {
                    parent2 = new ROINode(shape.getROI());
                    parent2.setExpanded(true);
                    this.nodesMap.add(parent2);
                    int childCount = this.root.getChildCount();
                    this.root.insert(parent2, childCount);
                } else {
                    parent2 = nodes.iterator().next();
                }
                roiShapeNode = parent2.findChild(shape.getCoord3D());
                newNode = new ROINode(shape);
                newNode.setExpanded(true);
                this.nodesMap.add(newNode);
                if (roiShapeNode != null) {
                    index = parent2.getIndex((TreeNode)((Object)roiShapeNode));
                    parent2.remove(shape.getCoord3D());
                    parent2.insert(newNode, index);
                    continue;
                }
                parent2.insert(newNode, parent2.getInsertionPoint(shape.getCoord3D()));
                continue;
            }
            nodes = this.nodesMap.get(shape.getROI());
            if (nodes.isEmpty()) {
                Collection<ROINode> folders = this.findFolders(shape.getROI());
                for (ROINode folder : folders) {
                    parent2 = new ROINode(shape.getROI());
                    parent2.setExpanded(true);
                    nodes.add(parent2);
                    this.nodesMap.add(parent2);
                    int childCount = folder.getChildCount();
                    folder.insert(parent2, childCount);
                }
            }
            for (ROINode parent2 : nodes) {
                roiShapeNode = parent2.findChild(shape.getCoord3D());
                newNode = new ROINode(shape);
                newNode.setExpanded(true);
                this.nodesMap.add(newNode);
                if (roiShapeNode != null) {
                    index = parent2.getIndex((TreeNode)((Object)roiShapeNode));
                    parent2.remove(shape.getCoord3D());
                    parent2.insert(newNode, index);
                    continue;
                }
                parent2.insert(newNode, parent2.getInsertionPoint(shape.getCoord3D()));
            }
        }
        this.model = new ROITableModel(this.root, this.columnNames);
        this.setTreeTableModel((TreeTableModel)this.model);
        tmp.clear();
        ROIUtil.getAllDecendants(this.root, tmp);
        for (ROINode n : tmp) {
            if (!expandedNodeIds.contains(ROIUtil.getUUID((Object)n))) continue;
            this.expandNode(n);
        }
    }

    private void expandNode(ROINode node) {
        if (node.getUserObject() instanceof ROI) {
            this.expandROIRow((ROI)node.getUserObject());
        }
    }

    ROIShape getROIShapeAtRow(int index) {
        TreePath path = this.getPathForRow(index);
        if (path == null) {
            return null;
        }
        ROINode node = (ROINode)((Object)path.getLastPathComponent());
        if (node.getUserObject() instanceof ROIShape) {
            return (ROIShape)node.getUserObject();
        }
        return null;
    }

    private void expandROIRow(ROINode parent) {
        this.expandPath(parent.getPath());
    }

    private void expandROIRow(ROI roi) {
        Collection<ROINode> nodes = this.nodesMap.get(roi);
        for (ROINode node : nodes) {
            this.expandROIRow(node);
        }
    }

    void removeROIShape(ROIShape shape) {
        Collection<ROINode> nodes = this.nodesMap.get(shape.getROI());
        for (ROINode node : nodes) {
            ROINode child = node.findChild(shape);
            if (child == null) continue;
            node.remove(child);
            if (node.getChildCount() != 0) continue;
            node.getParent().remove((MutableTreeTableNode)node);
        }
        this.setTreeTableModel((TreeTableModel)new ROITableModel(this.root, this.columnNames));
    }

    @Override
    public void setTreeTableModel(TreeTableModel model) {
        super.setTreeTableModel(model);
        this.setDefaultRenderer(Boolean.class, this.checkboxRenderer);
    }

    private boolean displayFolder(FolderData folder) {
        return this.checkIDFilter(folder) && this.checkNameFilter(folder);
    }

    private boolean checkIDFilter(FolderData folder) {
        return this.onlyShowFolderIds == null || this.onlyShowFolderIds.contains(folder.getId());
    }

    private boolean checkNameFilter(FolderData folder) {
        boolean match = folder.getName().toLowerCase().contains(this.folderNameFilter);
        if (match || folder.getParentFolder() == null) {
            return match;
        }
        return this.checkNameFilter(folder.getParentFolder());
    }

    public Collection<ROINode> findFolders(ROI roi) {
        if (roi.getFolders().isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<ROINode> insertInto = new ArrayList<ROINode>();
        for (FolderData f : roi.getFolders()) {
            if (!this.displayFolder(f)) continue;
            ROINode node = this.nodesMap.findFolderNode(f);
            if (node == null) {
                node = new ROINode(f);
                this.nodesMap.add(node);
                this.handleParentFolderNodes(node);
            }
            insertInto.add(node);
        }
        return insertInto;
    }

    private void handleParentFolderNodes(ROINode node) {
        FolderData parentFolder = ((FolderData)node.getUserObject()).getParentFolder();
        if (parentFolder == null) {
            this.root.insert(node, this.root.getInsertionPoint((FolderData)node.getUserObject()));
            return;
        }
        ROINode parent = this.nodesMap.findFolderNode(parentFolder);
        if (parent == null) {
            parent = new ROINode(parentFolder);
            this.nodesMap.add(parent);
            parent.insert(node, 0);
            this.handleParentFolderNodes(parent);
        } else if (parent.findChild((FolderData)node.getUserObject()) == null) {
            parent.insert(node, parent.getInsertionPoint((FolderData)node.getUserObject()));
        }
    }

    void initFolders(Collection<FolderData> folders) {
        for (FolderData f : folders) {
            ROINode node;
            if (!this.displayFolder(f) || (node = this.nodesMap.findFolderNode(f)) != null) continue;
            node = new ROINode(f);
            this.nodesMap.add(node);
            this.handleParentFolderNodes(node);
        }
        this.model = new ROITableModel(this.root, this.columnNames);
        this.setTreeTableModel((TreeTableModel)this.model);
    }

    Collection<Object> getSelectedObjects() {
        Object nodeObject;
        int[] selectedRows = this.getSelectedRows();
        TreeMap<Long, ROI> roiMap = new TreeMap<Long, ROI>();
        ArrayList<Object> selectedList = new ArrayList<Object>();
        for (int i = 0; i < selectedRows.length; ++i) {
            ROINode node = (ROINode)this.getNodeAtRow(selectedRows[i]);
            if (node == null || !((nodeObject = node.getUserObject()) instanceof ROI)) continue;
            ROI roi = (ROI)nodeObject;
            roiMap.put(roi.getID(), roi);
            selectedList.add(roi);
        }
        for (int i = 0; i < selectedRows.length; ++i) {
            ROINode node = (ROINode)this.getNodeAtRow(selectedRows[i]);
            if (node == null) continue;
            nodeObject = node.getUserObject();
            if (nodeObject instanceof ROIShape) {
                ROIShape roiShape = (ROIShape)nodeObject;
                if (roiMap.containsKey(roiShape.getID())) continue;
                selectedList.add(roiShape);
                continue;
            }
            if (!(nodeObject instanceof FolderData)) continue;
            FolderData folder = (FolderData)nodeObject;
            selectedList.add(folder);
        }
        return selectedList;
    }

    private List<ROIShape> getSelectedROIShapes() {
        Collection<Figure> figures;
        ROI roi;
        Object nodeObject;
        int[] selectedRows = this.getSelectedRows();
        TreeMap<Long, ROI> roiMap = new TreeMap<Long, ROI>();
        ArrayList<ROIShape> selectedList = new ArrayList<ROIShape>();
        for (int i = 0; i < selectedRows.length; ++i) {
            ROINode node = (ROINode)this.getNodeAtRow(selectedRows[i]);
            if (node == null || !((nodeObject = node.getUserObject()) instanceof ROI)) continue;
            roi = (ROI)nodeObject;
            if (roi.isClientSide()) {
                this.reset = true;
            }
            roiMap.put(roi.getID(), roi);
            Iterator<ROIShape> shapeIterator = roi.getShapes().values().iterator();
            while (shapeIterator.hasNext()) {
                selectedList.add(shapeIterator.next());
            }
        }
        for (int i = 0; i < selectedRows.length; ++i) {
            ROINode node = (ROINode)this.getNodeAtRow(selectedRows[i]);
            if (node == null || !((nodeObject = node.getUserObject()) instanceof ROIShape)) continue;
            ROIShape roiShape = (ROIShape)nodeObject;
            roi = roiShape.getROI();
            if (roi.getShapes().size() == 1) {
                this.reset = true;
            }
            if (roiMap.containsKey(roiShape.getID())) continue;
            selectedList.add(roiShape);
        }
        if (selectedList.size() == 0 && (figures = this.manager.getSelectedFigures()) != null && figures.size() > 0) {
            for (Figure figure : figures) {
                if (!(figure instanceof ROIFigure)) continue;
                selectedList.add(((ROIFigure)figure).getROIShape());
            }
        }
        return selectedList;
    }

    private List<FolderData> getSelectedFolders() {
        ArrayList<FolderData> result = new ArrayList<FolderData>();
        int[] selectedRows = this.getSelectedRows();
        for (int i = 0; i < selectedRows.length; ++i) {
            Object nodeObject;
            ROINode node = (ROINode)this.getNodeAtRow(selectedRows[i]);
            if (node == null || !((nodeObject = node.getUserObject()) instanceof FolderData)) continue;
            result.add((FolderData)nodeObject);
        }
        return result;
    }

    @Override
    public void duplicateROI() {
        this.manager.showReadyMessage();
        List<ROIShape> selectedObjects = this.getSelectedROIShapes();
        if (ROIUtil.onSeparatePlanes(selectedObjects) && ROIUtil.haveSameID(selectedObjects)) {
            this.manager.duplicateROI(ROIUtil.getSameID(selectedObjects), selectedObjects);
        } else {
            this.manager.showMessage("Duplicate: ROIs must be from the same ROI and on separate planes.");
        }
    }

    @Override
    public void mergeROI() {
        this.manager.showReadyMessage();
        List<ROIShape> selectedObjects = this.getSelectedROIShapes();
        if (ROIUtil.onSeparatePlanes(selectedObjects) && selectedObjects.size() > 1) {
            this.manager.mergeROI(ROIUtil.getIDList(selectedObjects), selectedObjects);
        } else {
            this.manager.showMessage("Merge: ROIs must be on separate planes and must include more than one.");
        }
    }

    @Override
    public void propagateROI() {
        this.manager.showReadyMessage();
        ROI roi = null;
        for (int i : this.getSelectedRows()) {
            ROINode n = (ROINode)this.getNodeAtRow(i);
            if (n == null) continue;
            Object obj = n.getUserObject();
            if (roi != null) {
                if (n.isROINode()) {
                    if (((ROI)obj).getID() == roi.getID()) continue;
                    this.manager.showMessage("Propagate: Only one ROI may be propagated at a time.");
                    return;
                }
                if (n.isShapeNode()) {
                    if (((ROIShape)obj).getROI().getID() == roi.getID()) continue;
                    this.manager.showMessage("Propagate: Only one ROI may be propagated at a time.");
                    return;
                }
                this.manager.showMessage("Propagate: No ROI selected.");
                return;
            }
            if (n.isROINode()) {
                roi = (ROI)obj;
                continue;
            }
            if (n.isShapeNode()) {
                roi = ((ROIShape)obj).getROI();
                continue;
            }
            this.manager.showMessage("Propagate: No ROI selected.");
            return;
        }
        if (roi == null) {
            this.manager.showMessage("Propagate: No ROI selected.");
            return;
        }
        this.manager.propagateROI(roi);
    }

    @Override
    public void splitROI() {
        this.manager.showReadyMessage();
        List<ROIShape> selectedObjects = this.getSelectedROIShapes();
        if (ROIUtil.onSeparatePlanes(selectedObjects) && ROIUtil.haveSameID(selectedObjects)) {
            this.manager.splitROI(ROIUtil.getSameID(selectedObjects), selectedObjects);
        } else {
            this.manager.showMessage("Split: ROIs must be from the same ROI and on separate planes.");
        }
    }

    @Override
    public void deleteROI() {
        List<ROIShape> selectionList = this.getSelectedROIShapes();
        this.manager.deleteROIShapes(selectionList);
        if (this.reset) {
            this.manager.reset();
        }
        this.reset = false;
    }

    @Override
    public void calculateStats() {
        this.manager.showReadyMessage();
        List<ROIShape> selectedObjects = this.getSelectedROIShapes();
        if (ROIUtil.onSeparatePlanes(selectedObjects) && ROIUtil.haveSameID(selectedObjects)) {
            this.manager.calculateStats(selectedObjects);
        } else {
            this.manager.showMessage("Calculate: ROIs must be from the same ROI and on separate planes.");
        }
    }

    @Override
    protected void onMousePressed(MouseEvent e) {
        if (MeasurementViewerControl.isRightClick(e)) {
            int row = this.rowAtPoint(e.getPoint());
            ListSelectionModel m = this.getSelectionModel();
            if (!m.isSelectedIndex(row)) {
                if (e.isControlDown()) {
                    m.addSelectionInterval(row, row);
                } else if (e.isShiftDown()) {
                    m.addSelectionInterval(m.getAnchorSelectionIndex(), row);
                } else {
                    this.getSelectionModel().clearSelection();
                    m.addSelectionInterval(row, row);
                }
            }
            this.onSelection(this.getSelectedObjects());
            this.showROIManagementMenu((Component)((Object)this), e.getX(), e.getY());
        }
    }

    public String getToolTipText(MouseEvent e) {
        TreePath path = this.getPathForLocation(e.getX(), e.getY());
        if (path == null) {
            return "";
        }
        int row = this.getRowForPath(path);
        if (row < 0) {
            return "";
        }
        ROINode node = (ROINode)this.getNodeAtRow(row);
        if (node == null) {
            return "";
        }
        Object object = node.getUserObject();
        if (node.isROINode()) {
            ROI roi = (ROI)object;
            return AnnotationKeys.TEXT.get(roi);
        }
        if (node.isShapeNode()) {
            ROIShape s = (ROIShape)object;
            return "" + s.getFigure().getAttribute(MeasurementAttributes.TEXT);
        }
        if (node.isFolderNode()) {
            return "";
        }
        return "";
    }

    @Override
    public void loadTags() {
        this.manager.loadTags();
    }

    public boolean canCreateFolder() {
        return this.manager.canCreateFolder();
    }

    @Override
    public void addToFolder() {
        this.action = ROIActionController.CreationActionType.ADD_TO_FOLDER;
        SelectionWizardDataSource dsAll = new SelectionWizardDataSource("All Folders");
        SelectionWizardDataSource dsDisplayed = new SelectionWizardDataSource("Displayed Folders");
        for (FolderData f : this.manager.getFolders()) {
            if (!f.canLink()) continue;
            dsAll.getData().add(f);
            if (!this.displayFolder(f)) continue;
            dsDisplayed.getData().add(f);
        }
        SelectionWizardDataSource[] ds = new SelectionWizardDataSource[2];
        if (this.defaultDS.equals("All Folders")) {
            ds[0] = dsAll;
            ds[1] = dsDisplayed;
        } else {
            ds[0] = dsDisplayed;
            ds[1] = dsAll;
        }
        SelectionWizard wiz = new SelectionWizard(null, null, FolderData.class, this.canCreateFolder(), MeasurementAgent.getUserDetails(), ds);
        wiz.setTitle("Add to ROI Folders", "Select the Folders to add the ROI(s) to", IconManager.getInstance().getIcon(47));
        wiz.addPropertyChangeListener(this);
        UIUtilities.centerAndShow(wiz);
    }

    @Override
    public void removeFromFolder() {
        this.action = ROIActionController.CreationActionType.REMOVE_FROM_FOLDER;
        List<ROIShape> selectedObjects = this.getSelectedROIShapes();
        HashMap<Long, FolderData> inFolders = new HashMap<Long, FolderData>();
        for (ROIShape shape : selectedObjects) {
            for (FolderData f : shape.getROI().getFolders()) {
                if (inFolders.containsKey(f.getId())) continue;
                inFolders.put(f.getId(), f);
            }
        }
        SelectionWizard wiz = new SelectionWizard(null, inFolders.values(), FolderData.class, MeasurementAgent.getUserDetails());
        wiz.setTitle("Remove from ROI Folders", "Select the Folders to remove the ROI(s) from", IconManager.getInstance().getIcon(47));
        wiz.addPropertyChangeListener(this);
        UIUtilities.centerAndShow(wiz);
    }

    @Override
    public void createFolder() {
        this.action = ROIActionController.CreationActionType.CREATE_FOLDER;
        FolderData obj = new FolderData();
        EditorDialog d = new EditorDialog((JFrame)null, (DataObject)obj, false);
        d.addPropertyChangeListener(this);
        UIUtilities.centerAndShow(d);
    }

    @Override
    public void deleteFolder() {
        this.action = ROIActionController.CreationActionType.DELETE_FOLDER;
        List<FolderData> selection = this.getSelectedFolders();
        this.manager.deleteFolders(selection);
    }

    @Override
    public void editFolder() {
        this.action = ROIActionController.CreationActionType.EDIT_FOLDER;
        List<FolderData> selection = this.getSelectedFolders();
        if (selection.size() == 1) {
            DataObject obj = (DataObject)selection.get(0);
            EditorDialog d = new EditorDialog((JFrame)null, obj, false, 1);
            d.addPropertyChangeListener(this);
            UIUtilities.centerAndShow(d);
        }
    }

    @Override
    public void moveFolder() {
        this.action = ROIActionController.CreationActionType.MOVE_FOLDER;
        HashSet<Long> excludeIds = new HashSet<Long>();
        for (FolderData folderData : this.getSelectedFolders()) {
            excludeIds.add(folderData.getId());
            if (folderData.getParentFolder() != null) {
                excludeIds.add(folderData.getParentFolder().getId());
            }
            ROINode fnode = this.nodesMap.findFolderNode(folderData);
            ArrayList<ROINode> subNodes = new ArrayList<ROINode>();
            ROIUtil.getAllDecendants(fnode, subNodes);
            for (ROINode subNode : subNodes) {
                if (!subNode.isFolderNode()) continue;
                excludeIds.add(((FolderData)subNode.getUserObject()).getId());
            }
        }
        ArrayList<DataObject> tmp = new ArrayList<DataObject>();
        for (FolderData folder : this.manager.getFolders()) {
            if (excludeIds.contains(folder.getId()) || !folder.canLink()) continue;
            tmp.add((DataObject)folder);
        }
        SelectionDialog selectionDialog = new SelectionDialog(tmp, "Destination Folder", "Move to selected Folder:", true);
        selectionDialog.addPropertyChangeListener(this);
        UIUtilities.centerAndShow(selectionDialog);
    }

    Collection<FolderData> getRecentlyModifiedFolders() {
        return this.recentlyModifiedFolders;
    }

    private void addRecentlyModifiedFolder(FolderData f) {
        this.recentlyModifiedFolders.add(f);
        this.onlyShowFolderIds.add(f.getId());
    }

    private void addRecentlyModifiedFolder(Collection<FolderData> f) {
        this.recentlyModifiedFolders.addAll(f);
        this.onlyShowFolderIds.addAll(Pojos.extractIds(f));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Collection<Long> excludeIds;
        String name = evt.getPropertyName();
        if ("datasource".equals(name)) {
            this.defaultDS = ((SelectionWizardDataSource)evt.getNewValue()).getName();
        }
        if ("selectedItems".equals(name)) {
            List<ROIShape> selectedObjects = this.getSelectedROIShapes();
            Collection<FolderData> folders = Collections.EMPTY_LIST;
            Map m = (Map)evt.getNewValue();
            if (m == null || m.size() != 1) {
                return;
            }
            folders = (Collection)m.get(FolderData.class);
            if (folders.isEmpty()) {
                return;
            }
            this.addRecentlyModifiedFolder(folders);
            if (this.action == ROIActionController.CreationActionType.ADD_TO_FOLDER) {
                this.manager.addRoisToFolder(selectedObjects, folders);
            } else if (this.action == ROIActionController.CreationActionType.REMOVE_FROM_FOLDER) {
                this.manager.removeRoisFromFolder(selectedObjects, folders);
            }
        }
        if ("createNoParent".equals(name) || "create".equals(name) && this.action == ROIActionController.CreationActionType.CREATE_FOLDER) {
            FolderData parentFolder = null;
            List<FolderData> sel = this.getSelectedFolders();
            if (sel.size() == 1 && this.action != ROIActionController.CreationActionType.EDIT_FOLDER) {
                parentFolder = sel.get(0);
            }
            FolderData folder = (FolderData)evt.getNewValue();
            if (parentFolder != null) {
                folder.setParentFolder(parentFolder.asFolder());
                this.addRecentlyModifiedFolder(parentFolder);
            }
            if (this.getSelectedROIShapes().isEmpty()) {
                this.manager.saveROIFolders(Collections.singleton(folder));
            } else {
                this.manager.addRoisToFolder(this.getSelectedROIShapes(), Collections.singleton(folder));
            }
        }
        if (SelectionDialog.OBJECT_SELECTION_PROPERTY.equals(name)) {
            excludeIds = this.nodesMap.getChildFolderIds(this.getSelectedFolders());
            FolderData target = (FolderData)evt.getNewValue();
            this.addRecentlyModifiedFolder(target);
            ArrayList<FolderData> toSave = new ArrayList<FolderData>();
            for (FolderData folder : this.getSelectedFolders()) {
                if (excludeIds.contains(folder.getId())) continue;
                folder.setParentFolder(target.asFolder());
                toSave.add(folder);
            }
            this.manager.saveROIFolders(toSave);
        }
        if (SelectionDialog.NONE_SELECTION_PROPERTY.equals(name)) {
            excludeIds = this.nodesMap.getChildFolderIds(this.getSelectedFolders());
            ArrayList<FolderData> toSave = new ArrayList<FolderData>();
            for (FolderData folder : this.getSelectedFolders()) {
                if (excludeIds.contains(folder.getId())) continue;
                folder.setParentFolder(null);
                toSave.add(folder);
            }
            this.manager.saveROIFolders(toSave);
        }
    }

    public void handleDragAndDrop(int[] rows, int destination) {
        if (this.manager.getState() != 5) {
            return;
        }
        ArrayList<ROINode> objects = new ArrayList<ROINode>();
        for (int i = 0; i < rows.length; ++i) {
            if (rows[i] == destination) {
                return;
            }
            ROINode n = (ROINode)this.getNodeAtRow(rows[i]);
            if (n == null) continue;
            objects.add(n);
        }
        ROINode target = (ROINode)this.getNodeAtRow(destination);
        if (target == null) {
            ArrayList<ROIShape> rois;
            if (((ROINode)((Object)objects.iterator().next())).isFolderNode()) {
                ArrayList<FolderData> toSave = new ArrayList<FolderData>();
                for (ROINode n : this.dropChildFolderNodes(objects)) {
                    FolderData folder = (FolderData)n.getUserObject();
                    folder.setParentFolder(null);
                    toSave.add(folder);
                }
                this.manager.saveROIFolders(toSave);
            } else if (((ROINode)((Object)objects.iterator().next())).isShapeNode()) {
                rois = new ArrayList<ROIShape>();
                for (ROINode n : objects) {
                    rois.add((ROIShape)n.getUserObject());
                }
                this.manager.moveROIsToFolder(rois, Collections.EMPTY_LIST);
            } else if (((ROINode)((Object)objects.iterator().next())).isROINode()) {
                rois = new ArrayList();
                for (ROINode n : objects) {
                    ROI r = (ROI)n.getUserObject();
                    rois.addAll(r.getShapes().values());
                }
                this.manager.moveROIsToFolder(rois, Collections.EMPTY_LIST);
            }
            return;
        }
        if (!target.isFolderNode()) {
            return;
        }
        Iterator it = objects.iterator();
        block4: while (it.hasNext()) {
            ROINode n = (ROINode)((Object)it.next());
            for (int i = 0; i < target.getChildCount(); ++i) {
                if (n != target.getChildAt(i)) continue;
                it.remove();
                continue block4;
            }
        }
        FolderData targetFolder = (FolderData)target.getUserObject();
        if (((ROINode)((Object)objects.iterator().next())).isFolderNode()) {
            ArrayList<FolderData> folders = new ArrayList<FolderData>(objects.size());
            for (ROINode n : this.dropChildFolderNodes(objects)) {
                FolderData f = (FolderData)n.getUserObject();
                f.setParentFolder(targetFolder.asFolder());
                folders.add(f);
            }
            this.addRecentlyModifiedFolder(targetFolder);
            this.manager.saveROIFolders(folders);
        } else if (((ROINode)((Object)objects.iterator().next())).isShapeNode()) {
            ArrayList<ROIShape> rois = new ArrayList<ROIShape>();
            for (ROINode n : objects) {
                rois.add((ROIShape)n.getUserObject());
            }
            this.addRecentlyModifiedFolder(targetFolder);
            this.manager.moveROIsToFolder(rois, Collections.singletonList(targetFolder));
        } else if (((ROINode)((Object)objects.iterator().next())).isROINode()) {
            ArrayList<ROIShape> rois = new ArrayList<ROIShape>();
            for (ROINode n : objects) {
                ROI r = (ROI)n.getUserObject();
                rois.addAll(r.getShapes().values());
            }
            this.addRecentlyModifiedFolder(targetFolder);
            this.manager.moveROIsToFolder(rois, Collections.singletonList(targetFolder));
        }
    }

    private List<ROINode> dropChildFolderNodes(List<ROINode> objects) {
        ArrayList<ROINode> sorted = new ArrayList<ROINode>();
        for (ROINode n : objects) {
            if (!n.isFolderNode()) continue;
            sorted.add(n);
        }
        Collections.sort(sorted, new Comparator<ROINode>(){

            @Override
            public int compare(ROINode o1, ROINode o2) {
                return o1.getPath().getPathCount() - o2.getPath().getPathCount();
            }
        });
        ArrayList<ROINode> result = new ArrayList<ROINode>();
        for (ROINode n1 : sorted) {
            boolean contains = false;
            for (ROINode n2 : sorted) {
                if (n2 == n1 || !n2.getPath().isDescendant(n1.getPath())) continue;
                contains = true;
                break;
            }
            if (contains) continue;
            result.add(n1);
        }
        return result;
    }

    static /* synthetic */ int[] access$002(ROITable x0, int[] x1) {
        x0.previousSelectionIndices = x1;
        return x1;
    }

    class CheckboxRenderer
    extends BooleanCellRenderer {
        CheckboxRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            ROINode node = (ROINode)ROITable.this.getNodeAtRow(row);
            if (node != null) {
                c.setEnabled(node.isShowEnabled());
            }
            return c;
        }
    }

    class CustomTableUI
    extends BasicTableUI {
        CustomTableUI() {
        }

        @Override
        protected MouseInputListener createMouseInputListener() {
            return new BasicTableUI.MouseInputHandler(){

                @Override
                public void mousePressed(MouseEvent e) {
                    Point origin = e.getPoint();
                    int row = CustomTableUI.this.table.rowAtPoint(origin);
                    int column = CustomTableUI.this.table.columnAtPoint(origin);
                    if (row != -1 && column != -1 && !CustomTableUI.this.table.isCellSelected(row, column)) {
                        super.mousePressed(e);
                    }
                }

                @Override
                public void mouseDragged(MouseEvent e) {
                    super.mouseDragged(e);
                    CustomTableUI.this.table.getTransferHandler().exportAsDrag(CustomTableUI.this.table, e, 2);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    super.mouseReleased(e);
                    ROITable.this.timer.stop();
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    super.mouseClicked(e);
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    super.mouseEntered(e);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    super.mouseExited(e);
                }

                @Override
                public void mouseMoved(MouseEvent e) {
                    super.mouseMoved(e);
                }
            };
        }
    }
}

