/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.view;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import omero.gateway.model.ShapeSettingsData;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.ConnectionFigure;
import org.jhotdraw.draw.DrawingEditor;
import org.openmicroscopy.shoola.agents.measurement.IconManager;
import org.openmicroscopy.shoola.agents.measurement.actions.DrawingAction;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewer;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerControl;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerModel;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerUI;
import org.openmicroscopy.shoola.agents.util.ui.PermissionMenu;
import org.openmicroscopy.shoola.util.roi.figures.MeasureArrowFigure;
import org.openmicroscopy.shoola.util.roi.figures.MeasureBezierFigure;
import org.openmicroscopy.shoola.util.roi.figures.MeasureEllipseFigure;
import org.openmicroscopy.shoola.util.roi.figures.MeasureLineConnectionFigure;
import org.openmicroscopy.shoola.util.roi.figures.MeasureLineFigure;
import org.openmicroscopy.shoola.util.roi.figures.MeasurePointFigure;
import org.openmicroscopy.shoola.util.roi.figures.MeasureRectangleFigure;
import org.openmicroscopy.shoola.util.roi.figures.MeasureTextFigure;
import org.openmicroscopy.shoola.util.roi.figures.ROIFigure;
import org.openmicroscopy.shoola.util.roi.model.annotation.MeasurementAttributes;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.drawingtools.attributes.DrawingAttributes;
import org.openmicroscopy.shoola.util.ui.drawingtools.attributes.FigureProperties;
import org.openmicroscopy.shoola.util.ui.drawingtools.creationtools.DrawingBezierTool;
import org.openmicroscopy.shoola.util.ui.drawingtools.creationtools.DrawingConnectionTool;
import org.openmicroscopy.shoola.util.ui.drawingtools.creationtools.DrawingObjectCreationTool;
import org.openmicroscopy.shoola.util.ui.drawingtools.creationtools.DrawingToolBarButtonFactory;

class ToolBar
extends JPanel
implements MouseListener {
    private static final Map<AttributeKey, Object> defaultConnectionAttributes = new HashMap<AttributeKey, Object>();
    private static final boolean addPolyline = false;
    private static final boolean addPolygon = true;
    private static final boolean addConnection = false;
    private static final String CREATE_KEY = "create";
    private static final Dimension HGLUE;
    private static final int MAX_SIZE = 1024;
    private FigureProperties lineConnectionProperties;
    private JToolBar toolBar;
    private MeasurementViewerControl controller;
    private MeasurementViewerUI view;
    private MeasurementViewerModel model;
    private MeasurementViewer measurementcomponent;
    private DrawingObjectCreationTool ellipseTool;
    private DrawingObjectCreationTool rectTool;
    private DrawingObjectCreationTool lineTool;
    private DrawingObjectCreationTool arrowTool;
    private DrawingObjectCreationTool textTool;
    private DrawingObjectCreationTool pointTool;
    private DrawingBezierTool polygonTool;
    private DrawingBezierTool polylineTool;
    private DrawingConnectionTool connectionTool;
    private JButton assistantButton;
    private JCheckBox showTextButton;
    private PermissionMenu deleteMenu;

    private void setUpToggleButton(JToggleButton button) {
        button.setAction(new DrawingAction(this.measurementcomponent, button));
        button.addMouseListener(this);
    }

    private double getDefaultFontSize() {
        double rx;
        double ry;
        Dimension d = this.model.getDrawingView().getSize();
        int sizeX = d.width;
        double r1 = 1.0;
        if (sizeX == 0) {
            sizeX = this.model.getSizeX();
        }
        r1 = this.model.getSizeX() / sizeX;
        int sizeY = d.height;
        if (sizeY == 0) {
            sizeY = this.model.getSizeY();
        }
        double r2 = 1.0;
        r2 = this.model.getSizeX() / sizeX;
        double f = 12.0;
        double sx = this.model.getSizeX();
        double sy = this.model.getSizeY();
        if (sx > 1024.0 || sy > 1024.0) {
            f = 2.0 * f;
        }
        if ((f = Math.floor(Math.max(ry = f * r2, rx = f * r1))) < 12.0) {
            return 12.0;
        }
        return f;
    }

    private void initComponents() {
        this.showTextButton = new JCheckBox("Show Comment");
        this.lineConnectionProperties = new FigureProperties(defaultConnectionAttributes);
        HashMap<AttributeKey, Object> p = new HashMap<AttributeKey, Object>();
        double value = this.getDefaultFontSize();
        Font font = ROIFigure.DEFAULT_FONT;
        font = font.deriveFont((float)value);
        p.put(MeasurementAttributes.FONT_SIZE, value);
        p.put(MeasurementAttributes.FONT_FACE, font);
        this.ellipseTool = new DrawingObjectCreationTool(new MeasureEllipseFigure(false, true, true, true, true), p);
        this.rectTool = new DrawingObjectCreationTool(new MeasureRectangleFigure(false, true, true, true, true), p);
        this.textTool = new DrawingObjectCreationTool(new MeasureTextFigure(false, true), p);
        this.lineTool = new DrawingObjectCreationTool(new MeasureLineFigure(false, true, true, true, true), p);
        this.arrowTool = new DrawingObjectCreationTool(new MeasureArrowFigure(false, true, true, true, true), p);
        Map<AttributeKey, Object> m = this.lineConnectionProperties.getProperties();
        m.put(MeasurementAttributes.FONT_SIZE, value);
        this.connectionTool = new DrawingConnectionTool((ConnectionFigure)new MeasureLineConnectionFigure(), (Map)m);
        this.pointTool = new DrawingObjectCreationTool(new MeasurePointFigure(false, true, true, true, true), p);
        this.polygonTool = new DrawingBezierTool(new MeasureBezierFigure(true, false, true, true, true, true), p);
        this.polylineTool = new DrawingBezierTool(new MeasureBezierFigure(false, false, true, true, true, true), p);
        this.toolBar = DrawingToolBarButtonFactory.createDefaultBar();
        DrawingEditor editor = this.model.getDrawingEditor();
        DrawingToolBarButtonFactory.addSelectionToolTo(this.toolBar, editor, true);
        Component component = this.toolBar.getComponent(this.toolBar.getComponentCount() - 1);
        if (component instanceof JToggleButton) {
            this.setUpToggleButton((JToggleButton)component);
        }
        this.toolBar.add(new JSeparator());
        this.toolBar.add(Box.createRigidArea(HGLUE));
        DrawingToolBarButtonFactory.addToolTo(this.toolBar, editor, this.rectTool, "createRectangle");
        component = this.toolBar.getComponent(this.toolBar.getComponentCount() - 1);
        if (component instanceof JToggleButton) {
            this.setUpToggleButton((JToggleButton)component);
        }
        DrawingToolBarButtonFactory.addToolTo(this.toolBar, editor, this.ellipseTool, "createEllipse");
        component = this.toolBar.getComponent(this.toolBar.getComponentCount() - 1);
        if (component instanceof JToggleButton) {
            this.setUpToggleButton((JToggleButton)component);
        }
        DrawingToolBarButtonFactory.addToolTo(this.toolBar, editor, this.pointTool, "createEllipse");
        component = this.toolBar.getComponent(this.toolBar.getComponentCount() - 1);
        if (component instanceof JToggleButton) {
            JToggleButton button = (JToggleButton)component;
            IconManager icons = IconManager.getInstance();
            button.setIcon(icons.getIcon(36));
            button.setToolTipText("Point");
            this.setUpToggleButton(button);
        }
        DrawingToolBarButtonFactory.addToolTo(this.toolBar, editor, this.lineTool, "createLine");
        component = this.toolBar.getComponent(this.toolBar.getComponentCount() - 1);
        if (component instanceof JToggleButton) {
            this.setUpToggleButton((JToggleButton)component);
        }
        DrawingToolBarButtonFactory.addToolTo(this.toolBar, editor, this.arrowTool, "createArrow");
        component = this.toolBar.getComponent(this.toolBar.getComponentCount() - 1);
        if (component instanceof JToggleButton) {
            this.setUpToggleButton((JToggleButton)component);
        }
        DrawingToolBarButtonFactory.addToolTo(this.toolBar, editor, this.polygonTool, "createPolygon");
        component = this.toolBar.getComponent(this.toolBar.getComponentCount() - 1);
        if (component instanceof JToggleButton) {
            this.setUpToggleButton((JToggleButton)component);
        }
        DrawingToolBarButtonFactory.addToolTo(this.toolBar, editor, this.textTool, "createText");
        component = this.toolBar.getComponent(this.toolBar.getComponentCount() - 1);
        if (component instanceof JToggleButton) {
            this.setUpToggleButton((JToggleButton)component);
        }
    }

    private JToolBar buildControlsBar() {
        JToolBar bar = new JToolBar();
        bar.setFloatable(false);
        bar.setRollover(true);
        bar.setBorder(null);
        JButton button = new JButton(this.controller.getAction(MeasurementViewerControl.SAVE));
        UIUtilities.unifiedButtonLookAndFeel(button);
        bar.add(button);
        button = new JButton(this.controller.getAction(MeasurementViewerControl.LOAD));
        UIUtilities.unifiedButtonLookAndFeel(button);
        button.setVisible(false);
        bar.add(button);
        this.assistantButton = new JButton(this.controller.getAction(MeasurementViewerControl.ROI_ASSISTANT));
        UIUtilities.unifiedButtonLookAndFeel(this.assistantButton);
        bar.add(this.assistantButton);
        button = new JButton(this.controller.getAction(MeasurementViewerControl.DELETE));
        if (!this.model.isMember()) {
            button.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (ToolBar.this.deleteMenu == null) {
                        ToolBar.this.deleteMenu = new PermissionMenu("Delete", "ROIs");
                        ToolBar.this.deleteMenu.addPropertyChangeListener(ToolBar.this.controller);
                    }
                    ToolBar.this.deleteMenu.show((JComponent)e.getSource(), e.getX(), e.getY());
                }
            });
        }
        UIUtilities.unifiedButtonLookAndFeel(button);
        bar.add(button);
        bar.add(new JSeparator());
        return bar;
    }

    private void buildGUI() {
        JPanel j = new JPanel();
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(this.buildControlsBar());
        p.add(Box.createHorizontalStrut(5));
        p.add(this.toolBar);
        p.add(Box.createHorizontalStrut(5));
        p.add(this.showTextButton);
        this.setLayout(new FlowLayout(0));
        j.setLayout(new BoxLayout(j, 1));
        j.add(p);
        this.add(j);
    }

    ToolBar(MeasurementViewer component, MeasurementViewerUI view, MeasurementViewerControl controller, MeasurementViewerModel model) {
        if (component == null) {
            throw new IllegalArgumentException("No component.");
        }
        if (view == null) {
            throw new IllegalArgumentException("No view.");
        }
        if (controller == null) {
            throw new IllegalArgumentException("No control.");
        }
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        this.measurementcomponent = component;
        this.view = view;
        this.controller = controller;
        this.model = model;
        this.initComponents();
        this.buildGUI();
    }

    protected boolean rightClick(MouseEvent e) {
        return e.getButton() == 3 || e.getButton() == 1 && e.isControlDown();
    }

    void createSingleFigure(boolean option) {
        this.ellipseTool.setResetToSelect(option);
        this.rectTool.setResetToSelect(option);
        this.textTool.setResetToSelect(option);
        this.lineTool.setResetToSelect(option);
        this.arrowTool.setResetToSelect(option);
        this.pointTool.setResetToSelect(option);
        this.polygonTool.setResetToSelect(option);
    }

    void refreshToolBar() {
        Collection<ROIFigure> figures = this.model.getAllFigures();
        if (figures.size() > 0) {
            Iterator<ROIFigure> i = figures.iterator();
            boolean b = false;
            while (i.hasNext()) {
                ROIFigure figure = i.next();
                Boolean value = (Boolean)MeasurementAttributes.SHOWTEXT.get(figure);
                if (value == null || !value.booleanValue()) continue;
                b = value;
                break;
            }
            this.showTextButton.setSelected(b);
        }
        this.showTextButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ToolBar.this.view.showText(ToolBar.this.showTextButton.isSelected());
            }
        });
    }

    void onFigureSelected() {
        int size = this.view.getDrawingView().getSelectedFigures().size();
        this.assistantButton.getAction().setEnabled(size == 1);
    }

    void onAnalysed(boolean analyse) {
        this.assistantButton.setEnabled(!analyse);
    }

    void onMagnificationChanged() {
        if (!this.model.isBigImage()) {
            return;
        }
        HashMap<AttributeKey, Object> p = new HashMap<AttributeKey, Object>();
        double value = this.getDefaultFontSize();
        Font font = ROIFigure.DEFAULT_FONT;
        font = font.deriveFont((float)value);
        p.put(MeasurementAttributes.FONT_SIZE, value);
        p.put(MeasurementAttributes.FONT_FACE, font);
        this.rectTool.setAttributes(p);
        this.ellipseTool.setAttributes(p);
        this.pointTool.setAttributes(p);
        this.lineTool.setAttributes(p);
        this.arrowTool.setAttributes(p);
        this.textTool.setAttributes(p);
        this.polygonTool.setAttributes(p);
        this.polylineTool.setAttributes(p);
        Map<AttributeKey, Object> m = this.lineConnectionProperties.getProperties();
        m.put(MeasurementAttributes.FONT_SIZE, value);
        this.connectionTool = new DrawingConnectionTool((ConnectionFigure)new MeasureLineConnectionFigure(), (Map)m);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.rightClick(e)) {
            this.createSingleFigure(false);
            JToggleButton button = (JToggleButton)e.getSource();
            button.setSelected(true);
        } else {
            this.createSingleFigure(this.view.isCreateSingleFigure());
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    static {
        defaultConnectionAttributes.put(MeasurementAttributes.FILL_COLOR, ShapeSettingsData.DEFAULT_FILL_COLOUR);
        defaultConnectionAttributes.put(MeasurementAttributes.STROKE_COLOR, ShapeSettingsData.DEFAULT_STROKE_COLOUR);
        defaultConnectionAttributes.put(MeasurementAttributes.TEXT_COLOR, ShapeSettingsData.DEFAULT_STROKE_COLOUR);
        defaultConnectionAttributes.put(MeasurementAttributes.FONT_SIZE, new Double(12.0));
        defaultConnectionAttributes.put(MeasurementAttributes.FONT_BOLD, false);
        defaultConnectionAttributes.put(MeasurementAttributes.STROKE_WIDTH, 1.0);
        defaultConnectionAttributes.put(MeasurementAttributes.TEXT, "");
        defaultConnectionAttributes.put(MeasurementAttributes.MEASUREMENTTEXT_COLOUR, ShapeSettingsData.DEFAULT_STROKE_COLOUR);
        defaultConnectionAttributes.put(MeasurementAttributes.SHOWMEASUREMENT, false);
        defaultConnectionAttributes.put(DrawingAttributes.SHOWTEXT, false);
        HGLUE = new Dimension(5, 5);
    }
}

