/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import omero.gateway.SecurityContext;
import omero.gateway.model.FileAnnotationData;
import omero.model.FileAnnotation;
import omero.model.OriginalFile;
import org.openmicroscopy.shoola.agents.metadata.EditorLoader;
import org.openmicroscopy.shoola.agents.metadata.MetadataViewerAgent;
import org.openmicroscopy.shoola.agents.metadata.editor.Editor;
import org.openmicroscopy.shoola.env.data.events.DSCallFeedbackEvent;
import org.openmicroscopy.shoola.env.data.views.CallHandle;

public class FileLoader
extends EditorLoader {
    private File file;
    private FileAnnotationData data;
    private Object uiView;
    private CallHandle handle;
    private Map<FileAnnotationData, Object> files;
    private Map<FileAnnotationData, File> filesMap;

    public FileLoader(Editor viewer, SecurityContext ctx, FileAnnotationData data, Object uiView) {
        super(viewer, ctx);
        if (data == null) {
            throw new IllegalArgumentException("No data set.");
        }
        this.data = data;
        this.uiView = uiView;
        this.file = new File(MetadataViewerAgent.getTmpDir() + File.separator + data.getFileName());
        this.file.deleteOnExit();
    }

    public FileLoader(Editor viewer, SecurityContext ctx, Map<FileAnnotationData, Object> files) {
        super(viewer, ctx);
        if (files == null) {
            throw new IllegalArgumentException("No data set.");
        }
        this.files = files;
    }

    @Override
    public void cancel() {
        this.handle.cancel();
        if (this.file != null) {
            this.file.delete();
        }
        if (this.filesMap != null) {
            for (Map.Entry<FileAnnotationData, File> entry : this.filesMap.entrySet()) {
                File f = entry.getValue();
                f.delete();
            }
        }
    }

    @Override
    public void load() {
        if (this.data != null) {
            OriginalFile f = ((FileAnnotation)this.data.asAnnotation()).getFile();
            if (f.isLoaded()) {
                this.handle = this.mhView.loadFile(this.ctx, this.file, f.getId().getValue(), this);
            }
        } else {
            Iterator<Map.Entry<FileAnnotationData, Object>> i = this.files.entrySet().iterator();
            this.filesMap = new HashMap<FileAnnotationData, File>(this.files.size());
            String dir = MetadataViewerAgent.getTmpDir();
            while (i.hasNext()) {
                Map.Entry<FileAnnotationData, Object> entry = i.next();
                FileAnnotationData fa = entry.getKey();
                File f = new File(dir + File.separator + fa.getFileID() + "_" + fa.getFileName());
                f.deleteOnExit();
                this.filesMap.put(fa, f);
            }
            this.handle = this.mhView.loadFiles(this.ctx, this.filesMap, this);
        }
    }

    @Override
    public void update(DSCallFeedbackEvent fe) {
        Map m;
        if (this.data == null && (m = (Map)fe.getPartialResult()) != null) {
            for (Map.Entry entry : m.entrySet()) {
                FileAnnotationData fa = (FileAnnotationData)entry.getKey();
                this.viewer.setLoadedFile(fa, (File)entry.getValue(), this.files.get(fa));
            }
        }
    }

    @Override
    public void handleNullResult() {
        if (this.data != null) {
            this.handleException(new Exception("No data available."));
        }
    }

    @Override
    public void handleResult(Object result) {
        if (this.data != null) {
            this.viewer.setLoadedFile(this.data, this.file, this.uiView);
        }
    }
}

