/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata;

import omero.cmd.OK;
import omero.gateway.SecurityContext;
import omero.gateway.exception.DSAccessException;
import omero.gateway.exception.DSOutOfServiceException;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.GroupData;
import org.openmicroscopy.shoola.agents.metadata.MetadataLoader;
import org.openmicroscopy.shoola.agents.metadata.MetadataViewerAgent;
import org.openmicroscopy.shoola.agents.metadata.view.MetadataViewer;
import org.openmicroscopy.shoola.env.data.AdminService;
import org.openmicroscopy.shoola.env.data.ProcessReport;
import org.openmicroscopy.shoola.env.data.views.CallHandle;

public class GroupEditor
extends MetadataLoader {
    public static final int UPDATE = 0;
    public static final int CHANGE = 1;
    private static final String GROUP_PERMISSION_ERROR_MSG = "Could not change group permissions";
    private GroupData group;
    private int permissions = -1;
    private int index;
    private CallHandle handle;

    public GroupEditor(MetadataViewer viewer, SecurityContext ctx, GroupData group, int permissions, int loaderID, int index) {
        super(viewer, ctx, loaderID);
        if (group == null) {
            throw new IllegalArgumentException("No group to edit.");
        }
        this.group = group;
        this.permissions = permissions;
        this.index = index;
    }

    public GroupEditor(MetadataViewer viewer, SecurityContext ctx, GroupData group, int loaderID, int index) {
        super(viewer, ctx, loaderID);
        if (group == null) {
            throw new IllegalArgumentException("No group to edit.");
        }
        this.group = group;
        this.permissions = -1;
        this.index = index;
    }

    @Override
    public void load() {
        switch (this.index) {
            case 0: {
                this.handle = this.adminView.updateGroup(this.ctx, this.group, this);
                break;
            }
            case 1: {
                ExperimenterData exp = this.viewer.getCurrentUser();
                if (this.viewer.getRefObject() != null && this.viewer.getRefObject() instanceof ExperimenterData) {
                    exp = (ExperimenterData)this.viewer.getRefObject();
                }
                this.handle = this.adminView.changeGroup(this.ctx, this.group, exp, this);
            }
        }
    }

    @Override
    public void cancel() {
        this.handle.cancel();
    }

    @Override
    public void handleResult(Object result) {
        if (this.viewer.getState() == 4) {
            return;
        }
        AdminService os = MetadataViewerAgent.getRegistry().getAdminService();
        switch (this.index) {
            case 0: {
                if (result instanceof GroupData) {
                    this.viewer.onAdminUpdated((GroupData)result);
                    if (this.permissions <= -1) break;
                    try {
                        os.updateGroupPermissions(this.ctx, (GroupData)result, this.permissions, this);
                    }
                    catch (DSOutOfServiceException e) {
                        MetadataViewerAgent.getRegistry().getUserNotifier().notifyError("Error", GROUP_PERMISSION_ERROR_MSG);
                    }
                    catch (DSAccessException e) {
                        MetadataViewerAgent.getRegistry().getUserNotifier().notifyError("Error", GROUP_PERMISSION_ERROR_MSG);
                    }
                    break;
                }
                if (result instanceof ProcessReport) {
                    MetadataViewerAgent.getRegistry().getUserNotifier().notifyError("Error", GROUP_PERMISSION_ERROR_MSG);
                    break;
                }
                if (!(result instanceof OK)) break;
                try {
                    this.group = os.reloadGroup(this.ctx, this.group);
                    this.viewer.onAdminUpdated(this.group);
                    break;
                }
                catch (DSOutOfServiceException e) {
                    MetadataViewerAgent.getRegistry().getLogger().debug((Object)this, "Couldn't reload group.");
                    break;
                }
                catch (DSAccessException e) {
                    MetadataViewerAgent.getRegistry().getLogger().debug((Object)this, "Couldn't reload group.");
                }
            }
        }
    }
}

