/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata;

import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import ome.model.units.BigResult;
import omero.gateway.SecurityContext;
import omero.gateway.model.ChannelData;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.GroupData;
import omero.gateway.model.ImageData;
import org.apache.commons.collections.CollectionUtils;
import org.openmicroscopy.shoola.agents.events.iviewer.CopyRndSettings;
import org.openmicroscopy.shoola.agents.events.iviewer.RndSettingsCopied;
import org.openmicroscopy.shoola.agents.events.measurement.ROIEvent;
import org.openmicroscopy.shoola.agents.events.metadata.ChannelSavedEvent;
import org.openmicroscopy.shoola.agents.events.treeviewer.DisplayModeEvent;
import org.openmicroscopy.shoola.agents.metadata.view.MetadataViewer;
import org.openmicroscopy.shoola.agents.metadata.view.MetadataViewerFactory;
import org.openmicroscopy.shoola.agents.metadata.view.RndSettingsPasted;
import org.openmicroscopy.shoola.env.Agent;
import org.openmicroscopy.shoola.env.Environment;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.AdminService;
import org.openmicroscopy.shoola.env.data.events.ReconnectedEvent;
import org.openmicroscopy.shoola.env.data.events.UserGroupSwitched;
import org.openmicroscopy.shoola.env.data.util.AgentSaveInfo;
import org.openmicroscopy.shoola.env.event.AgentEvent;
import org.openmicroscopy.shoola.env.event.AgentEventListener;
import org.openmicroscopy.shoola.env.event.EventBus;

public class MetadataViewerAgent
implements Agent,
AgentEventListener {
    private static Registry registry;
    private int displayMode = -1;

    public static Registry getRegistry() {
        return registry;
    }

    public static int runAsPlugin() {
        Environment env = (Environment)registry.lookup("/env");
        if (env == null) {
            return -1;
        }
        return env.runAsPlugin();
    }

    public static ExperimenterData getUserDetails() {
        return (ExperimenterData)registry.lookup("/current_user/details");
    }

    public static Collection getAvailableUserGroups() {
        return (Collection)registry.lookup("/userGroup/details");
    }

    public static boolean isAdministrator() {
        Boolean b = (Boolean)registry.lookup("/users/administrator");
        if (b == null) {
            return false;
        }
        return b;
    }

    public static boolean isFullAdministrator() {
        Boolean b = (Boolean)registry.lookup("/fulladministrator");
        if (b == null) {
            b = Boolean.FALSE;
        }
        return MetadataViewerAgent.isAdministrator() && b != false;
    }

    public static SecurityContext getAdminContext() {
        if (!MetadataViewerAgent.isAdministrator()) {
            return null;
        }
        Collection groups = MetadataViewerAgent.getAvailableUserGroups();
        Iterator i = groups.iterator();
        AdminService svc = registry.getAdminService();
        while (i.hasNext()) {
            GroupData g = (GroupData)i.next();
            if (!svc.isSecuritySystemGroup(g.getId(), "system")) continue;
            return new SecurityContext(g.getId());
        }
        return null;
    }

    public static boolean isFastConnection() {
        int value = (Integer)registry.lookup("/connection/speed");
        return value == 0;
    }

    public static String getOmeroHome() {
        Environment env = (Environment)registry.lookup("/env");
        String omeroDir = env.getOmeroHome();
        File home = new File(omeroDir);
        if (!home.exists()) {
            home.mkdir();
        }
        return omeroDir;
    }

    public static String getOmeroFilesHome() {
        Environment env = (Environment)registry.lookup("/env");
        String omeroDir = env.getOmeroFilesHome();
        File home = new File(omeroDir);
        if (!home.exists()) {
            home.mkdir();
        }
        return omeroDir;
    }

    public static String getTmpDir() {
        Environment env = (Environment)registry.lookup("/env");
        return env.getTmpDir();
    }

    public static ExperimenterData getExperimenter(long expID) {
        List l = (List)registry.lookup("/users/details");
        if (l == null) {
            return null;
        }
        for (ExperimenterData exp : l) {
            if (exp.getId() != expID) continue;
            return exp;
        }
        return null;
    }

    public static boolean isBinaryAvailable() {
        Boolean b = (Boolean)registry.lookup("/services/SERVER/BinaryAvailable");
        if (b == null) {
            return true;
        }
        return b;
    }

    public static void logBigResultExeption(Object src, Object exception, String property) {
        if (exception instanceof BigResult) {
            MetadataViewerAgent.getRegistry().getLogger().warn(src, "Arithmetic overflow; " + property + " is " + ((BigResult)((Object)exception)).result.doubleValue());
        }
    }

    public static boolean canCreate() {
        Boolean b = (Boolean)registry.lookup("canCreate");
        return b;
    }

    private void handleUserGroupSwitched(UserGroupSwitched evt) {
        if (evt == null) {
            return;
        }
        MetadataViewerFactory.onGroupSwitched(evt.isSuccessful());
    }

    private void handleReconnectedEvent(ReconnectedEvent evt) {
        MetadataViewerFactory.onGroupSwitched(true);
    }

    private void handleChannelSavedEvent(ChannelSavedEvent evt) {
        List<ChannelData> channels = evt.getChannels();
        Iterator<Long> i = evt.getImageIds().iterator();
        while (i.hasNext()) {
            MetadataViewer viewer = MetadataViewerFactory.getViewerFromId(ImageData.class.getName(), i.next());
            if (viewer == null) continue;
            viewer.onUpdatedChannels(channels);
        }
    }

    private void handleRndSettingsCopied(RndSettingsCopied evt) {
        Collection<Long> ids = evt.getImagesIDs();
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        Iterator<Long> i = ids.iterator();
        while (i.hasNext()) {
            MetadataViewer viewer = MetadataViewerFactory.getViewerFromId(ImageData.class.getName(), i.next());
            if (viewer == null || !viewer.isRendererLoaded()) continue;
            viewer.resetRenderingControl();
        }
    }

    private void handleCopyRndSettings(CopyRndSettings evt) {
        MetadataViewerFactory.setCopyRenderingSettingsFrom(evt.getImage(), evt.getRndDef());
    }

    private void handleRndSettingsPasted(RndSettingsPasted e) {
        MetadataViewerFactory.applyCopiedRndSettings(e.getImageId());
    }

    private void handleDisplayModeEvent(DisplayModeEvent evt) {
        this.displayMode = evt.getDisplayMode();
        MetadataViewerFactory.setDiplayMode(this.displayMode);
    }

    @Override
    public void activate(boolean master) {
    }

    @Override
    public void terminate() {
        Environment env = (Environment)registry.lookup("/env");
        if (env.isRunAsPlugin()) {
            MetadataViewerFactory.onGroupSwitched(true);
        }
    }

    @Override
    public void setContext(Registry ctx) {
        registry = ctx;
        EventBus bus = ctx.getEventBus();
        bus.register((AgentEventListener)this, UserGroupSwitched.class);
        bus.register((AgentEventListener)this, ReconnectedEvent.class);
        bus.register((AgentEventListener)this, ChannelSavedEvent.class);
        bus.register((AgentEventListener)this, DisplayModeEvent.class);
        bus.register((AgentEventListener)this, RndSettingsCopied.class);
        bus.register((AgentEventListener)this, CopyRndSettings.class);
        bus.register((AgentEventListener)this, RndSettingsPasted.class);
        bus.register((AgentEventListener)this, ROIEvent.class);
    }

    @Override
    public boolean canTerminate() {
        return true;
    }

    @Override
    public AgentSaveInfo getDataToSave() {
        List<Object> instances = MetadataViewerFactory.getInstancesToSave();
        if (instances == null || instances.size() == 0) {
            return null;
        }
        return new AgentSaveInfo("Edition", instances);
    }

    @Override
    public void save(List<Object> instances) {
        MetadataViewerFactory.saveInstances(instances);
    }

    @Override
    public void eventFired(AgentEvent e) {
        if (e instanceof UserGroupSwitched) {
            this.handleUserGroupSwitched((UserGroupSwitched)e);
        } else if (e instanceof ReconnectedEvent) {
            this.handleReconnectedEvent((ReconnectedEvent)e);
        } else if (e instanceof ChannelSavedEvent) {
            this.handleChannelSavedEvent((ChannelSavedEvent)e);
        } else if (e instanceof DisplayModeEvent) {
            this.handleDisplayModeEvent((DisplayModeEvent)e);
        } else if (e instanceof RndSettingsCopied) {
            this.handleRndSettingsCopied((RndSettingsCopied)e);
        } else if (e instanceof CopyRndSettings) {
            this.handleCopyRndSettings((CopyRndSettings)e);
        } else if (e instanceof RndSettingsPasted) {
            this.handleRndSettingsPasted((RndSettingsPasted)e);
        } else if (e instanceof ROIEvent) {
            this.handleROIEvent((ROIEvent)e);
        }
    }

    private void handleROIEvent(ROIEvent e) {
        MetadataViewer viewer = MetadataViewerFactory.getViewerFromId(ImageData.class.getName(), e.getImageId());
        if (viewer != null) {
            viewer.reloadROICount();
        }
    }

    public static boolean isEditGroup() {
        Boolean b = (Boolean)registry.lookup("/groups/edit");
        if (b == null) {
            b = Boolean.FALSE;
        }
        return MetadataViewerAgent.isAdministrator() && b != false;
    }

    public static boolean isEditUser() {
        Boolean b = (Boolean)registry.lookup("/users/edit");
        if (b == null) {
            b = Boolean.FALSE;
        }
        return MetadataViewerAgent.isAdministrator() && b != false;
    }
}

