/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.editor;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import omero.gateway.model.DataObject;
import omero.gateway.model.FilterData;
import omero.gateway.model.FilterSetData;
import omero.gateway.model.LightPathData;
import org.openmicroscopy.shoola.agents.metadata.editor.AcquisitionDataUI;
import org.openmicroscopy.shoola.agents.metadata.editor.DichroicComponent;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorModel;
import org.openmicroscopy.shoola.agents.metadata.editor.FilterComponent;
import org.openmicroscopy.shoola.agents.util.DataComponent;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.util.ui.JLabelButton;
import org.openmicroscopy.shoola.util.ui.OMETextArea;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class FilterGroupComponent
extends JPanel
implements PropertyChangeListener {
    private AcquisitionDataUI parent;
    private EditorModel model;
    private DataObject object;
    private List<FilterComponent> emissionfilters;
    private List<FilterComponent> excitationfilters;
    private DichroicComponent dichroic;
    private Map<String, DataComponent> fieldsFilterSet;
    private JLabelButton unsetFilterSet;
    private boolean unsetFilterSetShown;

    private void populateFilter(FilterData filter, List<FilterComponent> l, String title) {
        if (filter == null) {
            return;
        }
        Map<String, Object> details = EditorUtil.transformFilter(filter);
        List notSet = (List)details.get("NotSet");
        if (notSet.size() != 11) {
            FilterComponent comp = new FilterComponent(this.parent, this.model, title);
            comp.displayFilter(details);
            l.add(comp);
        }
    }

    private void transformFilterSet(Map<String, Object> details) {
        JLabel label = new JLabel();
        Font font = label.getFont();
        int sizeLabel = font.getSize() - 2;
        List notSet = (List)details.get("NotSet");
        details.remove("NotSet");
        if (notSet.size() > 0 && this.unsetFilterSet == null) {
            this.unsetFilterSet = this.parent.formatUnsetFieldsControl();
            this.unsetFilterSet.addPropertyChangeListener(this);
        }
        Set<Map.Entry<String, Object>> entrySet = details.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            String key = entry.getKey();
            boolean set = !notSet.contains(key);
            Object value = entry.getValue();
            label = UIUtilities.setTextFont(key, 1, sizeLabel);
            label.setBackground(UIUtilities.BACKGROUND_COLOR);
            JComponent area = UIUtilities.createComponent(OMETextArea.class, null);
            if (value == null || value.equals("")) {
                value = "None";
            }
            ((OMETextArea)area).setEditable(false);
            ((OMETextArea)area).setText((String)value);
            ((OMETextArea)area).setEditedColor(UIUtilities.EDITED_COLOR);
            area.setEnabled(!set);
            DataComponent comp = new DataComponent(label, area);
            comp.setEnabled(false);
            comp.setSetField(!notSet.contains(key));
            this.fieldsFilterSet.put(key, comp);
        }
    }

    private void initialize() {
        this.dichroic = new DichroicComponent(this.parent, this.model);
        this.dichroic.setVisible(false);
        this.emissionfilters = new ArrayList<FilterComponent>();
        this.excitationfilters = new ArrayList<FilterComponent>();
        this.fieldsFilterSet = new HashMap<String, DataComponent>();
        if (this.object instanceof FilterSetData) {
            Iterator i;
            List l;
            FilterSetData set = (FilterSetData)this.object;
            Map<String, Object> details = EditorUtil.transformDichroic(set.getDichroic());
            List notSet = (List)details.get("NotSet");
            if (notSet.size() != 4) {
                this.dichroic.displayDichroic(details);
                this.dichroic.setVisible(true);
            }
            if ((l = set.getEmissionFilters()) != null) {
                i = l.iterator();
                while (i.hasNext()) {
                    this.populateFilter((FilterData)i.next(), this.emissionfilters, "Emission Filter");
                }
            }
            if ((l = set.getExcitationFilters()) != null) {
                i = l.iterator();
                while (i.hasNext()) {
                    this.populateFilter((FilterData)i.next(), this.excitationfilters, "Excitation Filter");
                }
            }
            this.transformFilterSet(EditorUtil.transformFilterSetManufacturer(set));
        } else {
            Iterator i;
            List l;
            LightPathData path = (LightPathData)this.object;
            Map<String, Object> details = EditorUtil.transformDichroic(path.getDichroic());
            List notSet = (List)details.get("NotSet");
            if (notSet.size() != 4) {
                this.dichroic.displayDichroic(details);
                this.dichroic.setVisible(true);
            }
            if ((l = path.getEmissionFilters()) != null) {
                i = l.iterator();
                while (i.hasNext()) {
                    this.populateFilter((FilterData)i.next(), this.emissionfilters, "Emission Filter");
                }
            }
            if ((l = path.getExcitationFilters()) != null) {
                i = l.iterator();
                while (i.hasNext()) {
                    this.populateFilter((FilterData)i.next(), this.excitationfilters, "Excitation Filter");
                }
            }
        }
    }

    private void displayUnsetFilterSetFields() {
        if (this.object instanceof LightPathData) {
            return;
        }
        this.unsetFilterSetShown = !this.unsetFilterSetShown;
        String s = "Show unset fields";
        if (this.unsetFilterSetShown) {
            s = "Hide unset fields";
        }
        this.unsetFilterSet.setText(s);
        this.parent.layoutFields(this, this.unsetFilterSet, this.fieldsFilterSet, this.unsetFilterSetShown);
    }

    private void buildGUI() {
        this.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.setLayout(new GridBagLayout());
        this.setBackground(UIUtilities.BACKGROUND_COLOR);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.weightx = 1.0;
        constraints.gridy = 0;
        if (this.object instanceof FilterSetData) {
            this.parent.layoutFields(this, this.unsetFilterSet, this.fieldsFilterSet, this.unsetFilterSetShown);
        }
        Iterator<FilterComponent> i = this.excitationfilters.iterator();
        while (i.hasNext()) {
            this.add((Component)i.next(), constraints);
            ++constraints.gridy;
        }
        if (this.dichroic.isVisible()) {
            this.add((Component)this.dichroic, constraints);
            ++constraints.gridy;
        }
        i = this.emissionfilters.iterator();
        while (i.hasNext()) {
            this.add((Component)i.next(), constraints);
            ++constraints.gridy;
        }
    }

    FilterGroupComponent(AcquisitionDataUI parent, EditorModel model, DataObject object) {
        if (!(object instanceof LightPathData) && !(object instanceof FilterSetData)) {
            return;
        }
        this.parent = parent;
        this.model = model;
        this.object = object;
        this.initialize();
        this.buildGUI();
    }

    boolean hasDataToSave() {
        boolean b = false;
        if (this.object instanceof FilterSetData) {
            b = this.parent.hasDataToSave(this.fieldsFilterSet);
        }
        if (b) {
            return b;
        }
        Iterator<FilterComponent> i = this.emissionfilters.iterator();
        while (i.hasNext()) {
            if (!i.next().hasDataToSave()) continue;
            return true;
        }
        i = this.excitationfilters.iterator();
        while (i.hasNext()) {
            if (!i.next().hasDataToSave()) continue;
            return true;
        }
        return this.dichroic.hasDataToSave();
    }

    void prepareDataToSave() {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("selected".equals(name)) {
            this.displayUnsetFilterSetFields();
        }
    }
}

