/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.editor;

import java.awt.Font;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import omero.gateway.model.ChannelAcquisitionData;
import omero.gateway.model.LightSourceData;
import org.openmicroscopy.shoola.agents.metadata.editor.AcquisitionDataUI;
import org.openmicroscopy.shoola.agents.metadata.editor.Editor;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorModel;
import org.openmicroscopy.shoola.agents.util.DataComponent;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.env.data.model.EnumerationObject;
import org.openmicroscopy.shoola.util.ui.JLabelButton;
import org.openmicroscopy.shoola.util.ui.NumericalTextField;
import org.openmicroscopy.shoola.util.ui.OMEComboBox;
import org.openmicroscopy.shoola.util.ui.OMETextArea;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class LightSourceComponent
extends JPanel
implements PropertyChangeListener {
    private Map<String, DataComponent> fieldsLight;
    private JLabelButton unsetLight;
    private boolean unsetLightShown;
    private OMEComboBox laserMediumBox;
    private OMEComboBox lightTypeBox;
    private OMEComboBox arcTypeBox;
    private OMEComboBox filamentTypeBox;
    private OMEComboBox laserTypeBox;
    private OMEComboBox laserTuneableBox;
    private OMEComboBox laserPockelCellBox;
    private OMEComboBox laserPulseBox;
    private AcquisitionDataUI parent;
    private EditorModel model;
    private int channelIndex;

    private void displayUnsetLightFields() {
        this.unsetLightShown = !this.unsetLightShown;
        String s = "Show unset fields";
        if (this.unsetLightShown) {
            s = "Hide unset fields";
        }
        this.unsetLight.setText(s);
        this.parent.layoutFields(this, this.unsetLight, this.fieldsLight, this.unsetLightShown);
    }

    private void transformLightSource(String kind, Map<String, Object> details) {
        String title = EditorUtil.getLightSourceType(kind);
        this.setBorder(BorderFactory.createTitledBorder(title));
        JComponent area = null;
        JLabel label = new JLabel();
        Font font = label.getFont();
        int sizeLabel = font.getSize() - 2;
        List notSet = (List)details.get("NotSet");
        details.remove("NotSet");
        if (notSet.size() > 0 && this.unsetLight == null) {
            this.unsetLight = this.parent.formatUnsetFieldsControl();
            this.unsetLight.addPropertyChangeListener(this);
        }
        Set<Map.Entry<String, Object>> entrySet = details.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            Object selected;
            String key = entry.getKey();
            boolean set = !notSet.contains(key);
            Object value = entry.getValue();
            label = UIUtilities.setTextFont(key, 1, sizeLabel);
            label.setBackground(UIUtilities.BACKGROUND_COLOR);
            if (LightSourceData.LASER.equals(kind)) {
                boolean b;
                if ("Type".equals(key)) {
                    selected = this.model.getChannelEnumerationSelected(Editor.LASER_TYPE, (String)value);
                    if (selected != null) {
                        this.laserTypeBox.setSelectedItem(selected);
                        if (AcquisitionDataUI.UNSET_ENUM.contains(selected.toString())) {
                            set = false;
                        }
                    }
                    this.laserTypeBox.setEditedColor(UIUtilities.EDITED_COLOR);
                    area = this.laserTypeBox;
                } else if ("Medium".equals(key)) {
                    selected = this.model.getChannelEnumerationSelected(Editor.LASER_MEDIUM, (String)value);
                    if (selected != null) {
                        this.laserMediumBox.setSelectedItem(selected);
                        if (AcquisitionDataUI.UNSET_ENUM.contains(selected.toString())) {
                            set = false;
                        }
                    }
                    this.laserMediumBox.setEditedColor(UIUtilities.EDITED_COLOR);
                    area = this.laserMediumBox;
                } else if ("Pulse".equals(key)) {
                    selected = this.model.getChannelEnumerationSelected(Editor.LASER_PULSE, (String)value);
                    if (selected != null) {
                        this.laserPulseBox.setSelectedItem(selected);
                    } else {
                        set = false;
                        this.laserPulseBox.setSelectedIndex(this.laserPulseBox.getItemCount() - 1);
                    }
                    this.laserPulseBox.setEditedColor(UIUtilities.EDITED_COLOR);
                    area = this.laserPulseBox;
                } else if ("Tuneable".equals(key)) {
                    if (value != null) {
                        b = (Boolean)value;
                        if (b) {
                            this.laserTuneableBox.setSelectedItem("Yes");
                        } else {
                            this.laserTuneableBox.setSelectedItem("No");
                        }
                    } else {
                        this.laserTuneableBox.setSelectedItem("Not Set");
                        set = false;
                    }
                    this.laserTuneableBox.setEditedColor(UIUtilities.EDITED_COLOR);
                    area = this.laserTuneableBox;
                } else if ("PockelCell".equals(key)) {
                    if (value != null) {
                        b = (Boolean)value;
                        if (b) {
                            this.laserPockelCellBox.setSelectedItem("Yes");
                        } else {
                            this.laserPockelCellBox.setSelectedItem("No");
                        }
                    } else {
                        set = false;
                        this.laserPockelCellBox.setSelectedItem("Not Set");
                    }
                    this.laserPockelCellBox.setEditedColor(UIUtilities.EDITED_COLOR);
                    area = this.laserPockelCellBox;
                }
            } else if (LightSourceData.ARC.equals(kind)) {
                if ("Type".equals(key)) {
                    selected = this.model.getChannelEnumerationSelected(Editor.ARC_TYPE, (String)value);
                    if (selected != null) {
                        this.arcTypeBox.setSelectedItem(selected);
                        if (AcquisitionDataUI.UNSET_ENUM.contains(selected.toString())) {
                            set = false;
                        }
                    }
                    this.arcTypeBox.setEditedColor(UIUtilities.EDITED_COLOR);
                    area = this.arcTypeBox;
                }
            } else if (LightSourceData.FILAMENT.equals(kind)) {
                if ("Type".equals(key)) {
                    selected = this.model.getChannelEnumerationSelected(Editor.FILAMENT_TYPE, (String)value);
                    if (selected != null) {
                        this.filamentTypeBox.setSelectedItem(selected);
                        if (AcquisitionDataUI.UNSET_ENUM.contains(selected.toString())) {
                            set = false;
                        }
                    }
                    this.filamentTypeBox.setEditedColor(UIUtilities.EDITED_COLOR);
                    area = this.filamentTypeBox;
                }
            } else if (LightSourceData.LIGHT_EMITTING_DIODE.equals(kind)) {
                if ("Type".equals(key)) {
                    area = new JLabel();
                }
            } else {
                this.lightTypeBox.setSelectedIndex(this.lightTypeBox.getItemCount() - 1);
                area = this.lightTypeBox;
            }
            if (value instanceof Number) {
                String v;
                area = UIUtilities.createComponent(NumericalTextField.class, null);
                if (value instanceof Double) {
                    v = "" + UIUtilities.roundTwoDecimals(((Number)value).doubleValue());
                    ((NumericalTextField)area).setNumberType(Double.class);
                } else if (value instanceof Float) {
                    v = "" + UIUtilities.roundTwoDecimals(((Number)value).doubleValue());
                    ((NumericalTextField)area).setNumberType(Float.class);
                } else {
                    v = "" + value;
                }
                ((NumericalTextField)area).setText(v);
                ((NumericalTextField)area).setEditedColor(UIUtilities.EDITED_COLOR);
            } else if ("Pump".equals(key)) {
                area = UIUtilities.createComponent(OMETextArea.class, null);
                ((OMETextArea)area).setEditable(false);
                ((OMETextArea)area).setText((String)value);
                ((OMETextArea)area).setEditedColor(UIUtilities.EDITED_COLOR);
            } else if ("Model".equals(key) || "Manufacturer".equals(key) || "Serial Number".equals(key) || "Lot Number".equals(key)) {
                area = UIUtilities.createComponent(OMETextArea.class, null);
                if (value == null || value.equals("")) {
                    set = false;
                    value = "None";
                }
                ((OMETextArea)area).setEditable(false);
                ((OMETextArea)area).setText((String)value);
                ((OMETextArea)area).setEditedColor(UIUtilities.EDITED_COLOR);
            } else {
                area = UIUtilities.createComponent(OMETextArea.class, null);
                ((OMETextArea)area).setEditable(false);
                if (value != null) {
                    ((OMETextArea)area).setText(value.toString());
                } else {
                    ((OMETextArea)area).setText("N/A");
                }
                ((OMETextArea)area).setEditedColor(UIUtilities.EDITED_COLOR);
            }
            if (area == null) continue;
            area.setEnabled(!set);
            DataComponent comp = new DataComponent(label, area);
            comp.setEnabled(false);
            comp.setSetField(!notSet.contains(key));
            this.fieldsLight.put(key, comp);
        }
    }

    private void resetBoxes() {
        List<EnumerationObject> l = this.model.getChannelEnumerations(Editor.LASER_TYPE);
        this.laserTypeBox = EditorUtil.createComboBox(l);
        l = this.model.getChannelEnumerations(Editor.ARC_TYPE);
        this.arcTypeBox = EditorUtil.createComboBox(l);
        l = this.model.getChannelEnumerations(Editor.FILAMENT_TYPE);
        this.filamentTypeBox = EditorUtil.createComboBox(l);
        l = this.model.getChannelEnumerations(Editor.LASER_MEDIUM);
        this.laserMediumBox = EditorUtil.createComboBox(l);
        l = this.model.getChannelEnumerations(Editor.LASER_PULSE);
        Object[] array = new EnumerationObject[l.size() + 1];
        Iterator<EnumerationObject> j = l.iterator();
        int i = 0;
        while (j.hasNext()) {
            array[i] = j.next();
            ++i;
        }
        array[i] = new EnumerationObject("Not Set");
        this.laserPulseBox = EditorUtil.createComboBox(array);
    }

    private void handleLightSourceSelection() {
        ChannelAcquisitionData data = this.model.getChannelAcquisitionData(this.channelIndex);
        String selected = (String)this.lightTypeBox.getSelectedItem();
        String kind = "";
        if ("Laser".equals(selected)) {
            kind = LightSourceData.LASER;
        } else if ("Filament".equals(selected)) {
            kind = LightSourceData.FILAMENT;
        } else if ("Arc".equals(selected)) {
            kind = LightSourceData.ARC;
        } else if ("Light Emitting Diode".equals(selected)) {
            kind = LightSourceData.LIGHT_EMITTING_DIODE;
        }
        this.fieldsLight.clear();
        Map<String, Object> d = EditorUtil.transformLightSource(data.getLightSource());
        d.remove("Light");
        this.transformLightSource(kind, d);
        this.parent.layoutFields(this, this.unsetLight, this.fieldsLight, this.unsetLightShown);
        this.revalidate();
        this.repaint();
    }

    private void initComponents() {
        this.unsetLight = null;
        this.unsetLightShown = false;
        this.fieldsLight = new LinkedHashMap<String, DataComponent>();
        this.resetBoxes();
        Object[] values = new String[]{"Yes", "No", "Not Set"};
        this.laserTuneableBox = EditorUtil.createComboBox(values);
        this.laserPockelCellBox = EditorUtil.createComboBox(values);
        values = new String[]{"Arc", "Light Emitting Diode", "Filament", "Laser", "Not Set"};
        this.lightTypeBox = EditorUtil.createComboBox(values);
    }

    private void buildGUI() {
        this.setBorder(BorderFactory.createTitledBorder("Light"));
        this.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.setLayout(new GridBagLayout());
    }

    LightSourceComponent(AcquisitionDataUI parent, EditorModel model) {
        this.parent = parent;
        this.model = model;
        this.initComponents();
        this.buildGUI();
    }

    void displayLightSource(String kind, Map<String, Object> details) {
        this.resetBoxes();
        this.fieldsLight.clear();
        this.transformLightSource(kind, details);
        this.parent.layoutFields(this, this.unsetLight, this.fieldsLight, this.unsetLightShown);
        this.parent.attachListener(this.fieldsLight);
    }

    boolean hasDataToSave() {
        return this.parent.hasDataToSave(this.fieldsLight);
    }

    void prepareDataToSave() {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("selected".equals(name)) {
            this.displayUnsetLightFields();
        }
    }
}

