/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.editor.maptable;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.DropMode;
import javax.swing.InputMap;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import omero.gateway.model.MapAnnotationData;
import omero.model.NamedValue;
import org.openmicroscopy.shoola.agents.metadata.editor.maptable.MapTableCellEditor;
import org.openmicroscopy.shoola.agents.metadata.editor.maptable.MapTableCellRenderer;
import org.openmicroscopy.shoola.agents.metadata.editor.maptable.MapTableModel;
import org.openmicroscopy.shoola.agents.metadata.editor.maptable.MapTableSelectionModel;
import org.openmicroscopy.shoola.util.ui.table.TableRowTransferHandler;

public class MapTable
extends JTable {
    public static int PERMISSION_NONE = 0;
    public static int PERMISSION_EDIT = 1;
    public static int PERMISSION_MOVE = 2;
    public static int PERMISSION_DELETE = 4;
    private int permissions = PERMISSION_NONE;

    public MapTable() {
        this(PERMISSION_NONE);
    }

    public MapTable(int permissions) {
        this.permissions = permissions;
        this.setModel(new MapTableModel(this));
        this.init();
    }

    private void init() {
        this.getTableHeader().setReorderingAllowed(false);
        this.setSelectionModel(new MapTableSelectionModel(this));
        TableCellRenderer orgRend = this.getDefaultRenderer(String.class);
        TableCellEditor orgEdit = this.getDefaultEditor(String.class);
        MapTableCellRenderer cellRenderer = new MapTableCellRenderer(orgRend);
        MapTableCellEditor cellEditor = new MapTableCellEditor(orgEdit);
        TableColumn nameColumn = this.getColumnModel().getColumn(0);
        TableColumn valueColumn = this.getColumnModel().getColumn(1);
        nameColumn.setCellEditor(cellEditor);
        valueColumn.setCellEditor(cellEditor);
        nameColumn.setCellRenderer(cellRenderer);
        valueColumn.setCellRenderer(cellRenderer);
        if (this.canMove()) {
            this.setDragEnabled(true);
            this.setDropMode(DropMode.INSERT_ROWS);
            this.setTransferHandler(new TableRowTransferHandler(this));
        }
        KeyStroke tab = KeyStroke.getKeyStroke(9, 0);
        KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
        InputMap im = this.getInputMap(1);
        im.put(enter, im.get(tab));
    }

    public void setData(MapAnnotationData data) {
        ((MapTableModel)this.getModel()).setData(data);
        this.revalidate();
    }

    public MapAnnotationData getData() {
        return ((MapTableModel)this.getModel()).getMap();
    }

    public List<NamedValue> getSelection() {
        MapTableModel model = (MapTableModel)this.getModel();
        ArrayList<NamedValue> result = new ArrayList<NamedValue>();
        for (int row : this.getSelectedRows()) {
            NamedValue nv = model.getRow(row);
            if (nv == null) continue;
            result.add(model.getRow(row));
        }
        return result;
    }

    public void addEntry(NamedValue entry) {
        this.addEntry(entry, -1);
    }

    public void addEntry(NamedValue entry, int index) {
        this.addEntries(Arrays.asList(entry), index);
    }

    public void addEntries(List<NamedValue> entries, int index) {
        MapTableModel model = (MapTableModel)this.getModel();
        model.addEntries(entries, index);
        this.revalidate();
    }

    public void deleteSelected() {
        this.deleteEntries(this.getSelectedRows());
    }

    public void deleteEntry(int index) {
        MapTableModel model = (MapTableModel)this.getModel();
        model.deleteEntry(index);
    }

    public void deleteEntries(int[] indices) {
        MapTableModel model = (MapTableModel)this.getModel();
        model.deleteEntries(indices);
    }

    public boolean isEmpty() {
        return ((MapTableModel)this.getModel()).isEmpty();
    }

    public boolean canEdit() {
        return (this.permissions & PERMISSION_EDIT) == PERMISSION_EDIT;
    }

    public boolean canMove() {
        return (this.permissions & PERMISSION_MOVE) == PERMISSION_MOVE;
    }

    public boolean canDelete() {
        return (this.permissions & PERMISSION_DELETE) == PERMISSION_DELETE;
    }
}

