/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.rnd;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.JPanel;
import omero.gateway.model.ChannelData;
import org.openmicroscopy.shoola.agents.metadata.rnd.GraphicsPane;
import org.openmicroscopy.shoola.agents.metadata.rnd.RendererControl;
import org.openmicroscopy.shoola.agents.metadata.rnd.RendererModel;
import org.openmicroscopy.shoola.agents.util.ui.ChannelButton;
import org.openmicroscopy.shoola.util.CommonsLangUtils;
import org.openmicroscopy.shoola.util.ui.IconManager;
import org.openmicroscopy.shoola.util.ui.JLabelButton;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.colourpicker.LookupTableIconUtil;
import org.openmicroscopy.shoola.util.ui.slider.TextualTwoKnobsSlider;

class ChannelSlider
extends JPanel
implements PropertyChangeListener {
    static final Color GRADIENT_COLOR = Color.BLACK;
    private RendererModel model;
    private RendererControl controller;
    private GraphicsPane uiParent;
    private ChannelData channel;
    private TextualTwoKnobsSlider slider;
    private ChannelButton channelSelection;
    private JLabelButton colorPicker;

    private void initComponents() {
        int index = this.channel.getIndex();
        double s = this.model.getWindowStart(index);
        double e = this.model.getWindowEnd(index);
        double min = this.channel.getGlobalMin();
        double max = this.channel.getGlobalMax();
        boolean intMode = this.model.isIntegerPixelData();
        if (intMode) {
            int absMin = (int)this.model.getLowestValue(index);
            int absMax = (int)this.model.getHighestValue(index);
            if (!this.channel.hasStats()) {
                min = absMin;
                max = absMax;
            }
            this.slider = new TextualTwoKnobsSlider(absMin, absMax, absMin, (int)max, (int)s, (int)e);
            this.slider.layoutComponents(4);
            this.slider.setBackground(UIUtilities.BACKGROUND_COLOR);
        } else {
            double absMin = this.model.getLowestValue(index);
            double absMax = this.model.getHighestValue(index);
            if (!this.channel.hasStats()) {
                min = absMin;
                max = absMax;
            }
            double lowestBound = absMin;
            double highestBound = absMax;
            this.slider = new TextualTwoKnobsSlider(min, max, absMin, absMax, s, e);
            this.slider = new TextualTwoKnobsSlider(lowestBound, highestBound);
            this.slider.layoutComponents(4);
            this.slider.setBackground(UIUtilities.BACKGROUND_COLOR);
        }
        this.slider.getSlider().setPaintLabels(false);
        this.slider.getSlider().setPaintEndLabels(false);
        this.slider.getSlider().setPaintTicks(false);
        this.slider.addPropertyChangeListener(this);
        Color c = this.model.getChannelColor(index);
        String lut = this.model.getLookupTable(index);
        this.slider.setColourGradients(GRADIENT_COLOR, c);
        Font font = this.slider.getFont();
        this.slider.setFont(font.deriveFont(font.getStyle(), font.getSize() - 2));
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.channel.getChannelLabeling());
        list.add("min: " + min);
        list.add("max: " + max);
        this.slider.getSlider().setToolTipText(UIUtilities.formatToolTipText(list));
        this.channelSelection = CommonsLangUtils.isNotEmpty(lut) ? new ChannelButton(this.channel.getChannelLabeling(), LookupTableIconUtil.getLUTIconImage(lut), index) : new ChannelButton(this.channel.getChannelLabeling(), c, index);
        this.channelSelection.setPreferredSize(ChannelButton.DEFAULT_MAX_SIZE);
        this.channelSelection.setSelected(this.model.isChannelActive(index));
        this.channelSelection.setRightClickSupported(false);
        this.channelSelection.addPropertyChangeListener(this.controller);
        this.channelSelection.addPropertyChangeListener(this);
        this.colorPicker = new JLabelButton(IconManager.getInstance().getIcon(130), true);
        this.colorPicker.addPropertyChangeListener(this);
    }

    private void buildGUI() {
        this.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 2, 1, 2);
        c.weightx = 0.0;
        c.fill = 0;
        this.add((Component)this.channelSelection, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.add((Component)this.slider, c);
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 0;
        this.add((Component)this.colorPicker, c);
    }

    ChannelSlider(GraphicsPane uiParent, RendererModel model, RendererControl controller, ChannelData channel) {
        if (uiParent == null) {
            throw new IllegalArgumentException("UI cannot be null.");
        }
        if (model == null) {
            throw new IllegalArgumentException("Model cannot be null.");
        }
        if (controller == null) {
            throw new IllegalArgumentException("Control cannot be null.");
        }
        this.uiParent = uiParent;
        this.model = model;
        this.controller = controller;
        this.channel = channel;
        this.initComponents();
        this.buildGUI();
    }

    int getColumns() {
        return this.slider.getColumns();
    }

    int getIndex() {
        return this.channel.getIndex();
    }

    void setInterval(double s, double e) {
        this.slider.setInterval(s, e);
    }

    void setInputRange(boolean absolute) {
        int index = this.channel.getIndex();
        double s = this.model.getWindowStart(index);
        double e = this.model.getWindowEnd(index);
        double min = this.channel.getGlobalMin();
        double max = this.channel.getGlobalMax();
        double absMin = this.model.getLowestValue(index);
        double absMax = this.model.getHighestValue(index);
        if (!this.channel.hasStats()) {
            min = absMin;
            max = absMax;
        }
        if (absolute) {
            this.slider.getSlider().setValues(absMax, absMin, absMax, absMin, s, e);
        } else {
            this.slider.getSlider().setValues(max, min, max, min, s, e);
        }
    }

    void setColorModelChanged() {
        boolean lut = CommonsLangUtils.isNotEmpty(this.model.getLookupTable(this.getIndex()));
        if (lut) {
            this.slider.setColourGradients(Color.WHITE, Color.WHITE);
            this.slider.setImage(LookupTableIconUtil.getLUTIconImage(this.model.getLookupTable(this.getIndex())));
        } else {
            Color c = this.model.getChannelColor(this.getIndex());
            this.slider.setColourGradients(GRADIENT_COLOR, c);
            this.slider.setImage(null);
        }
        this.setSelectedChannel();
    }

    void setChannelColor() {
        boolean lut = CommonsLangUtils.isNotEmpty(this.model.getLookupTable(this.getIndex()));
        if (lut) {
            this.slider.setColourGradients(Color.WHITE, Color.WHITE);
            this.slider.setImage(LookupTableIconUtil.getLUTIconImage(this.model.getLookupTable(this.getIndex())));
        } else {
            Color c = this.model.getChannelColor(this.getIndex());
            this.slider.setColourGradients(GRADIENT_COLOR, c);
            this.slider.setImage(null);
        }
        if (this.channelSelection != null) {
            if (lut) {
                this.channelSelection.setImage(LookupTableIconUtil.getLUTIconImage(this.model.getLookupTable(this.getIndex())));
            } else {
                this.channelSelection.setColor(this.model.getChannelColor(this.getIndex()));
                this.channelSelection.setImage(null);
            }
        }
    }

    void setSelectedChannel() {
        if (this.channelSelection == null) {
            return;
        }
        this.channelSelection.setSelected(this.model.isChannelActive(this.getIndex()));
        if (CommonsLangUtils.isEmpty(this.model.getLookupTable(this.getIndex()))) {
            this.channelSelection.setColor(this.model.getChannelColor(this.getIndex()));
            this.channelSelection.setImage(null);
        } else {
            this.channelSelection.setImage(LookupTableIconUtil.getLUTIconImage(this.model.getLookupTable(this.getIndex())));
        }
    }

    private void handleSliderChange(boolean render) {
        if (render) {
            this.controller.setInputInterval(this.slider.getStartValue(), this.slider.getEndValue(), this.channel.getIndex());
        }
        this.uiParent.updateHistogram(this.slider.getStartValue(), this.slider.getEndValue(), this.channel.getIndex());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if (this.uiParent.isLiveUpdate()) {
            if ("leftMoved".equals(name) || "rightMoved".equals(name) || "knobReleased".equals(name)) {
                this.handleSliderChange(true);
            }
        } else if ("knobReleased".equals(name)) {
            this.handleSliderChange(true);
        }
        if (this.uiParent.isShowHistogram()) {
            if ("leftMoved".equals(name) || "rightMoved".equals(name) || "knobReleased".equals(name)) {
                this.handleSliderChange(false);
            }
            if (evt.getSource() == this.channelSelection && name.equals("channelSelected")) {
                boolean selected = (Boolean)((Map)evt.getNewValue()).values().iterator().next();
                if (selected) {
                    this.uiParent.updateHistogram(null, null, this.channel.getIndex());
                } else if (this.channel.getIndex() == this.uiParent.getHistogramChannelIndex()) {
                    int index = this.channel.getIndex() + 1;
                    if (index >= this.model.getMaxC()) {
                        index = 0;
                    }
                    this.uiParent.updateHistogram(null, null, index);
                }
            }
        }
        if (evt.getSource() == this.colorPicker && name.equals("selected")) {
            Point p = this.colorPicker.getLocationOnScreen();
            p.translate(-300, 10);
            this.controller.showColorPicker(this.channel.getIndex(), p);
        }
    }
}

