/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.rnd;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import omero.gateway.exception.DSOutOfServiceException;
import omero.gateway.exception.RenderingServiceException;
import omero.gateway.model.ChannelData;
import omero.gateway.model.DataObject;
import omero.gateway.model.ImageData;
import omero.gateway.model.PixelsData;
import omero.log.LogMessage;
import omero.log.Logger;
import omero.model.Length;
import omero.romio.PlaneDef;
import org.openmicroscopy.shoola.agents.events.iviewer.RendererUnloadedEvent;
import org.openmicroscopy.shoola.agents.events.iviewer.ViewImage;
import org.openmicroscopy.shoola.agents.events.iviewer.ViewImageObject;
import org.openmicroscopy.shoola.agents.metadata.MetadataViewerAgent;
import org.openmicroscopy.shoola.agents.metadata.rnd.Renderer;
import org.openmicroscopy.shoola.agents.metadata.rnd.RendererControl;
import org.openmicroscopy.shoola.agents.metadata.rnd.RendererModel;
import org.openmicroscopy.shoola.agents.metadata.rnd.RendererUI;
import org.openmicroscopy.shoola.agents.util.ViewedByItem;
import org.openmicroscopy.shoola.env.data.events.ViewInPluginEvent;
import org.openmicroscopy.shoola.env.event.EventBus;
import org.openmicroscopy.shoola.env.rnd.RenderingControl;
import org.openmicroscopy.shoola.env.rnd.RndProxyDef;
import org.openmicroscopy.shoola.env.rnd.data.ResolutionLevel;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.file.modulo.ModuloInfo;
import org.openmicroscopy.shoola.util.ui.MessageBox;
import org.openmicroscopy.shoola.util.ui.component.AbstractComponent;

class RendererComponent
extends AbstractComponent
implements Renderer {
    private static final String ERROR = " An error occurred while modifying the rendering settings.";
    public static final String RENDERINGSETTINGS_WARNING = "This will change the rendering settings of all images\nin the dataset/plate and cannot be undone.\nProceed?";
    private static final int MAX_RETRY = 1;
    private int loadingAttempt;
    private RendererModel model;
    private RendererControl controller;
    private RendererUI view;
    private List historyActiveChannels;
    private Map<Integer, Color> colorChanges;
    private String origLookupTable;

    private void handleException(Throwable e) {
        this.handleException(e, true);
    }

    private void handleException(Throwable e, boolean notify) {
        Logger logger = MetadataViewerAgent.getRegistry().getLogger();
        UserNotifier un = MetadataViewerAgent.getRegistry().getUserNotifier();
        if (e instanceof RenderingServiceException) {
            RenderingServiceException ex = (RenderingServiceException)e;
            switch (ex.getIndex()) {
                case 1: {
                    return;
                }
                case 2: {
                    un.notifyInfo("Image", "Operation not Supported");
                    return;
                }
            }
            if (ex.getIndex() == 1) {
                return;
            }
        }
        if (e instanceof RenderingServiceException) {
            RenderingServiceException rse = (RenderingServiceException)e;
            LogMessage logMsg = new LogMessage();
            logMsg.print("Rendering Exception:");
            logMsg.println(rse.getExtendedMessage());
            logMsg.print((Throwable)rse);
            logger.error((Object)this, logMsg);
            if (e.getCause() instanceof OutOfMemoryError || e instanceof OutOfMemoryError) {
                un.notifyInfo("Image", "Running out of memory, \nit is not possible to render the image.\nThe image might be too large or you might have several viewers already opened.");
                this.discard();
                this.fireStateChange();
                return;
            }
            if (notify) {
                JFrame f = MetadataViewerAgent.getRegistry().getTaskBar().getFrame();
                if (this.loadingAttempt == 1) {
                    un.notifyInfo("Rendering Error", "An error occurred while modifying the settings.\nThe attempts to reload failed, the viewer will now close.");
                    this.closeViewer();
                    return;
                }
                MessageBox box = new MessageBox(f, "Rendering Error", "An error occurred while modifying the settings.\nDo you want to reload the settings? If Not, the viewer will close.");
                if (box.centerMsgBox() == 1) {
                    ++this.loadingAttempt;
                    logger.debug((Object)this, "Reload rendering Engine.");
                    this.firePropertyChange("Reload", false, true);
                } else {
                    this.closeViewer();
                }
            }
        } else if (e instanceof DSOutOfServiceException) {
            logger.debug((Object)this, "Reload rendering Engine.");
            un.notifyError(ERROR, "Out of service.", e.getCause());
            this.discard();
            this.fireStateChange();
        }
    }

    private void closeViewer() {
        long id = this.model.getRefImage().getDefaultPixels().getId();
        MetadataViewerAgent.getRegistry().getEventBus().post(new RendererUnloadedEvent(id));
        this.discard();
        this.fireStateChange();
    }

    RendererComponent(RendererModel model) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.model = model;
        this.controller = new RendererControl();
        this.view = new RendererUI();
        this.model.getRndDefHistory().addPropertyChangeListener(this.controller);
    }

    void initialize() {
        this.model.initialize(this);
        this.controller.initialize(this, this.view);
        this.view.initialize(this.controller, this.model);
        this.setSelectedChannel(-1);
    }

    @Override
    public void discard() {
        this.model.discard();
    }

    @Override
    public double getGlobalMax() {
        return this.model.getGlobalMax();
    }

    @Override
    public double getGlobalMin() {
        return this.model.getGlobalMin();
    }

    @Override
    public double getHighestValue() {
        return this.model.getHighestValue();
    }

    @Override
    public double getLowestValue() {
        return this.model.getLowestValue();
    }

    @Override
    public int getState() {
        return this.model.getState();
    }

    @Override
    public JComponent getUI() {
        return this.view;
    }

    @Override
    public double getWindowEnd() {
        return this.model.getWindowEnd();
    }

    @Override
    public double getWindowStart() {
        return this.model.getWindowStart();
    }

    @Override
    public void onStateChange(boolean b) {
        if (this.view != null) {
            this.view.onStateChange(b);
        }
    }

    @Override
    public void setBitResolution(int v) {
        try {
            this.makeHistorySnapshot();
            this.model.setBitResolution(v);
            this.firePropertyChange("renderPlane", false, true);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    @Override
    public void setChannelSelection(int index, boolean selected) {
        int selectedIndex = index;
        boolean render = true;
        try {
            this.makeHistorySnapshot();
            if (this.model.isGeneralIndex()) {
                if ("greyscale".equals(this.model.getColorModel())) {
                    if (this.model.isChannelActive(index)) {
                        return;
                    }
                    for (int i = 0; i < this.model.getMaxC(); ++i) {
                        boolean c = i == index;
                        this.model.setChannelActive(i, c);
                    }
                } else {
                    this.model.setChannelActive(index, selected);
                }
            } else if ("greyscale".equals(this.model.getColorModel())) {
                if (this.model.isChannelActive(index)) {
                    return;
                }
                for (int i = 0; i < this.model.getMaxC(); ++i) {
                    boolean c;
                    boolean bl = c = i == index;
                    if (c) {
                        selectedIndex = index;
                    }
                    this.model.setChannelActive(i, c);
                }
            } else {
                this.model.setChannelActive(index, selected);
                List<Integer> active = this.model.getActiveChannels();
                if (!active.contains(index) && active.size() > 0) {
                    int oldSelected = this.model.getSelectedChannel();
                    if (active.contains(oldSelected)) {
                        selectedIndex = oldSelected;
                    } else {
                        int setIndex = this.model.createSelectedChannel();
                        if (setIndex >= 0) {
                            selectedIndex = setIndex;
                        }
                    }
                }
            }
            this.model.setSelectedChannel(selectedIndex);
            this.view.setSelectedChannel();
            if (render) {
                this.firePropertyChange("renderPlane", false, true);
            }
            this.firePropertyChange("selectedChannel", -1, selectedIndex);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    @Override
    public void setCodomainInterval(int s, int e) {
        try {
            this.model.setCodomainInterval(s, e);
            this.firePropertyChange("renderPlane", false, true);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    @Override
    public void setColorModelChanged() {
        this.view.setColorModelChanged();
    }

    @Override
    public void setCurveCoefficient(int channel, double k) {
        try {
            this.model.setCurveCoefficient(k);
            this.firePropertyChange("renderPlane", false, true);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    @Override
    public void setFamily(int channel, String family) {
        try {
            this.model.setFamily(channel, family);
            this.firePropertyChange("renderPlane", false, true);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    @Override
    public void setInputInterval(double start, double end) {
        this.setChannelWindow(this.model.getSelectedChannel(), start, end);
    }

    @Override
    public void setNoiseReduction(boolean b) {
        try {
            this.model.setNoiseReduction(b);
            this.firePropertyChange("renderPlane", false, true);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    @Override
    public void setSelectedChannel(int c) {
        List<Integer> active = this.model.getActiveChannels();
        if (!active.contains(c) && active.size() > 0) {
            int oldSelected = this.model.getSelectedChannel();
            if (active.contains(oldSelected)) {
                c = oldSelected;
            } else {
                int setIndex = this.model.createSelectedChannel();
                if (setIndex >= 0) {
                    c = setIndex;
                }
            }
        }
        this.model.setSelectedChannel(c);
        this.view.setSelectedChannel();
    }

    @Override
    public void resetLookupTable(int index) {
        if (this.origLookupTable != null) {
            if (this.origLookupTable.equals("NONE")) {
                this.model.setLookupTable(index, null);
            } else {
                this.model.setLookupTable(index, this.origLookupTable);
            }
        }
    }

    @Override
    public void setLookupTable(int index, String lut, boolean preview) {
        this.origLookupTable = preview ? (this.model.getLookupTable(index) == null ? "NONE" : this.model.getLookupTable(index)) : null;
        try {
            this.makeHistorySnapshot();
            this.model.setLookupTable(index, lut);
            this.view.setLookUpTable(index);
            this.firePropertyChange("channelColor", -1, index);
            this.firePropertyChange("renderPlane", false, true);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void setReverseIntensity(int index, boolean revInt, boolean preview) {
        try {
            this.makeHistorySnapshot();
            this.model.setReverseIntensity(index, revInt);
            this.firePropertyChange("channelColor", -1, index);
            this.firePropertyChange("renderPlane", false, true);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void setChannelColor(int index, Color color, boolean preview) {
        if (preview) {
            if (this.colorChanges == null) {
                this.colorChanges = new HashMap<Integer, Color>();
            }
            if (color == null) {
                color = this.colorChanges.get(index);
                this.colorChanges.clear();
            } else if (!this.colorChanges.containsKey(index)) {
                this.colorChanges.put(index, this.model.getChannelColor(index));
            }
        } else if (this.colorChanges != null) {
            this.colorChanges.remove(index);
        }
        if (color == null) {
            return;
        }
        try {
            this.makeHistorySnapshot();
            this.model.setChannelColor(index, color);
            this.view.setChannelColor(index);
            this.firePropertyChange("channelColor", -1, index);
            if ("greyscale".equals(this.model.getColorModel())) {
                this.setColorModel("rgb", true);
            } else {
                this.firePropertyChange("renderPlane", false, true);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public String getColorModel() {
        return this.model.getColorModel();
    }

    @Override
    public void setColorModel(String index, boolean update) {
        try {
            List<Integer> active = this.model.getActiveChannels();
            this.model.setColorModel(index);
            if (!update) {
                this.view.setColorModelChanged();
                this.firePropertyChange("colorModel", false, true);
                return;
            }
            if ("greyscale".equals(index)) {
                this.historyActiveChannels = this.model.getActiveChannels();
                if (active != null && active.size() >= 1) {
                    List<ChannelData> channels = this.model.getChannelData();
                    Iterator<Integer> i = channels.iterator();
                    boolean set = false;
                    while (i.hasNext()) {
                        ChannelData channel = (ChannelData)i.next();
                        int j = channel.getIndex();
                        if (!active.contains(j)) continue;
                        if (set) {
                            this.model.setChannelActive(j, false);
                            continue;
                        }
                        this.model.setChannelActive(j, true);
                        set = true;
                    }
                } else if (active == null || active.size() == 0) {
                    this.model.setChannelActive(0, true);
                }
                if (active != null) {
                    for (int j : active) {
                    }
                }
            } else if (this.historyActiveChannels != null && this.historyActiveChannels.size() > 0) {
                Iterator i = this.historyActiveChannels.iterator();
                while (i.hasNext()) {
                    int j = (Integer)i.next();
                    this.model.setChannelActive(j, true);
                }
            } else if (active == null || active.size() == 0) {
                this.model.setChannelActive(0, true);
            } else {
                for (int j : active) {
                    this.model.setChannelActive(j, true);
                }
            }
            this.view.setColorModelChanged();
            this.firePropertyChange("colorModel", false, true);
            if (update) {
                this.firePropertyChange("renderPlane", false, true);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void setSelectedXYPlane(int z, int t, int bin) {
        try {
            int defaultZ = this.model.getDefaultZ();
            if (bin < 0) {
                int selectedT = this.model.getRealSelectedT();
                if (defaultZ == z && selectedT == t) {
                    return;
                }
                this.model.setSelectedXYPlane(z, t);
                if (defaultZ != z) {
                    this.firePropertyChange("zSelected", defaultZ, z);
                }
                if (selectedT != t) {
                    this.firePropertyChange("tSelected", selectedT, t);
                }
            } else {
                int selectedT = this.model.getRealSelectedT();
                if (t < 0 || t >= this.model.getRealT()) {
                    t = selectedT;
                }
                this.model.setSelectedBin(bin, t);
                if (selectedT != t) {
                    this.firePropertyChange("tSelected", selectedT, t);
                }
                this.model.setSelectedZ(z);
                if (defaultZ != z) {
                    this.firePropertyChange("zSelected", defaultZ, z);
                }
            }
            this.firePropertyChange("renderPlane", false, true);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    @Override
    public void applyToAll() {
        if (!this.model.isGeneralIndex()) {
            return;
        }
        MessageBox box = new MessageBox((JFrame)SwingUtilities.windowForComponent(this.view), "Save rendering settings", RENDERINGSETTINGS_WARNING);
        if (box.centerMsgBox() != 1) {
            return;
        }
        try {
            this.saveCurrentSettings();
            this.firePropertyChange("applyToAll", false, true);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void onSettingsApplied(RenderingControl rndControl) {
        if (rndControl == null) {
            return;
        }
        this.loadingAttempt = 0;
        this.model.setRenderingControl(rndControl);
        this.controller.updatePasteAction();
    }

    @Override
    public void onSettingsCopied() {
        this.controller.updatePasteAction();
    }

    @Override
    public int getDefaultT() {
        return this.model.getDefaultT();
    }

    @Override
    public int getDefaultZ() {
        return this.model.getDefaultZ();
    }

    @Override
    public int getPixelsDimensionsT() {
        return this.model.getMaxT();
    }

    @Override
    public int getPixelsDimensionsX() {
        return this.model.getMaxX();
    }

    @Override
    public int getPixelsDimensionsY() {
        return this.model.getMaxY();
    }

    @Override
    public int getPixelsDimensionsZ() {
        return this.model.getMaxZ();
    }

    @Override
    public List<ChannelData> getChannelData() {
        return this.model.getChannelData();
    }

    @Override
    public List<Integer> getActiveChannels() {
        return this.model.getActiveChannels();
    }

    @Override
    public Color getChannelColor(int index) {
        return this.model.getChannelColor(index);
    }

    @Override
    public String getLookupTable(int index) {
        return this.model.getLookupTable(index);
    }

    @Override
    public boolean getReverseIntensity(int index) {
        return this.model.getReverseIntensity(index);
    }

    @Override
    public int getCompressionLevel() {
        return this.model.getCompressionLevel();
    }

    @Override
    public int getPixelsDimensionsC() {
        return this.model.getMaxC();
    }

    @Override
    public Length getPixelsSizeX() {
        return this.model.getPixelsSizeX();
    }

    @Override
    public Length getPixelsSizeY() {
        return this.model.getPixelsSizeY();
    }

    @Override
    public Length getPixelsSizeZ() {
        return this.model.getPixelsSizeZ();
    }

    @Override
    public RndProxyDef getRndSettingsCopy() {
        return this.model.getRndSettingsCopy();
    }

    @Override
    public boolean[] hasRGB() {
        boolean[] rgb = new boolean[]{this.model.hasActiveChannel(0), this.model.hasActiveChannel(1), this.model.hasActiveChannel(2)};
        return rgb;
    }

    @Override
    public boolean isChannelActive(int index) {
        return this.model.isChannelActive(index);
    }

    @Override
    public boolean isColorComponent(int band, int index) {
        return this.model.isColorComponent(band, index);
    }

    @Override
    public boolean isCompressed() {
        return this.model.isCompressed();
    }

    @Override
    public boolean isSameSettings(RndProxyDef def, boolean checkPlane) {
        return this.model.isSameSettings(def, checkPlane);
    }

    @Override
    public void resetSettings() {
        this.resetSettings(null, true);
    }

    @Override
    public void historyBack() {
        try {
            this.model.historyBack();
            this.refresh();
            this.firePropertyChange("renderPlane", false, true);
        }
        catch (Throwable e) {
            this.handleException(e);
        }
    }

    @Override
    public void historyForward() {
        try {
            this.model.historyForward();
            this.refresh();
            this.firePropertyChange("renderPlane", false, true);
        }
        catch (Throwable e) {
            this.handleException(e);
        }
    }

    @Override
    public void makeHistorySnapshot() {
        this.model.makeHistorySnapshot();
    }

    @Override
    public void resetSettings(RndProxyDef settings, boolean update) {
        try {
            this.model.makeHistorySnapshot();
            if (settings != null) {
                this.model.resetSettings(settings);
            } else {
                this.model.resetDefaults();
            }
            if (update) {
                this.view.resetDefaultRndSettings();
                if (settings == null) {
                    settings = this.model.getInitialRndSettings();
                }
                this.view.resetViewedBy(settings);
                this.firePropertyChange("renderPlane", false, true);
                this.firePropertyChange("colorModel", false, true);
                this.controller.updatePasteAction();
            }
        }
        catch (Throwable e) {
            this.handleException(e);
        }
    }

    @Override
    public RndProxyDef saveCurrentSettings() throws RenderingServiceException, DSOutOfServiceException {
        RndProxyDef def = this.model.saveCurrentSettings();
        return def;
    }

    @Override
    public void saveSettings() {
        this.firePropertyChange("saveSettings", false, true);
    }

    @Override
    public void setActive(int index, boolean active) {
        try {
            this.model.setActive(index, active);
        }
        catch (Throwable e) {
            this.handleException(e);
        }
    }

    @Override
    public void setChannelWindow(int index, double start, double end) {
        try {
            this.makeHistorySnapshot();
            double s = this.model.getWindowStart(index);
            double e = this.model.getWindowEnd(index);
            if (start == s && end == e) {
                return;
            }
            this.model.setInputInterval(index, start, end);
            this.firePropertyChange("renderPlane", false, true);
            this.firePropertyChange("inputInterval", false, true);
        }
        catch (Throwable e) {
            this.handleException(e);
        }
    }

    @Override
    public boolean isIntegerPixelData() {
        return this.model.isIntegerPixelData();
    }

    @Override
    public void setCompression(int compression) {
        this.model.setCompression(compression);
    }

    @Override
    public void setOriginalRndSettings() {
        try {
            this.model.setOriginalRndSettings();
            this.view.resetDefaultRndSettings();
        }
        catch (Throwable e) {
            this.handleException(e);
        }
    }

    @Override
    public boolean isModified() {
        return this.model.isModified();
    }

    @Override
    public boolean validatePixels(PixelsData pixels) {
        if (pixels == null) {
            return false;
        }
        return this.model.validatePixels(pixels);
    }

    @Override
    public BufferedImage renderPlane(PlaneDef pDef, int compression) {
        if (pDef == null) {
            return null;
        }
        try {
            return this.model.render(pDef, compression);
        }
        catch (Throwable e) {
            this.handleException(e, false);
            return null;
        }
    }

    @Override
    public BufferedImage renderPlane(PlaneDef pDef) {
        if (pDef == null) {
            return null;
        }
        try {
            return this.model.render(pDef);
        }
        catch (Throwable e) {
            this.handleException(e, false);
            return null;
        }
    }

    @Override
    public void setRangeAllChannels(boolean absolute) {
        try {
            this.makeHistorySnapshot();
            for (int i = 0; i < this.model.getMaxC(); ++i) {
                double max;
                double min;
                if (absolute) {
                    min = this.model.getLowestValue(i);
                    max = this.model.getHighestValue(i);
                } else {
                    min = this.model.getGlobalMin(i);
                    max = this.model.getGlobalMax(i);
                }
                this.model.setInputInterval(i, min, max);
            }
            this.firePropertyChange("renderPlane", false, true);
            this.firePropertyChange("inputInterval", false, true);
            this.firePropertyChange("rangeInput", !absolute, absolute);
        }
        catch (Throwable e) {
            this.handleException(e);
        }
    }

    @Override
    public boolean isMappedImageRGB(List channels) {
        return this.model.isMappedImageRGB(channels);
    }

    @Override
    public BufferedImage createSingleChannelImage(boolean color, int channel, PlaneDef pDef) {
        try {
            String cm = this.model.getColorModel();
            if (!color) {
                this.model.setColorModel("greyscale");
            }
            List<Integer> active = this.model.getActiveChannels();
            for (int i = 0; i < this.model.getMaxC(); ++i) {
                this.model.setActive(i, channel == i);
            }
            BufferedImage img = this.model.render(pDef);
            this.model.setActive(channel, false);
            if (active != null) {
                Iterator<Integer> i = active.iterator();
                while (i.hasNext()) {
                    this.model.setActive(i.next(), true);
                }
            }
            if (!color) {
                this.model.setColorModel(cm);
            }
            return img;
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    @Override
    public void setOverlays(long tableID, Map<Long, Integer> overlays) {
        try {
            this.model.setOverlays(tableID, overlays);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void refresh() {
        this.firePropertyChange("colorModel", null, this.model.getColorModel());
        this.view.resetDefaultRndSettings();
    }

    @Override
    public void renderPreview() {
        if (!this.model.isGeneralIndex()) {
            return;
        }
        this.view.renderPreview();
    }

    @Override
    public ImageData getRefImage() {
        return this.model.getRefImage();
    }

    @Override
    public RndProxyDef getInitialRndSettings() {
        return this.model.getInitialRndSettings();
    }

    @Override
    public void retrieveRelatedSettings() {
        this.firePropertyChange("ViewedBy", null, "");
    }

    @Override
    public void loadRndSettings(boolean loading, List<ViewedByItem> results) {
        this.view.displayViewedBy(results);
    }

    @Override
    public Dimension getTileSize() {
        try {
            return this.model.getTileSize();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public int getResolutionLevels() {
        return this.model.getResolutionLevels();
    }

    @Override
    public int getSelectedResolutionLevel() {
        return this.model.getSelectedResolutionLevel();
    }

    @Override
    public void setSelectedResolutionLevel(int level) {
        try {
            this.model.setSelectedResolutionLevel(level);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public boolean isBigImage() {
        return this.model.isBigImage();
    }

    @Override
    public void viewImage() {
        ImageData image = this.model.getRefImage();
        if (image == null) {
            return;
        }
        EventBus bus = MetadataViewerAgent.getRegistry().getEventBus();
        if (MetadataViewerAgent.runAsPlugin() == 1) {
            bus.post(new ViewInPluginEvent(this.model.getSecurityContext(), (DataObject)image, 1));
        } else {
            ViewImageObject vio = new ViewImageObject((DataObject)image);
            RndProxyDef def = this.view.getSelectedDef();
            if (def != null) {
                vio.setSelectedRndDef(def.getDataID());
            }
            bus.post(new ViewImage(this.model.getSecurityContext(), vio, null));
        }
    }

    @Override
    public void onUpdatedChannels(List<ChannelData> channels) {
        this.model.setChannels(channels);
    }

    @Override
    public boolean canAnnotate() {
        return this.model.canAnnotate();
    }

    @Override
    public List<RenderingControl> getRenderingControls() {
        return this.model.getRenderingControls();
    }

    @Override
    public List<ResolutionLevel> getResolutionDescriptions() {
        try {
            return this.model.getResolutionDescriptions();
        }
        catch (Exception e) {
            MetadataViewerAgent.getRegistry().getLogger().error((Object)this, "Cannot retrieve the resolution levels");
            return null;
        }
    }

    @Override
    public int getRealSelectedT() {
        return this.model.getRealSelectedT();
    }

    @Override
    public int getRealT() {
        return this.model.getRealT();
    }

    @Override
    public int getMaxLifetimeBin() {
        return this.model.getMaxLifetimeBin();
    }

    @Override
    public int getSelectedBin() {
        return this.model.getSelectedBin();
    }

    @Override
    public boolean isLifetimeImage() {
        return this.model.isLifetimeImage();
    }

    @Override
    public ModuloInfo getModuloT() {
        return this.model.getModuloT();
    }

    @Override
    public void updatePasteAction() {
        this.controller.updatePasteAction();
    }

    @Override
    public RndProxyDef getSelectedDef() {
        return this.view.getSelectedDef();
    }

    @Override
    public void setHistogramData(int ch, int[] data) {
        this.model.setHistogramData(ch, data);
        this.view.onHistogramLoaded(ch);
    }
}

