/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.rnd;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import org.apache.commons.collections.CollectionUtils;
import org.openmicroscopy.shoola.agents.metadata.rnd.CodomainPane;
import org.openmicroscopy.shoola.agents.metadata.rnd.ControlPane;
import org.openmicroscopy.shoola.agents.metadata.rnd.DomainPane;
import org.openmicroscopy.shoola.agents.metadata.rnd.RendererControl;
import org.openmicroscopy.shoola.agents.metadata.rnd.RendererModel;
import org.openmicroscopy.shoola.agents.util.ViewedByItem;
import org.openmicroscopy.shoola.env.rnd.RndProxyDef;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class RendererUI
extends JPanel {
    static final Integer DOMAIN = 0;
    static final Integer CODOMAIN = 1;
    private RendererControl controller;
    private RendererModel model;
    private Map<Integer, ControlPane> controlPanes = new HashMap<Integer, ControlPane>(2);

    private void createControlPanes() {
        ControlPane p = new DomainPane(this.model, this.controller);
        p.addPropertyChangeListener(this.controller);
        this.controlPanes.put(DOMAIN, p);
        p = new CodomainPane(this.model, this.controller);
        p.addPropertyChangeListener(this.controller);
        this.controlPanes.put(CODOMAIN, p);
    }

    private void buildGUI() {
        this.setBackground(UIUtilities.BACKGROUND_COLOR);
        DomainPane pane = (DomainPane)this.controlPanes.get(DOMAIN);
        pane.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.add((Component)pane, c);
    }

    RendererUI() {
    }

    void initialize(RendererControl controller, RendererModel model) {
        if (controller == null) {
            throw new NullPointerException("No control.");
        }
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.controller = controller;
        this.model = model;
        this.createControlPanes();
        this.buildGUI();
    }

    void addCodomainMap(Class mapType) {
        CodomainPane pane = (CodomainPane)this.controlPanes.get(CODOMAIN);
        pane.addCodomainMap(mapType);
    }

    void removeCodomainMap(Class mapType) {
        CodomainPane pane = (CodomainPane)this.controlPanes.get(CODOMAIN);
        pane.removeCodomainMap(mapType);
    }

    void setSelectedChannel() {
        DomainPane pane = (DomainPane)this.controlPanes.get(DOMAIN);
        pane.setSelectedChannel();
    }

    void setChannelColor(int index) {
        DomainPane pane = (DomainPane)this.controlPanes.get(DOMAIN);
        pane.setChannelColor(index);
    }

    void setLookUpTable(int index) {
        DomainPane pane = (DomainPane)this.controlPanes.get(DOMAIN);
        pane.setLookupTable(index);
    }

    void setInputInterval() {
        DomainPane pane = (DomainPane)this.controlPanes.get(DOMAIN);
        pane.setInputInterval();
    }

    void resetDefaultRndSettings() {
        Iterator<ControlPane> i = this.controlPanes.values().iterator();
        while (i.hasNext()) {
            i.next().resetDefaultRndSettings();
        }
    }

    void resetViewedBy(RndProxyDef settings) {
        DomainPane pane = (DomainPane)this.controlPanes.get(DOMAIN);
        pane.resetViewedBy(settings);
    }

    void setColorModelChanged() {
        DomainPane pane = (DomainPane)this.controlPanes.get(DOMAIN);
        pane.setColorModelChanged();
    }

    void onCurveChange() {
        DomainPane pane = (DomainPane)this.controlPanes.get(DOMAIN);
        pane.onCurveChange();
    }

    void onStateChange(boolean b) {
        if (this.controlPanes != null && this.controlPanes.size() > 0) {
            Iterator<ControlPane> i = this.controlPanes.values().iterator();
            while (i.hasNext()) {
                i.next().onStateChange(b);
            }
        }
    }

    Color getChannelColor(int channel) {
        return this.model.getChannelColor(channel);
    }

    String getLookupTable(int channel) {
        return this.model.getLookupTable(channel);
    }

    boolean getReverseIntensity(int channel) {
        return this.model.getReverseIntensity(channel);
    }

    void setZSection(int z) {
        DomainPane pane = (DomainPane)this.controlPanes.get(DOMAIN);
        pane.setZSection(z);
    }

    void setTimepoint(int t) {
        DomainPane pane = (DomainPane)this.controlPanes.get(DOMAIN);
        pane.setTimepoint(t);
    }

    boolean isSourceDisplayed(Object source) {
        DomainPane pane = (DomainPane)this.controlPanes.get(DOMAIN);
        return pane.isSourceDisplayed(source);
    }

    void renderPreview() {
        DomainPane pane = (DomainPane)this.controlPanes.get(DOMAIN);
        pane.renderPreview();
    }

    void displayViewedBy(List<ViewedByItem> results) {
        if (CollectionUtils.isEmpty(results)) {
            return;
        }
        DomainPane pane = (DomainPane)this.controlPanes.get(DOMAIN);
        RndProxyDef activeDef = null;
        if (this.model.getAlternativeRndSettings() != null) {
            activeDef = this.model.getAlternativeRndSettings();
        } else {
            for (ViewedByItem item : results) {
                if (!item.isSelected()) continue;
                activeDef = item.getRndDef();
                item.setSelected(false);
            }
            if (activeDef == null && CollectionUtils.isNotEmpty(this.model.getRenderingControls())) {
                activeDef = this.model.getRenderingControls().get(0).getRndSettingsCopy();
            }
        }
        pane.displayViewedBy(results, activeDef);
    }

    void setInputRange(boolean absolute) {
        DomainPane pane = (DomainPane)this.controlPanes.get(DOMAIN);
        pane.setInputRange(absolute);
    }

    void onChannelUpdated() {
        DomainPane pane = (DomainPane)this.controlPanes.get(DOMAIN);
        pane.onChannelUpdated();
    }

    RndProxyDef getSelectedDef() {
        DomainPane pane = (DomainPane)this.controlPanes.get(DOMAIN);
        return pane.getSelectedDef();
    }

    Collection<String> getAvailableLookupTables() {
        return this.model.getAvailableLookupTables();
    }

    public void onHistogramLoaded(int ch) {
        DomainPane pane = (DomainPane)this.controlPanes.get(DOMAIN);
        pane.onHistogramLoaded(ch);
    }
}

