/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.view;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import omero.gateway.SecurityContext;
import omero.gateway.exception.DSAccessException;
import omero.gateway.exception.DSOutOfServiceException;
import omero.gateway.model.AnnotationData;
import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.FileAnnotationData;
import omero.gateway.model.GroupData;
import omero.gateway.model.ImageData;
import omero.gateway.model.PlateAcquisitionData;
import omero.gateway.model.PlateData;
import omero.gateway.model.ProjectData;
import omero.gateway.model.ScreenData;
import omero.gateway.model.WellSampleData;
import org.apache.commons.collections.CollectionUtils;
import org.openmicroscopy.shoola.agents.metadata.AdminEditor;
import org.openmicroscopy.shoola.agents.metadata.ContainersLoader;
import org.openmicroscopy.shoola.agents.metadata.DataBatchSaver;
import org.openmicroscopy.shoola.agents.metadata.DataSaver;
import org.openmicroscopy.shoola.agents.metadata.ExperimenterEditor;
import org.openmicroscopy.shoola.agents.metadata.GroupEditor;
import org.openmicroscopy.shoola.agents.metadata.MetadataLoader;
import org.openmicroscopy.shoola.agents.metadata.MetadataViewerAgent;
import org.openmicroscopy.shoola.agents.metadata.RenderingSettingsLoader;
import org.openmicroscopy.shoola.agents.metadata.StructuredDataLoader;
import org.openmicroscopy.shoola.agents.metadata.ThumbnailLoader;
import org.openmicroscopy.shoola.agents.metadata.browser.Browser;
import org.openmicroscopy.shoola.agents.metadata.browser.BrowserFactory;
import org.openmicroscopy.shoola.agents.metadata.browser.TreeBrowserSet;
import org.openmicroscopy.shoola.agents.metadata.editor.Editor;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorFactory;
import org.openmicroscopy.shoola.agents.metadata.rnd.Renderer;
import org.openmicroscopy.shoola.agents.metadata.util.DataToSave;
import org.openmicroscopy.shoola.agents.metadata.view.MetadataViewer;
import org.openmicroscopy.shoola.agents.metadata.view.MetadataViewerFactory;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.env.data.OmeroMetadataService;
import org.openmicroscopy.shoola.env.data.model.AdminObject;
import org.openmicroscopy.shoola.env.data.model.MovieExportParam;
import org.openmicroscopy.shoola.env.data.util.StructuredDataResults;
import org.openmicroscopy.shoola.env.rnd.RndProxyDef;

class MetadataViewerModel {
    private int state = 1;
    private MetadataViewer component;
    private Object refObject;
    private Object parentRefObject;
    private Object grandParent;
    private Map<DataObject, StructuredDataResults> data;
    private StructuredDataResults parentData;
    private Browser browser;
    private Editor editor;
    private StructuredDataLoader multiDataLoader;
    private Class dataType;
    private boolean singleMode;
    private List<DataObject> relatedNodes;
    private int index;
    private long userID;
    private Map viewedBy;
    private SecurityContext ctx;
    private int loaderID;
    private Map<Integer, MetadataLoader> loaders;
    private RndProxyDef def;
    private long selectedViewedByDef;

    private SecurityContext retrieveContext(DataObject ho) {
        if (ho == null && this.ctx != null) {
            return this.ctx;
        }
        return new SecurityContext(ho.getGroupId());
    }

    private Integer getLoaderID(Class refClass) {
        for (Map.Entry<Integer, MetadataLoader> e : this.loaders.entrySet()) {
            if (!e.getValue().getClass().equals(refClass)) continue;
            return e.getKey();
        }
        return null;
    }

    private List<FileAnnotationData> getTabularData() {
        StructuredDataResults data = this.getStructuredData();
        ArrayList<FileAnnotationData> l = new ArrayList<FileAnnotationData>();
        if (data == null) {
            return l;
        }
        Collection<FileAnnotationData> attachments = data.getAttachments();
        if (attachments == null) {
            return l;
        }
        for (FileAnnotationData f : attachments) {
            String ns = f.getNameSpace();
            if (!"openmicroscopy.org/omero/bulk_annotations".equals(ns)) continue;
            l.add(f);
        }
        return l;
    }

    MetadataViewerModel(Object refObject, int index, RndProxyDef def, long selectedViewedByDef) {
        this.selectedViewedByDef = selectedViewedByDef;
        switch (index) {
            case 0: 
            case 1: {
                this.index = index;
                break;
            }
            default: {
                this.index = 0;
            }
        }
        this.def = def;
        this.refObject = refObject;
        this.loaderID = 0;
        this.loaders = new HashMap<Integer, MetadataLoader>();
        this.data = null;
        this.dataType = null;
        this.singleMode = true;
        this.userID = MetadataViewerAgent.getUserDetails().getId();
    }

    long getSelectedViewedByDef() {
        return this.selectedViewedByDef;
    }

    void initialize(MetadataViewer component) {
        this.component = component;
        this.browser = BrowserFactory.createBrowser(component, this.refObject);
        this.editor = EditorFactory.createEditor(component, this.refObject, this.browser);
    }

    long getUserID() {
        return this.userID;
    }

    void setDataType(Class dataType) {
        this.dataType = dataType;
    }

    int getState() {
        return this.state;
    }

    void discard() {
        this.setState(4);
        this.loaders.entrySet().iterator();
        Iterator<Map.Entry<Integer, MetadataLoader>> i = this.loaders.entrySet().iterator();
        while (i.hasNext()) {
            MetadataLoader loader = i.next().getValue();
            if (loader == null) continue;
            loader.cancel();
        }
        this.loaders.clear();
        if (this.multiDataLoader != null) {
            this.multiDataLoader.cancel();
        }
    }

    void setRootObject(Object refObject, SecurityContext ctx) {
        DataObject data;
        this.refObject = refObject;
        this.ctx = ctx;
        if (ctx == null && refObject instanceof DataObject && (data = (DataObject)refObject).getId() >= 0L) {
            this.ctx = new SecurityContext(data.getGroupId());
        }
        this.browser.setRootObject(refObject);
        this.editor.setRootObject(refObject);
        this.data = null;
        if (!(refObject instanceof WellSampleData) && this.parentData != null) {
            this.parentData = null;
        }
        this.parentRefObject = null;
        this.viewedBy = null;
    }

    void setParentRootObject(Object parentRefObject, Object grandParent) {
        this.parentRefObject = parentRefObject;
        this.grandParent = grandParent;
        this.editor.setParentRootObject(parentRefObject, grandParent);
    }

    Object getParentRefObject() {
        return this.parentRefObject;
    }

    Object getRefObject() {
        if (this.data == null) {
            return this.refObject;
        }
        return this.refObject;
    }

    ImageData getImage() {
        ImageData img = null;
        if (this.refObject instanceof WellSampleData) {
            img = ((WellSampleData)this.refObject).getImage();
        }
        if (this.refObject instanceof ImageData) {
            img = (ImageData)this.refObject;
        }
        return img;
    }

    Browser getBrowser() {
        return this.browser;
    }

    Editor getEditor() {
        return this.editor;
    }

    void cancel(int loaderID) {
        MetadataLoader loader = this.loaders.get(loaderID);
        if (loader != null) {
            loader.cancel();
            this.loaders.remove(loaderID);
        }
    }

    void fireParentLoading(TreeBrowserSet refNode) {
        Object ho;
        Integer id = this.getLoaderID(ContainersLoader.class);
        if (id != null) {
            this.cancel(id);
        }
        if ((ho = refNode.getUserObject()) instanceof DataObject) {
            ++this.loaderID;
            this.ctx = this.retrieveContext((DataObject)ho);
            ContainersLoader loader = new ContainersLoader(this.component, this.ctx, refNode, ho.getClass(), ((DataObject)ho).getId(), this.loaderID);
            this.loaders.put(this.loaderID, loader);
            loader.load();
        }
    }

    void fireStructuredDataLoading(Object node) {
        if (!(node instanceof DataObject)) {
            return;
        }
        if (node instanceof ExperimenterData) {
            return;
        }
        if (node instanceof DataObject) {
            Integer id = this.getLoaderID(StructuredDataLoader.class);
            if (id != null) {
                this.cancel(id);
            }
            ++this.loaderID;
            if (node instanceof WellSampleData) {
                node = ((WellSampleData)node).getImage();
            }
            this.ctx = this.retrieveContext((DataObject)node);
            StructuredDataLoader loader = new StructuredDataLoader(this.component, this.ctx, Arrays.asList((DataObject)node), this.loaderID);
            this.loaders.put(this.loaderID, loader);
            loader.load();
            this.setState(2);
        }
    }

    boolean isSameObject(DataObject uo, Object ref) {
        DataObject object;
        if (uo == null || !(ref instanceof DataObject)) {
            return false;
        }
        Class<?> klass = ref.getClass();
        if (ref instanceof WellSampleData) {
            klass = ((WellSampleData)ref).getImage().getClass();
            object = ((WellSampleData)ref).getImage();
        } else {
            object = (DataObject)ref;
        }
        Class<?> hoKlass = uo.getClass();
        if (uo instanceof WellSampleData) {
            hoKlass = ((WellSampleData)uo).getImage().getClass();
            uo = ((WellSampleData)uo).getImage();
        }
        if (!hoKlass.equals(klass)) {
            return false;
        }
        return uo.getId() == object.getId();
    }

    boolean isSameObject(Object uo) {
        if (uo instanceof DataObject) {
            return this.isSameObject((DataObject)uo, this.refObject);
        }
        return false;
    }

    String getRefObjectPath() {
        return this.getRefObjectName();
    }

    String getRefObjectName() {
        Object ref = this.getRefObject();
        if (ref instanceof ImageData) {
            return ((ImageData)ref).getName();
        }
        if (ref instanceof DatasetData) {
            return ((DatasetData)ref).getName();
        }
        if (ref instanceof ProjectData) {
            return ((ProjectData)ref).getName();
        }
        if (ref instanceof PlateData) {
            return ((PlateData)ref).getName();
        }
        if (ref instanceof ScreenData) {
            return ((ScreenData)ref).getName();
        }
        if (ref instanceof ExperimenterData) {
            return EditorUtil.formatExperimenter((ExperimenterData)ref);
        }
        if (ref instanceof GroupData) {
            return ((GroupData)ref).getName();
        }
        return "";
    }

    String getInstanceToSave() {
        Object ref = this.getRefObject();
        String v = "";
        if (ref instanceof ImageData) {
            v = "Image's Data: ";
            v = v + EditorUtil.truncate(((ImageData)ref).getName());
        } else if (ref instanceof DatasetData) {
            v = "Dataset's Data: ";
            v = v + EditorUtil.truncate(((DatasetData)ref).getName());
        } else if (ref instanceof ProjectData) {
            v = "Project's Data: ";
            v = v + EditorUtil.truncate(((ProjectData)ref).getName());
        } else if (ref instanceof PlateData) {
            v = "Plate's Data: ";
            v = v + EditorUtil.truncate(((PlateData)ref).getName());
        } else if (ref instanceof PlateAcquisitionData) {
            v = "Run's Data: ";
            v = v + EditorUtil.truncate(((PlateAcquisitionData)ref).getLabel());
        } else if (ref instanceof ScreenData) {
            v = "Screen's Data: ";
            v = v + EditorUtil.truncate(((ScreenData)ref).getName());
        } else if (ref instanceof ExperimenterData) {
            v = EditorUtil.formatExperimenter((ExperimenterData)ref);
            v = v + "'s details";
        }
        if (ref instanceof GroupData) {
            v = ((GroupData)ref).getName();
            v = v + "'s details";
        }
        return v;
    }

    void fireSaving(DataToSave object, List<Object> metadata, Collection<DataObject> data, boolean asynch) {
        if (this.state != 3) {
            return;
        }
        List<AnnotationData> toAdd = null;
        List<Object> toRemove = null;
        if (object != null) {
            toAdd = object.getToAdd();
            toRemove = object.getToRemove();
        }
        if (asynch) {
            DataSaver loader = new DataSaver(this.component, this.ctx, data, toAdd, toRemove, metadata, this.loaderID);
            ++this.loaderID;
            this.loaders.put(this.loaderID, loader);
            loader.load();
            this.setState(6);
        } else {
            OmeroMetadataService os = MetadataViewerAgent.getRegistry().getMetadataService();
            if (metadata != null) {
                Iterator<Object> i = metadata.iterator();
                while (i.hasNext()) {
                    try {
                        os.saveAcquisitionData(this.ctx, i.next());
                    }
                    catch (DSOutOfServiceException e) {
                        this.handleException((Exception)((Object)e));
                    }
                    catch (DSAccessException e) {
                        this.handleException((Exception)((Object)e));
                    }
                }
            }
            try {
                os.saveBatchData(this.ctx, data, toAdd, toRemove, this.userID);
            }
            catch (DSOutOfServiceException e) {
                this.handleException((Exception)((Object)e));
            }
            catch (DSAccessException e) {
                this.handleException((Exception)((Object)e));
            }
        }
    }

    private void handleException(Exception e) {
        MetadataViewerAgent.getRegistry().getUserNotifier().notifyError("Could not save metadata", "Could not save metadata before closing application.", e);
    }

    void fireExperimenterSaving(ExperimenterData data, boolean async) {
        ++this.loaderID;
        this.ctx = this.retrieveContext((DataObject)data);
        ExperimenterEditor loader = new ExperimenterEditor(this.component, this.ctx, data, this.loaderID);
        this.loaders.put(this.loaderID, loader);
        loader.load();
        this.setState(6);
    }

    void fireChangeGroup(GroupData group) {
        SecurityContext c = this.ctx;
        if (MetadataViewerAgent.isAdministrator()) {
            c = this.getAdminContext();
        }
        GroupEditor loader = new GroupEditor(this.component, c, group, this.loaderID, 1);
        ((MetadataLoader)loader).load();
    }

    void fireAdminSaving(AdminObject data, boolean asynch) {
        SecurityContext c = this.ctx;
        if (MetadataViewerAgent.isAdministrator()) {
            c = this.getAdminContext();
        }
        GroupData group = data.getGroup();
        switch (data.getIndex()) {
            case 2: {
                ++this.loaderID;
                GroupEditor loader = new GroupEditor(this.component, c, group, data.getPermissions(), this.loaderID, 0);
                this.loaders.put(this.loaderID, loader);
                ((MetadataLoader)loader).load();
                this.setState(6);
                break;
            }
            case 3: {
                ++this.loaderID;
                AdminEditor loader = new AdminEditor(this.component, c, data.getGroup(), data.getExperimenters(), this.loaderID);
                this.loaders.put(this.loaderID, loader);
                ((MetadataLoader)loader).load();
                this.setState(6);
            }
        }
    }

    void setStructuredDataResults(Map<DataObject, StructuredDataResults> data, int loaderID) {
        this.loaders.remove(loaderID);
        this.data = data;
        this.setState(3);
    }

    void setParentDataResults(StructuredDataResults parentData, DataObject node, int loaderID) {
        this.loaders.remove(loaderID);
        this.parentData = parentData;
        this.setState(3);
    }

    StructuredDataResults getStructuredData() {
        return this.getStructuredData(this.refObject);
    }

    StructuredDataResults getStructuredData(Object object) {
        if (this.data == null) {
            return null;
        }
        if (object instanceof DataObject) {
            if (object instanceof WellSampleData) {
                object = ((WellSampleData)object).getImage();
            }
            return this.data.get((DataObject)object);
        }
        return null;
    }

    StructuredDataResults getParentStructuredData() {
        return this.parentData;
    }

    boolean isArchived() {
        if (!(this.refObject instanceof ImageData)) {
            return false;
        }
        ImageData img = (ImageData)this.refObject;
        return img.isArchived();
    }

    void fireBatchSaving(List<AnnotationData> toAdd, List<Object> toRemove, Collection<DataObject> toSave) {
        DataBatchSaver loader = new DataBatchSaver(this.component, this.ctx, toSave, toAdd, toRemove, this.loaderID);
        loader.load();
        ++this.loaderID;
        this.setState(5);
    }

    void setSelectionMode(boolean singleMode) {
        this.singleMode = singleMode;
        if (singleMode) {
            this.relatedNodes = null;
        }
    }

    boolean isSingleMode() {
        return this.singleMode;
    }

    void setRelatedNodes(List<DataObject> relatedNodes) {
        this.relatedNodes = relatedNodes;
        if (CollectionUtils.isEmpty(relatedNodes)) {
            return;
        }
        DataObject ho = relatedNodes.get(0);
        ArrayList<DataObject> l = new ArrayList<DataObject>();
        if (ho instanceof WellSampleData) {
            Iterator<DataObject> i = relatedNodes.iterator();
            while (i.hasNext()) {
                l.add((DataObject)((WellSampleData)i.next()).getImage());
            }
        } else {
            l.addAll(relatedNodes);
        }
        ++this.loaderID;
        this.ctx = this.retrieveContext(ho);
        StructuredDataLoader loader = new StructuredDataLoader(this.component, this.ctx, l, this.loaderID);
        this.loaders.put(this.loaderID, loader);
        loader.load();
        this.setState(2);
    }

    List<DataObject> getRelatedNodes() {
        return this.relatedNodes;
    }

    void setState(int state) {
        this.state = state;
        if (state == 3 || state == 4) {
            this.editor.setStatus(false);
        }
    }

    void loadParents(Class type, long id) {
        ++this.loaderID;
        ContainersLoader loader = new ContainersLoader(this.component, this.ctx, type, id, this.loaderID);
        this.loaders.put(this.loaderID, loader);
        loader.load();
    }

    void createMovie(MovieExportParam parameters) {
        if (parameters == null) {
            return;
        }
        if (!(this.refObject instanceof ImageData)) {
            return;
        }
    }

    int getIndex() {
        return this.index;
    }

    FileAnnotationData getIRF() {
        if (!(this.refObject instanceof ImageData)) {
            return null;
        }
        if (this.data == null) {
            return null;
        }
        Collection<FileAnnotationData> l = this.getStructuredData().getAttachments();
        if (l == null || l.size() == 0) {
            return null;
        }
        for (FileAnnotationData fa : l) {
            if (!fa.getFileName().contains("irf")) continue;
            return fa;
        }
        return null;
    }

    boolean isNumerousChannel() {
        if (!(this.refObject instanceof ImageData)) {
            return false;
        }
        ImageData img = (ImageData)this.refObject;
        return img.getDefaultPixels().getSizeC() >= 100;
    }

    void setUserID(long userID) {
        this.userID = userID;
    }

    Map getViewedBy() {
        return this.viewedBy;
    }

    void setViewedBy(Map viewedBy) {
        LinkedHashMap m = new LinkedHashMap();
        if (viewedBy != null) {
            ExperimenterData exp;
            long id = MetadataViewerAgent.getUserDetails().getId();
            for (Map.Entry entry : viewedBy.entrySet()) {
                exp = (ExperimenterData)entry.getKey();
                if (exp.getId() != id) continue;
                m.put(exp, entry.getValue());
            }
            for (Map.Entry entry : viewedBy.entrySet()) {
                exp = (ExperimenterData)entry.getKey();
                if (exp.getId() == id) continue;
                m.put(exp, entry.getValue());
            }
        }
        this.viewedBy = m;
    }

    void fireViewedByLoading() {
        ImageData img = null;
        if (this.refObject instanceof ImageData) {
            img = (ImageData)this.refObject;
        } else if (this.refObject instanceof WellSampleData) {
            img = ((WellSampleData)this.refObject).getImage();
        }
        if (img == null) {
            return;
        }
        Renderer rnd = this.getEditor().getRenderer();
        if (rnd == null) {
            return;
        }
        this.getEditor().getRenderer().loadRndSettings(false, null);
        ++this.loaderID;
        this.ctx = this.retrieveContext((DataObject)img);
        RenderingSettingsLoader loader = new RenderingSettingsLoader(this.component, this.ctx, img.getDefaultPixels().getId(), this.loaderID, 0);
        this.loaders.put(this.loaderID, loader);
        loader.load();
    }

    void fireLoadRndSettings() {
        if (!this.hasRndSettingsCopied()) {
            return;
        }
        ImageData copyRenderingSettingsFrom = MetadataViewerFactory.getCopyRenderingSettingsFrom();
        RndProxyDef copiedRndSettings = MetadataViewerFactory.getCopiedRndSettings();
        if (copiedRndSettings != null) {
            this.applyRenderingSettings(copiedRndSettings);
            return;
        }
        if (copyRenderingSettingsFrom == null) {
            return;
        }
        if (this.ctx == null) {
            this.ctx = this.retrieveContext((DataObject)this.refObject);
        }
        RenderingSettingsLoader loader = new RenderingSettingsLoader(this.component, this.ctx, copyRenderingSettingsFrom.getDefaultPixels().getId(), this.loaderID, 1);
        this.loaders.put(this.loaderID, loader);
        loader.load();
    }

    void fireThumbnailsLoading() {
        if (this.viewedBy == null) {
            return;
        }
        ImageData image = null;
        if (this.refObject instanceof ImageData) {
            image = (ImageData)this.refObject;
        } else if (this.refObject instanceof WellSampleData) {
            image = ((WellSampleData)this.refObject).getImage();
        }
        if (image == null) {
            return;
        }
        Set experimenters = this.viewedBy.keySet();
        HashSet<Long> ids = new HashSet<Long>();
        Iterator i = experimenters.iterator();
        while (i.hasNext()) {
            ids.add(((ExperimenterData)i.next()).getId());
        }
        if (ids.size() == 0) {
            return;
        }
        Integer lId = this.getLoaderID(ThumbnailLoader.class);
        if (lId != null) {
            this.cancel(lId);
        }
        ++this.loaderID;
        this.ctx = this.retrieveContext((DataObject)image);
        ThumbnailLoader loader = new ThumbnailLoader(this.component, this.ctx, image, ids, this.loaderID);
        this.loaders.put(this.loaderID, loader);
        loader.load();
    }

    void applyRenderingSettings(RndProxyDef rndDef) {
        Renderer rnd = this.getEditor().getRenderer();
        if (rnd != null) {
            rnd.resetSettings(rndDef, true);
        }
    }

    boolean canEdit() {
        if (this.editor == null) {
            return false;
        }
        return this.editor.canEdit();
    }

    boolean canAnnotate() {
        if (this.editor == null) {
            return false;
        }
        return this.editor.canAnnotate();
    }

    boolean canLink() {
        if (this.editor == null) {
            return false;
        }
        return this.editor.canLink();
    }

    SecurityContext getSecurityContext() {
        return this.ctx;
    }

    SecurityContext getAdminContext() {
        if (MetadataViewerAgent.isAdministrator()) {
            return MetadataViewerAgent.getAdminContext();
        }
        return null;
    }

    Map<DataObject, StructuredDataResults> getAllStructuredData() {
        return this.data;
    }

    boolean isSameSelection(Collection<DataObject> keys) {
        if (keys == null) {
            return false;
        }
        List<DataObject> nodes = this.getRelatedNodes();
        if (nodes == null) {
            return false;
        }
        int count = 0;
        for (DataObject o : keys) {
            Iterator<DataObject> k = nodes.iterator();
            while (k.hasNext()) {
                if (!this.isSameObject(o, k.next())) continue;
                ++count;
            }
        }
        return count == nodes.size() && count == keys.size();
    }

    ExperimenterData getCurrentUser() {
        return MetadataViewerAgent.getUserDetails();
    }

    void loadRnd() {
        this.editor.loadRnd();
    }

    boolean hasRndSettingsCopied() {
        Renderer rnd = this.component.getRenderer();
        ImageData img = this.getImage();
        ImageData copyRenderingSettingsFrom = MetadataViewerFactory.getCopyRenderingSettingsFrom();
        RndProxyDef copiedRndSettings = MetadataViewerFactory.getCopiedRndSettings();
        return copiedRndSettings != null && rnd != null && !rnd.isSameSettings(copiedRndSettings, false) || copyRenderingSettingsFrom != null && img != null && copyRenderingSettingsFrom.getId() != img.getId();
    }

    RndProxyDef getAlternativeRenderingSettings() {
        return this.def;
    }
}

