/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer;

import omero.gateway.SecurityContext;
import omero.log.LogMessage;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.events.DSCallAdapter;
import org.openmicroscopy.shoola.env.data.views.AdminView;
import org.openmicroscopy.shoola.env.data.views.DataHandlerView;
import org.openmicroscopy.shoola.env.data.views.DataManagerView;
import org.openmicroscopy.shoola.env.data.views.HierarchyBrowsingView;
import org.openmicroscopy.shoola.env.data.views.MetadataHandlerView;

public abstract class DataBrowserLoader
extends DSCallAdapter {
    protected final Browser viewer;
    protected final Registry registry;
    protected final DataManagerView dmView;
    protected final DataHandlerView dhView;
    protected final HierarchyBrowsingView hiBrwView;
    protected final MetadataHandlerView mhView;
    protected final AdminView adminView;
    protected final SecurityContext ctx;

    protected DataBrowserLoader(Browser viewer, SecurityContext ctx) {
        if (viewer == null) {
            throw new NullPointerException("No viewer.");
        }
        if (ctx == null) {
            throw new NullPointerException("No security context.");
        }
        this.viewer = viewer;
        this.ctx = ctx;
        this.registry = TreeViewerAgent.getRegistry();
        this.dmView = (DataManagerView)this.registry.getDataServicesView(DataManagerView.class);
        this.dhView = (DataHandlerView)this.registry.getDataServicesView(DataHandlerView.class);
        this.hiBrwView = (HierarchyBrowsingView)this.registry.getDataServicesView(HierarchyBrowsingView.class);
        this.mhView = (MetadataHandlerView)this.registry.getDataServicesView(MetadataHandlerView.class);
        this.adminView = (AdminView)this.registry.getDataServicesView(AdminView.class);
    }

    @Override
    public void handleNullResult() {
        this.handleException(new Exception("No data available."));
    }

    @Override
    public void handleCancellation() {
        String info = "The data retrieval has been cancelled.";
        this.registry.getLogger().info((Object)this, info);
        this.registry.getUserNotifier().notifyInfo("Data Retrieval Cancellation", info);
    }

    @Override
    public void handleException(Throwable exc) {
        int state = this.viewer.getState();
        String s = "Data Retrieval Failure: ";
        LogMessage msg = new LogMessage();
        msg.print("State: " + state);
        msg.print(s);
        msg.print(exc);
        this.registry.getLogger().error((Object)this, msg);
        if (state != 16) {
            this.registry.getUserNotifier().notifyError("Data Retrieval Failure", s, exc);
        }
        this.viewer.cancel();
    }

    public abstract void load();

    public abstract void cancel();
}

