/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer;

import java.util.Collection;
import java.util.Set;
import omero.gateway.SecurityContext;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.GroupData;
import org.apache.commons.collections.CollectionUtils;
import org.openmicroscopy.shoola.agents.treeviewer.DataBrowserLoader;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.util.browser.TreeFileSet;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageSet;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageTimeSet;
import org.openmicroscopy.shoola.env.data.views.CallHandle;

public class ExperimenterImageLoader
extends DataBrowserLoader {
    private TreeImageSet expNode;
    private TreeImageSet smartFolderNode;
    private CallHandle handle;

    private int convertType(int type) {
        switch (type) {
            case 4: {
                return 4;
            }
            case 2: {
                return 2;
            }
        }
        return 3;
    }

    public ExperimenterImageLoader(Browser viewer, SecurityContext ctx, TreeImageSet expNode, TreeImageSet smartFolderNode) {
        super(viewer, ctx);
        if (expNode == null) {
            throw new IllegalArgumentException("Node not valid.");
        }
        Object ho = expNode.getUserObject();
        if (!(ho instanceof ExperimenterData) && !(ho instanceof GroupData)) {
            throw new IllegalArgumentException("Node not valid.");
        }
        if (smartFolderNode == null) {
            throw new IllegalArgumentException("No smart folder specified.");
        }
        this.expNode = expNode;
        this.smartFolderNode = smartFolderNode;
    }

    @Override
    public void load() {
        long expID = -1L;
        if (this.expNode.getUserObject() instanceof ExperimenterData) {
            expID = ((ExperimenterData)this.expNode.getUserObject()).getId();
        }
        if (this.smartFolderNode instanceof TreeImageTimeSet) {
            TreeImageTimeSet time = (TreeImageTimeSet)this.smartFolderNode;
            this.handle = this.dhView.loadImages(this.ctx, time.getStartTime(), time.getEndTime(), expID, this);
        } else if (this.smartFolderNode instanceof TreeFileSet) {
            TreeFileSet set = (TreeFileSet)this.smartFolderNode;
            if (set.getType() == 5) {
                Boolean v = Boolean.parseBoolean((String)TreeViewerAgent.getRegistry().lookup("omero.client.ui.tree.orphans.enabled"));
                if (v != null && !v.booleanValue()) {
                    boolean enabled = false;
                    if (!TreeViewerAgent.isAdministrator()) {
                        Set leaders;
                        TreeImageDisplay node = this.expNode.getParentDisplay();
                        long id = node.getUserObjectId();
                        if (id == -1L) {
                            id = TreeViewerAgent.getUserDetails().getGroupId();
                        }
                        if (CollectionUtils.isNotEmpty((Collection)(leaders = TreeViewerAgent.getGroupsLeaderOf()))) {
                            for (GroupData type : leaders) {
                                if (id != type.getId()) continue;
                                enabled = true;
                            }
                        }
                    }
                    if (!enabled) {
                        expID = TreeViewerAgent.getUserDetails().getId();
                    }
                }
                this.handle = this.dmView.loadImages(this.ctx, expID, true, this);
            } else {
                this.handle = this.dhView.loadFiles(this.ctx, this.convertType(set.getType()), expID, this);
            }
        }
    }

    @Override
    public void cancel() {
        this.handle.cancel();
    }

    @Override
    public void handleResult(Object result) {
        if (this.viewer.getState() == 16) {
            return;
        }
        this.viewer.setLeaves((Collection)result, this.smartFolderNode, this.expNode);
    }
}

