/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer;

import java.util.List;
import java.util.Map;
import omero.gateway.SecurityContext;
import omero.gateway.model.DatasetData;
import omero.gateway.model.ImageData;
import omero.gateway.model.PlateAcquisitionData;
import omero.gateway.model.PlateData;
import omero.gateway.model.ProjectData;
import omero.gateway.model.ScreenData;
import org.openmicroscopy.shoola.agents.treeviewer.DataTreeViewerLoader;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.env.data.model.TimeRefObject;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import org.openmicroscopy.shoola.env.rnd.RndProxyDef;

public class RndSettingsSaver
extends DataTreeViewerLoader {
    public static final int PASTE = 0;
    public static final int RESET = 1;
    public static final int SET_MIN_MAX = 2;
    public static final int SET_OWNER = 3;
    private Class rootType;
    private List<Long> ids;
    private TimeRefObject ref;
    private CallHandle handle;
    private int index;
    private RndProxyDef defToPaste;
    private ImageData refImage;

    private void checkIndex(int index) {
        switch (index) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Index not supported.");
            }
        }
    }

    private void checkRootType(Class type) {
        if (ImageData.class.equals((Object)type) || DatasetData.class.equals((Object)type) || PlateData.class.equals((Object)type) || ProjectData.class.equals((Object)type) || ScreenData.class.equals((Object)type) || PlateAcquisitionData.class.equals((Object)type)) {
            return;
        }
        throw new IllegalArgumentException("Type not supported.");
    }

    public RndSettingsSaver(TreeViewer viewer, SecurityContext ctx, Class rootType, List<Long> ids, int index) {
        super(viewer, ctx);
        this.checkRootType(rootType);
        this.checkIndex(index);
        this.index = index;
        if (ids == null || ids.size() == 0) {
            throw new IllegalArgumentException("No nodes specified.");
        }
        this.rootType = rootType;
        this.ids = ids;
        this.ref = null;
    }

    public RndSettingsSaver(TreeViewer viewer, SecurityContext ctx, TimeRefObject ref, int index) {
        super(viewer, ctx);
        this.checkIndex(index);
        this.index = index;
        if (ref == null) {
            throw new IllegalArgumentException("Period not valid.");
        }
        this.ref = ref;
    }

    public RndSettingsSaver(TreeViewer viewer, SecurityContext ctx, Class rootType, List<Long> ids, RndProxyDef defToPaste, ImageData refImage) {
        super(viewer, ctx);
        this.checkRootType(rootType);
        this.index = 0;
        if (ids == null || ids.size() == 0) {
            throw new IllegalArgumentException("No nodes specified.");
        }
        if (refImage == null) {
            throw new IllegalArgumentException("No reference image provided.");
        }
        this.rootType = rootType;
        this.ids = ids;
        this.defToPaste = defToPaste;
        this.refImage = refImage;
        this.ref = null;
    }

    public RndSettingsSaver(TreeViewer viewer, SecurityContext ctx, TimeRefObject ref, ImageData refImage) {
        super(viewer, ctx);
        this.index = 0;
        if (refImage == null) {
            throw new IllegalArgumentException("Pixels ID not valid.");
        }
        if (ref == null) {
            throw new IllegalArgumentException("Period not valid.");
        }
        this.refImage = refImage;
        this.ref = ref;
    }

    @Override
    public void cancel() {
        this.handle.cancel();
    }

    @Override
    public void load() {
        switch (this.index) {
            case 0: {
                if (this.ref == null) {
                    if (this.defToPaste == null) {
                        this.handle = this.dhView.pasteRndSettings(this.ctx, this.refImage.getDefaultPixels().getId(), this.rootType, this.ids, this);
                        break;
                    }
                    this.handle = this.dhView.pasteRndSettings(this.ctx, this.rootType, this.ids, this.defToPaste, this.refImage, this);
                    break;
                }
                this.handle = this.dhView.pasteRndSettings(this.ctx, this.refImage.getDefaultPixels().getId(), this.ref, this);
                break;
            }
            case 1: {
                if (this.ref == null) {
                    this.handle = this.dhView.resetRndSettings(this.ctx, this.rootType, this.ids, this);
                    break;
                }
                this.handle = this.dhView.resetRndSettings(this.ctx, this.ref, this);
                break;
            }
            case 2: {
                if (this.ref == null) {
                    this.handle = this.dhView.setMinMaxSettings(this.ctx, this.rootType, this.ids, this);
                    break;
                }
                this.handle = this.dhView.setMinMaxSettings(this.ctx, this.ref, this);
                break;
            }
            case 3: {
                this.handle = this.ref == null ? this.dhView.setOwnerRndSettings(this.ctx, this.rootType, this.ids, this) : this.dhView.setOwnerRndSettings(this.ctx, this.ref, this);
            }
        }
    }

    @Override
    public void handleResult(Object result) {
        if (this.viewer.getState() == 2) {
            return;
        }
        this.viewer.rndSettingsPasted((Map)result);
    }
}

