/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComponent;
import omero.gateway.SecurityContext;
import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.FileAnnotationData;
import omero.gateway.model.GroupData;
import omero.gateway.model.ImageData;
import omero.gateway.model.PlateData;
import omero.gateway.model.ProjectData;
import omero.gateway.model.ScreenData;
import org.openmicroscopy.shoola.agents.events.hiviewer.DownloadEvent;
import org.openmicroscopy.shoola.agents.events.hiviewer.LaunchViewer;
import org.openmicroscopy.shoola.agents.events.importer.BrowseContainer;
import org.openmicroscopy.shoola.agents.events.importer.ImportStatusEvent;
import org.openmicroscopy.shoola.agents.events.importer.LoadImporter;
import org.openmicroscopy.shoola.agents.events.iviewer.CopyRndSettings;
import org.openmicroscopy.shoola.agents.events.iviewer.ResetRndSettings;
import org.openmicroscopy.shoola.agents.events.iviewer.RndSettingsCopied;
import org.openmicroscopy.shoola.agents.events.iviewer.ScriptDisplay;
import org.openmicroscopy.shoola.agents.events.iviewer.ViewImage;
import org.openmicroscopy.shoola.agents.events.iviewer.ViewImageObject;
import org.openmicroscopy.shoola.agents.events.iviewer.ViewerCreated;
import org.openmicroscopy.shoola.agents.events.metadata.AnnotatedEvent;
import org.openmicroscopy.shoola.agents.events.treeviewer.DataObjectSelectionEvent;
import org.openmicroscopy.shoola.agents.events.treeviewer.MoveToEvent;
import org.openmicroscopy.shoola.agents.events.treeviewer.NodeToRefreshEvent;
import org.openmicroscopy.shoola.agents.treeviewer.actions.SaveResultsAction;
import org.openmicroscopy.shoola.agents.treeviewer.view.SearchEvent;
import org.openmicroscopy.shoola.agents.treeviewer.view.SearchSelectionEvent;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewerFactory;
import org.openmicroscopy.shoola.env.Agent;
import org.openmicroscopy.shoola.env.Environment;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.AdminService;
import org.openmicroscopy.shoola.env.data.events.ReconnectedEvent;
import org.openmicroscopy.shoola.env.data.events.SaveEventRequest;
import org.openmicroscopy.shoola.env.data.events.UserGroupSwitched;
import org.openmicroscopy.shoola.env.data.util.AgentSaveInfo;
import org.openmicroscopy.shoola.env.event.AgentEvent;
import org.openmicroscopy.shoola.env.event.AgentEventListener;
import org.openmicroscopy.shoola.env.event.EventBus;
import org.openmicroscopy.shoola.env.event.SaveEvent;
import org.openmicroscopy.shoola.env.rnd.RndProxyDef;
import org.openmicroscopy.shoola.env.ui.ActivityProcessEvent;
import org.openmicroscopy.shoola.env.ui.ViewObjectEvent;

public class TreeViewerAgent
implements Agent,
AgentEventListener {
    public static final String MULTI_USER = "MultiUser";
    public static final String LAYOUT_TYPE = "BrowserLayout";
    private static Registry registry;

    public static Registry getRegistry() {
        return registry;
    }

    public static ExperimenterData getUserDetails() {
        return (ExperimenterData)registry.lookup("/current_user/details");
    }

    public static Collection getAvailableUserGroups() {
        return (Collection)registry.lookup("/userGroup/details");
    }

    public static boolean isAdministrator() {
        Boolean b = (Boolean)registry.lookup("/users/administrator");
        if (b == null) {
            return false;
        }
        return b;
    }

    public static boolean isMoveGroup() {
        Boolean b = (Boolean)registry.lookup("/groups/move");
        if (b == null) {
            b = Boolean.FALSE;
        }
        return TreeViewerAgent.isAdministrator() && b != false;
    }

    public static boolean isEditGroup() {
        Boolean b = (Boolean)registry.lookup("/groups/edit");
        if (b == null) {
            b = Boolean.FALSE;
        }
        return TreeViewerAgent.isAdministrator() && b != false;
    }

    public static boolean isAddToGroup() {
        Boolean b = (Boolean)registry.lookup("/groups/add");
        if (b == null) {
            b = Boolean.FALSE;
        }
        return TreeViewerAgent.isAdministrator() && b != false;
    }

    public static boolean isEditUser() {
        Boolean b = (Boolean)registry.lookup("/users/edit");
        if (b == null) {
            b = Boolean.FALSE;
        }
        return TreeViewerAgent.isAdministrator() && b != false;
    }

    public static boolean isUploadScript() {
        Boolean b = (Boolean)registry.lookup("/scripts/upload");
        if (b == null) {
            b = Boolean.FALSE;
        }
        return TreeViewerAgent.isAdministrator() && b != false;
    }

    public static boolean canCreate() {
        Boolean b = (Boolean)registry.lookup("canCreate");
        return b;
    }

    public static SecurityContext getAdminContext() {
        if (!TreeViewerAgent.isAdministrator()) {
            return null;
        }
        Collection groups = TreeViewerAgent.getAvailableUserGroups();
        Iterator i = groups.iterator();
        AdminService svc = registry.getAdminService();
        while (i.hasNext()) {
            GroupData g = (GroupData)i.next();
            if (!svc.isSecuritySystemGroup(g.getId(), "system")) continue;
            return new SecurityContext(g.getId());
        }
        return null;
    }

    public static boolean isBinaryAvailable() {
        Boolean b = (Boolean)registry.lookup("/services/SERVER/BinaryAvailable");
        if (b == null) {
            return true;
        }
        return b;
    }

    public static Set getGroupsLeaderOf() {
        HashSet<GroupData> values = new HashSet<GroupData>();
        Collection groups = TreeViewerAgent.getAvailableUserGroups();
        Iterator i = groups.iterator();
        ExperimenterData exp2 = TreeViewerAgent.getUserDetails();
        long id = exp2.getId();
        while (i.hasNext()) {
            GroupData g = (GroupData)i.next();
            Set leaders = g.getLeaders();
            if (leaders == null || leaders.size() <= 0) continue;
            for (ExperimenterData exp2 : leaders) {
                if (exp2.getId() != id) continue;
                values.add(g);
            }
        }
        return values;
    }

    public static boolean isMultiGroups() {
        Boolean b = (Boolean)registry.lookup("MutliGroup");
        if (b == null) {
            return false;
        }
        return b;
    }

    public static int getDefaultHierarchy() {
        Environment env = (Environment)registry.lookup("/env");
        if (env == null) {
            return 0;
        }
        switch (env.getDefaultHierarchy()) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
        }
        return 0;
    }

    public static int runAsPlugin() {
        Environment env = (Environment)registry.lookup("/env");
        if (env == null) {
            return -1;
        }
        return env.runAsPlugin();
    }

    public static boolean isRunAsPlugin() {
        return TreeViewerAgent.runAsPlugin() > 0;
    }

    private void handleCopyRndSettings(CopyRndSettings evt) {
        TreeViewerFactory.copyRndSettings(evt.getImage(), evt.getRndDef());
    }

    private void handleSaveEventRequest(SaveEventRequest evt) {
        Object origin = evt.getOrigin();
        if (!(origin instanceof TreeViewer)) {
            return;
        }
        TreeViewerFactory.saveOnClose(evt, this);
    }

    private void handleRndSettingsCopied(RndSettingsCopied evt) {
        TreeViewerFactory.onRndSettingsCopied(evt.getImagesIDs());
    }

    private void handleActivityProcessed(ActivityProcessEvent evt) {
        ExperimenterData exp = (ExperimenterData)registry.lookup("/current_user/details");
        if (exp == null) {
            return;
        }
        TreeViewer viewer = TreeViewerFactory.getTreeViewer(exp);
        if (viewer != null) {
            viewer.onActivityProcessed(evt.getActivity(), evt.isFinished());
        }
    }

    private void handleViewerCreated(ViewerCreated evt) {
    }

    private void handleDataObjectSelectionEvent(DataObjectSelectionEvent evt) {
        ExperimenterData exp = (ExperimenterData)registry.lookup("/current_user/details");
        if (exp == null) {
            return;
        }
        TreeViewer viewer = TreeViewerFactory.getTreeViewer(exp);
        if (viewer != null) {
            viewer.findDataObject(evt.getDataType(), evt.getID(), evt.isSelectTab());
        }
    }

    private void handleUserGroupSwitched(UserGroupSwitched evt) {
        if (evt == null) {
            return;
        }
        TreeViewerFactory.onGroupSwitched(evt.isSuccessful());
    }

    private void handleViewObjectEvent(ViewObjectEvent evt) {
        if (evt == null) {
            return;
        }
        Object o = evt.getObject();
        if (!evt.browseObject()) {
            return;
        }
        if (o instanceof DatasetData || o instanceof ProjectData || o instanceof PlateData || o instanceof ScreenData || o instanceof ImageData || o instanceof FileAnnotationData) {
            JComponent src;
            DataObject data = (DataObject)o;
            ExperimenterData exp = (ExperimenterData)registry.lookup("/current_user/details");
            if (exp == null) {
                return;
            }
            TreeViewer viewer = TreeViewerFactory.getTreeViewer(exp);
            if (viewer != null) {
                viewer.browseContainer(data, null);
            }
            if ((src = evt.getSource()) != null) {
                src.setEnabled(true);
            }
        }
    }

    public void handleImportStatusEvent(ImportStatusEvent evt) {
        if (evt == null) {
            return;
        }
        ExperimenterData exp = (ExperimenterData)registry.lookup("/current_user/details");
        if (exp == null) {
            return;
        }
        TreeViewer viewer = TreeViewerFactory.getTreeViewer(exp);
        if (viewer != null) {
            viewer.setImporting(evt.isImporting(), evt.getContainers(), evt.isToRefresh(), evt.getImportResult());
        }
    }

    private void handleBrowseContainer(BrowseContainer evt) {
        if (evt == null) {
            return;
        }
        ExperimenterData exp = (ExperimenterData)registry.lookup("/current_user/details");
        if (exp == null) {
            return;
        }
        TreeViewer viewer = TreeViewerFactory.getTreeViewer(exp);
        if (viewer != null) {
            viewer.browseContainer(evt.getData(), evt.getNode());
        }
    }

    private void handleNodeToRefreshEvent(NodeToRefreshEvent evt) {
        if (evt == null) {
            return;
        }
        ExperimenterData exp = (ExperimenterData)registry.lookup("/current_user/details");
        if (exp == null) {
            return;
        }
        TreeViewer viewer = TreeViewerFactory.getTreeViewer(exp);
        if (viewer != null) {
            viewer.indicateToRefresh(evt.getObjects(), evt.getRefresh());
        }
    }

    private void handleReconnectedEvent(ReconnectedEvent evt) {
        if (TreeViewerFactory.onReconnected()) {
            return;
        }
    }

    private void handleMoveToEvent(MoveToEvent evt) {
        ExperimenterData exp = (ExperimenterData)registry.lookup("/current_user/details");
        if (exp == null) {
            return;
        }
        TreeViewer viewer = TreeViewerFactory.getTreeViewer(exp);
        if (viewer != null) {
            viewer.moveTo(evt.getGroup(), evt.getObjects());
        }
    }

    private void handleAnnotatedEvent(AnnotatedEvent evt) {
        TreeViewerFactory.onAnnotated(evt.getData(), evt.getCount());
    }

    private void handleSearchEvent(SearchEvent evt) {
        ExperimenterData exp = (ExperimenterData)registry.lookup("/current_user/details");
        if (exp == null) {
            return;
        }
        TreeViewer viewer = TreeViewerFactory.getTreeViewer(exp);
        viewer.handleSearchEvent(evt);
    }

    private void handleSearchSelectionEvent(SearchSelectionEvent evt) {
        ExperimenterData exp = (ExperimenterData)registry.lookup("/current_user/details");
        if (exp == null) {
            return;
        }
        TreeViewer viewer = TreeViewerFactory.getTreeViewer(exp);
        viewer.handleSearchSelectionEvent(evt);
    }

    private void handleSaveEvent(SaveEvent evt) {
        ExperimenterData exp = (ExperimenterData)registry.lookup("/current_user/details");
        if (evt == null || exp == null) {
            return;
        }
        TreeViewer viewer = TreeViewerFactory.getTreeViewer(exp);
        SaveResultsAction a = new SaveResultsAction(viewer, 1);
        a.setSaveIndex(evt.getSaveIndex());
        a.actionPerformed(new ActionEvent(new JButton(), 1001, ""));
    }

    private void handleDownloadEvent(DownloadEvent evt) {
        if (evt == null) {
            return;
        }
        ExperimenterData exp = (ExperimenterData)registry.lookup("/current_user/details");
        if (exp == null) {
            return;
        }
        TreeViewer viewer = TreeViewerFactory.getTreeViewer(exp);
        viewer.download(evt.getFolder(), evt.isOverride(), evt.getSelection());
    }

    private void handleScriptDisplay(ScriptDisplay evt) {
        if (evt == null) {
            return;
        }
        ExperimenterData exp = (ExperimenterData)registry.lookup("/current_user/details");
        if (exp == null) {
            return;
        }
        TreeViewer viewer = TreeViewerFactory.getTreeViewer(exp);
        viewer.showMenu(10, evt.getSource(), evt.getLocation());
    }

    private void handleResetRndSettings(ResetRndSettings evt) {
        if (evt == null) {
            return;
        }
        ExperimenterData exp = (ExperimenterData)registry.lookup("/current_user/details");
        if (exp == null) {
            return;
        }
        TreeViewer viewer = TreeViewerFactory.getTreeViewer(exp);
        viewer.resetRndSettings(evt.getImageID(), evt.getSettings());
    }

    private void handleLaunchViewer(LaunchViewer evt) {
        if (evt == null) {
            return;
        }
        ExperimenterData exp = (ExperimenterData)registry.lookup("/current_user/details");
        if (exp == null) {
            return;
        }
        TreeViewer viewer = TreeViewerFactory.getTreeViewer(exp);
        ViewImageObject data = evt.getData();
        if (data == null) {
            return;
        }
        RndProxyDef def = viewer.getSelectedViewedBy();
        if (def != null) {
            data.setSelectedRndDef(def.getDataID());
        }
        TreeViewerAgent.getRegistry().getEventBus().post(new ViewImage(evt.getSecurityContext(), data, null));
    }

    @Override
    public void activate(boolean master) {
        if (!master) {
            return;
        }
        Environment env = (Environment)registry.lookup("/env");
        if (env == null) {
            return;
        }
        ExperimenterData exp = (ExperimenterData)registry.lookup("/current_user/details");
        if (exp == null) {
            return;
        }
        TreeViewer viewer = TreeViewerFactory.getTreeViewer(exp);
        if (viewer != null) {
            viewer.activate();
        }
        if (TreeViewerAgent.runAsPlugin() == 3) {
            EventBus bus = registry.getEventBus();
            GroupData gp = null;
            try {
                gp = exp.getDefaultGroup();
            }
            catch (Exception exception) {
                // empty catch block
            }
            long id = -1L;
            if (gp != null) {
                id = gp.getId();
            }
            LoadImporter event = new LoadImporter(null, 0);
            event.setGroup(id);
            bus.post(event);
        }
    }

    @Override
    public void terminate() {
        Environment env = (Environment)registry.lookup("/env");
        if (env.isRunAsPlugin()) {
            TreeViewerFactory.terminate();
        }
    }

    @Override
    public void setContext(Registry ctx) {
        registry = ctx;
        EventBus bus = registry.getEventBus();
        bus.register((AgentEventListener)this, CopyRndSettings.class);
        bus.register((AgentEventListener)this, SaveEventRequest.class);
        bus.register((AgentEventListener)this, RndSettingsCopied.class);
        bus.register((AgentEventListener)this, ActivityProcessEvent.class);
        bus.register((AgentEventListener)this, ViewerCreated.class);
        bus.register((AgentEventListener)this, UserGroupSwitched.class);
        bus.register((AgentEventListener)this, DataObjectSelectionEvent.class);
        bus.register((AgentEventListener)this, ImportStatusEvent.class);
        bus.register((AgentEventListener)this, BrowseContainer.class);
        bus.register((AgentEventListener)this, NodeToRefreshEvent.class);
        bus.register((AgentEventListener)this, ViewObjectEvent.class);
        bus.register((AgentEventListener)this, ReconnectedEvent.class);
        bus.register((AgentEventListener)this, MoveToEvent.class);
        bus.register((AgentEventListener)this, AnnotatedEvent.class);
        bus.register((AgentEventListener)this, SearchEvent.class);
        bus.register((AgentEventListener)this, SearchSelectionEvent.class);
        bus.register((AgentEventListener)this, SaveEvent.class);
        bus.register((AgentEventListener)this, DownloadEvent.class);
        bus.register((AgentEventListener)this, ScriptDisplay.class);
        bus.register((AgentEventListener)this, ResetRndSettings.class);
        bus.register((AgentEventListener)this, LaunchViewer.class);
    }

    @Override
    public boolean canTerminate() {
        TreeViewerFactory.writeExternalApplications();
        return true;
    }

    @Override
    public AgentSaveInfo getDataToSave() {
        return null;
    }

    @Override
    public void save(List<Object> instances) {
    }

    @Override
    public void eventFired(AgentEvent e) {
        if (e instanceof CopyRndSettings) {
            this.handleCopyRndSettings((CopyRndSettings)e);
        } else if (e instanceof SaveEventRequest) {
            this.handleSaveEventRequest((SaveEventRequest)e);
        } else if (e instanceof RndSettingsCopied) {
            this.handleRndSettingsCopied((RndSettingsCopied)e);
        } else if (e instanceof ActivityProcessEvent) {
            this.handleActivityProcessed((ActivityProcessEvent)e);
        } else if (e instanceof ViewerCreated) {
            this.handleViewerCreated((ViewerCreated)e);
        } else if (e instanceof UserGroupSwitched) {
            this.handleUserGroupSwitched((UserGroupSwitched)e);
        } else if (e instanceof DataObjectSelectionEvent) {
            this.handleDataObjectSelectionEvent((DataObjectSelectionEvent)e);
        } else if (e instanceof ViewObjectEvent) {
            this.handleViewObjectEvent((ViewObjectEvent)e);
        } else if (e instanceof ImportStatusEvent) {
            this.handleImportStatusEvent((ImportStatusEvent)e);
        } else if (e instanceof BrowseContainer) {
            this.handleBrowseContainer((BrowseContainer)e);
        } else if (e instanceof NodeToRefreshEvent) {
            this.handleNodeToRefreshEvent((NodeToRefreshEvent)e);
        } else if (e instanceof ReconnectedEvent) {
            this.handleReconnectedEvent((ReconnectedEvent)e);
        } else if (e instanceof MoveToEvent) {
            this.handleMoveToEvent((MoveToEvent)e);
        } else if (e instanceof AnnotatedEvent) {
            this.handleAnnotatedEvent((AnnotatedEvent)e);
        } else if (e instanceof SearchEvent) {
            this.handleSearchEvent((SearchEvent)e);
        } else if (e instanceof SearchSelectionEvent) {
            this.handleSearchSelectionEvent((SearchSelectionEvent)e);
        } else if (e instanceof SaveEvent) {
            this.handleSaveEvent((SaveEvent)e);
        } else if (e instanceof DownloadEvent) {
            this.handleDownloadEvent((DownloadEvent)e);
        } else if (e instanceof ScriptDisplay) {
            this.handleScriptDisplay((ScriptDisplay)e);
        } else if (e instanceof ResetRndSettings) {
            this.handleResetRndSettings((ResetRndSettings)e);
        } else if (e instanceof LaunchViewer) {
            this.handleLaunchViewer((LaunchViewer)e);
        }
    }
}

